<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>

    <style>
        .bg-white {
            background-color: white;
        }

        .tab-pane {
            padding: 10px;
        }

        .editor {
            height: 700px;
        }

        .mb-1 {
            margin-bottom: 10px;
        }
    </style>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jodit/3.24.9/jodit.es2018.en.min.css" />

</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                <strong>Support Ticket</strong>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>


        <!-- Main content -->

        <section class="content">

            <div class="row">
                <div class="col-12 col-md-12">
                    <div class="box box-info">
                        <div class="box-body">
                            <iframe width='100%' height='840' src='https://javacomtech.com/pm/index.php/external_tickets' frameborder='0'></iframe>
                        </div>
                    </div>
                </div>
            </div>
        </section><!-- /.content -->
    </div><!-- /.content-wrapper -->

    <!-- ./wrapper -->

    <?php require_once(APPPATH . "views/admin/footer.php"); ?>



</body>

</html>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jodit/3.24.9/jodit.min.js"></script>
<script>
    // Store selected tab in localstorage
    $('.tab_list0').on('click', 'li', function() {
        var tabIndex = $(this).index();
        localStorage.setItem('selectedTabIndex0', tabIndex);
    });

    // Load tab index from localstorage
    $(document).ready(function() {
        let selectedTab = localStorage.getItem('selectedTabIndex0') != null ? localStorage.getItem('selectedTabIndex0') : 0;
        $(`.tab_list0 a:eq(${selectedTab})`).tab('show');
    });

    $('.tab_list1').on('click', 'li', function() {
        var tabIndex = $(this).index();
        localStorage.setItem('selectedTabIndex1', tabIndex);
    });

    // Load tab index from localstorage
    $(document).ready(function() {
        let selectedTab = localStorage.getItem('selectedTabIndex1') != null ? localStorage.getItem('selectedTabIndex1') : 0;
        $(`.tab_list1 a:eq(${selectedTab})`).tab('show');
    });

    // Load editor
    const editor = Jodit.make("#invoice-template", {
        "uploader": {
            "insertImageAsBase64URI": true
        },
        "spellcheck": true,
        "toolbarButtonSize": "small",
        "enter": "P",
        // "defaultMode": "3"
    });

    // Load template data
    function editTemplate(id = null) {
        if (id == null) {
            alert('Invalid template ID');
            return false;
        }

        const url = '<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/getInvoiceTemplate') ?>';

        const data = {
            id: id,
        };

        $.ajax({
            url: url,
            type: 'POST',
            contentType: 'application/json',
            data: JSON.stringify(data),
            success: function(response) {
                console.log('Response:', response);
                $('#template-id').val(response.id);
                $('#template-type').val(response.invoice_type);
                $('#template-name').val(response.name);
                editor.value = response.template;
            },
            error: function(error) {
                console.error('Error:', error);
            }
        });
    }


    // Add event listerner to template edit buttons
    $('.template-edit').on('click', function() {
        editTemplate($(this).attr('template-index'));
    });

    // Reset template form
    $('#template-for-reset').on('click', function() {
        editor.value = '';
        $('#template-id').val('');
    });

    // Template delete button event
    $('.template-delete').on('click', function() {
        Swal.fire({
            title: "Are you sure?",
            text: "You won't be able to revert this!",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "Yes, delete it!"
        }).then((result) => {
            if (result.isConfirmed) {
                $(this).closest('form').submit()
            }
        });
    });

    // Consent forms
    $(document).ready(function() {
        $(".consent_list").parent().find(".active").trigger("click");
    });

    $(".consent_list").click(function(e) {
        $(".consent_list").removeClass("active");
        $(this).addClass("active");

        var id = $(this).attr('id');
        $('#active_consent_id').val(id);

        $.ajax({
            type: "POST",
            url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/get_consent_form'); ?>",
            data: {
                consent_id: id
            },
            dataType: 'JSON',
            beforeSend: function() {
                $('#consent_content').addClass('hide');
                $('#consent_loading').removeClass('hide');

            },
            success: function(data) {
                $('#consent_content').removeClass('hide');
                $('#consent_loading').addClass('hide');
                editor_en.value = data[0].en_content;
                editor_ar.value = data[0].ar_content;
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(xhr.status + ' : ' + xhr.responseText);
            }
        });
    });

    $("#consent_content_save").click(function(e) {

        var id = $('#active_consent_id').val(),
            en_content = $('#editor_en').val(),
            ar_content = $('#editor_ar').val();

        $.ajax({
            type: "POST",
            url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/update_consent_template'); ?>",
            data: {
                consent_id: id,
                en_content: en_content,
                ar_content: ar_content
            },
            dataType: 'JSON',
            beforeSend: function() {
                $('#consent_content').addClass('hide');
                $('#consent_loading').removeClass('hide');
            },
            success: function(data) {
                $('#consent_content').removeClass('hide');
                $('#consent_loading').addClass('hide');
            },
            error: function(xhr, ajaxOptions, thrownError) {
                alert(xhr.status + ' : ' + xhr.responseText);
            }
        });
    });

    // const editor_en = Jodit.make("#editor_en", {
    //     "uploader": {
    //         "insertImageAsBase64URI": true
    //     },
    //     "spellcheck": true,
    //     "toolbarButtonSize": "small",
    //     "enter": "P",
    //     // "defaultMode": "3"
    // });

    // const editor_ar = Jodit.make("#editor_ar", {
    //     "uploader": {
    //         "insertImageAsBase64URI": true
    //     },
    //     "spellcheck": true,
    //     "toolbarButtonSize": "small",
    //     "enter": "P",
    //     // "defaultMode": "3"
    // });

    $(".modal_consent").click(function(e) {
        let type = $(this).attr("title");
        if (type == "Edit") {
            var consent_ = $(".consent_list").parent().find(".active"),
                id = consent_[0].id;
            text = consent_[0].text;
            $("#consent_id").val(id);
            $("#consent_name").val(text);
        } else {
            $("#consent_id").val("");
            $("#consent_name").val("");
        }

        $("#consent_type").text(type + " ");
        $("#modal_consent").modal({
            keyboard: false,
        });
    });



    const editor_en = Jodit.make("#editor_en", {
        "saveModeInStorage": true
    });
    editor_en.value = "<p></p>";

    const editor_ar = Jodit.make("#editor_ar", {
        "saveModeInStorage": true
    });
    editor_ar.value = '<p style="text-align: right;"></p>';
</script>