<div class="tab-pane fade" id="priceList" role="tabpanel" aria-labelledby="qlm-config-tab">
<form action="" method="POST" id="couponForm">
    <!-- Coupon Code -->
  <div class="row">
    <div class="form-group col-md-6">
        <label for="code">Coupon Code</label>
        <input type="text" class="form-control" required id="code" name="code" required placeholder="Enter coupon code">
    </div>
   
    
    <!-- Description -->
    <div class="form-group col-md-6">
        <label for="description">Description</label>
        <textarea class="form-control" id="description"  name="description" rows="3" placeholder="Enter a brief description"></textarea>
    </div>
    
    <!-- Discount Type -->
    <div class="form-group col-md-6">
        <label for="discount_type">Discount Type</label>
        <select class="form-control" id="discount_type" name="discount_type" required>
            <option value="percentage">Percentage</option>
            <option value="fixed">Fixed Amount</option>
        </select>
    </div>
    
    <!-- Discount Value -->
    <div class="form-group col-md-6">
        <label for="discount_value">Discount Value</label>
        <input type="number" class="form-control" id="discount_value" name="discount_value" step="0.01" required placeholder="Enter discount value">
    </div>
    
    <!-- Valid From -->
    <div class="form-group col-md-6">
        <label for="valid_from">Valid From</label>
        <input type="date" class="form-control" id="valid_from" name="valid_from" required>
    </div>
    
    <!-- Valid Until -->
    <div class="form-group col-md-6">
        <label for="valid_until">Valid Until</label>
        <input type="date" class="form-control" id="valid_until" name="valid_until" required>
    </div>
    
    <!-- Minimum Purchase -->
    <div class="form-group col-md-6">
        <label for="min_purchase">Minimum Purchase</label>
        <input type="number" class="form-control" id="min_purchase" name="min_purchase" step="0.01" placeholder="Enter minimum purchase amount (optional)">
    </div>
    
    <!-- Maximum Discount Value -->
    <div class="form-group col-md-6">
        <label for="max_discount_value">Maximum Discount Value</label>
        <input type="number" class="form-control" id="max_discount_value" name="max_discount_value" step="0.01" placeholder="Enter max discount value (optional)">
    </div>
    
    <!-- Applicable To -->
    <div class="form-group col-md-6">
        <label for="applicable_to">Applicable For</label>
        <select class="form-control" id="applicable_to" name="applicable_to" required>
            <option value="all">All Patients</option>
            <option value="birthdays">Birthdays</option>
            <option value="selected">Selected Patients</option>
        </select>
    </div>

    <div class="form-group col-md-6" style="display: none;" id="selectuser">
        <label for="applicable_to">Select User</label>
        <select class="" id="users" name="users[]"   multiple>
           
         
        </select>
    </div>
    
    <!-- Is Active -->
    <div class="form-group col-md-6">
        <label for="is_active">Is Active</label>
        <select class="form-control" id="is_active" name="is_active">
            <option value="1" selected>Active</option>
            <option value="0">Inactive</option>
        </select>
    </div>

    <div class="form-group col-md-6">
        <label for="is_active">Notification Channel</label>
        <p><i class="fa fa-info-circle mr-1"></i> Please ensure sufficient credits are available for this channel.</p>
        <select class="form-control" id="notification_type" required name="notification_type">
         <option value="">--Please Select--</option>
            <option value="1">SMS</option>
            <option value="2">Whatsapp</option>
        </select>
    </div>
    </div>
    
    <!-- Submit Button -->
    <button type="submit" class="btn btn-sm btn-light mt-1 "><i class="fa fa-save mr-1"></i>Create Coupon</button>
</form>
<hr>
<div class="col-md-12 mt-3">
            <h4>All Coupons</h4>

            <table class="table table-bordered">
                <thead>
                    <th> ID</th>
                    <th>Code</th>
                    <th>Discount Type</th>
                    <th>Discount Value</th>
                    <th>Minimum Amount</th>
                    <th>Valid From</th>
                    <th>Valid Untill</th>
                    <th>Applicable For</th>
                    <th>Notification Channel</th>
                  
                    <th class="text-center">Status</th>
                    <th class="text-center">Actions</th>
                </thead>
                <tbody id="notification_reminder_table_body"></tbody>
            </table>
        </div>
</div>
<link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/js/bootstrap4-toggle.min.js"></script>
<style>
  .toggle.ios, .toggle-on.ios, .toggle-off.ios { border-radius: 20rem; }
  .toggle.ios .toggle-handle { border-radius: 20rem; }
</style>
<script>

    $('#couponForm').submit(function(e) {
        e.preventDefault(); // Prevent the default form submission

        $.ajax({
            url: '<?php echo base_url('admin/Coupon/CouponController/create_coupon') ?>',  // Replace with your actual controller path
            type: 'POST',
            data: $(this).serialize(),  // Serialize form data
            dataType: 'json',  // Expect JSON response from the server
            success: function(response) {
                if (response.success) {
                    // Display success message and clear form
                 
                    successNotification(response.message);
                    
                    $('#couponForm')[0].reset();
                    if(multUserSelect != undefined){
                        multUserSelect.destroy();
                    multUserSelect = undefined;
                    }
                   
                    if ($("#selectuser").is(":visible")) {
                        $("#selectuser").hide(); // Hide the element if it is visible

                        $('#users').attr('required',false);
                        }
                    
                 loadNotificationRemindersToTable();
                } else {
                    // Display error message
                    $('#errorMessage').html('<div class="alert alert-danger">' + response.message + '</div>');
                }
            },
            error: function(xhr, status, error) {
                // Handle server errors
                $('#errorMessage').html('<div class="alert alert-danger">An error occurred: ' + xhr.responseText + '</div>');
            }
        });
    });


    loadNotificationRemindersToTable();
    function loadNotificationRemindersToTable() {
        $('.loader-remind').show();
        // Load Existing templates here using -> 'notification_type'
        $.ajax({
            url: '<?= base_url('index.php/admin/Coupon/CouponController/get_all'); ?>',
            method: 'POST',
            dataType: 'json',
            data: {
                notification_type: $('#notifications_type').val()
            },
            success: function(response) {
                $('.loader-remind').hide();

                let _row = '';

                $.each(response, function(index, row) {
                    let data = {};

                    _row += `<tr data-id="${row.id}">
                        <td>${row.id}</td>
                        <td>${row.code.toUpperCase()}</td>
                        <td>${row.discount_type.toUpperCase()}</td>
                        <td>${row.discount_value.toUpperCase()}</td>
                        <td>${row.min_purchase}</td>
                        <td>${row.valid_from} </td>
                        <td>${row.valid_until} </td>
                        <td>${row.applicable_to.toUpperCase()} </td>
                        <td>${row.notification_type == 1 ? 'SMS' : row.notification_type == 2 ? 'WhatsApp' : 'Unknown'}</td>
                      
                        <td class="text-center">  
                        <input type="checkbox" class="checkbox"  data-on=""   data-size="sm" data-style="ios" data-off="" data-toggle="toggle" ${row.is_active == 1 ? 'checked' : ''}>
                
                        </td>
                        <td class="text-center">  
                        <a class="btn btn-sm btn-light delete-btn" data-id="${row.id}"><i class="fa fa-trash"></i></a>
                
                        </td>
                        
                    </tr>`;
                    //console.log(row);
                });

                $('#notification_reminder_table_body').html(_row);
                $('.checkbox').bootstrapToggle() 
            },
            error: function(xhr, status, error) {

                console.error('Error:', error);
            }
        });
    }


    $('#applicable_to').change(function(){
        var value = $(this).val();
        if(value == 'selected'){
            $('#selectuser').show();
            $('#users').attr('required',true);
            if(multUserSelect == undefined){
                
                initTomSelectPatietns( $('#users'))
            }
            
        }else{
            $('#selectuser').hide();
            $('#users').attr('required',false);
            // $('#selectuser').reset();
            multUserSelect.destroy();
            multUserSelect = undefined
        }
    })


    var multUserSelect = undefined

function initTomSelectPatietns(selector) {
   
    multUserSelect = new TomSelect(selector, {
        valueField: 'patient_id',
        labelField: 'patient_name',
        searchField: ['patient_name','qatar_id'],
      
        persist: false,
        createOnBlur: false,
        create: true,
        plugins: {
		remove_button:{
			title:'Remove this item',
		}
	},
        // Set the "load" property to define the function to fetch data dynamically
        load: function(query, callback) {
            var apiUrl = "<?php echo site_url('admin/Patients/PatientsController/getpatients?'); ?>";

            fetch(apiUrl)
                .then(response => response.json())
                .then(data => {
                    callback(data);
                })
                .catch(() => {
                    callback();
                });
        },
        render: {
            option: function(item, escape) {
                return '<div>' +
                    '<span class="btn btn-sm">' + escape(item.patient_name) + '- '+ escape(item.qatar_id) + '</span>' +
                    '</div>';
            },
            item: function(item, escape) {
                return '<div>' +
                    '<span class="btn  btn-sm">' + escape(item.patient_name) + '</span>' +
                    '</div>';
            }
        },
    });

    // Optional: You can also set a minimum number of characters before triggering the API call
    multUserSelect.settings.minLength = 2;
    multUserSelect.settings.placeholder = "Select User";
}

$(document).on('click', '.delete-btn', function () {
    var id = $(this).data('id'); // Get the ID from data attribute
    
    // SweetAlert confirmation
    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            // If confirmed, send the AJAX request
            $.ajax({
                url: '<?php echo base_url('admin/Coupon/CouponController/delete_item') ?>', // Your delete URL here
                type: 'POST',
                data: { id: id }, // Send the ID
                success: function (response) {
                    Swal.fire(
                        'Deleted!',
                        'Your item has been deleted.',
                        'success'
                    );
                    // Optionally, you can remove the deleted element from the DOM
                    loadNotificationRemindersToTable(); // Assuming you want to remove a table row
                },
                error: function () {
                    Swal.fire(
                        'Error!',
                        'There was an issue deleting the item.',
                        'error'
                    );
                }
            });
        }
    });
});

$(document).on('change', 'input[type="checkbox"][data-toggle="toggle"]', function() {
    var reminderId = $(this).closest('tr').data('id');  // Assuming reminder ID is stored in the row data attribute
    var isActive = $(this).is(':checked') ? 1 : 0;  // Get the status from the checkbox
   $('.loader-remind').show();
    $.ajax({
        url: '<?= base_url("index.php/admin/Coupon/CouponController/updateCouponStatus") ?>',
        method: 'POST',
        data: {
            id: reminderId,
            status: isActive
        },
        success: function(response) {
            var result = JSON.parse(response);
            $('.loader-remind').hide();
            if (result.status === 'success') {
                // You can show success message or update UI accordingly
               successNotification('Status Updated Successfully')
            } else {
                console.log('Failed to update status.');
            }
        },
        error: function() {
            $('.loader-remind').hide();
            console.log('Error updating status.');
        }
    });
});

</script>