<div class="tab-pane fade" id="priceList" role="tabpanel" aria-labelledby="qlm-config-tab">
<form action="" method="POST" id="loyaltyForm">
    <!-- Coupon Code -->
    <div class="row">
   
     <!-- Program Name -->
  <div class="form-group col-md-6">
    <label for="programName" class="col-sm-3 col-form-label">Program Name</label>
    <div class="col-sm-9">
      <input type="text" class="form-control" id="programName" name="programName" placeholder="Enter Program Name" required>
    </div>
  </div>

  <!-- Points Per Dollar -->
  <div class="form-group col-md-6">
    <label for="pointsPerDollar" class="col-sm-3 col-form-label">Points Per QAR</label>
    <div class="col-sm-9">
      <input type="number" class="form-control" id="pointsPerDollar" name="pointsPerDollar" placeholder="Points earned per dollar" step="0.01" value="1.00" required>
    </div>
  </div>
 
  <!-- Minimum Points to Redeem -->
  <div class="form-group col-md-6">
    <label for="minPointsToRedeem" class="col-sm-3 col-form-label">Minimum Points to Redeem</label>
    <div class="col-sm-9">
      <input type="number" class="form-control" id="minPointsToRedeem" name="minPointsToRedeem" placeholder="Minimum points required for redemption" value="100" required>
    </div>
  </div>

  <!-- Discount Per Point -->
  <div class="form-group col-md-6">
    <label for="discountPerPoint" class="col-sm-3 col-form-label">Discount Per Point</label>
    <div class="col-sm-9">
      <input type="number" class="form-control" id="discountPerPoint" name="discountPerPoint" placeholder="Discount value per point" step="0.01" value="0.01" required>
    </div>
  </div>

  <!-- Program Status -->
  <div class="form-group col-md-6">
    <label for="programStatus" class="col-sm-3 col-form-label">Program Status</label>
    <div class="col-sm-9">
      <select class="form-control" id="programStatus" name="programStatus" required>
        <option value="1" selected>Active</option>
        <option value="0">Inactive</option>
      </select>
    </div>
  </div>

  <div class="form-group col-md-6">
    <label for="programStatus" class="col-sm-3 col-form-label">Expired After</label>
    <div class="col-sm-9">
      <select class="form-control" id="expiredAfter" name="expiredAfter" required >
      <option class="">-- Select Months--</option>
        <option class="0" >Never</option>
        <?php  for($i=1; $i<=12; $i++){ ?>
            <option value="<?= $i; ?>"><?= $i . ' ' . ($i == 1 ? 'Month' : 'Months'); ?></option>
      <?php   } ?>
        
     
      </select>
    </div>
  </div>
  </div>
  <!-- Submit Button -->
  <div class="row mt-2">
  <div class="form-group col-md-8 justify-content-start d-flex ">
    <div class="col-sm-12 ">
      <button type="submit" class="btn btn-light btn-sm "> <i class="fa fa-save"></i> Save Loyalty Program</button>
    </div>
  </div>
  </div>
       
  
</form>
<hr>
<div class="col-md-12 mt-3">
            <h4>All Programs</h4>

            <table class="table table-bordered">
                <thead>
                    <th> ID</th>
                    <th>Name</th>
                    <th>Points Per QAR</th>
                    <th>Minimum Points to Redeem</th>
                    <th>Discount Per Point</th>
                   
                  
                    <th class="text-center">Status</th>
                    <th class="text-center">Actions</th>
                </thead>
                <tbody id="notification_reminder_table_body"></tbody>
            </table>
        </div>
</div>
<link href="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/css/bootstrap4-toggle.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/js/bootstrap4-toggle.min.js"></script>
<style>
  .toggle.ios, .toggle-on.ios, .toggle-off.ios { border-radius: 20rem; }
  .toggle.ios .toggle-handle { border-radius: 20rem; }
</style>
<script>

    $('#loyaltyForm').submit(function(e) {
        e.preventDefault(); // Prevent the default form submission

        $.ajax({
            url: '<?php echo base_url('admin/Coupon/CouponController/save_loyalty_program') ?>',  // Replace with your actual controller path
            type: 'POST',
            data: $(this).serialize(),  // Serialize form data
            dataType: 'json',  // Expect JSON response from the server
            success: function(response) {
                if (response.success) {
                    // Display success message and clear form
                 
                    successNotification(response.message);
                    
                    $('#loyaltyForm')[0].reset();
                   
                   
                    
                 loadNotificationRemindersToTable();
                } else {
                    // Display error message
                    $('#errorMessage').html('<div class="alert alert-danger">' + response.message + '</div>');
                }
            },
            error: function(xhr, status, error) {
                // Handle server errors
                $('#errorMessage').html('<div class="alert alert-danger">An error occurred: ' + xhr.responseText + '</div>');
            }
        });
    });


    loadNotificationRemindersToTable();
    function loadNotificationRemindersToTable() {
        $('.loader-remind').show();
        // Load Existing templates here using -> 'notification_type'
        $.ajax({
            url: '<?= base_url('index.php/admin/Coupon/CouponController/get_all_programs'); ?>',
            method: 'POST',
            dataType: 'json',
            data: {
                notification_type: $('#notifications_type').val()
            },
            success: function(response) {
                $('.loader-remind').hide();

                let _row = '';

                $.each(response, function(index, row) {
                    let data = {};

                    _row += `<tr data-id="${row.id}">
                        <td>${row.id}</td>
                        <td>${row.name.toUpperCase()}</td>
                        <td>${row.points_per_dollar}</td>
                        <td>${row.min_points_to_redeem}</td>
                        <td>${row.discount_per_point} </td>
                      
                      
                        <td class="text-center">  
                        <input type="checkbox" class="checkbox"  data-on=""   data-size="sm" data-style="ios" data-off="" data-toggle="toggle" ${row.is_active == 1 ? 'checked' : ''}>
                
                        </td>
                        <td class="text-center">  
                        <a class="btn btn-sm btn-light delete-btn" data-id="${row.id}"><i class="fa fa-trash"></i></a>
                
                        </td>
                        
                    </tr>`;
                    //console.log(row);
                });

                $('#notification_reminder_table_body').html(_row);
                $('.checkbox').bootstrapToggle() 
            },
            error: function(xhr, status, error) {

                console.error('Error:', error);
            }
        });
    }


  




$(document).on('click', '.delete-btn', function () {
    var id = $(this).data('id'); // Get the ID from data attribute
    
    // SweetAlert confirmation
    Swal.fire({
        title: 'Are you sure?',
        text: "You won't be able to revert this!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, delete it!'
    }).then((result) => {
        if (result.isConfirmed) {
            // If confirmed, send the AJAX request
            $.ajax({
                url: '<?php echo base_url('admin/Coupon/CouponController/delete_loyalty_program') ?>', // Your delete URL here
                type: 'POST',
                data: { id: id }, // Send the ID
                success: function (response) {
                    Swal.fire(
                        'Deleted!',
                        'Your item has been deleted.',
                        'success'
                    );
                    // Optionally, you can remove the deleted element from the DOM
                    loadNotificationRemindersToTable(); // Assuming you want to remove a table row
                },
                error: function () {
                    Swal.fire(
                        'Error!',
                        'There was an issue deleting the item.',
                        'error'
                    );
                }
            });
        }
    });
});

$(document).on('change', 'input[type="checkbox"][data-toggle="toggle"]', function() {
    var reminderId = $(this).closest('tr').data('id');  // Assuming reminder ID is stored in the row data attribute
    var isActive = $(this).is(':checked') ? 1 : 0;  // Get the status from the checkbox
   $('.loader-remind').show();
    $.ajax({
        url: '<?= base_url("index.php/admin/Coupon/CouponController/updateLoyaltyStatus") ?>',
        method: 'POST',
        data: {
            id: reminderId,
            status: isActive
        },
        success: function(response) {
            var result = JSON.parse(response);
            $('.loader-remind').hide();
            if (result.status === 'success') {
                // You can show success message or update UI accordingly
               successNotification('Status Updated Successfully')
            } else {
                console.log('Failed to update status.');
            }
        },
        error: function() {
            $('.loader-remind').hide();
            console.log('Error updating status.');
        }
    });
});

</script>