<div class="tab-pane fade" id="priceList" role="tabpanel" aria-labelledby="qlm-config-tab">
<?php if (strlen(trim($this->session->flashdata('ignored'))) > 0) { ?>
            <div class="callout callout-danger error-msg mb-2">
                <i class="icon fa fa-warning"></i><?php echo $this->session->flashdata('ignored'); ?>
            </div>
        <?php } ?>
    <div class="row">
        <div class="col-md-12">
            <h5><label for="">Insurance Price List</label></h5>
        </div>
        <div class="col-md-12">
            <table id="priceListTable" class="display responsive" cellspacing="0" width="100%">
                <thead>
                    <tr>
                        <th>Treatment Code</th>
                        <th>Treatment Name</th>
                        <th>Treatment Name Arabic</th>
                        <th>Insurance Type</th>
                        <th>Department</th>
                        <th>Price</th>
                        <th>Status</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>


<div class="modal fade" id="price_import_modal" tabindex="-1" role="dialog" aria-labelledby="import_patients" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="import_patients">Import Insurance Price List</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <form action="<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/ImportPriceList'); ?>" method="post" enctype="multipart/form-data">
          <div class="modal-body text-center">

            <div class="form-group">
              <i class="fa fa-cloud-upload uploadIcon" aria-hidden="true"></i><br>
              <label class="uploadLablePrice d-block" style="font-size:20px" for="csv_file">CHOOSE A FILE</label>
              <small class="text-danger" style="font-size:17px">"Support only CSV files."</small>
              <input type="file" name="csv_file" id="csv_file" class="form-control" placeholder="Choose CSV File" onchange="handleFileSelect()">
            </div>

            <div id="csv_table_container" class="overflow-auto"></div>

          </div>
          <div class="modal-footer">
            <a href="<?php echo base_url('template_formats/import_price_list.csv') ?>" class="btn btn-dark btn-sm" download target="_blank">
              <i class="fa fa-download" aria-hidden="true"></i>
              Download CSV Template
            </a>
            <button type="button" class="btn btn-light btn-sm" data-dismiss="modal">
              <i class="fa fa-times-circle" aria-hidden="true"></i>
              Close
            </button>
            <button type="submit" class="btn btn-light btn-sm">
              <i class="fa fa-check-circle" aria-hidden="true"></i>
              Submit
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <script>
    var DataTableEditor;
  
        DataTableEditor = new $.fn.dataTable.Editor({
            "ajax": '<?php echo base_url('index.php/admin/Setting/Configurations/ConfigurationsController/priceList') ?>',
            "table": "#priceListTable",
            "fields": [{
                "label": "Treatment Code:",
                "name": "tbl_insurance_prices.treatment_id"
            }, {
                "label": "Treatment Name:",
                "name": "tbl_insurance_prices.treatment_name",
            }, {
                "label": "Treatment Name Arabic:",
                "name": "tbl_insurance_prices.treatment_name_ar",
            }, {
                "label": "Insurance:",
                "name": "tbl_insurance_prices.insurance_type_id",
                "type": "select",
                options: <?php echo json_encode($insurance_types); ?>
            }, {
                "label": "Price:",
                "name": "tbl_insurance_prices.lqdc_gross",
            }, {
                "label": "Treatment Category:",
                "name": "tbl_insurance_prices.treatment_category",
                "type": "select",
                options: <?php echo json_encode($departments); ?>
            }, {
                "label": "Status:",
                "name": "tbl_insurance_prices.deleted",
                "type": "select",
                options: [{
                        "value": "0",
                        "label": "Activate"
                    },
                    {
                        "value": "1",
                        "label": "Deactivate"
                    }
                ]
            }]
        });

        $('#priceListTable').DataTable({
            dom: "Blfrtip",
            ajax: {
                url: '<?php echo base_url('index.php/admin/Setting/Configurations/ConfigurationsController/priceList') ?>',
                type: "POST"
            },
            serverSide: true,
            columns: [{
                    data: "tbl_insurance_prices.treatment_id"
                },
                {
                    data: "tbl_insurance_prices.treatment_name"
                },
                {
                    data: "tbl_insurance_prices.treatment_name_ar"
                },
                {
                    data: "tbl_insurance_types.insurance_name"
                },
                {
                    data: "tbl_modules.module_name"
                },
                {
                    data: "tbl_insurance_prices.lqdc_gross"
                },
                {
                    data: "tbl_status.status_name"
                }
            ],
            select: true,
            responsive: true,
            paging: true,
            lengthChange: true,
            lengthMenu: [
                [10, 25, 50, 100, -1],
                [10, 25, 50, 100, "All"]
            ],
            buttons: [{
                    extend: "create",
                    editor: DataTableEditor
                },
                {
                    extend: "edit",
                    editor: DataTableEditor
                },
                {
                    extend: "remove",
                    editor: DataTableEditor
                },
                {
                    extend: 'excel',
                    title: `Price List`
                },
                {
                    text: "Upload",
                    action: function(e, dt, node, config) {
                        $('#price_import_modal').modal('show');
                    }
                }
            ]
        });
     
        function handleFileSelect() {
        const fileInput = document.getElementById('csv_file');
        const file = fileInput.files[0];

        if (file) {
            const reader = new FileReader();

            reader.onload = function(e) {
                const contents = e.target.result;
                displayCSVContents(contents);
            };

            reader.readAsText(file);
        }
    }

    function displayCSVContents(contents) {
        const csvTableContainer = document.getElementById('csv_table_container');
        const lines = contents.split('\n');
        const table = document.createElement('table');
        table.setAttribute('class', 'table table-bordered');

        // Create thead
        const thead = document.createElement('thead');
        thead.setAttribute('class', 'thead-dark');
        const headerRow = lines[0].split(',').map(header => {
            return header.trim().replace(/_/g, ' ').replace(/\b\w/g, c => c.toUpperCase());
        });

        const headerRowElement = document.createElement('tr');
        headerRow.forEach(header => {
            const th = document.createElement('th');
            th.textContent = header;
            headerRowElement.appendChild(th);
        });

        thead.appendChild(headerRowElement);
        table.appendChild(thead);

        // Create tbody
        const tbody = document.createElement('tbody');
        lines.slice(1).forEach(line => {
            const row = tbody.insertRow();
            const cells = line.split(',');

            cells.forEach(cell => {
                
                const cellElement = document.createElement('td');
                cellElement.textContent = cell.trim();
                row.appendChild(cellElement);
            });
        });

        table.appendChild(tbody);

        csvTableContainer.innerHTML = ''; // Clear previous content
        csvTableContainer.appendChild(table);
    }


  </script>