<div class="col-md-6 form-container">  
    <form id="discountCategory"  method="post" enctype="multipart/form-data">
         
        <div class="col-md-12 mt-4">
		<input type="hidden" name="cat_id" id="discountcat_id">
            <div class="form-group">
                <label for="">Patient Category </label>
                <input type="text" name="category_name" id="category_name" class="form-control" placeholder="Category Name" />
            </div>     
            
            <div class="form-group">
                <label for="">Discount</label>
                <input type="number" name="discount" id="discount_category" class="form-control" placeholder="Discount in percentage (%)" />
                <p><i class="fa fa-info-circle mr-1"></i> Please enter the discount as a percentage. If the patient falls into this category, they will receive this percentage discount on any procedure.</p>

            </div>  
                
            </div>
            <div class="col-md-12 mt-4 d-flex justify-content-end">
            <button type="submit" class="btn btn-light btn-sm  mb-2"><i class="fa fa-check-circle"></i> Save</button>
            </div>
            </form>
            </div> 
            <hr>
            <div class="row">
        
            <div class="col-md-12">
            <table class="table-striped" id="discount_categories">
                    <tr>
                        <th>NO</th>
                        <th>Name</th>
                        <th>Discount</th>
                    </tr>
            </table>
            </div>
           
            
            </div>


    
<script type="text/javascript">

	var dataTable = undefined;
	$(document).ready(function() {
		// Initialize the DataTable
		dataTable = $('#discount_categories').DataTable({
			dom: 'lBfrtip',
			buttons: [{
				extend: 'excel',
				title: `Discount Categories`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `Daily Collection Report`,
				exportOptions: {
					columns: ':not(:last-child)'
				},
				customize: function(win) {
					$(win.document.body).prepend(`<?php print_header($this); ?>`);
				}
			}, ],
			'ajax': {
				'url': '<?= site_url('admin/Setting/Configurations/ConfigurationsController/get_discount_categories'); ?>',
				'type': 'GET',
				'data': function(d) {
					d.receptionist = $('#receptionist').val();
					d.fromdate = $('#fromdate').val();
					d.todate = $('#todate').val();
				}
			},
			'columns': [{
					'data': 'id',
					'title': ' No.'
				},
				{
					'data': 'category',
					'title': 'Category Name'
				},
				{
					'data': 'discount',
					'title': 'Discount(%)',
					'render': function(data,type,row){
						return row.discount+'%';
					}
				},
                {
					'data': '',
					'title': 'Action',
                    'render': function(data, type, row) {
					 $html = '<a href="" class="btn btn-light edit-discount" data-id="'+row.id+'"><i class="fa fa-pencil"></i></a><a href="" data-id="'+row.id+'" class="btn btn-light delete-discount"><i class="fa fa-trash"></i></a>'
					return $html;
				}
				},
				
			],
			'searching': false,
			'serverSide': true,
			'pageLength': 10,
			aLengthMenu: [
				[25, 50, 100, 200, -1],
				[25, 50, 100, 200, "All"]
			],
			'pagingType': 'full_numbers',
			footer:true,
			autoWidth: false

		});



		$('#receptionist, #fromdate,#todate ').on('change', function() {
			dataTable.ajax.reload();
		});
	});

	

</script>

<script>
    $(document).ready(function() {
    $('#discountCategory').on('submit', function(e) {
        e.preventDefault(); // Prevent the default form submission
        
        let formData = new FormData(this);

        $.ajax({
            url: '<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/SaveDiscountCategories'); ?>',
            type: 'POST',
            data: formData,
            contentType: false,
            processData: false,
            success: function(response) {
                // Handle the success response here
                let res = JSON.parse(response);
              successNotification(res.message);
              dataTable.ajax.reload();
			  $('#discountCategory')[0].reset();
            },
            error: function(xhr, status, error) {
                // Handle the error response here
                alert('An error occurred while saving the discount settings.');
            }
        });
    });
	$('#discount_categories').on('click', '.edit-discount', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
      
        
        $.ajax({
            url: '<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/getDiscountCatById'); ?>',
            type: 'POST',
            data: { id: id },
            dataType: 'json',
            success: function(response) {
                $('#discountcat_id').val(response.id);
                $('#category_name').val(response.category);
               
                $('#discount_category').val(parseFloat(response.discount));
                if( $('.form-container').hasClass('shake')){
                    $('.form-container').removeClass('shake').outerWidth();
                   
                }
                    $('.form-container').addClass('shake');    
				
               
            },
            error: function(xhr, status, error) {
                alert('An error occurred while fetching the discount data.');
            }
        });
    });

	  // Delete discount
	  $('#discount_categories').on('click', '.delete-discount', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
        
        Swal.fire({
			title: "Are you sure?",
			text: "You won't be able to revert this!",
			icon: "warning",
			showCancelButton: true,
			confirmButtonColor: "#3085d6",
			cancelButtonColor: "#d33",
			confirmButtonText: "Yes, delete it!"
		}).then((result) => {
			if (result.isConfirmed) {
				$.ajax({
                url: '<?= base_url('index.php/admin/Setting/Configurations/ConfigurationsController/deleteDiscountCategory'); ?>',
                type: 'POST',
                data: { id: id },
                success: function(response) {
                    let res = JSON.parse(response);
                    successNotification(res.message);
                    dataTable.ajax.reload();
                },
                error: function(xhr, status, error) {
                    alert('An error occurred while deleting the discount.');
                }
            });
			}
		});

       
    });




});
</script>       