<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title> Page Setup</title>
        <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

        <!--image crop-->
        <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
        <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>


        <?php require_once(APPPATH . "views/admin/header.php"); ?>
    </head>
    <body class="<?php echo $this->config->item('theme'); ?> fixed">
        <!-- Site wrapper -->


        <!-- Header Navbar: style can be found in header.less -->
        <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Left side column. contains the sidebar -->
        <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

        <!-- =============================================== -->

        <!-- Right side column. Contains the navbar and content of the page -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <section class="content-header">
                <h1>
                    Page setup
                </h1>
                <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
            </section>

                <form id="save_form" name ="save_form" role="form" action="<?php echo base_url('index.php/admin/Setting/PageSetup/PageSetupController/Save') ?>" method="post" >
                <section class="content">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="box margin-bottom-5px box-warning">
                                <div class="box-body">
                                    <div class="row">
                                        <div class="col-md-1">
										
											  <div class="col-md-1">
												  <a href="<?php echo base_url('index.php/admin/Setting/PageSetup/PageSetupController') ?>" class="btn btn-info"><i class="fa fa-angle-left"></i> Go back </a>
											  </div>
										
										</div>
                                        <div class="col-md-9">
                                            <?php if (validation_errors()) { ?>
                                                <div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
        <!--                                                      <i class="icon fa fa-warning"></i>-->
                                                    <div>

                                                        <p><i class="icon fa fa-warning"></i>There is a problem that we need to fix.</p>
                                                    </div>
                                                </div>
                                            <?php } ?>
                                        </div>
                                        <div class="col-md-2">
                                            <a href="#" onclick="document.getElementById('save_form').submit(); return false;" class="btn btn-block btn-social <?php echo $this->config->item('save'); ?>">
                                                <i class="fa fa-save"></i> Save Home
                                            </a>
                                        </div>
                                    </div>	
                                </div><!-- /.box-body -->
                            </div>
                            <div class="box box-info">
                                <div class="row" style="padding: 20px;">
									<div class="col-md-3">
										<div class="form-group <?php echo form_error("template_id") ? "has-error" : "" ?>">
											  <label>Template Name</label>
											  <select id="template_id" name="template_id" data-control="template_change" class="form-control selectpicker"  placeholder="Enter ..." data-live-search="true"/>

												<option  value="0" <?php echo $template_id == 0 ? 'selected' : '' ?>  >Select</option>

												<?php foreach ($template->result() as $value) { ?>

													<option  value="<?php echo $value->site_template_id ?>" <?php echo $value->site_template_id == $template_id ? 'selected' : '' ?>  ><?php echo $value->template_name ?></option>

												<?php } ?>
											  </select>
											  <label><small><?php echo form_error("template_id"); ?></small></label>
										</div>  
									</div>
								
									<div class="col-md-3">
										<div class="form-group <?php echo form_error("page_id") ? "has-error" : "" ?>">
											  <label>Page Name</label>
											  <select id="page_id" name="page_id" class="form-control selectpicker"  placeholder="Enter ..." data-live-search="true"/>

												<option  value="0" <?php echo $page_id == 0 ? 'selected' : '' ?>  >Select</option>

												<?php foreach ($page->result() as $value) { ?>

													<option  value="<?php echo $value->site_page_id ?>" <?php echo $value->site_page_id == $page_id ? 'selected' : '' ?>  ><?php echo $value->page_name ?></option>

												<?php } ?>
											  </select>
											  <label><small><?php echo form_error("page_id"); ?></small></label>
										</div>  
									</div>
                                </div>
                            </div>
              
                        </div><!--/.col (right) -->
                    </div>
					<div class="row">
						<div class="col-xs-12">
                            <div class="box box-solid">
                                <div class="row" style="padding: 20px;">
									<div class="col-md-12">
										<table id="product_grid" class="table table-bordered table-striped">
									<thead>
									  <tr class="<?php echo $this->config->item('grid_header'); ?>">
										<th class="col_5"></th>
										<th class="col_85">Widget</th>
										<th class="col_10">Widget order</th>
									  </tr>
									</thead>
									<tbody>
										
										<?php if( form_error("is_row_available") != '' ){ ?> 
											<tr>
												<td colspan="11" class="gridError">
													<?php echo  form_error("is_row_available") ?>
												</td>
											</tr>
										<?php } ?>
										
										<?php $item_count = 0; foreach ($dynamicGrid_details as $key => $value) { $item_count++; ?>
										<tr id="gridRow_<?php echo $item_count ?>">
											<td align="center">
												<input data-control="chkGridSelected" <?php echo $value['is_selected'] == 1 ? 'checked' : '' ?> type="checkbox" id="grid_dynamic_isSelected_<?php echo $item_count ?>" name="grid_dynamic_isSelected_<?php echo $item_count ?>" value="1">
											</td>
											<td>
												<p><?php echo $value['widgets_file_name'] ?></p>
												<input type="hidden" id="grid_dynamic_widgetName_<?php echo $item_count ?>" name="grid_dynamic_widgetName_<?php echo $item_count ?>" value="<?php echo $value['widgets_file_name'] ?>">
												<input type="hidden" id="grid_dynamic_widgetId_<?php echo $item_count ?>" name="grid_dynamic_widgetId_<?php echo $item_count ?>" value="<?php echo $value['site_widgets_id'] ?>">
											</td>
											<td class="<?php echo form_error("grid_dynamic_widgetOrder_".$item_count) ? "has-error" : "" ?>">
												<input <?php echo $value['is_selected'] == 1 ? '' : 'readonly' ?> type="text" id="grid_dynamic_widgetOrder_<?php echo $item_count ?>" value=" <?php echo $value['is_selected'] == 1 ? $value['widget_order'] : '0' ?>" name="grid_dynamic_widgetOrder_<?php echo $item_count ?>" class="form-control input_numbers text-right" placeholder=""> 
											</td>
										</tr>
										
										<?php if( form_error("grid_dynamic_widgetOrder_".$item_count) != '' ){ ?> 

											<tr id="gridErrorRow_<?php echo $item_count ?>">
												<td colspan="11" class="gridError">

													<?php echo form_error("grid_dynamic_widgetOrder_".$item_count) ? '<p class="p"><i class="fa fa-info-circle"></i>Widget order</p> '.form_error("grid_dynamic_widgetOrder_".$item_count) : "" ?>

												</td>
											</tr>

										<?php } ?>
									<?php } ?>

									</tbody>
								  </table>  
									</div>
                                </div>
                            </div>
						</div>
					</div>
                </section><!-- /.content -->
		
		<input type="hidden" runat="server" id="page_component_id" name="page_component_id" value="<?php echo $page_component_id ?>">
		
            </form>
            
        </div>

        <!-- ./wrapper -->


        <?php require_once(APPPATH . "views/admin/footer.php"); ?>


    </body>
</html>

<script>

	
	$(document).on('change', '[data-control=template_change]', function(e){
			
		document.getElementById('save_form').action = '<?php echo base_url('index.php/admin/Setting/PageSetup/PageSetupController/Change_Template') ?>';
			document.getElementById('save_form').target= '_parent'; 
			document.getElementById('save_form').submit(); return false;
			
		}); 
	
	$('.content').on('change', '[data-control=chkGridSelected]', function(e) {
			
			var data = e.target.id.split('_');
			var id = data[3];
			var is_checked = $(this).prop('checked');
			
		
			$('#grid_dynamic_widgetOrder_'+id).prop('readonly',true);
			$('#grid_dynamic_widgetOrder_'+id).val('');
			
			if($(this).prop('checked')){
				$('#grid_dynamic_widgetOrder_'+id).prop('readonly',false);
			}
		
		});
		

</script>








