<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>

    <style>
        .bg-white {
            background-color: white;
        }

        .tab-pane {
            padding: 10px;
        }

        .editor {
            height: 700px;
        }

        .mb-1 {
            margin-bottom: 10px;
        }

        .uploadIcon {
            font-size: 5em !important;
            color: #084a6a;
        }

        .uploadLablePrice {
            cursor: pointer;
            padding: 10px;
            cursor: pointer;
            animation: blink 1s infinite;
        }


        .DTED_Lightbox_Content {
            border: none !important;
        }

        .DTED_Lightbox_Content .DTE .DTE_Header {
            background-color: #084a6a !important;
            color: white;
            height: 58px !important;
        }

        .DTED_Lightbox_Content .DTE .DTE_Footer {
            background-color: none !important;
        }

        .DTE_Field_Input .DTE_Field_InputControl input {
            display: block;
            width: 100%;
            padding: .375rem .75rem;
            line-height: 1.5;
            color: #495057;
            background-color: #fff;
            background-clip: padding-box;
            border: 1px solid #ced4da;
            transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
            border-radius: 0 !important;
            box-shadow: none;
            border-color: #d2d6de;
        }
        .DTE_Field_Input .DTE_Field_InputControl input:focus {
            background-color: #fff;
            border: 1px solid #ced4da!;
            transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
        }

        .DTE_Field_Input .DTE_Field_InputControl select {
            display: block;
            width: 100%;
            padding: .375rem .75rem;
            line-height: 1.5;
            color: #495057;
            background-color: #fff;
            background-clip: padding-box;
            border: 1px solid #ced4da;
            transition: border-color .15s ease-in-out, box-shadow .15s ease-in-out;
            border-radius: 0 !important;
            box-shadow: none;
            border-color: #d2d6de;
        }
        .receipt {
     
      margin: 50px auto;
      padding: 20px;
      border: 1px solid #e3e3e3;
      border-radius: 5px;
    }
    .receipt-header {
      text-align: center;
      margin-bottom: 20px;
    }
    .receipt-details {
      margin-bottom: 20px;
    }
    </style>

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jodit/3.24.9/jodit.es2018.en.min.css" />
    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/jquery.dataTables.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/buttons.dataTables.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/select.dataTables.min.css'); ?>" rel="stylesheet">
    <link href="<?php echo base_url('js/Services/Pharmacy/lib/css/editor.dataTables.min.css'); ?>" rel="stylesheet">

</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                All User Transactions
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>


        <!-- Main content -->

        <section class="content bg-white">

            <!-- <div class="row">
                <div class="col-md-12">
                    <div class="form-group col-md-4">
                        <label for="">Select Transaction Type</label>
                      <select name="" id="type" class="form-control">
                        <option value="">--Select Type--</option>
                        <option value="whatsapp_package">Whatsapp Package Purchase</option>
                        <option value="sms_package">SMS Package Purchase</option>
                        <option value="H-Mate Subscription Renewal"> H-Mate Subscription Renewal </option>
                      </select>
                    </div>
                </div>
            </div> -->

            <div class="row">
            <div class="col-md-12 table-responsive bg-white p-3 ">
            <table class="table-striped" id="discount_categories">
                    <tr>
                        <th>NO</th>
                        <th>Name</th>
                        <th>Discount</th>
                    </tr>
            </table>
            </div>
            </div>
        </section>
                  
                   
    </div>

<?php require_once(APPPATH . "views/admin/footer.php"); ?>
   
<script type="text/javascript">

	var dataTable = undefined;
	$(document).ready(function() {
		// Initialize the DataTable
		dataTable = $('#discount_categories').DataTable({
			dom: 'lBfrtip',
			buttons: [{
				extend: 'excel',
				title: `Transactions History`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `Transactions History`,
				exportOptions: {
					columns: ':not(:last-child)'
				},
				customize: function(win) {
					$(win.document.body).prepend(`<?php print_header($this); ?>`);
				}
			}, ],
			'ajax': {
				'url': '<?= site_url('admin/SkipCash/TransactionController/getTransactions'); ?>',
				'type': 'GET',
				'data': function(d) {
					d.type = $('#type').val();
					
				}
			},
			'columns': [{
					'data': 'id',
					'title': ' No.'
				},
				{
					'data': 'transaction_id',
					'title': 'Transations ID'
				},
                {
					'data': 'type',
					'title': 'Type'
				},
				{
					'data': 'amount',
					'title': 'amount',
					'render': function(data,type,row){
						return row.amount+'QR';
					}
				},
                {
					'data': null,
					'title': 'Status',
                    'render': function(data,type,row){
						if(row.status=='Completed'){
                            return '<span class="badge badge-success">'+row.status+'</span>';
                        }else{
                            return '<span class="badge badge-warning">'+row.status+'</span>';
                        }
					}
					
				},
                {
					'data': '',
					'title': 'Action',
                    'render': function(data, type, row) {
					 $html = '<a href="<?php echo base_url() ?>admin/SkipCash/TransactionController/Invoice/'+row.id+'" class="btn btn-light btn-sm" data-id="'+row.id+'"><i class="fa fa-file mr-1"></i>Invoice</a>'
					return $html;
				}
				},
               
				
			],
			'searching': false,
			'serverSide': true,
			'pageLength': 10,
			aLengthMenu: [
				[25, 50, 100, 200, -1],
				[25, 50, 100, 200, "All"]
			],
			'pagingType': 'full_numbers',
			footer:true,
			autoWidth: false

		});



		$('#type').on('change', function() {
			dataTable.ajax.reload();
		});
	});

	

</script>



</body>

</html>


