<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>

    <style>
        .dataTables_info {
            display: none !important;
        }
    </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                <strong>SMS Portal</strong>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title"></h3>
                        </div>

                        <div class="box-body">
                            <div class="panel-group" id="accordion">

                                <div class="row">
                                    <div class="col-md-6">
                                        <form action="<?= base_url('index.php/admin/SmsPortal/SmsPortalController/sendIndividualSms'); ?>" method="post">
                                            <h4>Send Messages To Individuals</h4>
                                            <div class="form-group">
                                                <label for="patient">Patient</label>
                                                <select name="patient" id="patient">
                                                    <option value="">Choose Patient</option>
                                                </select>
                                                <?= _e($this, 'patient'); ?>
                                            </div>

                                            <div class="form-group">
                                                <label for="message">Message</label>
                                                <textarea name="message" id="message" rows="10" class="form-control mt-2" placeholder="Type your message here.."></textarea>
                                                <?= _e($this, 'message'); ?>
                                            </div>

                                            <div class="d-flex flex-wrap justify-content-end mt-2">
                                                <button type="submit" class="btn btn-sm btn-light mr-1"><i class="fa fa-paper-plane-o" aria-hidden="true"></i> Send</button>
                                                <button type="reset" class="btn btn-sm btn-light" onclick="init_patients()"><i class="fa fa-refresh" aria-hidden="true"></i> Clear</button>
                                            </div>
                                        </form>
                                    </div>
                                    <div class="col-md-6">
                                        <h4>Bulk Messages</h4>
                                        <form action="<?= base_url('index.php/admin/SmsPortal/SmsPortalController/sendBulkSms') ?>" method="POST">

                                            <div class="form-group">
                                                <label for="bulk_patients">Patients</label>
                                                <select name="bulk_patients[]" id="bulk_patients" multiple>
                                                    <option value="all">All Patients</option>
                                                    <option value="vip">VIP Patients</option>
                                                </select>
                                                <?= _e($this, 'bulk_patients[]'); ?>
                                            </div>

                                            <div class="form-group">
                                                <label for="bulk_message">Message</label>
                                                <textarea name="bulk_message" id="bulk_message" rows="10" class="form-control mt-2" placeholder="Type your message here.."></textarea>
                                                <?= _e($this, 'bulk_message'); ?>
                                            </div>

                                            <div class="d-flex flex-wrap justify-content-end mt-2">
                                                <button type="submit" class="btn btn-sm btn-light mr-1"><i class="fa fa-paper-plane-o" aria-hidden="true"></i> Send</button>
                                                <button type="reset" class="btn btn-sm btn-light" onclick="init_bulk_patients()"><i class="fa fa-refresh" aria-hidden="true"></i> Clear</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div><!-- /.content-wrapper -->
    <!-- ./wrapper -->
    <?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>

</html>

<script>
    var choose_patient, bulk_patient = null;

    function init_patients() {

        if (choose_patient) {
            choose_patient.destroy();
        }

        choose_patient = new TomSelect('#patient', {

            load: function(query, callback) {
                $.ajax({
                    url: '<?= base_url('index.php/admin/SmsPortal/SmsPortalController/getPatients'); ?>',
                    type: 'GET',
                    dataType: 'json',
                    data: {
                        query: query
                    },
                    success: function(response) {
                        var options = response.map(function(item) {
                            return {
                                value: item.mobile,
                                text: item.patient_name
                            };
                        });
                        callback(options);
                    },
                    error: function(xhr, status, error) {
                        console.error('Error fetching data:', error);
                    }
                });
            }
        });
    }

    function init_bulk_patients() {

        if (bulk_patient) {
            bulk_patient.destroy();
        }

        bulk_patient = new TomSelect('#bulk_patients', {

            load: function(query, callback) {
                $.ajax({
                    url: '<?= base_url('index.php/admin/SmsPortal/SmsPortalController/getPatients'); ?>',
                    type: 'GET',
                    dataType: 'json',
                    data: {
                        query: query
                    },
                    success: function(response) {
                        var options = response.map(function(item) {
                            return {
                                value: item.mobile,
                                text: item.patient_name
                            };
                        });
                        callback(options);
                    },
                    error: function(xhr, status, error) {
                        console.error('Error fetching data:', error);
                    }
                });
            }
        });
    }

    $(function(){
        init_patients();
        init_bulk_patients();
    })
</script>