<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <?php require_once(APPPATH . "views/admin/header.php"); ?>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->


    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <?php if (validation_errors()) { ?>
        <div class="callout <?php echo $this->config->item('msg_error'); ?> error-msg">
            <div>
                <p><i class="icon fa fa-warning"></i>There is a problem that we need to fix.</p>
            </div>
        </div>
    <?php } ?>

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                <strong>User <small> - <?php echo ($user_id_val > 0 ? "Edit" : "Create New") ?> User</small></strong>
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>

        <!-- Main content -->
        <?php echo form_open_multipart('admin/Users/UsersController/SaveUser'); ?>
        <form id="save_form" name="save_form" role="form" action="<?php echo base_url('index.php/admin/Users/UsersController/SaveUser') ?>" method="post">
            <section class="content">
                <div class="row">
                    <div class="col-xs-12 col-12">
                        <div class="box margin-bottom-5px" style="border:none">
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="d-flex justify-content-between">
                                            <a href="<?php echo base_url('index.php/admin/Users/UsersController') ?>" class="btn btn-sm btn-dark <?php echo $this->config->item('new_update_back'); ?>" data-toggle="tooltip" data-placement="bottom" title="Back">
                                                <i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Go Back
                                            </a>

                                            <?php if (($add_user == 1 && $user_id_val == 0) || $edit_user == 1) { ?>
                                                <button type="submit" href="#" class="btn btn-sm btn-dark <?php echo $this->config->item('save'); ?>">
                                                    <i class="fa fa-check-circle" aria-hidden="true"></i> Save user
                                                </button>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="box box-info">
                            <div class="box-header">
                                <h3 class="box-title font-weight-bold">General Informations</h3>
                            </div>
                            <div class="row">
                                <div class="col-md-1"></div>
                                <div class="col-md-5">
                                    <div class="box-body">
                                        <div class="form-group <?php echo form_error("UserName") ? "has-error" : "" ?>">
                                            <label>User Name</label>
                                            <input id="UserName" name="UserName" type="text" value="<?php echo $user_name_val; ?>" type="text" class="form-control" placeholder="Enter ..." />
                                            <label><small><?php echo form_error("UserName"); ?></small></label>
                                        </div>
                                        <div class="form-group <?php echo form_error("FullName") ? "has-error" : "" ?>">
                                            <label>Full name</label>
                                            <input id="FullName" name="FullName" type="text" value="<?php echo $full_name_val; ?>" type="text" class="form-control" placeholder="Enter ..." />
                                            <label><small><?php echo form_error("FullName"); ?></small></label>
                                        </div>
                                        <div class="form-group <?php echo form_error("Email") ? "has-error" : "" ?>">
                                            <label>Email</label>
                                            <input id="Email" name="Email" type="text" value="<?php echo $email_val; ?>" type="email" class="form-control" placeholder="Enter ..." />
                                            <label><small><?php echo form_error("Email"); ?></small></label>
                                        </div>
                                        <div class="form-group <?php echo form_error("PhoneNo") ? "has-error" : "" ?>">
                                            <label>Phone number</label>
                                            <input id="PhoneNo" name="PhoneNo" type="text" value="<?php echo $phone_no_val; ?>" type="number" class="form-control" placeholder="Enter ..." />
                                            <label><small><?php echo form_error("PhoneNo"); ?></small></label>
                                        </div>

                                        <!-- textarea -->
                                        <div class="form-group <?php echo form_error("Description") ? "has-error" : "" ?>">
                                            <label>Description</label>
                                            <textarea id="Description" name="Description" type="text" class="form-control" rows="3" placeholder="Enter ..."><?php echo $description_val; ?></textarea>
                                            <label><small><?php echo form_error("Description"); ?></small></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <div class="box-body">
                                        <!-- text input -->
                                        <?php if ($user_id_val == 0) { ?>
                                            <div class="form-group <?php echo form_error("Password") ? "has-error" : "" ?>">
                                                <label>Password</label>
                                                <input id="Password" name="Password" type="password" type="text" class="form-control" placeholder="Enter ..." />
                                                <label><small><?php echo form_error("Password"); ?></small></label>
                                            </div>
                                            <div class="form-group <?php echo form_error("ConfirmPassword") ? "has-error" : "" ?>">
                                                <label>Confirm Password</label>
                                                <input id="ConfirmPassword" name="ConfirmPassword" type="password" type="text" class="form-control" placeholder="Enter ..." />
                                                <label><small><?php echo form_error("ConfirmPassword"); ?></small></label>
                                            </div>
                                        <?php } ?>
                                        <div class="form-group <?php echo form_error("UserGroupId") ? "has-error" : "" ?>">
                                            <label>User group</label>
                                            <select class="form-control txtBx_mdl selectpicker" data-live-search="true" id="UserGroupId" name="UserGroupId">
                                                <option value="0">Select Group Name</option>
                                                <?php foreach ($user_group_id->result() as $value) { ?>
                                                    <?php if ($user_group_Id_val == $value->user_group_Id) { ?>
                                                        <option selected value="<?php echo $value->user_group_Id ?>"><?php echo $value->user_group_name ?></option>
                                                    <?php } else { ?>
                                                        <option value="<?php echo $value->user_group_Id ?>"><?php echo $value->user_group_name ?></option>
                                                    <?php } ?>

                                                <?php } ?>
                                            </select>
                                            <label><small><?php echo form_error("UserGroupId"); ?></small></label>
                                        </div>

                                        <!-- text input -->

                                        <div class="form-group <?php echo form_error("designation_id") ? "has-error" : "" ?>">
                                            <label>Designation</label>

                                            <select class="form-control txtBx_mdl selectpicker" data-live-search="true" id="designation_id" name="designation_id">
                                                <option value="0" <?php echo $designation_id == 0 ? "selected" : "" ?>>None</option>
                                                <?php foreach ($designation_list as $value) { ?>

                                                    <option value="<?php echo $value->designation_id ?>" <?php echo $designation_id == $value->designation_id ? "selected" : "" ?>><?php echo $value->designation ?></option>

                                                <?php } ?>
                                            </select>
                                            <label><small><?php echo form_error("district_id"); ?></small></label>

                                        </div>
                                        <div class="form-group <?php echo form_error("designation_id") ? "has-error" : "" ?>">
                                            <label>Status</label>
                                            <select class="form-control txtBx_mdl selectpicker" data-live-search="true" id="is_inactive" name="is_inactive">
                                                <option value="0" <?php echo $is_inactive == 0 ? "selected" : "" ?>>Active</option>
                                                <option value="1" <?php echo $is_inactive == 1 ? "selected" : "" ?>>Inactive</option>
                                            </select>
                                            <label><small><?php echo form_error("district_id"); ?></small></label>
                                        </div>

                                        <input type="hidden" runat="server" id="user_Id" name="user_Id" value=" <?php echo $user_id_val; ?> ">

                                    </div>


                                </div>
                            </div>
                        </div><!-- /.box --><!-- /.box-body -->
                        <!-- add image-->
                        <div class="box box-info">
                            <div class="box-header">
                                <h3 class="box-title font-weight-bold">Image</h3>
                            </div><!-- /.box-header -->
                            <div class="row">
                                <div class="col-md-1"></div>
                                <div class="col-md-4">
                                    <div class="box-body">
                                        <div class="form-group">
                                            <label>Profile Image</label>
                                            <label class="file-control">
                                                <input type="file" id="fileUploader" name="fileUploader" size="60">
                                                <div class="dv-image">
                                                    <img class="result-image" id="result" name="result" src="
														<?php echo ($user_id_val > 0 ? $image_path_val : base_url('dist/img/user.jpg')) ?>">
                                                    <div class="dv-hover center">
                                                        <i class="fa fa-image"></i>
                                                    </div>
                                                </div>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div id="crop-image" class="box-body"></div>
                                    <input hidden="hidden" type="text" runat="server" id="image_path" name="image_path" value=" <?php echo $image_path_val; ?> " class="txtBx">
                                </div>
                            </div>
                        </div>
                    </div><!--/.col (right) -->
                </div> <!-- /.row -->

            </section><!-- /.content -->
        </form>

    </div><!-- /.content-wrapper -->


    <!-- ./wrapper -->

    <?php require_once(APPPATH . "views/admin/footer.php"); ?>

    <script type="text/javascript">
        $(document).ready(function() {

            // $('#ddl_teacher').select2({
            //     selectOnClose: true,
            //     allowClear: true,
            //     placeholder: "Choose teacher",
            //     ajax: {
            //         type: "post",
            //         url: function(params) {
            //             return "<?php echo base_url(); ?>" + "index.php/admin/Teachers/ClassTeacherController/teacher_dropdown";
            //         },
            //         dataType: "json",
            //         width: 'style',
            //         delay: 250,
            //         data: function(params) {
            //             return {
            //                 q: params.term,
            //                 page: params.page,
            //                 per_page: 10
            //             };
            //         },

            //         success: function(response) {
            //             //alert(JSON.stringify(response));
            //             //alert($("#grade").val());
            //         },
            //         processResults: function(data, page) {
            //             return {
            //                 results: data.map(function(item) {
            //                     return {
            //                         //id: item.teacher_id,
            //                         text: item.first_name + " " + item.last_name,
            //                         image_path: item.image_path
            //                     };

            //                 }),
            //                 pagination: {
            //                     more: data.length === 10
            //                 }
            //             };
            //         },
            //         // cache: true
            //     }
            // }).on("select2:select", function(e) {

            //     var data = e.params.data;
            //     //var teacher_id = data.id;
            //     var teacher_name = data.text;
            //     var teacher_image = data.image_path;

            //     //$("#ddl_teacher").val(teacher_id);
            //     //$("#teacher_id").val(teacher_id);
            //     $("#teacher_name").val(teacher_name);
            //     $("#teacher_image").val(teacher_image);

            //     var image = '<?php echo base_url() ?>' + teacher_image;

            //     document.getElementById('teacher_image_id').innerHTML = '<img class="result-image" src="' + image + '">';

            // }).on("select2:unselect", function(e) {
            //     $("#teacher_name").val('');
            //     $("#ddl_teacher").val('0');
            //     //$("#teacher_id").val('0');
            //     $("#teacher_name").val('documents/user.png');

            //     document.getElementById('teacher_image_id').innerHTML = '';

            // });

            /*image crop */
            function readURL(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {

                        document.getElementById('crop-image').innerHTML = "<div class='form-group'><img id='upload_image' src='#' /></div><div class='form-group'><a id='use' class='image-select btn-primary'><i class='fa fa-crop'></i> Crop</a></div>";


                        $('#upload_image').attr('src', e.target.result);
                        var resize = new Croppie($('#upload_image')[0], {
                            viewport: {
                                width: 200,
                                height: 200
                            },
                            boundary: {
                                width: 520,
                                height: 280
                            },
                            showZoomer: false,
                            enableResize: false,
                            enableOrientation: true
                        });

                        $('#use').fadeIn();

                        $('#use').on('click', function() {
                            resize.result('base64').then(function(dataImg) {
                                var data = [{
                                    image: dataImg
                                }, {
                                    name: 'myimgage.jpg'
                                }];

                                // use ajax to send data to php
                                $('#result').attr('src', dataImg);

                                $('#is_new_image').val('true');
                                $('#image_path').val(dataImg);
                                document.getElementById('crop-image').innerHTML = "";

                            });
                        });

                    }
                    reader.readAsDataURL(input.files[0]);
                }
            }

            $("#fileUploader").change(function() {
                readURL(this);
            });
        });
    </script>

</body>

</html>