# Hamte Documentation

## Framework Informations

- Framework: Codeigniter 3
- Programming Language: PHP 7.4
- Database: Mysql 5.6 or Higher
- third_party directory (Use to external dependancies)
- libaries directory (Use to store custom libraries write by hmate development team)

## Important Database tables

- ### Notifications Service

    - tbl_notifications (Store sent notification details - SMS, Email)
    - tbl_notifications_services (Store notification configurations - Sms api congis, Email configs, etc..)
    - tbl_notification_templates (Store notification templates - Sms, Email)

- ### Jobs 
    - tbl_jobs (Store jobs)
    - tbl_executed_jobs (Store execution completed jobs)
- ### Events
    - tbl_event_names (For now this table only used for set notification template for specific event)


## Helper Classes

- application/helpers/job - (Job queue)
- application/helpers/hmate_helper - (Common helper function whiched used in hmate)

## Framework Configurations

- application/config/config.php (Configuration file)
- application/config/autoload (Autoload classes, helpers)
- application/config/database.php (Database configurations)

## Important Helper Functions

- ### Set Errors (In Controller)
  ```
  if ($this->form_validation->run() == FALSE) {
    set_old($this);
    errors_to_flashdata($this);
    redirect('admin/Setting/Configurations/ConfigurationsController');
  }
  ```
- ### Show Errors (In View)

  `<?= _e($this, 'template'); ?>`

- ### Set Old Values (In Controller)

  ```
  if ($this->form_validation->run() == FALSE) {
      set_old($this);
      redirect('admin/Setting/Configurations/ConfigurationsController');
  }
  ```

- ### Show Old Values (In View)

  `<input type="text" name="name" value="<?= old($this, 'name'); ?>">`

- ### Encrypt & URL Encode | Decrypt & URL Decode (Anyware)
  `encrypt_and_url_encode('TEST_VALYE', $this)`
  `decrypt_and_url_decode('ÉNCRYPTED_AND_ENCODED_VALUE', $this)`

## How To Set Cron Job

- php -d display_errors=on path/to/codeigniter3/index.php admin/Jobs/JobController dispatch
- [php] [php params] [index.php] [controller path] [controller function]
- index.php - Codeigniter default (path/to/index.php)

## Testing
 - ### Job Testing 

      - http://localhost/projects/hmate_v5/index.php/admin/Jobs/JobController/dispatch
  
## Arrow Chat
 - http://localhost/projects/hmate_v5/arrowchat/debug/
 - http://localhost/projects/hmate_v5/arrowchat/admin/general.php?do=chatsettings
 - https://www.arrowchat.com/docs/installation/#custom

## Git
 - ### Untrack file
    `git rm -r --cached .\arrowchat\cache\`
 - ### Delete local branch
    `git branch -d localBranchName`
 - ### Delete remote branch
     `git push origin --delete remoteBranchName`

## Notification templates with placeholders for events

 - ### Table - `tbl_event_names`
 - ### Example for (type : create_appointment) 
    `tbl_event_names.placeholders` column : `[{"placeholder":"{PATIENT_NAME}", "description":"Patient Name"},{"placeholder":"{APP_DATE}", "description":"Appointment Date"},{"placeholder":"{APP_TIME}", "description":"Appointment Time"}]`
 - ### Example for (type : make_payment)
    `tbl_event_names.placeholders` column : `[{"placeholder":"{PATIENT_NAME}", "description":"Patient Name"},{"placeholder":"{PAY_DATE}", "description":"Paied Date"},{"placeholder":"{PAY_TIME}", "description":"Paied Time"},{"placeholder":"{AMOUNT}", "description": "Paid Amount"},{"placeholder":"{INVOICE_NUMBER}", "description": "Invoice Number"},{"placeholder":"{RECEIPT_NUMBER}", "description": "Receipt Number"}]`