<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| Display Debug backtrace
|--------------------------------------------------------------------------
|
| If set to TRUE, a backtrace will be displayed along with php errors. If
| error_reporting is disabled, the backtrace will not display, regardless
| of this setting
|
*/
defined('SHOW_DEBUG_BACKTRACE') OR define('SHOW_DEBUG_BACKTRACE', TRUE);

/*
|--------------------------------------------------------------------------
| File and Directory Modes
|--------------------------------------------------------------------------
|
| These prefs are used when checking and setting modes when working
| with the file system.  The defaults are fine on servers with proper
| security, but you may wish (or even need) to change the values in
| certain environments (Apache running a separate process for each
| user, PHP under CGI with Apache suEXEC, etc.).  Octal values should
| always be used to set the mode correctly.
|
*/
defined('FILE_READ_MODE')  OR define('FILE_READ_MODE', 0644);
defined('FILE_WRITE_MODE') OR define('FILE_WRITE_MODE', 0666);
defined('DIR_READ_MODE')   OR define('DIR_READ_MODE', 0755);
defined('DIR_WRITE_MODE')  OR define('DIR_WRITE_MODE', 0755);

/*
|--------------------------------------------------------------------------
| File Stream Modes
|--------------------------------------------------------------------------
|
| These modes are used when working with fopen()/popen()
|
*/
defined('FOPEN_READ')                           OR define('FOPEN_READ', 'rb');
defined('FOPEN_READ_WRITE')                     OR define('FOPEN_READ_WRITE', 'r+b');
defined('FOPEN_WRITE_CREATE_DESTRUCTIVE')       OR define('FOPEN_WRITE_CREATE_DESTRUCTIVE', 'wb'); // truncates existing file data, use with care
defined('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE')  OR define('FOPEN_READ_WRITE_CREATE_DESTRUCTIVE', 'w+b'); // truncates existing file data, use with care
defined('FOPEN_WRITE_CREATE')                   OR define('FOPEN_WRITE_CREATE', 'ab');
defined('FOPEN_READ_WRITE_CREATE')              OR define('FOPEN_READ_WRITE_CREATE', 'a+b');
defined('FOPEN_WRITE_CREATE_STRICT')            OR define('FOPEN_WRITE_CREATE_STRICT', 'xb');
defined('FOPEN_READ_WRITE_CREATE_STRICT')       OR define('FOPEN_READ_WRITE_CREATE_STRICT', 'x+b');

/*
|--------------------------------------------------------------------------
| Exit Status Codes
|--------------------------------------------------------------------------
|
| Used to indicate the conditions under which the script is exit()ing.
| While there is no universal standard for error codes, there are some
| broad conventions.  Three such conventions are mentioned below, for
| those who wish to make use of them.  The CodeIgniter defaults were
| chosen for the least overlap with these conventions, while still
| leaving room for others to be defined in future versions and user
| applications.
|
| The three main conventions used for determining exit status codes
| are as follows:
|
|    Standard C/C++ Library (stdlibc):
|       http://www.gnu.org/software/libc/manual/html_node/Exit-Status.html
|       (This link also contains other GNU-specific conventions)
|    BSD sysexits.h:
|       http://www.gsp.com/cgi-bin/man.cgi?section=3&topic=sysexits
|    Bash scripting:
|       http://tldp.org/LDP/abs/html/exitcodes.html
|
*/
defined('EXIT_SUCCESS')        OR define('EXIT_SUCCESS', 0); // no errors
defined('EXIT_ERROR')          OR define('EXIT_ERROR', 1); // generic error
defined('EXIT_CONFIG')         OR define('EXIT_CONFIG', 3); // configuration error
defined('EXIT_UNKNOWN_FILE')   OR define('EXIT_UNKNOWN_FILE', 4); // file not found
defined('EXIT_UNKNOWN_CLASS')  OR define('EXIT_UNKNOWN_CLASS', 5); // unknown class
defined('EXIT_UNKNOWN_METHOD') OR define('EXIT_UNKNOWN_METHOD', 6); // unknown class member
defined('EXIT_USER_INPUT')     OR define('EXIT_USER_INPUT', 7); // invalid user input
defined('EXIT_DATABASE')       OR define('EXIT_DATABASE', 8); // database error
defined('EXIT__AUTO_MIN')      OR define('EXIT__AUTO_MIN', 9); // lowest automatically-assigned error code
defined('EXIT__AUTO_MAX')      OR define('EXIT__AUTO_MAX', 125); // highest automatically-assigned error code



//Twillio APi


defined('TWILLIO_SID')      OR define('TWILLIO_SID', 'AC6ccfe83aae191ff7e6eae2098ee6dc07');

defined('TWILLIO_TOKEN')      OR define('TWILLIO_TOKEN', 'a6fb432dc37a99ca67c068da7e8e47e0');

//Skip Cash 

defined('SKIPCASH_SECRET')      OR define('SKIPCASH_SECRET', 'j62iXETHCMRCxmxIN5lplFcxhXWSsocYvYa+Wt2bKlss6sqsOORxd1MNQWfVTI0aPmK2aeedvlbULtifen+1SViAThJL7enJSeWHAxCAoYMAw130rZH774jlmhPPydhyn0j2tmPYZRb274Rj8rVLTGw5dBsHdhvdLfJS/sZ8WH+ToYTwdHHhMpi7kXbAjsqABtbI3vLA6SQqER/JjFhjv1Y25/8lDMnn7Gv+m+wFLuQnr68tpaixur7YtmUkjYzvYAbjkMfyQkEV3agzO4WsgTCf+431KbQ84ysvJcPlX9wLdsh9237XO1rzx86d1sLWkIxcvCYPDmysTkgxYwom2b9ag2sUevzAyYIqRrnVmcayxV6Go16UCknxghxcdMjBLLYME96zjFi5bwdlIW6bW1vU8MMXcPDM4ECzJ91bsmj1rDGsEFKOEv63gY/VSpg5g5EzoMbzcOXJjLyFPOWwVCJjC+Fvj8qGdF9fdjDafa9OZQyXnGgzbMQhBKpYZoXZP0tx3xGW7kebIWaqIVK2rw==');
defined('SKIPCASH_KEYID')      OR define('SKIPCASH_KEYID', '1b84b934-dc01-427a-95a1-9788ff350d73');
defined('SKIPCASH_CLIENTID')      OR define('SKIPCASH_CLIENTID', '2582ac48-8b6f-418d-b323-f6d11e104fcc');
defined('SKIPCASH_SANDBOX_URL')      OR define('SKIPCASH_SANDBOX_URL', 'https://skipcashtest.azurewebsites.net/api/v1/payments');
defined('SKIPCASH_PRODUCTION_URL')      OR define('SKIPCASH_PRODUCTION_URL', 'https://api.skipcash.app/api/v1/payments');
$host_parts = explode('.', $_SERVER['HTTP_HOST']);
$subdomain = array_shift($host_parts);
defined('UPLOAD_PATH')      OR define('UPLOAD_PATH', 'uploads/'.$subdomain.'/');
if($subdomain == 'shmc'){
    defined('NODE_SERVER_URL')      OR define('NODE_SERVER_URL', 'https://shmcnode.h-mate.com');
}elseif($subdomain == 'clinicajoelle01'){
      defined('NODE_SERVER_URL')      OR define('NODE_SERVER_URL', 'https://joellenode.h-mate.com');
}elseif($subdomain=='v1'){
     defined('NODE_SERVER_URL')      OR define('NODE_SERVER_URL', 'https://demo.h-mate.com');
}

defined('DOMAIN')      OR define('DOMAIN', $subdomain);
