<?php
defined('BASEPATH') or exit('No direct script access allowed');

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");


class ApiController extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        header("Access-Control-Allow-Headers: Authorization, Content-Type, X-Requested-With");

        if ($_SERVER['REQUEST_METHOD'] == "OPTIONS") {
            header("HTTP/1.1 200 OK");
            exit();
        }
        $this->load->model('admin/Login/LoginModel');
        $this->load->model('admin/Patients/PatientsModel');
        $this->basic_auth(); // Require login for every call
    }


    private function basic_auth()
    {
        $headers = apache_request_headers();

        if (!isset($headers['Authorization'])) {
            header("HTTP/1.1 401 Unauthorized");
            echo json_encode(["status" => "error", "message" => "Unauthorized"]);
            exit;
        }


        $authHeader = $headers['Authorization'];

        // Ensure it starts with "Basic "
        if (strpos($authHeader, 'Basic ') !== 0) {
            header("HTTP/1.1 401 Unauthorized");
            echo json_encode(["status" => "error", "message" => "Invalid Authorization format"]);
            exit;
        }

        // Extract Base64 encoded credentials
        $base64Credentials = substr($authHeader, 6); // Remove "Basic "
        $decodedCredentials = base64_decode($base64Credentials);

        // Ensure decoding was successful
        if (!$decodedCredentials || strpos($decodedCredentials, ':') === false) {
            header("HTTP/1.1 401 Unauthorized");
            echo json_encode(["status" => "error", "message" => "Invalid credentials format"]);
            exit;
        }

        // Split into username and password
        list($username, $password) = explode(':', $decodedCredentials, 2);


        // Validate user from database
        $login_details = $this->LoginModel->login($username);
        // json_encode(print_r($password));die;
        if (empty($login_details) || !hash_equals($login_details->password, crypt($password, $login_details->password)) || $login_details->is_inactive == 1) {
            header("HTTP/1.1 401 Unauthorized");
            echo json_encode(["status" => "error", "message" => "Invalid credentials"]);
            exit;
        }
    }

    
    public function patients()
    {
        $search = $this->input->get('search');

        $this->db->select('tbl_patients.*, tbl_insurance_types.*, tbl_patients.patient_id as file_no')
            ->from('tbl_patients')
            ->join('tbl_insurance_types', 'tbl_patients.insurance_type = tbl_insurance_types.insurance_type_id', 'left')
            ->order_by('tbl_patients.patient_id', 'DESC')
            ->group_by('tbl_patients.patient_id');

        if (!empty($search)) {
            $this->db->group_start();
            $this->db->where('patient_id', $search);
            // $this->db->or_like('qatar_id', $search);
            // $this->db->or_like('mobile', $search);
            // $this->db->or_like('patient_id', $search);
            $this->db->group_end();
        }

        $this->db->where('tbl_patients.deleted', 0);

        $records = $this->db->get()->result_array(); // Make sure this is uncommented

        foreach ($records as $key => $row) {
           $prescription = $this->db->query("SELECT tbl_prescription_main.*,tbl_users.full_name as doctor_name ,
                                            (
                                                SELECT GROUP_CONCAT(CONCAT(tbl_prescription.drug_name, '~', tbl_prescription.drug_qty, '~',tbl_prescription.after_before, '~',tbl_prescription.drug_duration, '~',tbl_prescription.drug_note) SEPARATOR '<NEW> ') 
                                                FROM tbl_prescription 
                                                WHERE tbl_prescription.prescription_main_id = tbl_prescription_main.prescription_main_id
                                            ) AS drugs_list
                                         FROM tbl_prescription_main 
                                         JOIN tbl_users ON tbl_users.user_Id = tbl_prescription_main.doctor_id
                                        WHERE tbl_prescription_main.patient_id = '" . $row['patient_id'] . "' ");

            $records[$key]['prescriptions'] = ($prescription->num_rows() > 0) ? $prescription->result_array() : [];
        }

        echo json_encode($records);
    }
}
