<?php

class BrandsController extends MY_Controller {

    function __construct() {
        parent::__construct();

        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->load->model('admin/Brands/BrandsModel');
    }

    public function index() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 15;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$data['dataList'] = $this->BrandsModel->get_dataList(); 

            $this->load->view('admin/Brands/BrandsList', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	public function createnew() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 15;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = 0;
			$brand_name = '';
			$is_active = '';
			$item_image = 'dist/img/empty.png';
			$is_new_image = 'false';
			
			$data['_id'] = $_id;
			$data['brand_name'] = $brand_name;
			$data['is_active'] = $is_active;
			$data['item_image'] = $item_image;
			$data['is_new_image'] = $is_new_image;
			
            $this->load->view('admin/Brands/Brands', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	public function save() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 15;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = $this->input->post('_id');
			$brand_name = $this->input->post('brand_name');
			$is_active = $this->input->post('is_active');
			$item_image = $this->input->post('item_image');
			$is_new_image = $this->input->post('is_new_image');
			
			$data['_id'] = $_id;
			$data['brand_name'] = $brand_name;
			$data['is_active'] = $is_active;
			$data['item_image'] = $item_image;
			$data['is_new_image'] = $is_new_image;
			
			//print_r($data['brand_name']);die;
			$this->form_validation->set_rules('brand_name', 'Brand name', 'trim|required');
			
			
			if ($this->form_validation->run() == FALSE) {
				
                $this->load->view('admin/Brands/Brands', $data);
                return;
				
            }
			
			
			$data_save = array (

				'brand_name' => $brand_name,
				'is_active' => $is_active == 'active' ? 1 : 0,
				'image_path' => ''				
			);
			
			//print_r($data_save);die;
			
			if($_id > 0 ) {
								
				$this->BrandsModel->update($_id,$data_save,$is_new_image,$item_image);
				
			} else {
				
				$this->BrandsModel->save($data_save,$is_new_image,$item_image);
				
			}
			
			
			redirect('admin/Brands/BrandsController', 'refresh');

			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	
	public function edit() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 15;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = base64_decode(urldecode($this->input->post('selected_id')));
			
			if($_id != null && $_id != ''){
			
				$details = $this->BrandsModel->get_details_by_id($_id);
				foreach ($details->result() as $row) {

					$brand_name = $row->brand_name;
					$is_active = $row->is_active == 1 ? 'active' : '';
					$item_image = $row->image_path;
					$is_new_image = false;
				}

				$data['_id'] = $_id;
				$data['brand_name'] = $brand_name;
				$data['is_active'] = $is_active;
				$data['item_image'] = $item_image;
				$data['is_new_image'] = $is_new_image;
				
				$this->load->view('admin/Brands/Brands', $data);
				
			} else {
				
				redirect('admin/CommenController/page_not_found', 'refresh');
				
			}
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	

}
