<?php

class ConsentFormController extends MY_Controller
{

	function __construct()
	{
		parent::__construct();

		$this->load->helper('file');
		$this->load->helper('url');
		$this->load->helper('date');
		$this->load->library('session');
		$this->load->library('form_validation');
		$this->load->library('upload');
		$this->load->model('admin/Patients/PatientsModel');
		$this->load->model('admin/ConsentForm/ConfigurationInsertModel');
		$this->load->model('admin/ConsentForm/ConfigurationRetriveModel');
		$this->load->model('admin/ConsentForm/DoctorRetriveModel');
		$this->load->model('admin/ConsentForm/RetriveProcessModel');
		$this->load->model('admin/ConsentForm/ConsentFormsModel');
	}

	public function index()
	{
		$data['title'] = 'Patient Profile::: Hospital Managemnt Software';
		$data['page_header'] = 'Consent Form';
		$lang = $_GET["lang"];
		$type = $_GET["id"];
		$data['consent_form'] = $this->ConfigurationRetriveModel->retrieve_data_unique('tbl_consent_forms', 'consent_id', $type);

		$data['content'] = $this->parser_template($data['consent_form'][0][$lang . '_content']);
		$data['consent_type'] = $type;
		$data['consent_lang'] = $lang;
		$data['results'] = $this->ConfigurationRetriveModel->concern_list($type, $lang);
		$this->load->view('admin/ConsentForm/ConsentForm', $data);
	}

	public function add_consent_form()
	{
		$consent_id = $this->input->post('consent_id');
		$consent_name = $this->input->post('consent_name');

		$consent_data = array(
			'consent_name'  => $consent_name
		);
		$success = FALSE;
		if ($consent_id != '') {
			$success = $this->ConfigurationInsertModel->update_data('tbl_consent_forms', 'consent_id', $consent_id, $consent_data);
			if ($success) {
				$this->session->set_flashdata('success', 'New consent create successfully.');
			}
		} else {
			$success = $this->ConfigurationInsertModel->get_insert_id('tbl_consent_forms',  $consent_data);
			if ($success) {
				$this->session->set_flashdata('success', 'Consent updated successfully.');
			}
		}

		if ($success == FALSE) {
			$this->session->set_flashdata('errors', 'Task failed.');
		}

		redirect(base_url('index.php/admin/Setting/Configurations/ConfigurationsController'));
	}

	public function get_consent_form()
	{
		$consent_id = $this->input->post('consent_id');
		$data = $this->ConfigurationRetriveModel->retrieve_data_unique('tbl_consent_forms', 'consent_id', $consent_id);
		echo json_encode($data);
	}

	public function update_consent_template()
	{
		$consent_id = $this->input->post('consent_id');
		$en_content = $this->input->post('en_content');
		$ar_content = $this->input->post('ar_content');

		$consent_data = array(
			'en_content'  => $en_content,
			'ar_content'  => $ar_content,
		);

		try {
			$result = $this->ConfigurationInsertModel->update_data('tbl_consent_forms', 'consent_id', $consent_id, $consent_data);

			if ($result == false) {
				throw new Exception($result);
			} else {
				print_r($result);
			}
		} catch (Exception $e) {
			header("HTTP/1.0 401");
			echo 'Message: ' . $e->getMessage();
		}
	}

	public function parser_template($content)
	{
		$fields = ['PATIENT' => 0, 'DOCTOR' => 0, 'CHECKBOX' => 0, 'DATE' => 0, 'SIGNATURE' => 0, 'TEXT' => 0, 'RADIO' => 0];

// Detect placeholders like {PATIENT_1}, {PATIENT_2}, etc.
foreach ($fields as $key => $field) {
    // Match all placeholders with numbered suffixes, like {PATIENT_1}, {PATIENT_2}, etc.
    preg_match_all('/\{' . $key . '_\d+\}/', $content, $matches);
    
    // Also match radio button placeholders in the format {RADIO_X_Y}
    if ($key === 'RADIO') {
        preg_match_all('/\{RADIO_(\d+)_(\d+)\}/', $content, $radioMatches);
        if (!empty($radioMatches[0])) {
            $fields[$key] = $radioMatches[0]; // Store radio matches
        }
    } elseif (!empty($matches[0])) {
        // Store all other detected placeholders in an associative array with the key as the field name
        $fields[$key] = $matches[0];
    } else {
        // If there are no matches, ensure the field key is still defined (optional)
        $fields[$key] = [];
    }
}



// Now process the content to replace placeholders with corresponding HTML inputs
foreach ($fields as $key => $placeholders) {
    foreach ($placeholders as $placeholder) {
        // Extract the number from the placeholder
        preg_match('/' . $key . '_(\d+)/', $placeholder, $match);
        $x = isset($match[1]) ? $match[1] : null; // Use null if no match found

        if ($key == 'PATIENT') {
            $replace_patient = '<input type="text" class="single-line w-30 patient_idx" name="' . $key . '_' . $x . '" />';
            $content = str_replace($placeholder, $replace_patient, $content);
        }
        if ($key == 'DOCTOR') {
            $replace_doctor = '<input type="text" class="single-line w-30 doctor_idx" name="' . $key . '_' . $x . '" />';
            $content = str_replace($placeholder, $replace_doctor, $content);
        }
        if ($key == 'CHECKBOX') {
            $replace_checkbox = '<input type="checkbox" name="' . $key . '_' . $x . '" />';
            $content = str_replace($placeholder, $replace_checkbox, $content);
        }
        if ($key == 'DATE') {
            $replace_date = '<input type="text" class="single-line w-30" value="' . date('Y-m-d') . '" name="' . $key . '_' . $x . '" />';
            $content = str_replace($placeholder, $replace_date, $content);
        }
        if ($key == 'SIGNATURE') {
            $replace_signature = '<div class="signArea" id="wsignArea">
                <div class="sig sigWrapper" style="height:auto;">
                    <div class="typed"></div>
                    <canvas class="sign-pad" width="300" height="100"></canvas>
                </div>
                <br>
                <input type="hidden" class="img_val" name="' . $key . '_' . $x . '">
                <button type="button" class="reset_signature">Reset signature</button>
            </div>';
            $content = str_replace($placeholder, $replace_signature, $content);
        }
        if ($key == 'TEXT') {
            $replace_text = '<input type="text" class="single-line w-30" name="' . $key . '_' . $x . '" />';
            $content = str_replace($placeholder, $replace_text, $content);
        }
        
        // Match for radio buttons specifically
        if (preg_match('/{RADIO_(\d+)_(\d+)}/', $placeholder, $matches)) {
            $groupNumber = $matches[1]; // Extract the group number
            $optionNumber = $matches[2]; // Extract the option number
            
            // Create the radio button with the correct name and value
            $replace_radio = '<input type="radio" name="RADIO_' . $groupNumber . '" value="' . $optionNumber . '" />';
            
            // Replace the placeholder in the content with the generated radio button
            $content = str_replace($placeholder, $replace_radio, $content);
        }
    }

}
		return $content;
	}

	public function insert_to_consents()
	{

		$data['title'] = 'Concern Form::: Hospital Management System';
		$data['page_header'] = 'Consent Form';
		$values = [];
		$signature_count = 0;
		date_default_timezone_set('Asia/Kuwait');
		$date_string = '%Y-%m-%d';
		$curr_date = mdate($date_string);
		$curr_time = date("H:i");
		$patient_id = $this->input->post('patient_id');
		$consent_type = $this->input->post('consent_type');
		$consent_lang = $this->input->post('consent_lang');

		foreach ($_POST as $key => $value) {
			if (
				strpos($key, 'SIGNATURE_') === false && $key != 'patient_id' && $key != 'doctor_id'
				&& $key != 'consent_type' && $key != 'consent_lang'
			) {
				$values[$key] = $value;
			}
			if (strpos($key, 'SIGNATURE_') !== false) {
				$signature_count++;
			}
		}

		if (!is_dir('./'.UPLOAD_PATH.'signature')) {
			mkdir('./'.UPLOAD_PATH.'signature');
		}

		for ($x = 1; $x <= $signature_count; $x++) {
			$p_sign = $patient_id . '_' . $consent_type . '_' . uniqid();
			$img_src = base64_decode($this->input->post('SIGNATURE_' . $x));
			$file_name = './'.UPLOAD_PATH.'signature/' . $p_sign . '.png';
			$values['SIGNATURE_' . $x] = $p_sign . '.png';
			file_put_contents($file_name, $img_src);
		}


		$consent_data = array(
			'created_date' => $curr_date,
			'created_time' => $curr_time,
			'consent_values' => serialize($values),
			'patient_id' => $patient_id,
			'doctor_id' => $this->input->post('doctor_id'),
			'consent_type' => $consent_type,
			'consent_lang' => $consent_lang,
		);

		$data['consent_form'] = $this->ConfigurationRetriveModel->retrieve_data_unique('tbl_consent_forms', 'consent_id', $consent_type);
		$data['content'] = $this->parser_template($data['consent_form'][0][$consent_lang . '_content']);
		$data['consent_type'] = $consent_type;
		$data['consent_lang'] = $consent_lang;

		$this->form_validation->set_rules('patient_id', 'select patient', 'required');


		if ($this->form_validation->run() == FALSE) {
			$data['alert_msg'] = '';
			$data['error'] = 'Patient name needed';
			$data['success'] = '';
			$this->session->set_flashdata('error', 'Please Fill All the Fields');
			$data['results'] = $this->ConfigurationRetriveModel->concern_list($consent_type, $consent_lang);
			redirect("admin/ConsentForm/ConsentFormController/index?lang={$consent_lang}&id={$consent_type}");
			
		} else {

			$this->ConfigurationInsertModel->get_insert_id('tbl_consent_data', $consent_data);
			$data['alert_msg'] = '';
			$data['error'] = '';
			$data['success'] = 'Concent details have saved successfully!';
			$data['results'] = $this->ConfigurationRetriveModel->concern_list($consent_type, $consent_lang);
			$this->session->set_flashdata('success', $data['success']);
			// $this->load->view('admin/ConsentForm/ConsentForm', $data);
			redirect("admin/ConsentForm/ConsentFormController/index?lang={$consent_lang}&id={$consent_type}");
		}
	}

	public function view()
	{
		$data['title'] = 'Patient Profile::: Hospital Managemnt Software';
		$data['page_header'] = 'Consent Form';
		$lang = $_GET["lang"];
		$type = $_GET["type"];
		$id = $_GET["id"];
		$data['consent_form'] = $this->ConfigurationRetriveModel->retrieve_data_unique('tbl_consent_forms', 'consent_id', $type);
		$results = $this->ConfigurationRetriveModel->get_row_data('tbl_consent_data', 'consent_data_id', $id);

		$data['content'] = $this->parser_template_values($data['consent_form'][0][$lang . '_content'], $results->consent_values);
		$data['consent_type'] = $type;
		$data['consent_lang'] = $lang;
		$data['clinic_info'] = $this->DoctorRetriveModel->get_row('tbl_company');
		$this->load->view('admin/ConsentForm/ConsentFormView', $data);
	}

	public function parser_template_values($content, $values)
	{

		$clean_data = unserialize($values);

		$fields = ['PATIENT' => 0, 'DOCTOR' => 0, 'CHECKBOX' => 0, 'DATE' => 0, 'SIGNATURE' => 0, 'TEXT' => 0, 'RADIO' => 0];

		// foreach ($fields as  $key => $field) {
		// 	$fields[$key] = substr_count($content, $key);
		// }
		// for ($x = 1; $x <= $fields['RADIO']; $x++) {
		// 	if ((substr_count($content, 'RADIO_' . $x)) > 0)
		// 		$fields['RADIO_' . $x] = substr_count($content, 'RADIO_' . $x);
		// }
		foreach ($fields as $key => $field) {
			// Match all placeholders with numbered suffixes, like {PATIENT_1}, {PATIENT_2}, etc.
			preg_match_all('/\{' . $key . '_\d+\}/', $content, $matches);
			
			// Also match radio button placeholders in the format {RADIO_X_Y}
			if ($key === 'RADIO') {
				preg_match_all('/\{RADIO_(\d+)_(\d+)\}/', $content, $radioMatches);
				if (!empty($radioMatches[0])) {
					$fields[$key] = $radioMatches[0]; // Store radio matches
				}
			} elseif (!empty($matches[0])) {
				// Store all other detected placeholders in an associative array with the key as the field name
				$fields[$key] = $matches[0];
			} else {
				// If there are no matches, ensure the field key is still defined (optional)
				$fields[$key] = [];
			}
		}

		foreach ($fields as  $key => $placeholders) {
			foreach ($placeholders as $placeholder) {
				 preg_match('/' . $key . '_(\d+)/', $placeholder, $match);
        $x = $match[1];

				if ($key == 'PATIENT') {
					$value = isset($clean_data[$key . '_' . $x]) ? 'value="' . $clean_data[$key . '_' . $x] . '"' : 'value="N/A"';
					$replace_patient = '<input type="text" class="single-line w-30 patient_idx" name="' . $key . '_' . $x . '"  ' . $value . '/>';
					$content = str_replace('{PATIENT_' . $x . '}', $replace_patient, $content);
				}
				if ($key == 'DOCTOR') {
					$value = isset($clean_data[$key . '_' . $x]) ? 'value="' . $clean_data[$key . '_' . $x] . '"' : 'value="N/A"';
					
					$replace_doctor = '<input type="text" class="single-line w-30 doctor_idx" name="' . $key . '_' . $x . '" ' . $value . ' />';
					$content = str_replace('{DOCTOR_' . $x . '}', $replace_doctor, $content);
				}
				if ($key == 'CHECKBOX') {
					$checked = isset($clean_data[$key . '_' . $x]) ? 'checked' : '';
					$replace_checkbox = '<input  type="checkbox" onclick="return false" name="' . $key . '_' . $x . '" ' . $checked . '/>';
					$content = str_replace('{CHECKBOX_' . $x . '}', $replace_checkbox, $content);
				}
				
				if (preg_match('/{RADIO_(\d+)_(\d+)}/', $placeholder, $matches)) {
					$groupNumber = $matches[1]; // Extract the group number
					$optionNumber = $matches[2]; // Extract the option number
					
					// Check if this radio button should be checked
					$checked = isset($clean_data['RADIO_' . $groupNumber]) && $clean_data['RADIO_' . $groupNumber] == $optionNumber ? 'checked' : '';
					
					// Create the radio button with the correct name and value, including the checked attribute if applicable
					$replace_radio = '<input type="radio" onclick="return false" name="RADIO_' . $groupNumber . '" value="' . $optionNumber . '" ' . $checked . ' />';
					
					// Replace the placeholder in the content with the generated radio button
					$content = str_replace($placeholder, $replace_radio, $content);
				}
				if ($key == 'DATE') {
					$value = isset($clean_data[$key . '_' . $x]) ? 'value="' . $clean_data[$key . '_' . $x] . '"' : 'value="N/A"';
					$replace_date = '<input  type="text" class="single-line w-30" value="' . $clean_data[$key . '_' . $x] . '"  name="' . $key . '_' . $x . '"  ' . $value . '/>';
					$content = str_replace('{DATE_' . $x . '}', $replace_date, $content);
				}
				if ($key == 'SIGNATURE') {
					$value = isset($clean_data[$key . '_' . $x]) ? 'src="' . base_urL('/'.UPLOAD_PATH.'signature/' . $clean_data[$key . '_' . $x]) . '"' : 'alt="Signature"';
					$replace_signature = '<img class="show_div" ' . $value . ' alt="Signature">';
					$content = str_replace('{SIGNATURE_' . $x . '}', $replace_signature, $content);
				}
				if ($key == 'TEXT') {
					$value = isset($clean_data[$key . '_' . $x]) ? 'value="' . $clean_data[$key . '_' . $x] . '"' : 'value="N/A"';
					$replace_text = '<input type="text"  class="single-line w-30" name="' . $key . '_' . $x . '" ' . $value . '/>';
					$content = str_replace('{TEXT_' . $x . '}', $replace_text, $content);
				}
				
				$x++;
			}
		}
		return $content;
	}

	public function delete()
	{

		$lang = $_GET["lang"];
		$type = $_GET["type"];
		$id = $_GET["id"];

		if (!empty($lang) && !empty($type) && !empty($id)) {

			$data['consent_form'] = $this->ConfigurationRetriveModel->retrieve_data_unique('tbl_consent_forms', 'consent_id', $type);
			$results = $this->ConfigurationRetriveModel->get_row_data('tbl_consent_data', 'consent_data_id', $id);
			$results = unserialize($results->consent_values);

			foreach ($results as $key => $value) {
				if (strpos($key, 'SIGNATURE_') !== false) {
					if (file_exists('./'.UPLOAD_PATH.'signature/' . $value)) {
						unlink('./'.UPLOAD_PATH.'signature/' . $value);
					}
				}
			}

			$this->ConfigurationRetriveModel->data_delete_other('tbl_consent_data', 'consent_data_id', $id);
			$this->session->set_flashdata('success', 'Consent deleted successfully.');
		} else {
			$this->session->set_flashdata('error', 'Consent Failed to delete consent.');
		}

		redirect("admin/ConsentForm/ConsentFormController/index?lang={$lang}&id={$type}");
	}

	public function search_concern_form()
	{
		$search_data = $this->input->post('search_data');
		$type = $this->input->post('type');
		$result = $this->RetriveProcessModel->search_concern($search_data, $type);

		$HTML = '';
		if ($result != FALSE) {
			$HTML .= '<br><br><br>
									<table class="table table-striped table-bordered table-hover">
				                      <thead>
				                          <tr>
			                                    <th>Patient</th>
			                                    <th>Create Date</th>
			                                    <th>Status</th>
				                          </tr>
				                      </thead>
				                      <tbody>
				            ';
			foreach ($result as $row) {
				$HTML .= '
				                      
				                      	<tr>
					                      	<td>' . $row['patient_id'] . '-' . $row['patient_name'] . '</td>
					                      	<td>' . $row['print_date'] . '</td>
					                      	<td>
					                      		<a href="' . site_url("patient/consent1_edit" . $row['concern_form_id']) . '/0" class="btn btn-success btn-xs" role="button">Print|Edit</a>
					                      		<a href="' . site_url("patient/delete_concern/" . $row['concern_form_id']) . '" class="btn btn-danger btn-xs" role="button">Delete</a>		
			                                </td>
			                             </tr>
							';
			}

			$HTML .= '
				                      </tbody>
				                    </table>
						';
			echo $HTML;
		} else {
			$HTML .= 'Not Found Any Records';
			echo $HTML;
		}
	}

	public function search_concern_form_byname()
	{
		$search_data = $this->input->post('search_data');
		$type = $this->input->post('type');
		$result = $this->RetriveProcessModel->search_concern_byname($search_data, $type);

		$HTML = '';
		if ($result != FALSE) {
			$HTML .= '<br><br><br>
									<table class="table table-striped table-bordered table-hover table-light">
				                      <thead>
				                          <tr>
			                                    <th>Patient</th>
			                                    <th>Create Date</th>
			                                    <th class="text-center">Status</th>
				                          </tr>
				                      </thead>
				                      <tbody>
				            ';
			foreach ($result as $row) {
				$HTML .= '
				                      
				                      	<tr>
					                      	<td>' . $row['patient_id'] . '-' . $row['patient_name'] . '</td>
					                      	<td>' . $row['created_date'] . '</td>
					                      	<td class="text-center">
					                      		<a href="' . site_url("patient/consent" . $type . "_edit/" . $row['concern_form_id']) . '/0" class="btn btn-success btn-sm" role="button">Print|Edit</a>
					                      		<a href="' . site_url("patient/delete_concern/" . $row['concern_form_id']) . '" class="btn btn-danger btn-sm" role="button">Delete</a>		
			                                </td>
			                             </tr>
							';
			}

			$HTML .= '
				                      </tbody>
				                    </table>
						';
			echo $HTML;
		} else {
			$HTML .= 'Not Found Any Records';
			echo $HTML;
		}
	}

	public function get_patients()
	{
		if ($_GET['type'] == 'patient_id') {

			$nameStartsWith = $this->input->get('name_startsWith');
			$showAll = $this->input->get('show_all');

			$data = $this->RetriveProcessModel->getPatients($nameStartsWith, $showAll);

			echo json_encode($data);
		}
	}

	public function get_patients_doctor()
	{
		if ($_GET['type'] == 'patient_id') {

			$nameStartsWith = $this->input->get('name_startsWith');

			$data = $this->RetriveProcessModel->getPatientsDoctor($nameStartsWith);

			echo json_encode($data);
		}
	}

	public function consent_list()
	{
		$loginId = $this->session->userdata('user_Id');
		$data['active_menu'] = 14;
		$data['active_submenu'] = 1;
		$data['user_right'] = $this->CommonModel->logged_user_right($loginId);
		$data['profile'] = $this->CommonModel->profile($loginId);
		$data['consents_list'] = $this->CommonModel->retrieve_data('tbl_consent_forms');

		$this->load->view('admin/ConsentForm/ConsentList', $data);
	}

	public function deleteConsentForm()
	{
		$consent_id = $this->input->post('consent_id');
		$consents_count = $this->ConsentFormsModel->get_existing_consent_forms_count((int)$consent_id)->count;

		if ($consents_count > 0) {
			return $this->output
				->set_status_header(403)
				->set_content_type('application/json')
				->set_output(json_encode(["message" => "You canno't delete this consent template."]));
		}

		// Delete process
		if ($this->ConsentFormsModel->delete_consent_template((int)$consent_id)) {
			return $this->output
				->set_content_type('application/json')
				->set_output(json_encode(["message" => "Consent template deleted succesfully."]));
		} else {
			return $this->output
				->set_status_header(400)
				->set_content_type('application/json')
				->set_output(json_encode(["message" => "Failed to delete consent template."]));
		}
	}

	public function feedbackForm()
	{

		$loginId = $this->session->userdata('user_Id');
		$data['active_menu'] = 14;
		$data['active_submenu'] = 1;
		$data['user_right'] = $this->CommonModel->logged_user_right($loginId);
		$data['profile'] = $this->CommonModel->profile($loginId);

		$this->load->view('admin/Feedback/feedback', $data);
	}


	public function insert_feedback()
	{

		date_default_timezone_set('Asia/Kuwait');

		$date_string = '%Y-%m-%d';

		$curr_date = mdate($date_string);

		$curr_time = date("H:i");

		$newdata = array(
			'appointment' => $this->input->post('appointment'),
			'previous' => $this->input->post('previous'),
			'treatment' => $this->input->post('treatment'),
			'session' => $this->input->post('session'),
			'laser' => $this->input->post('laser'),
			'nurse' => $this->input->post('nurse'),
			'waiting' => $this->input->post('waiting'),
			'reception' =>  $this->input->post('reception'),
			'patient_id' => $this->input->post('patient_id'),
			'assign' =>  $this->input->post('doctor_id'),
			'comment' =>  $this->input->post('comment'),
			'curr_date' => $curr_date,
			'curr_time' => $curr_time
		);

		$result = $this->CommonModel->insert_data('tbl_patient_feedback', $newdata);
		echo json_encode($result);
	}

	public function get_patient_details()
	{

		$result = $this->PatientsModel->get_patient_details('patient_id', $_GET['patient_id']);
		echo json_encode($result);
	}
}
