<?php

class InventoryController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Inventory/InventoryModel');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
    }

    public function index()
    {

        $data['page_header'] = 'Inventory';
        $data['title'] = 'Inventory View ::: Hospital Managemnt Software';

        $data['clinic_info'] = $this->InventoryModel->retrieve_data_unique_row('tbl_company');
        $data['items'] = $this->InventoryModel->retrieve_data('tbl_items_list');
        $data['item_types'] = $this->InventoryModel->retrieve_data('tbl_item_types');
        $data['units'] = $this->InventoryModel->retrieve_data('tbl_units');
        $data['doctors'] = $this->InventoryModel->get_doctors();
        $data['departments'] = $this->InventoryModel->retrieve_data('tbl_item_departments');
        $data['suppliers'] = $this->InventoryModel->retrieve_data('tbl_item_suppliers');

        // $loginId = $this->session->userdata('user_Id');
        // $data['active_menu'] = 22;
        // $data['active_submenu'] = 1;
        // $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        // $data['profile'] = $this->CommonModel->profile($loginId);

        $this->load->view('admin/Inventory/dashboard', $data);
    }

    public function get_phar_expired_items_list()
    {
    }

    public function get_phar_no_expiry_items_list()
    {
    }

    public function get_phar_items_list()
    {
        $this->db->select('tbl_items_list.item_id, tbl_items_list.item_name, IFNULL(type_name, "--") as type_name, tbl_items_list.min_qty,
                    (IFNULL(SUM(tbl_item_inventory_invoice_items.quantity + tbl_item_inventory_invoice_items.bonus), 0) - 
                    IFNULL((SELECT SUM(tbl_item_requests_items.quantity) 
                            FROM tbl_item_requests_items 
                            INNER JOIN tbl_item_requests 
                            ON tbl_item_requests.request_id = tbl_item_requests_items.request_id 
                            INNER JOIN tbl_item_inventory_invoice_items 
                            ON tbl_item_inventory_invoice_items.item_inventory_invoice_item_id = tbl_item_requests_items.invoice_item_id 
                            WHERE tbl_item_requests_items.item_id = tbl_items_list.item_id), 0)) AS qty,
                    tbl_items_list.item_type, tbl_items_list.unit, tbl_items_list.barcode');
        $this->db->from('tbl_items_list');
        $this->db->join('tbl_units', 'tbl_items_list.unit = tbl_units.unit_id', 'left');
        $this->db->join('tbl_item_types', 'tbl_items_list.item_type = tbl_item_types.item_type', 'left');
        $this->db->join('tbl_item_inventory_invoice_items', 'tbl_item_inventory_invoice_items.item_id = tbl_items_list.item_id', 'left');
        $this->db->group_by('tbl_items_list.item_id');

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            $items = $query->result_array();

            foreach ($items as &$item) {
                $item['item_id'] = addslashes($item['item_id']);
            }

            echo json_encode($items);
        } else {
            return FALSE;
        }
    }

    public function get_doctor_requests_list()
    {
        $this->db->select('tbl_item_requests.employee_id, tbl_item_requests.department, tbl_item_departments.department_name,tbl_item_requests.date,tbl_item_requests.item_id,tbl_item_requests.request_id,emp.full_name as emp_name,tbl_item_requests.quantity,(SELECT usr.user_name FROM tbl_users usr WHERE tbl_item_requests.user_id = usr.user_Id LIMIT 1) as user_name', false);
        $this->db->from('tbl_item_requests');
        $this->db->join('tbl_users emp', 'tbl_item_requests.employee_id = emp.user_Id', 'left');
        $this->db->join('tbl_employees', 'tbl_item_requests.employee_id = tbl_employees.employee_id', 'left');
        $this->db->join('tbl_item_departments', 'tbl_item_departments.id = tbl_item_requests.department', 'left');
        $this->db->order_by("date DESC");

        //print_r($this->db);die;
        $row = $this->db->get();
        $items = $row->result_array();

        echo json_encode($items);
    }

    public function get_phar_invoice_list()
    {
        $this->db->from('tbl_item_inventory_invoices');
        $this->db->join('tbl_item_suppliers', 'tbl_item_inventory_invoices.supplier_id = tbl_item_suppliers.supplier_id', 'left');
        $this->db->order_by('inventory_invoice_id DESC');

        $row = $this->db->get();
        $items = $row->result_array();
        echo json_encode($items);
    }

    public function get_phar_department_list()
    {
        $types = $this->InventoryModel->retrieve_data('tbl_item_departments');
        echo json_encode($types);
    }

    public function get_phar_supplier_list()
    {
        $types = $this->InventoryModel->retrieve_data('tbl_item_suppliers');
        echo json_encode($types);
    }

    public function get_phar_category_list()
    {
        $types = $this->InventoryModel->retrieve_data('tbl_item_types');
        echo json_encode($types);
    }

    // Items
    public function get_phar_item_info()
    {
        $this->db->from('tbl_items_list');
        $this->db->join('tbl_units', 'tbl_items_list.unit = tbl_units.unit_id', 'left');

        $this->db->where('item_id', $this->input->post('item_id'));

        $this->db->group_by('tbl_items_list.item_id');

        $row = $this->db->get();
        $items = $row->result_array();

        echo json_encode($items);
    }

    public function manage_items()
    {

        //echo json_encode($this->input->post());exit;

        $data['page_header'] = 'Inventory';
        $data['title'] = 'Inventory View ::: Hospital Managemnt Software';

        $data['items'] = $this->InventoryModel->retrieve_data('tbl_items_list');
        $data['item_types'] = $this->InventoryModel->retrieve_data('tbl_item_types');
        $data['units'] = $this->InventoryModel->retrieve_data('tbl_units');

        $code = $this->input->post('item_code');
        $barcode = $this->input->post('barcode');
        $name = $this->input->post('item_name');
        $description = $this->input->post('description');
        $type = $this->input->post('item_type');
        $unit = $this->input->post('ph_item_unit');
        $price = $this->input->post('price');
        $exist = $this->input->post('new');

        if ($exist != 'true') {
            $this->form_validation->set_rules('barcode', 'Barcode', 'is_unique[tbl_items_list.barcode]');
            $this->form_validation->set_rules('item_name', 'Item Name', 'required');

            if ($this->form_validation->run() == FALSE) {
                // $data['validation_msg'] = validation_errors();
                // $this->load->view('pharmacy_dashboard', $data);

                $this->session->set_flashdata('errors', validation_errors());
                redirect(base_url('index.php/admin/Inventory/InventoryController/index'));
            } else {
                $newdata = [
                    //'item_id'           => $code,
                    'barcode'           => $barcode,
                    'user_id'           => $this->session->userdata('user_Id'),
                    'item_name'         => $name,
                    'description'       => $description,
                    'item_type'         => $type,
                    'unit'              => $unit,
                    'price'             => $price
                ];


                $this->InventoryModel->insert_data('tbl_items_list', $newdata);
                $this->createLog('Inventory Item', $this->session->userdata('user_Id'), 'Create', $this->input->post());
                $data['success_msg'] = 'Success';
                $this->session->set_flashdata('success', 'Item created successfully.');
                redirect(base_url('index.php/admin/Inventory/InventoryController/index'));
            }
        } else {
            $this->form_validation->set_rules('item_name', 'Item Name', 'required');

            if ($this->form_validation->run() == FALSE) {
                // $data['validation_msg'] = validation_errors();
                // $this->load->view('pharmacy_dashboard', $data);

                $this->session->set_flashdata('errors', validation_errors());
                redirect(base_url('index.php/admin/Inventory/InventoryController/index'));


            } else {
                $newdata = [
                    'barcode'     => $barcode,
                    'user_id'     => $this->session->userdata('user_id'),
                    'item_name'   => $name,
                    'description' => $description,
                    'item_type'   => $type,
                    'unit'        => $unit,
                    'price'       => $price
                ];
                
                $this->InventoryModel->update_data_where('tbl_items_list', 'item_id', $code, $newdata);
                $this->createLog('Inventory Item', $this->session->userdata('user_Id'), 'Update', $this->input->post());
                
                $data['success_msg'] = 'Success';
                $this->session->set_flashdata('success', 'Item updated successfully.');
                redirect(base_url('index.php/admin/Inventory/InventoryController/index'));
            }
        }

        redirect(base_url('index.php/admin/Inventory/InventoryController/index#ph_items'));
    }

    public function delete_phar_inventory()
    {
        $tbl = '';
        $col = '';

        switch ($this->input->post('mod')) {
            case 'item':
                $tbl = 'tbl_items_list';
                $col = 'item_id';
                break;
            case 'category':
                $tbl = 'tbl_item_types';
                $col = 'item_type';
                break;
            case 'supplier':
                $tbl = 'tbl_item_suppliers';
                $col = 'supplier_id';
                break;
            case 'invoice':
                $tbl = 'tbl_item_inventory_invoices';
                $col = 'inventory_invoice_id';
                break;
            case 'request':
                $tbl = 'tbl_item_requests';
                $col = 'request_id';
                break;
            case 'department':
                $tbl = 'tbl_item_departments';
                $col = 'id';
                break;
        }

        $array = ['query' => 'DELETE FROM ' . $tbl . ' WHERE ' . $col . ' = "' . $this->input->post('id') . '"'];
        
        // Log
        $data = $this->db->select('*')->from($tbl)->where($col, $this->input->post('id'))->get()->row();
        $tableName = ucwords(implode(' ', explode('_', str_replace('tbl_', '', $tbl))));
        $this->createLog('Inventory ' . $tableName, $this->session->userdata('user_Id'), 'Delete', $data);

        $this->db->where($col, $this->input->post('id'));
        $this->db->delete($tbl);

        if ($this->input->post('mod') == 'invoice') {
            $array = ['query' => 'DELETE FROM tbl_item_inventory_invoice_items WHERE item_inventory_invoice_id = "' . $this->input->post('id') . '"'];

            // Log
            $data = $this->db->select('*')->from('tbl_item_inventory_invoice_items')->where('item_inventory_invoice_id', $this->input->post('id'))->get()->row();
            $this->createLog('Inventory Invoice Item', $this->session->userdata('user_Id'), 'Delete', $data);

            $this->db->where('item_inventory_invoice_id', $this->input->post('id'));
            $this->db->delete('tbl_item_inventory_invoice_items');
        }

        if ($this->input->post('mod') == 'request') {

            // Log
            $data = $this->db->select('*')->from('tbl_item_requests_items')->where('request_id', $this->input->post('id'))->get()->row();
            $this->createLog('Inventory Request Item', $this->session->userdata('user_Id'), 'Delete', $data);

            $this->db->where('request_id', $this->input->post('id'));
            $this->db->delete('tbl_item_requests_items');
        }

        $this->session->set_flashdata('success', 'Item deleted successfully.');
        echo TRUE;
    }

    // Category
    public function manage_categories()
    {
        $data['page_header'] = 'Inventory';
        $data['title'] = 'Inventory View ::: Hospital Managemnt Software';

        $category = $this->input->post('category_name');
        $category_id = $this->input->post('ph_category_id');
        $exist = $this->input->post('new_category');

        $this->form_validation->set_rules('category_name', 'Category Name', 'required');

        if ($this->form_validation->run() == FALSE) {
            // $data['validation_msg'] = validation_errors();
            // $this->load->view('admin/Inventory/dashboard', $data);
            $this->session->set_flashdata('errors', validation_errors());
            redirect(base_url('index.php/admin/Inventory/InventoryController/index'));
        } else {
            $newdata = ['type_name' => $category];

            if ($exist != 'true') {
                $this->InventoryModel->insert_data('tbl_item_types', $newdata);
                $this->session->set_flashdata('success', 'Category saved successfully.');
                $this->createLog('Inventory Item Type', $this->session->userdata('user_Id'), 'Create', $this->input->post());
            } else {
                $this->session->set_flashdata('success', 'Category updated successfully.');
                $this->InventoryModel->update_data_where('tbl_item_types', 'item_type', $category_id, $newdata);
                $this->createLog('Inventory Item Type', $this->session->userdata('user_Id'), 'Update', $this->input->post());
            }

            redirect(base_url('index.php/admin/Inventory/InventoryController/index#ph_item_categories'));
        }
    }

    public function supplier_categories($id = '')
    {
        $data['page_header'] = '';
        $data['title'] = 'Inventory View ::: Hospital Managemnt Software';

        $data['items'] = $this->InventoryModel->retrieve_data('tbl_items_list');
        $data['item_types'] = $this->InventoryModel->retrieve_data('tbl_item_types');
        $data['units'] = $this->InventoryModel->retrieve_data('tbl_units');
        $data['categories'] = $this->InventoryModel->retrieve_data('tbl_item_types');
        $data['clinic_info'] = $this->InventoryModel->retrieve_data_unique_row('tbl_company');

        $data['inventory'] = $this->InventoryModel->stock_list($id);
        $data['logs'] = $this->InventoryModel->stock_history($id);

        if (isset($id)) {
            $data['header'] = $this->InventoryModel->item_inventory_invoices($id);
            $data['items'] = $this->InventoryModel->item_inventory_invoice_items($id);
        }

        $this->load->view('admin/Inventory/pharmacy_stock_categories', $data);
    }

    public function search_supplier_categories()
    {

        $category_id = $this->input->post('category_id');
        $result = $this->InventoryModel->get_supplier_category($category_id);

        $HTML = '';
        if ($result != FALSE and $category_id != "") {
            $total = 0;
            $tqty = 0;

            foreach ($result as $row) {
                $name = ($row['item_name'] != '' ? $row['item_name'] : '-');
                $code = ($row['item_id'] != '' ? $row['item_id'] : '-');
                $unit = ($row['unit_name'] != '' ? $row['unit_name'] : '-');
                $category = ($row['type_name'] != '' ? $row['type_name'] : '-');
                $stotal = ($row['stock_qty'] * $row['price']);

                $HTML .= '
                        <tr>
                            <td><input type="hidden" class="form-control" name="item_id[]" value="' . $row['item_id'] . '"><input type="hidden" class="form-control" name="unit_id[]" value="' . $row['unit_id'] . '">' . $row['item_id'] . '</td>
                            <td>' . ($row['item_name'] != '' ? $row['item_name'] : '-') . '</td>
                            <td>' . $row['supplier_name'] . '</td>
                            <td>' . ($row['unit_name'] != '' ? $row['unit_name'] : '-') . '</td>
                            <td>' . number_format(($row['price'] != '' ? $row['price'] : 0), 2) . '</td>
                            <td class="text-right">' . ($row['stock_qty'] <= 5 ? '<label style="color: #eb3434">' . $row['stock_qty'] . '</label>' : $row['stock_qty']) . '</td>
                            <td class="text-right">' . number_format(($stotal != '' ? $stotal : 0), 2) . '</td>
                        </tr>
                    ';
                $total += ($row['stock_qty'] * $row['price']);
                $tqty += $row['stock_qty'];
            }

            $HTML .= '<tr style="font-size: 16px;font-weight: bold;"><td colspan=5 class="text-right"><b>TOTAL:</b></td><td class="text-right">' . $tqty . '</td><td class="text-right">' . number_format($total, 2) . '</td></tr>';


            echo $HTML;
        } else {
            $HTML .= '<tr><td colspan="7" class="text-center">Not Found Any Records</td></tr>';
            echo $HTML;
        }
    }

    public function manage_departments()
    {
        $data['page_header'] = 'Inventory';
        $data['title'] = 'Inventory View ::: Hospital Managemnt Software';

        $department_name = $this->input->post('department_name');
        $ph_department_id = $this->input->post('ph_department_id');


        $this->form_validation->set_rules('department_name', 'Department Name', 'required');

        if ($this->form_validation->run() == FALSE) {
            // $data['validation_msg'] = validation_errors();
            // $this->load->view('admin/Inventory/dashboard', $data);
            $this->session->set_flashdata('errors', validation_errors());
            redirect(base_url('index.php/admin/Inventory/InventoryController/index'));
        } else {
            $newdata = array(
                'department_name' => $department_name
            );

            if ($ph_department_id != '0') {
                $this->createLog('Inventory Item Departments', $this->session->userdata('user_Id'), 'Update', $this->input->post());
                $this->InventoryModel->update_data_where('tbl_item_departments', 'id', $ph_department_id, $newdata);
            } else {
                $this->createLog('Inventory Item Departments', $this->session->userdata('user_Id'), 'Create', $this->input->post());
                $this->InventoryModel->insert_data('tbl_item_departments', $newdata);
            }

            // echo $this->db->last_query();
            redirect(base_url('index.php/admin/Inventory/InventoryController/index#ph_item_departments'));
        }
    }

    public function manage_suppliers()
    {
        $data['page_header'] = 'Inventory';
        $data['title'] = 'Inventory View ::: Hospital Managemnt Software';

        $supplier = $this->input->post('supplier_name');
        $supplier_id = $this->input->post('ph_supplier_id');
        $exist = $this->input->post('new_supplier');
        $supplier_code = $this->input->post('supplier_code') ?? 0;
        $contact_person = $this->input->post('contact_person');
        $number = $this->input->post('number');
        $address = $this->input->post('address');
        $email = $this->input->post('email');
        $payment_type = $this->input->post('payment_type') ?? 0;

        $this->form_validation->set_rules('supplier_name', 'Supplier Name', 'required');

        if ($this->form_validation->run() == FALSE) {
            // $data['validation_msg'] = validation_errors();
            // $this->load->view('admin/Inventory/dashboard', $data);
            $this->session->set_flashdata('errors', validation_errors());
            redirect(base_url('index.php/admin/Inventory/InventoryController/index'));
        } else {
            $newdata = array(
                'supplier_name' => $supplier,
                'contact_person' => $contact_person,
                'number' => $number,
                'address' => $address,
                'email' => $email,
                'payment_type' => $payment_type,
                'supplier_code' => $supplier_code
            );

            if ($exist != 'true') {
                $this->InventoryModel->insert_data('tbl_item_suppliers', $newdata);
                $this->session->set_flashdata('success', 'Supplier saved successfully.');
                $this->createLog('Inventory Item Suppliers', $this->session->userdata('user_Id'), 'Create', $this->input->post());
            } else {
                $this->createLog('Inventory Item Suppliers', $this->session->userdata('user_Id'), 'Update', $this->input->post());
                $this->session->set_flashdata('success', 'Supplier updated successfully.');
                $this->InventoryModel->update_data_where('tbl_item_suppliers', 'supplier_id', $supplier_id, $newdata);
            }

            redirect(base_url('index.php/admin/Inventory/InventoryController/index#ph_item_suppliers'));
        }
    }

    public function get_items_stock_json()
    {
        $term = strtoupper($this->input->get('term'));
        $not_all = $this->input->get('not_all');

        $this->db->select('tbl_item_inventory_invoice_items.*, tbl_item_inventory_invoices.date, tbl_items_list.item_name, tbl_items_list.barcode as item_barcode,tbl_items_list.item_id, 
                    (IFNULL(tbl_item_inventory_invoice_items.quantity + tbl_item_inventory_invoice_items.bonus, 0) - IFNULL((SELECT SUM(tbl_item_requests_items.quantity) 
                            FROM tbl_item_requests_items 
                            WHERE tbl_item_requests_items.invoice_item_id = tbl_item_inventory_invoice_items.item_inventory_invoice_item_id), 0))
                    as stock_qty');
        $this->db->from('tbl_item_inventory_invoice_items');
        $this->db->join('tbl_items_list', 'tbl_items_list.item_id = tbl_item_inventory_invoice_items.item_id', 'inner');
        $this->db->join('tbl_item_inventory_invoices', 'tbl_item_inventory_invoices.inventory_invoice_id = tbl_item_inventory_invoice_items.item_inventory_invoice_id', 'inner');
        $this->db->where("(tbl_items_list.item_id LIKE '$term%' OR tbl_items_list.item_name LIKE '%$term%')");
        $this->db->where_not_in('tbl_item_inventory_invoice_items.item_inventory_invoice_item_id', $not_all);
        $this->db->order_by('tbl_items_list.item_name', 'ASC');
        $this->db->limit(10);

        $query = $this->db->get();

        $data = array();

        foreach ($query->result_array() as $row) {
            if ($row['stock_qty'] > 0) {
                $data[] = (object)[
                    'id' => $row['item_inventory_invoice_item_id'],
                    'text' =>  $row['item_inventory_invoice_id'] . ' || ' . $row['item_id'] . ' || ' . $row['item_barcode'] . ' || ' . $row['item_name'] . ' || ' . $row['stock_qty'] . ' || ' . number_format($row['out_price'], 2)
                ];
            }
        }

        echo json_encode($data);
    }

    public function manage_requests()
    {
        $this->db->trans_begin();
        try {
            $data['page_header'] = 'Inventory';
            $data['title'] = 'Inventory View ::: Hospital Managemnt Software';

            $data['items'] = $this->InventoryModel->retrieve_data('tbl_items_list');
            $data['item_types'] = $this->InventoryModel->retrieve_data('tbl_item_types');
            $data['units'] = $this->InventoryModel->retrieve_data('tbl_units');

            $invoice_item_id = $this->input->post('invoice_item_id');
            $item_id = $this->input->post('item_id');
            $doctor_id = $this->input->post('doctor_id');
            $qty = $this->input->post('qty') ?? 0;
            $date = $this->input->post('date');
            $items = $this->input->post('items');
            $quantity = $this->input->post('quantity');
            $department = $this->input->post('department');

            $item_request_data = [
                'employee_id' => $doctor_id,
                'user_id' => $this->session->userdata('user_Id'),
                'date' => $date,
                'department' => $department
            ];

            $request_id = $this->InventoryModel->insert_data('tbl_item_requests', $item_request_data);

            if(count($quantity) == 0) {
                $this->session->set_flashdata('errors', "You must select items before make a request.");
                redirect(base_url('index.php/admin/Inventory/InventoryController/index'));
            }

            foreach ($quantity as $k => $q) {
                if ($q != 0) {
                    $items_data = array('invoice_item_id' => $invoice_item_id[$k], 'request_id' => $request_id, 'item_id' => $items[$k], 'quantity' => $quantity[$k]);
                    $this->InventoryModel->insert_data('tbl_item_requests_items', $items_data);
                }
            }

            $history_data = [
                'request_id' => $request_id,
                'updated_by' => $this->session->userdata('user_Id'),
                'quantity' => $qty,
                // 'drug_id' => $item_id,
                'update_date' => date('Y-m-d H:i:s'),
                //'location' => '',
                //'expiry_date' => '',
                // 'action' => 'Create'
                'action' => 'Transfer'
            ];

            $this->InventoryModel->insert_data('tbl_item_inventory_history', $history_data);
            $this->createLog('Inventory Request Item', $this->session->userdata('user_Id'), 'Create', $this->input->post());
            $this->session->set_flashdata('success', 'Request saved successfully.');
            $this->db->trans_commit();

            redirect(base_url('index.php/admin/Inventory/InventoryController/index#ph_requests'));
        } catch (Exception $e) {
            $this->db->trans_rollback();
            log_message('error', $e->getMessage());
            echo 'Exception!';
        }
    }

    public function get_doctor_requests_items()
    {

        $this->db->select('tbl_item_requests_items.*,tbl_item_inventory_invoice_items.out_price as item_price,
		(IFNULL((SELECT SUM(tbl_item_inventory_invoice_items.quantity+tbl_item_inventory_invoice_items.bonus) FROM tbl_item_inventory_invoice_items WHERE tbl_item_requests_items.invoice_item_id = tbl_item_inventory_invoice_items.item_inventory_invoice_item_id),0) - IFNULL((SELECT SUM(tbl_item_requests_items.quantity) FROM tbl_item_requests_items WHERE tbl_item_requests_items.invoice_item_id = tbl_item_inventory_invoice_items.item_inventory_invoice_item_id),0)) stock_qty,
		tbl_items_list.*', false);
        $this->db->from('tbl_item_requests_items');
        $this->db->join('tbl_items_list', 'tbl_items_list.item_id = tbl_item_requests_items.item_id', 'left');
        $this->db->join('tbl_item_inventory_invoice_items', 'tbl_item_inventory_invoice_items.item_inventory_invoice_item_id = tbl_item_requests_items.invoice_item_id', 'left');
        $this->db->where('request_id', $this->input->post('request_id'));

        $row = $this->db->get();
        $items = $row->result_array();

        echo json_encode($items);
    }

    public function update_requests()
    {
        $this->db->trans_begin();

        try {
            $data['page_header'] = 'Inventory';
            $data['title'] = 'Inventory View ::: Hospital Managemnt Software';

            $data['items'] = $this->InventoryModel->retrieve_data('tbl_items_list');
            $data['item_types'] = $this->InventoryModel->retrieve_data('tbl_item_types');
            $data['units'] = $this->InventoryModel->retrieve_data('tbl_units');

            $invoice_item_id = $this->input->post('invoice_item_id');
            $item_id = $this->input->post('item_id2_edit');
            $doctor_id = $this->input->post('doctor_id_edit');
            $qty = $this->input->post('qty_edit') ?? 0;
            $date = $this->input->post('date_edit');
            $request_id = $this->input->post('request_id_edit');
            $items = $this->input->post('items');
            $quantity = $this->input->post('quantity');
            $department = $this->input->post('department');

            $item_request_data = array(
                'employee_id' => $doctor_id,
                'user_id' => $this->session->userdata('user_Id'),
                'date' => $date,
                'department' => $department
            );

            $this->InventoryModel->update_data_where('tbl_item_requests', 'request_id', $request_id, $item_request_data);
            $this->createLog('Inventory Request Item', $this->session->userdata('user_Id'), 'Update', $this->input->post());
            $this->db->delete('tbl_item_requests_items', array('request_id' => $request_id));

            foreach ($quantity as $k => $q) {
                if ($q != 0) {
                    $items_data = array('invoice_item_id' => $invoice_item_id[$k], 'request_id' => $request_id, 'item_id' => $items[$k], 'quantity' => $quantity[$k]);
                    $this->InventoryModel->insert_data('tbl_item_requests_items', $items_data);
                }
            }

            $history_data = array(
                'request_id' => $request_id,
                'updated_by' => $this->session->userdata('user_Id'),
                'quantity' => $qty,
                'update_date' => date('Y-m-d H:i:s'),
                'action' => 'Transfer'
            );

            $this->InventoryModel->insert_data('tbl_item_inventory_history', $history_data);

            $this->db->trans_commit();
            $this->session->set_flashdata('success', 'Request update successfully.');
            redirect(base_url('index.php/admin/Inventory/InventoryController/index#ph_requests'));
        } catch (Exception $e) {
            $this->db->trans_rollback();
            log_message('error', $e->getMessage());
            echo 'Exception!';
        }
    }

    public function invoice($id = '')
    {
        $data['page_header'] = '';
        $data['title'] = 'Inventory View ::: Hospital Managemnt Software';

        $data['items'] = $this->InventoryModel->retrieve_data('tbl_items_list');
        $data['item_types'] = $this->InventoryModel->retrieve_data('tbl_item_types');
        $data['units'] = $this->InventoryModel->retrieve_data('tbl_units');
        $data['suppliers'] = $this->InventoryModel->retrieve_data('tbl_item_suppliers');
        $data['clinic_info'] = $this->InventoryModel->retrieve_data_unique_row('tbl_company');

        $data['inventory'] = $this->InventoryModel->stock_list($id);
        $data['logs'] = $this->InventoryModel->stock_history($id);
        $data['locations'] = $this->InventoryModel->retrieve_data('tbl_inventory_item_locations');

        if (isset($id)) {
            $data['header'] = $this->InventoryModel->item_inventory_invoices($id);
            $data['items'] = $this->InventoryModel->item_inventory_invoice_items($id);
        }

        $this->load->view('admin/Inventory/pharmacy_stock_invoice', $data);

        //redirect(base_url('index.php/admin/Inventory/InventoryController/index#ph_requests'));
    }

    public function get_items_json()
    {
        $term = strtoupper($this->input->get('term'));
        $this->db->select('*, 
        (IFNULL((SELECT SUM(tbl_item_inventory_invoice_items.quantity + tbl_item_inventory_invoice_items.bonus) FROM tbl_item_inventory_invoice_items WHERE tbl_item_inventory_invoice_items.item_id = tbl_items_list.item_id),0) - IFNULL((SELECT SUM(tbl_item_requests_items.quantity) FROM tbl_item_requests_items WHERE tbl_item_requests_items.item_id = tbl_items_list.item_id),0)) as stock_qty,
        IFNULL(tbl_items_list.barcode, "-") AS barcode');
        $this->db->from('tbl_items_list');
        $this->db->join('tbl_units', 'tbl_items_list.unit = tbl_units.unit_id', 'left');
        $this->db->where("(tbl_items_list.item_id LIKE '$term%' OR tbl_items_list.item_name LIKE '$term%' OR tbl_items_list.barcode LIKE '$term%')");
        $this->db->order_by('tbl_items_list.item_name', 'ASC');
        $this->db->limit(10);
        $query = $this->db->get();

        $data = array();
        foreach ($query->result_array() as $row) {
            $data[] = (object) array(
                'id' => $row['item_id'],
                'text' => $row['item_id'] . ' || ' . (isset($row['barcode']) ? $row['barcode'] : '') . ' || ' . $row['item_name'] . ' || ' . $row['stock_qty'] . ' || ' . $row['unit_id']
            );
        }

        echo json_encode($data);
    }

    public function manage_invoice()
    {

        $this->db->trans_begin();
        try {
            $invoice_id = $this->input->post('invoice_id');

            $qty = $this->input->post('qty');
            $invoice_no = $this->input->post('invoice_no');
            $payment_method = $this->input->post('payment_method');
            $date = $this->input->post('date');
            $supplier_id = $this->input->post('supplier_id');
            $qty = $this->input->post('item_qty');
            $item_expire = $this->input->post('item_expire');
            $scanned_invoice = $this->input->post('scanned_invoice') ?? '';
            $scanned_payment = $this->input->post('scanned_payment') ?? '';
            $location = $this->input->post('location');
            $bonus = $this->input->post('bonus');

            $invoice_item_arr = $this->input->post('invoice_item_id');
            $items_arr = $this->input->post('item');
            $qty_arr = $this->input->post('qty');
            $price = $this->input->post('price');
            $unit_arr = $this->input->post('item_list_unit');
            $expiry_arr = $this->input->post('item_expire');
            $location_arr = $this->input->post('item_location');

            $invoice = '';
            $payment = '';

            $data = [
                'ref_no' => $invoice_no,
                'payment_method' => $payment_method,
                'date' => $date,
                'supplier_id' => $supplier_id,
                'scanned_invoice' => $scanned_invoice,
                'scanned_payment' => $scanned_payment
            ];

            if (($invoice_id) != '') {
                $this->InventoryModel->update_data_where('tbl_item_inventory_invoices', 'inventory_invoice_id', $invoice_id, $data);
                $inv_id = $invoice_id;
            } else {
                $inv_id = $this->InventoryModel->insert_data('tbl_item_inventory_invoices', $data);
            }


            if (isset($_FILES['scanned_invoice'])) {
                $ext = strtolower(pathinfo($_FILES['scanned_invoice']['name'], PATHINFO_EXTENSION));
                $invoice = $inv_id . '-inv.' . $ext;

                $config['upload_path'] = './'.UPLOAD_PATH.'inventory/';
                $config['allowed_types'] = 'jpg|png|jpeg|gif|pdf';
                $config['overwrite']    = 'TRUE';
                $config['max_size'] = '3072';
                $config['max_width']  = '0';
                $config['max_height']  = '0';
                $config['file_name']  = $invoice;

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if (!$this->upload->do_upload('scanned_invoice')) {
                    $error = ['error' => $this->upload->display_errors()];
                } else {
                    $data = ['upload_data' => $this->upload->data()];
                }
            }

            if (isset($_FILES['scanned_payment'])) {
                $ext = strtolower(pathinfo($_FILES['scanned_payment']['name'], PATHINFO_EXTENSION));
                $payment = $inv_id . '-pay.' . $ext;

                $config['upload_path'] = './'.UPLOAD_PATH.'inventory/';
                $config['allowed_types'] = 'jpg|png|jpeg|gif|pdf';
                $config['overwrite']    = 'TRUE';
                $config['max_size'] = '3072';
                $config['max_width']  = '0';
                $config['max_height']  = '0';
                $config['file_name']  = $payment;

                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                if (!$this->upload->do_upload('scanned_payment')) {
                    $error = ['error' => $this->upload->display_errors()];
                } else {
                    $data = ['upload_data' => $this->upload->data()];
                }
            }

            $data = [
                'ref_no' => $invoice_no,
                'payment_method' => $payment_method,
                'date' => $date,
                'supplier_id' => $supplier_id,
                'scanned_invoice' => $invoice,
                'scanned_payment' => $payment
            ];

            $this->InventoryModel->update_data_where('tbl_item_inventory_invoices', 'inventory_invoice_id', $inv_id, $data);

            foreach ($items_arr as $k => $item) {
                $out_price = ($qty_arr[$k] * $price[$k]) / ($qty_arr[$k] + $bonus[$k]);

                $item_data = array(
                    'item_inventory_invoice_id' => $inv_id,
                    'item_id' => $item,
                    'quantity' => $qty_arr[$k],
                    'price' => $price[$k],
                    'out_price' => number_format($out_price, 2),
                    'unit' => $unit_arr[$k],
                    'bonus' => $bonus[$k],
                    'expiry_date' => $expiry_arr[$k],
                    'location' => $location_arr[$k]
                );

                if ($invoice_item_arr[$k] != '') {
                    $this->InventoryModel->update_data_where('tbl_item_inventory_invoice_items', 'item_inventory_invoice_item_id', $invoice_item_arr[$k], $item_data);
                    $inventory_item_id = $invoice_item_arr[$k];
                } else {
                    $inventory_item_id = $this->InventoryModel->insert_data('tbl_item_inventory_invoice_items', $item_data);
                }

                $item_info = $this->InventoryModel->get_inventory_item_info($item);

                $history_data = array(
                    'item_inventory_invoice_item_id' => $inventory_item_id,
                    'item_inventory_id' => $inv_id,
                    'updated_by' => $this->session->userdata('user_Id'),
                    'update_date' => date('Y-m-d H:i:s'),
                    'quantity' => $qty_arr[$k],
                    'expiry_date' => $expiry_arr[$k],
                    'price' => $item_info->price,
                    'item_type' => $item_info->item_type,
                    'unit' => $item_info->unit,
                    'location' => $location_arr[$k],
                    // 'action' => ($invoice_id == '' ? 'Create' : 'Update')
                    'action' => 'Billing',
                    'update_date' => date('Y-m-d H:i:s')
                );

                $inventory_item_id = $this->InventoryModel->insert_data('tbl_item_inventory_history', $history_data);
            }

            $logArray = array_merge($data, $this->input->post());
            $this->createLog('Inventory Item Invoice', $this->session->userdata('user_Id'), 'Create', $logArray);
            $this->session->set_flashdata('success', 'Invoice saved successfully.');

            $this->db->trans_commit();
            redirect(base_url('index.php/admin/Inventory/InventoryController/invoice'));
        } catch (Exception $e) {
            $this->db->trans_rollback();
            log_message('error', $e->getMessage());
            echo 'Exception!';
        }
    }

    public function restock($id = '')
    {
        $data['page_header'] = '';
        $data['title'] = 'Inventory View ::: Hospital Managemnt Software';

        $data['items'] = $this->InventoryModel->retrieve_data('tbl_items_list');
        $data['item_types'] = $this->InventoryModel->retrieve_data('tbl_item_types');
        $data['units'] = $this->InventoryModel->retrieve_data('tbl_units');
        $data['suppliers'] = $this->InventoryModel->retrieve_data('tbl_item_suppliers');
        $data['clinic_info'] = $this->InventoryModel->retrieve_data_unique_row('tbl_company');

        $data['inventory'] = $this->InventoryModel->stock_list($id);
        $data['logs'] = $this->InventoryModel->stock_history($id);

        if (isset($id)) {
            $data['header'] = $this->InventoryModel->item_inventory_invoices($id);
            $data['items'] = $this->InventoryModel->item_inventory_invoice_items($id);
        }

        $this->load->view('admin/Inventory/pharmacy_stock_restock', $data);
    }

    public function search_supplier_items()
    {
        $supplier_id = $this->input->post('supplier_id');
        $result = $this->InventoryModel->get_supplier_items($supplier_id);
        $HTML = '';
        if ($result != FALSE and $supplier_id != "") {
            foreach ($result as $row) {
                $HTML .= '
                                <tr>
                                    <td width="30%"><input type="hidden" class="form-control" name="item_id[]" value="' . $row['item_id'] . '"><input type="hidden" class="form-control" name="unit_id[]" value="' . $row['unit_id'] . '"><b>' . $row['item_id'] . ' - ' . $row['item_name'] . '</b><br>' . $row['supplier_name'] . '</td>
                                    <td width="10%"><input type="date" class="form-control datepicker" name="expiry_date[]"></td>
                                    <td width="10%"><input type="text" class="form-control" name="serial_no[]"></td>
                                    <td width="15%"><input type="text" class="form-control" name="location[]"></td>
                                    <td class="text-left">' . ($row['stock_qty'] <= 5 ? '<label style="color: #eb3434">' . $row['stock_qty'] . '</label>' : $row['stock_qty']) . '</td>
                                    <td class="col-md-1"><input type="text" class="form-control" name="qty[]" value="0"></td>
                                    <td>' . $row['unit_name'] . '</td>
                                    <td class="col-md-1"><input type="text" class="form-control" name="price[]" value="' . ($row['price'] != '' ? $row['price'] : 0) . '"></td>
                                </tr>
                    ';
            }

            echo $HTML;
        } else {
            $HTML .= 'Not Found Any Records';
            echo $HTML;
        }
    }

    public function manage_restock()
    {
        $data['page_header'] = 'Inventory';
        $data['title'] = 'Inventory View ::: Hospital Managemnt Software';

        $data['items'] = $this->InventoryModel->retrieve_data('tbl_items_list');
        $data['item_types'] = $this->InventoryModel->retrieve_data('tbl_item_types');
        $data['units'] = $this->InventoryModel->retrieve_data('tbl_units');
        $data['doctors'] = $this->InventoryModel->get_doctors();

        $supplier_id = $this->input->post('supplier_id');
        $invoice_no = $this->input->post('invoice_no');
        $date = $this->input->post('date');
        $payment_method = $this->input->post('payment_method');

        $item = $this->input->post('item_id');
        $unit = $this->input->post('unit_id');
        $expiry_date = $this->input->post('expiry_date');
        $serial_no = $this->input->post('serial_no');
        $location = $this->input->post('location');
        $qty = $this->input->post('qty');
        $price = $this->input->post('price');

        $data = [
            'ref_no' => $invoice_no,
            'payment_method' => $payment_method,
            'date' => $date,
            'supplier_id' => $supplier_id
        ];

        $inv_id = $this->InventoryModel->insert_data('tbl_item_inventory_invoices', $data);

        foreach ($qty as $k => $q) {
            if ($q != 0) {
                $items = array('item_id' => $item[$k], 'quantity' => $qty[$k], 'price' => $price[$k], 'unit' => $unit[$k], 'expiry_date' => $expiry_date[$k], 'location' => $location[$k], 'item_inventory_invoice_id' => $inv_id);

                $this->InventoryModel->insert_data('tbl_item_inventory_invoice_items', $items);
            }
        }

        $this->createLog('Inventory Item Restock', $this->session->userdata('user_Id'), 'Create', $this->input->post());

        $this->session->set_flashdata('success', 'Restock completed.');
        redirect(base_url('index.php/admin/Inventory/InventoryController/index#ph_items'));
    }

    public function get_items_json_reports()
    {
        $this->db->select('tbl_items_list.*, 
        (IFNULL((SELECT SUM(tbl_item_inventory_invoice_items.quantity + tbl_item_inventory_invoice_items.bonus) 
        FROM tbl_item_inventory_invoice_items 
        WHERE tbl_item_inventory_invoice_items.item_id = tbl_items_list.item_id),0) - 
        IFNULL((SELECT SUM(tbl_item_requests_items.quantity) 
        FROM tbl_item_requests_items 
        WHERE tbl_item_requests_items.item_id = tbl_items_list.item_id),0)) AS stock_qty');
        $this->db->select("IFNULL(tbl_items_list.barcode,'-') AS barcode");
        $this->db->from('tbl_items_list');
        $this->db->join('tbl_units', 'tbl_items_list.unit = tbl_units.unit_id', 'left');
        $this->db->where("(tbl_items_list.item_id LIKE '" . strtoupper($this->input->get('term')) . "%' OR tbl_items_list.item_name LIKE '" . strtoupper($this->input->get('term')) . "%' OR tbl_items_list.barcode LIKE '" . strtoupper($this->input->get('term')) . "%')");
        $this->db->order_by('tbl_items_list.item_name', 'ASC');
        $this->db->limit(10);

        $query = $this->db->get();
        $data = array(array('id' => 0, 'text' => 'All'));

        foreach ($query->result_array() as $row) {
            $data[] = (object)[
                'id' => $row['item_id'],
                'text' => $row['item_id'] . ' || ' . (isset($row['barcode']) ? $row['barcode'] : '') . ' || ' . $row['item_name'] . ' || ' . $row['stock_qty'] . ' || ' . $row['unit_id']
            ];
        }

        echo json_encode($data);
    }

    function get_report_billing()
    {

        $supplier_id = $this->input->post('supplier_id');
        $item_id = $this->input->post('item_id');
        $from_date = $this->input->post('from_date');
        $to_date = $this->input->post('to_date');

        $data['clinic_info'] = $this->InventoryModel->retrieve_data_unique_row('tbl_company');
        $data['result'] = $this->InventoryModel->get_supplier_items_report_billing($supplier_id, $item_id, $from_date, $to_date);
        $data['supplier_info'] = $this->InventoryModel->get_supplier_info($supplier_id);
        $data['item_info'] = $this->InventoryModel->get_item_info($item_id);

        $this->load->view('admin/Inventory/report_inventory_billing', $data);
    }

    function get_report_transfer(){

        $doctor_id = $this->input->post('doctor_id');
        $department = $this->input->post('department');
        $item_id = $this->input->post('item_id');
        $from_date = $this->input->post('from_date');
        $to_date = $this->input->post('to_date');

        $data['department'] = $department;
        $data['clinic_info'] = $this->InventoryModel->retrieve_data_unique_row('tbl_company');
        $data['result'] = $this->InventoryModel->get_doctor_items_report_transfer($doctor_id, $item_id, $from_date, $to_date, $department);
        $data['doctor_info'] = $this->InventoryModel->get_doctors_by_emp($doctor_id);
        $data['item_info'] = $this->InventoryModel->get_item_info($item_id);

        $this->load->view('admin/Inventory/report_inventory_transfer', $data);

	}
    
    function get_report_balance(){

        $item_id = $this->input->post('item_id');

        $data['clinic_info'] = $this->InventoryModel->retrieve_data_unique_row('tbl_company');
        $data['result'] = $this->InventoryModel->get_items_report_balance($item_id);
        $data['item_info'] = $this->InventoryModel->get_item_info($item_id);
        
        $this->load->view('admin/Inventory/report_inventory_balance', $data);


	}
    
    public function get_inventory_item_locations(){
     
        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');
        $search = $this->input->get('search')['value'];

        $records = $this->InventoryModel->retrieve_data('tbl_inventory_item_locations');
        $total_records = count($records);

        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));

    }

    public function create_new_inventory_location(){
        return $this->InventoryModel->insert_data('tbl_inventory_item_locations',$this->input->post());
    }

    public function delete_inventory_location($location_id){
        $this->InventoryModel->delete_data_where('tbl_inventory_item_locations', 'id', $location_id);
        $this->session->set_flashdata('success', 'Inventory location deleted successfully.');
        redirect(base_url('index.php/admin/Inventory/InventoryController/index'));
    }

    public function change_min_qty() {
        $item_id = $this->input->post('item_id');
        $min_qty = $this->input->post('item_min_qty');

        $this->InventoryModel->update_data_where('tbl_items_list', 'item_id', $item_id, ['min_qty' => $min_qty]);

        $this->output->set_content_type('application/json')->set_status_header(200)->set_output(json_encode([
            'message' => 'Item minimum qty changed.'
        ]));


    }

}
