<?php
use Picqer\Barcode\BarcodeGeneratorPNG;
use Twilio\Rest\Client;


class InvoiceController extends MY_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->load->model('admin/Invoice/InvoiceModel');
        $this->load->model('admin/Payments/PaymentsModel');
        $this->load->library('PdfGenerator');
        $this->load->library('TwilioWhatsApp');
        $this->load->model('admin/Receipt/ReceiptModel');
    }

    public function test(){
        return 'sd';
    }
    public function generate_barcode($invoice_number) {

        
        // Load the Barcode Generator library
        $generator = new BarcodeGeneratorPNG();

        // Generate the barcode 
        $barcode = $generator->getBarcode($invoice_number, $generator::TYPE_CODE_128);

        // Set the content type to PNG
        header('Content-Type: image/png');

        // Output the barcode image
        echo $barcode;
    }

    public function get_encrypted_value($value){
         $encrypted=encrypt_and_url_encode($value,$this);
        echo json_encode(['encrypted' => $encrypted]);
    }

    public function index($treatment_payment_id)
    {

        $data = [];
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;

        $template = $this->InvoiceModel->get_active_template();
        $data['company'] = $this->CommonModel->get_company_info();
        
        $treatment_payment_id = decrypt_and_url_decode($treatment_payment_id, $this);
        $data['invoiceData'] = $this->InvoiceModel->get_invoice_details($treatment_payment_id);
        $data['receipts'] = $this->ReceiptModel->get_receipt_summary($treatment_payment_id);

        $data['view']='invoice';

        $data['treatment_payment_id']=$treatment_payment_id;
        $this->load->view('admin/Invoice/Templates/'.$template.'.php', $data);
    }

    

    public function labInvoice($treatment_payment_id)
    {

        $data = [];
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;
        $treatment_payment_id = decrypt_and_url_decode($treatment_payment_id, $this);
        $template = $this->InvoiceModel->get_active_template();
        $data['company'] = $this->CommonModel->get_company_info();
        
        
        $data['invoiceData'] = $this->InvoiceModel->get_invoice_details($treatment_payment_id);

        $data['tests'] = $this->InvoiceModel->get_case_test_by_payment($treatment_payment_id);
        $data['treatment_payment_id']=$treatment_payment_id;
        $data['view']='lab';
        $this->load->view('admin/Invoice/Templates/'.$template.'.php', $data);
    }

    

    public function upload() {
        header('Content-Type: application/json');

        $uploadDir = './'.UPLOAD_PATH.'PdfInvoices/';
        $uploadFile = $uploadDir . basename($_FILES['file']['name']);

        if (move_uploaded_file($_FILES['file']['tmp_name'], $uploadFile)) {
            $response = [
                'success' => true,
                'url' => base_url('/'.UPLOAD_PATH.'Pdfinvoices/' . $_FILES['file']['name'])
            ];
        } else {
            $response = [
                'success' => false,
                'error' => 'Failed to upload file.'
            ];
        }

        echo json_encode($response);
    }

    public function send_whatsapp_pdf() {
       // Load the file from the POST request
        if (!isset($_FILES['file']['tmp_name'])) {
            echo json_encode(['message' => 'No file uploaded.']);
            return;
        }
        $id = $this->input->post('id');
        $data = $this->PaymentsModel->getTreatment($id);
        
      
         $pdfContent = file_get_contents($_FILES['file']['tmp_name']);

        // // Save the PDF temporarily on the server
        $fileName = $data->treatement_payment_id.'_invoice.pdf';
        $tempPath = FCPATH . ''.UPLOAD_PATH.$fileName;
        file_put_contents($tempPath, $pdfContent);

        $fileUrl = base_url(UPLOAD_PATH . $fileName);
        
       $this->send_whatsapp_invoice($data,$fileUrl,$fileName);
       
    }
    public function send_whatsapp_invoice($data,$fileUrl,$fileName) {
       ///for invouce fuke
         $template_id = $this->InvoiceModel->get_content_id('patient_invoice_new');
        
        $content_sid = $template_id;
        $to = '+'.$data->wa_code .$data->wa_mobile ; // Recipient number
     
      
        if(!empty($to)){
            $file= $fileUrl;
            
            $patient_name= $data->patient_name;
            // $data= array(
            //       "1" => $data->patient_name, // Ensure these match the variables in your template
            //       "2"=>'97474710868',
            //     );
      
         $response = $this->twiliowhatsapp->send_template_message_with_content($to, $content_sid, $patient_name,$file,$fileName);

         $data= array(
            'status'=>true,'message'=>'Invoice Sent Successfully'
         );
      
        }else{
            $data= array(
                'status'=>true,'message'=>'Please Add Patient Whatsapp Number'
             );
             
        }
        
        // $from_number = "whatsapp:+12342941402"; // Your Twilio WhatsApp number
       
        echo json_encode($data);
    }

    public function view_template($id){
        
        $data['template'] = $this->InvoiceModel->get_active_template();
        $data['company'] = $this->CommonModel->get_company_info();
        $data['invoiceData'] = $this->InvoiceModel->get_invoice_details(6);

        $this->load->view('admin/Invoice/Templates/template1.php', $data);
    }
}