<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once APPPATH . 'helpers/job/should_queue.interface.php';

class SmsNotification implements ShouldQueue
{

    private $lang = null; // en - 1 , ar - 2 [Type - Integer]
    private $api_key = null; // [Type - String]
    private $sender = null; // [Type - String]
    private $phone_number = null; // [Type - Integer or Array or string ('all', 'vip') : ]
    private $message = null; // [Type - Integer]

    public function __construct($CI = null, $lang = null, $sender = null, $phone_number = null, $message = null)
    {

        $CI->load->model('admin/NotificationServices/NotificationServicesModel');

        $configObj = $CI->NotificationServicesModel->get_configurations('SMS Service');
        $config = json_decode($configObj->service_configuration);

        $this->lang = $lang ?? ($config->lang ?? null);
        $this->api_key = $config->api_key ?? null;
        $this->sender = $sender ?? ($config->sender ?? null);
        $this->phone_number = $phone_number ?? null;
        $this->message = $message ?? null;


        $unsetParams = [];
        if (empty($config->lang)) {
            $unsetParams[] = 'lang';
        }
        if (empty($config->api_key)) {
            $unsetParams[] = 'api_key';
        }
        if (empty($config->sender)) {
            $unsetParams[] = 'sender';
        }
        if (empty($phone_number)) {
            $unsetParams[] = 'phone_number';
        }
        if (empty($message)) {
            $unsetParams[] = 'message';
        }

        if (!empty($unsetParams)) {
            throw new Exception("The following required properties are not set: " . implode(', ', $unsetParams));
        }
    }

    public function handle($CI = null)
    {
        $CI->load->model('admin/NotificationServices/NotificationServicesModel');

        if (is_array($this->phone_number)) {

            if(count($this->phone_number) == 1 && in_array($this->phone_number[0], ['all', 'vip']) ){

                $phone_number_query = $CI->db->select('mobile')->from('tbl_patients');
                
                if($this->phone_number[0] != 'all') {
                    $phone_number_query->where($this->phone_number[0], $this->phone_number[0] ? 1 : 0);
                }

                $res = $phone_number_query->get()->result();
                
                if($res) {
                    $phone_numbers = array_column($res, 'mobile');
                    $this->phone_number = $phone_numbers;
                }else{
                    throw new Exception('Failed to fetch patient mobile numbers.');
                }
            }else{
                // If user provide selected customers with all, it remove [all] from array
                unset($this->phone_number['all']);
            }

            // Get patient mobile numbers
            foreach ($this->phone_number as $phone_number) {

                $url = "https://www.api-server14.com/api/send.aspx?apikey={$this->api_key}&language={$this->lang}&sender={$this->sender}&mobile=$phone_number&message=" . urlencode($this->message);
                
                try {
                    //$response = file_get_contents($url);
                    echo $url . (php_sapi_name() === 'cli' ? "\r\n" : "<br>");
                    $CI->NotificationServicesModel->save_sms_notification_response(json_encode(['response' => $response ?? '', 'url' => $url]));
                    //return true;
                } catch (Exception $e) {
                    echo "Message:" . $e->getMessage();
                    $CI->NotificationServicesModel->save_sms_notification_response(json_encode(['response' => $e->getMessage(), 'url' => $url]));
                    return false;
                }
            }

            return true;
        } else {
            $url = "https://www.api-server14.com/api/send.aspx?apikey={$this->api_key}&language={$this->lang}&sender={$this->sender}&mobile=+974$this->phone_number&message=" . urlencode($this->message);
            
            try {
                //$response = file_get_contents($url);
                echo $url . (php_sapi_name() === 'cli' ? "\r\n" : "<br>");
                $CI->NotificationServicesModel->save_sms_notification_response(json_encode(['response' => $response ?? '', 'url' => $url]));
                return true;
            } catch (Exception $e) {
                echo "Message:" . $e->getMessage();
                $CI->NotificationServicesModel->save_sms_notification_response(json_encode(['response' => $e->getMessage(), 'url' => $url]));
                return false;
            }
        }

        return false;
    }
}
