<?php


class FilterController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('admin/Pharmacy/PharmacyModel');
        $this->load->model('admin/Patients/PatientsModel');
        $this->load->model('admin/Payments/PaymentsModel');
        $this->load->model('admin/Reports/ReportsModel','report_retrive');
        $this->load->model('admin/ConsentForm/ConfigurationRetriveModel');
        $this->load->model('admin/Pharmacy/SubModels/inquiry', 'inquiry_model');
        $this->load->model('admin/Pharmacy/SubModels/bill', 'bill_model');
        $this->load->model('admin/Pharmacy/SubModels/financial', 'financial_model');
        $this->load->model('admin/Pharmacy/SubModels/supplier', 'supplier_model');
        $this->load->model('admin/Pharmacy/SubModels/inventory', 'inventory_model');
        $this->load->model('admin/Pharmacy/SubModels/quantity', 'quantity_model');
        $this->load->model('admin/Pharmacy/SubModels/statement', 'statement_model');
        $this->load->model('admin/Pharmacy/SubModels/categories', 'categories_model');
        $this->load->model('admin/Pharmacy/SubModels/items', 'items_model');
        $this->load->model('admin/Pharmacy/SubModels/locations', 'locations_model');
        $this->load->model('admin/Pharmacy/SubModels/pos', 'PosModel');
        $this->load->model('admin/Pharmacy/SubModels/drugsmodel');
   

        $this->load->library('upload');
    }


    public function lab_tests() {
        
        
        $this->load->view('admin/Lab/Configuration/LabTest/lab_test');
    }
    public function new_case() {
        $this->load->model('admin/Patients/PatientsModel');
        $data['countries'] = $this->PatientsModel->retrieve_data('tbl_countries');
        
        $this->load->view('admin/Lab/Case/add_case',$data);
    }

    public function all_cases() {
        $data['units'] = $this->report_retrive->retrieve_data('lab_units');
        $this->load->view('admin/Lab/Case/all_cases',$data);
    }
    public function categories() {
        $data['units'] = $this->report_retrive->retrieve_data('test_categories');
        $this->load->view('admin/Lab/Configuration/categories',$data);
    }
    public function parameters() {
        
        $this->load->view('admin/Lab/Configuration/Parameters/parameters');
    }

    public function lab_requests() {
        
        $data['units'] = $this->report_retrive->retrieve_data('test_categories');
        $this->load->view('admin/Lab/Request/all_request', $data);
    }
    public function units() {
        
        $data['units'] = $this->report_retrive->retrieve_data('lab_units');
        $this->load->view('admin/Lab/Configuration/units', $data);
    }
    
    



}