<?php

class LoginController extends CI_Controller {

    function __construct() {
        parent::__construct();
        $this->load->helper('url');
        $this->load->library('form_validation');
        $this->load->model('admin/Login/LoginModel');
    }

    public function index() {
		
		$data['logo_val'] = '';
		$data['company_name_val'] = '';
		
		$load_data = $this->LoginModel->get_by_id();
		
		foreach ($load_data AS $row) {
				
			$data['logo_val'] = $row['logo'];
			$data['company_name_val'] = $row['company_name'];
			
       }
		
        $this->load->view('admin/Login/Login',$data);
    }

    public function login() {
        $this->form_validation->set_rules('user_name', 'user_name', 'trim|required');
        $this->form_validation->set_rules('password', 'password', 'trim|required');

        if ($this->form_validation->run() == FALSE) {
            //Field validation failed.  User redirected to login page
            $this->session->set_flashdata('message', '<a class="errorMsg"><i class="fa">&#xf06a;</i>&nbsp;&nbsp; Username and password required.</a>');
            redirect('admin/Login/LoginController');
        } else {
            $user_name = $this->input->post('user_name');
            $full_name = $this->input->post('full_name');
            $password = $this->input->post('password');

            $login_details = $this->LoginModel->login($user_name);

            if (empty($login_details)) {
                $this->session->set_flashdata('message', '<a class="errorMsg"><i class="fa">&#xf06a;</i>&nbsp;&nbsp; Username and Password Invalid.</a>');
                redirect('admin/Login/LoginController');
                return;
            }
            if($login_details->is_inactive == 1){
                 $this->session->set_flashdata('message', '<a class="errorMsg"><i class="fa">&#xf06a;</i>&nbsp;&nbsp; Account Is Not Active.</a>');
                redirect('admin/Login/LoginController');
                return;
            }

            $loginId = -1;

            if (hash_equals($login_details->password, crypt($password, $login_details->password))) {
                $loginId = $login_details->user_Id;
                $full_name = $login_details->full_name;
                $group_id = $login_details->user_group_Id;
            }


            if ($loginId > 0 && $login_details == TRUE) {
				
                $this->session->set_userdata('user_Id', $loginId);
                $this->session->set_userdata('userid', $loginId);
                $this->session->set_userdata('group_id', $group_id);


                $cookie_name = 'userid';
                $cookie_value = $loginId;
                $cookie_expiration = time() + (86400 * 30); // 30 days
                $cookie_path = '/';
                $cookie_domain = '';
                $cookie_secure = FALSE;
                $cookie_httponly = FALSE;

                setcookie($cookie_name, $cookie_value, $cookie_expiration, $cookie_path, $cookie_domain, $cookie_secure, $cookie_httponly);
				
                $this->session->set_flashdata('message', '<div class="alert alert-success fade in">
                                    <button data-dismiss="alert" class="close close-sm" type="button">
                                        <i class="fa fa-times"></i>
                                    </button>
                                    <strong>Well Come!</strong> ' . $full_name . '
                                </div>');
				/*save login user*/
                $this->LoginModel->login_save($user_name, $loginId);
                redirect('admin/Dashboard/DashboardController', 'refresh');
            } else {
                $this->session->set_flashdata('message', '<a class="errorMsg"><i class="fa">&#xf06a;</i>&nbsp;&nbsp; Username and Password Invalid.</a>');
                redirect('admin/Login/LoginController');
            }
        }
    }

    public function log_out() {
        $newdata = array(
            'user_name' => '',
            'password' => '',
            'logged_in' => FALSE,
        );

        $this->session->unset_userdata($newdata);
        $this->session->sess_destroy();
        $this->input->set_cookie('userid', '', time() - 3600);

        redirect('admin/Login/LoginController', 'refresh');
    }

}
