<?php

class DentalController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Patients/PatientsModel');

        $this->load->library('upload');
    }

    public function tooth_svg(){
        $this->load->view('admin/Chart/tooth_svg');
    }
    public function index()
    {
        //Commen -------------------------------------
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $data['dataList'] = $this->PatientsModel->get_dataList();

        $this->load->view('admin/Patients/PatientsList', $data);
    }


    public function save()
    {

            $patient_id = $this->input->post('patient_id');
            $decryptedId = decrypt_and_url_decode($patient_id, $this);
           
            $patient = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);

            $result['active_menu'] = 15;
            $result['active_submenu'] = 1;

            $diagnosis = $this->input->post('treatment_diagnosis');
            $treatment_diagnosis_id = $this->input->post('treatment_diagnosis_id');
            $cheif_compalin = $this->input->post('cheif_compalin');
            $clinical_finding = $this->input->post('clinical_finding');
            $procedure = $this->input->post('treat_procedure');
            $teeth = $this->input->post('treat_teeth');
            $full_teeth = $this->input->post('full_teeth');;
            $fees = $this->input->post('treat_fees');
            $lab_test = $this->input->post('lab_test');
            $radiological = $this->input->post('radiological');
            $note = $this->input->post('note');
         
            $treatment_date = $this->input->post('treatment_date');
            $treatment_time = $this->input->post('treatment_time');
            $treat_type = $this->input->post('treat_type');
            $composit = $this->input->post('composit');
            $assigned_package = $this->input->post('assigned_package');
            $followup = $this->input->post('followup');
            
            $discount = $this->input->post('discount');
            $discount_per = $this->input->post('discount_per');
            $orig_price = $this->input->post('orig_price');

            if (is_array($fees)) {
                $total = array_sum($fees);
            }

            if (is_array($fees)) {
                $orig_price_total = array_sum($orig_price);
            }

            if (is_array($discount)) {
                $total_discount = array_sum($discount);
            }

            $this->db->trans_start();
           

        
        try { 
            if($followup == 0){
            $treatment_payment_data = array(
                'patient_id'  => $decryptedId,
                'user_id' => $this->loginId,
                'treat_date' => $treatment_date,
                'treat_time' => $treatment_time,
                'total' => $orig_price_total,
                'discount' => $total_discount,
                'followup'  => $followup,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => 1 
            );
            
           
        }else{
            $treatment_payment_data = array(
                'patient_id'  => $decryptedId,
                'user_id' => $this->loginId,
                'treat_date' => $treatment_date,
                'treat_time' => $treatment_time,
                'total' => 0,
                'discount' => 0,
                'followup'  => $followup,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => 1 
            );
        }
        $treatement_payment_id = $this->PatientsModel->insert_data('tbl_treatment_payment', $treatment_payment_data);
            $dental_data = array(
                'cheif_compalin'  => $cheif_compalin,
                'clinical_finding' => $clinical_finding,
                'lab_test' => $lab_test,
                'radiological' => $radiological,
                'note' => $note,
                'treatment_payment_id' => $treatement_payment_id ?? 0
            );
       
           $this->PatientsModel->insert_data('tbl_treat_dental', $dental_data);
           if($followup == 0){
            for ($i = 0; $i < count($procedure); $i++) {

                $newdata = array(
                    'procedure_id' => $procedure[$i],
                    'episode_type' => 1,
                    'teeth_number' => $teeth[$i],
                    'full_tooth' => $full_teeth[$i],
                    'diagnostise_id' => $treatment_diagnosis_id[$i],
                    'fees' => $fees[$i],
                    'discount_qr' => $discount[$i],
                    'discount_per' => $discount_per[$i],
                    'treatement_payment_id' => $treatement_payment_id ?? 0,
                    'aditional_diagnostise_name' => $diagnosis[$i],
                    'treat_type' => $treat_type[$i],
                    'orig_price' => $orig_price[$i],
                    'composit' => $composit[$i],
                );

                $this->PatientsModel->insert_data('tbl_episode_payment', $newdata);
            }
            }
            if($followup == 2){
              $this->PatientsModel->updateSessions($decryptedId,$assigned_package,1);
               
               
            }
            
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
			} else {
				$this->db->trans_commit();
			}
			$this->session->set_flashdata('success', 'Dental Treatment saved successfully.');
            redirect('admin/Patients/PatientsController/medical_book/'.$patient_id,'refresh');
        } catch (Exception $e) {
			$this->db->trans_rollback();
            echo $e;
            $this->session->set_flashdata('Error', 'Dental Treatment not saved.');
            redirect('admin/Patients/PatientsController/medical_book/'.$patient_id,'refresh');
            exit;
        }
        
		$this->db->trans_complete();
    }

    public function update()
    {

            $patient_id = $this->input->post('patient_id');
            $treatement_payment_id = $this->input->post('treatement_payment_id');
            $decryptedId = decrypt_and_url_decode($patient_id, $this);
            $patient = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);

            $result['active_menu'] = 15;
            $result['active_submenu'] = 1;

            $diagnosis = $this->input->post('treatment_diagnosis');
            $treatment_diagnosis_id = $this->input->post('treatment_diagnosis_id');
            $cheif_compalin = $this->input->post('cheif_compalin');
            $clinical_finding = $this->input->post('clinical_finding');
            $procedure = $this->input->post('treat_procedure');
            $teeth = $this->input->post('treat_teeth');
            $full_teeth = $this->input->post('full_teeth');;
            $fees = $this->input->post('treat_fees');
            $lab_test = $this->input->post('lab_test');
            $radiological = $this->input->post('radiological');
            $note = $this->input->post('note');
            $followup = $this->input->post('followup');
         
            $treat_type = $this->input->post('treat_type');
            $composit = $this->input->post('composit');


            $discount = $this->input->post('discount');
            $discount_per = $this->input->post('discount_per');
            $orig_price = $this->input->post('orig_price');

            if (is_array($fees)) {
                $total = array_sum($fees);
            }

            if (is_array($fees)) {
                $orig_price_total = array_sum($orig_price);
            }

            if (is_array($discount)) {
                $total_discount = array_sum($discount);
            }

            $this->db->trans_start();
        try { 
            $treatment_payment_data = array(
                'patient_id'  => $decryptedId,
                'user_id' => $this->loginId,
              
                'total' => $orig_price_total,
                'discount' => $total_discount,
                'followup'  => $followup,
                'insurance_type'  => $patient->insurance_type,
                
                'department_id' => 1 
            );

            $dental_data = array(
                'cheif_compalin'  => $cheif_compalin,
                'clinical_finding' => $clinical_finding,
                'lab_test' => $lab_test,
                'radiological' => $radiological,
                'note' => $note
            );
            
            
            $this->PatientsModel->update_data_where('tbl_treatment_payment', 'treatement_payment_id', $treatement_payment_id, $treatment_payment_data);
            $this->PatientsModel->update_data_where('tbl_treat_dental','treatment_payment_id', $treatement_payment_id, $dental_data);
            $this->PatientsModel->delete_data_where('tbl_episode_payment','treatement_payment_id', $treatement_payment_id);

            for ($i = 0; $i < count($procedure); $i++) {

                $newdata = array(
                    'procedure_id' => $procedure[$i],
                    'episode_type' => 1,
                    'teeth_number' => $teeth[$i],
                    'full_tooth' => $full_teeth[$i],
                    'diagnostise_id' => $treatment_diagnosis_id[$i],
                    'fees' => $fees[$i],
                    'discount_qr' => $discount[$i],
                    'discount_per' => $discount_per[$i],
                    'treatement_payment_id' => $treatement_payment_id,
                    'aditional_diagnostise_name' => $diagnosis[$i],
                    'orig_price' => $orig_price[$i],
                    'treat_type' => $treat_type[$i],
                    'composit' => $composit[$i],
                );

                $this->PatientsModel->insert_data('tbl_episode_payment', $newdata);
            }
            
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
			} else {
				$this->db->trans_commit();
			}
            $this->session->set_flashdata('success', 'Dental Treatment Updated Successfully.');
            redirect('admin/Patients/PatientsController/medical_book/'.$patient_id,'refresh');
        } catch (Exception $e) {
			$this->db->trans_rollback();
            echo $e;
            exit;
        }
        
		$this->db->trans_complete();
    }
    public function edit($treatement_payment_id){
        $decryptedId = decrypt_and_url_decode($treatement_payment_id, $this);
        $data['invoice'] = $this->PatientsModel->retrieve_data_unique_row('tbl_treatment_payment','treatement_payment_id',$decryptedId);
        $data['episodes'] = $this->PatientsModel->get_treatment_episodes($decryptedId);
        $data['dental'] = $this->PatientsModel->retrieve_data_unique_row('tbl_treat_dental','treatment_payment_id',$decryptedId);
        $data['patient_id'] = $data['invoice']->patient_id;

        $this->load->view('admin/Modules/Dental/dentalEdit',$data);
    }

    public function savePlan()
    {

            $patient_id = $this->input->post('patient_id');
            $decryptedId = decrypt_and_url_decode($patient_id, $this);
           
            $patient = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);

            $result['active_menu'] = 15;
            $result['active_submenu'] = 1;

            $diagnosis = $this->input->post('treatment_diagnosis');
            $treatment_diagnosis_id = $this->input->post('treatment_diagnosis_id');
            $cheif_compalin = $this->input->post('cheif_compalin');
           
            $procedure = $this->input->post('treat_procedure');
            $teeth = $this->input->post('treat_teeth');
            $full_teeth = $this->input->post('full_teeth');;
            $fees = $this->input->post('treat_fees');
            $radiological = $this->input->post('radiological');
            $note = $this->input->post('note');
         
            $treatment_date = $this->input->post('treatment_date');
            $treatment_time = $this->input->post('treatment_time');
            $treat_type = $this->input->post('treat_type');
            $composit = $this->input->post('composit');
            $assigned_package = $this->input->post('assigned_package');
            $followup = $this->input->post('followup');
            
            $discount = $this->input->post('discount');
            $discount_per = $this->input->post('discount_per');
            $orig_price = $this->input->post('orig_price');
            $plan_name = $this->input->post('plan_name');

            if (is_array($fees)) {
                $total = array_sum($fees);
            }

            if (is_array($fees)) {
                $orig_price_total = array_sum($orig_price);
            }

            if (is_array($discount)) {
                $total_discount = array_sum($discount);
            }

            $this->db->trans_start();
           

        
        try { 

            $treatment_payment_data = array(
                'treat_date' => $treatment_date,
                'treat_time' => $treatment_time,
                'total' => $orig_price_total,
                'discount' => $total_discount,
                'followup'  => $followup,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => 1 
            );

           
            
           
            $dental_data = array(
                'cheif_compalin'  => $cheif_compalin,
                'radiological' => $radiological,
                'note' => $note,
                'treatment_payment_id' => $treatement_payment_id ?? 0
            );

            
           
            $episode_payment = array(); // Fix typo in variable name
            $episode_payment['treatment'] = array(); // Initialize 'treatment' as an array
            
            for ($i = 0; $i < count($procedure); $i++) {
                $newdata = array(
                    'key_id' => $i + 1,
                    'procedure_id' => $procedure[$i],
                    'episode_type' => 1,
                    'teeth_number' => $teeth[$i],
                    'full_tooth' => $full_teeth[$i],
                    'diagnostise_id' => $treatment_diagnosis_id[$i],
                    'fees' => $fees[$i],
                    'discount_qr' => $discount[$i],
                    'discount_per' => $discount_per[$i],
                    'treatement_payment_id' => $treatement_payment_id ?? 0,
                    'aditional_diagnostise_name' => $diagnosis[$i],
                    'treat_type' => $treat_type[$i],
                    'orig_price' => $orig_price[$i],
                    'composit' => $composit[$i],
                );
            
                // Append newdata to the treatment array
                $episode_payment['treatment'][] = $newdata; 
            }

            $savedata=array(
                'plan_name'  => $plan_name,
                'patient_id'  => $decryptedId,
                'doctor_id' => $this->loginId,
                'payment_data'=>json_encode($treatment_payment_data),
                'department_id' => 1 ,
                'treatment_data'=>json_encode($dental_data),
                'episode_payment'=>json_encode($episode_payment),
            );




             $this->PatientsModel->insert_data('treatment_plan', $savedata);
          
            
			if ($this->db->trans_status() === FALSE) {
				$this->db->trans_rollback();
			} else {
				$this->db->trans_commit();
			}
			$this->session->set_flashdata('success', 'Dental Treatment Plan successfully.');
            redirect('admin/Patients/PatientsController/medical_book/'.$patient_id,'refresh');
        } catch (Exception $e) {
			$this->db->trans_rollback();
            echo $e;
            $this->session->set_flashdata('Error', 'Dental Treatment Plan not saved.');
            redirect('admin/Patients/PatientsController/medical_book/'.$patient_id,'refresh');
            exit;
        }
        
		$this->db->trans_complete();
    }

    public function make_treatment_plan() {
       
        $planId = $this->input->post('plan_id');
        $selectedTreatments = $this->input->post('selected'); // Get selected treatments
    
        $plan = $this->PatientsModel->get_plan_data($planId); // Implement this function in your model
        $patient = $this->PatientsModel->get_patient_details('patient_id', $plan->patient_id);


        if ($plan) {
            $episode_payment_data = json_decode($plan->episode_payment, true); // Decode once
            $total=0;
            $discount=0;
            foreach ($episode_payment_data['treatment'] as $episode) {
                if (in_array($episode['key_id'], $selectedTreatments)) {
                    $total+= $episode['orig_price'];
                    $discount += $episode['discount_qr'];
                }
            }
          
            $treatment_data = json_decode($plan->treatment_data);
            $payment_data = json_decode($plan->payment_data);
            $treatment_payment_data = array(
                'patient_id' => $plan->patient_id,
                'user_id' => $this->loginId,
                'treat_date' => date('Y-m-d'), // Set your treatment date
                'treat_time' => date('H:i:s'),
                'total' => $total,
                'discount' => $discount,
                'followup'  => 0,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => 1 
            );
            $treatement_payment_id = $this->PatientsModel->insert_data('tbl_treatment_payment', $treatment_payment_data);
            $dental_data = array(
                'cheif_compalin'  => $treatment_data->cheif_compalin ?? 'nill',
                'clinical_finding' => 'nill',
                'lab_test' => 'nill',
                'radiological' => $treatment_data->radiological,
                'note' => NULL,
                'treatment_payment_id' => $treatement_payment_id ?? 0
            );
       
           $this->PatientsModel->insert_data('tbl_treat_dental', $dental_data);    
           
         
           
            foreach ($episode_payment_data['treatment'] as $episode) {
                if (in_array($episode['key_id'], $selectedTreatments)) {
                    
                    $newdata = array(
                        'procedure_id' => $episode['procedure_id'], // Accessing as an array
                        'episode_type' => 1,
                        'teeth_number' => $episode['teeth_number'],
                        'full_tooth' => $episode['full_tooth'],
                        'diagnostise_id' => $episode['diagnostise_id'],
                        'fees' => $episode['fees'],
                        'discount_qr' => $episode['discount_qr'],
                        'discount_per' => $episode['discount_per'],
                        'treatement_payment_id' => $treatement_payment_id ?? 0,
                        'aditional_diagnostise_name' => $episode['aditional_diagnostise_name'],
                        'treat_type' => $episode['treat_type'],
                        'orig_price' => $episode['orig_price'],
                        'composit' => $episode['composit'],
                    );
                    $this->PatientsModel->insert_data('tbl_episode_payment', $newdata);
                
                }
                }
    
           
    
            echo json_encode(array('status' => 'success', 'message' => 'Payment processed successfully!'));
        } else {
            // Return error response if plan not found
            echo json_encode(array('status' => 'error', 'message' => 'Plan not found.'));
        }
    }
    
}
