<?php

class DermatologyController extends MY_Controller
{
    function __construct()
    {
        parent::__construct();

        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Patients/PatientsModel');
        $this->load->model('admin/Payments/PaymentsModel');
        $this->load->model('admin/Modules/Dermatology/DermatologyModel');
        $this->load->helper('file');
        $this->load->library('csvimport');
    }


    public function canvan_images($imagepath, $pid, $folder_name)
    {

        if (!is_dir('./'.UPLOAD_PATH.'')) {
            mkdir('./'.UPLOAD_PATH.'');
        }

        if (!is_dir('/'.UPLOAD_PATH.'derma/')) {
            mkdir('./'.UPLOAD_PATH.'derma/');
        }

        if (!is_dir("./".UPLOAD_PATH."derma/{$folder_name}")) {
            mkdir("./".UPLOAD_PATH."derma/{$folder_name}");
        }


        $imagepath = substr($imagepath, strpos($imagepath, ",") + 1);
        $imagepath = base64_decode($imagepath);
        $path = ''.UPLOAD_PATH.'derma/' . $folder_name;
        $image_name = $pid . '_' . uniqid() . ".png";
        $file_path = $path . $image_name;
        file_put_contents($file_path, $imagepath, FILE_USE_INCLUDE_PATH);
        return $image_name;
    }

    public function derma_images($filename, $pid, $folder_name)
    {
        $files = $_FILES;
        $file_exist = $_FILES[$filename]['size'];
        if ($file_exist) {

            $this->load->library('upload');

            $config = array();
            $config['upload_path'] = './'.UPLOAD_PATH.'derma/' . $folder_name;
            $config['allowed_types'] = '*';
            $config['max_size']      = '*';
            $config['overwrite']     = TRUE;

            $_FILES[$filename]['name'] = $files[$filename]['name'];
            $_FILES[$filename]['type'] = $files[$filename]['type'];
            $_FILES[$filename]['tmp_name'] = $files[$filename]['tmp_name'];
            $_FILES[$filename]['error'] = $files[$filename]['error'];
            $_FILES[$filename]['size'] = $files[$filename]['size'];

            $ext = strtolower(pathinfo($_FILES[$filename]['name'], PATHINFO_EXTENSION));
            $newfilename = $pid . '-' . uniqid() . '.' . $ext;

            $config['file_name'] = $newfilename;

            $this->upload->initialize($config);

            if (!$this->upload->do_upload($filename)) {
            } else {
                return $newfilename;
            }
        }
    }

    public function validate_fees_derma($fees_derma)
    {
        foreach ($fees_derma as $fee) {
            // Add your validation logic here for each $fee element
            // For example, you can use is_numeric, greater_than, required, etc.
            if (!is_numeric($fee)) {
                $this->form_validation->set_message('validate_fees_derma', 'Invalid fee value.');
                return FALSE;
            }
        }

        return TRUE; // All elements in the array passed validation
    }

    public function insert_derma()
    {
        //return $this->output->set_content_type('application/json')->set_output(json_encode($_POST));

        $pid = decrypt_and_url_decode($this->input->post('patient_id'), $this);

        $insurance_current_id = $this->input->post('insurance_current_id');

        $nurse_name = $this->input->post('nurse_name');
        $doctor_name = $this->input->post('doctor_name');
        
        $nurse_id = $this->input->post('nurse_id');
        $doctor_id = $this->input->post('doctor_id');

        $remarks_derma = $this->input->post('remarks_derma');

        $area_derma = $this->input->post('area_derma');
        $sessions_derma = $this->input->post('sessions_derma');
        $measurement_derma = $this->input->post('measurement_derma');
        $pads_derma = $this->input->post('pads_derma');
        $duration_derma = $this->input->post('duration_derma');

        $area_main = $this->input->post('area_main');
        $cartridge_derma = $this->input->post('cartridge_derma');
        $energy_derma = $this->input->post('energy_derma');
        $length_derma = $this->input->post('length_derma');
        $spacing_derma = $this->input->post('spacing_derma');
        $count_derma = $this->input->post('count_derma');

        $skin_type_derma = $this->input->post('skin_type_derma');
        $indication_derma = $this->input->post('indication_derma');
        $program_derma = $this->input->post('program_derma');
        $intensity_derma = $this->input->post('intensity_derma');
        $total_pulse_derma = $this->input->post('total_pulse_derma');

        $indication_main_derma = $this->input->post('indication_main_derma');
        $skin_type_main_derma = $this->input->post('skin_type_main_derma');
        $specify_derma = $this->input->post('specify_derma');
        $skin_reaction_derma = $this->input->post('skin_reaction_derma');
        $wavelength_derma = $this->input->post('wavelength_derma');
        $spot_size_derma = $this->input->post('spot_size_derma');
        $fluence_derma = $this->input->post('fluence_derma');
        $pulse_derma = $this->input->post('pulse_derma');
        $rep_rate_derma = $this->input->post('rep_rate_derma');

        $filler_derma = $this->input->post('filler_derma');
        $quantity_derma = $this->input->post('quantity_derma');

        $botox_derma = $this->input->post('botox_derma');
        $ml_derma = $this->input->post('ml_derma');

        $hydrafacial_derma = $this->input->post('hydrafacial_derma');
        $mesotherapy_derma = $this->input->post('mesotherapy_derma');

        $applicator_derma = $this->input->post('applicator_derma');
        $ir_derma = $this->input->post('ir_derma');
        $rf_derma = $this->input->post('rf_derma');
        $vac_derma = $this->input->post('vac_derma');

        $date_derma = $this->input->post('date_derma');

        // $date1 = str_replace('/', '-', $date_derma);
        // $date_derma =  date('Y-m-d', strtotime($date1));

        $time_derma = $this->input->post('time_derma');
        $chief_complaint_derma = $this->input->post('chief_complaint_derma');
        $prog_note_derma = $this->input->post('prog_note_derma');
        $diagnosis_name = $this->input->post('derma_diagnosis_name');
        $diagnosis_id = $this->input->post('derma_diagnosis_id');
        $treatment_name = $this->input->post('derma_treatment_name');
        $treatment_id = $this->input->post('derma_treatment_id');
        $fees = $this->input->post('fees_derma');
         $derm_qty = $this->input->post('derm_qty');
        $drug_id = $this->input->post('drug_id_derma');
        $drug_name = $this->input->post('drug_name_derma');
        $drugs_qty = $this->input->post('drugs_qty_derma');
        $meals = $this->input->post('meals_derma');
        $drug_notes = $this->input->post('drug_notes_derma');

        $user_id = $this->session->userdata('user_Id');

        $check_cooltech = $this->input->post('check_cooltech');
        $check_etwo = $this->input->post('check_etwo');
        $check_hifu = $this->input->post('check_hifu');
        $check_elite = $this->input->post('check_elite');
        $check_acclaim = $this->input->post('check_acclaim');
        $check_apogee = $this->input->post('check_apogee');
        $check_filler = $this->input->post('check_filler');
        $check_botox = $this->input->post('check_botox');
        $check_hydrafacial = $this->input->post('check_hydrafacial');
        $check_velashape = $this->input->post('check_velashape');
        $check_prp = $this->input->post('check_prp');
        $check_mesotherapy = $this->input->post('check_mesotherapy');
        $check_threading = $this->input->post('check_threading');
        $check_injections = $this->input->post('check_injections');
        $check_plastic_surg = $this->input->post('check_plastic_surg');

        $area_cooltech = $this->input->post('area_cooltech');
        $sessions_cooltech = $this->input->post('sessions_cooltech');
        $measurement_cooltech = $this->input->post('measurement_cooltech');
        $pads_cooltech = $this->input->post('pads_cooltech');
        $duration_cooltech = $this->input->post('duration_cooltech');

        $sub_category = $this->input->post('sub_category');
        $skin_type_etwo = $this->input->post('skin_type_etwo');
        $indication_etwo = $this->input->post('indication_etwo');
        $program_etwo = $this->input->post('program_etwo');
        $area_etwo = $this->input->post('area_etwo');
        $intensity_etwo = $this->input->post('intensity_etwo');
        $total_pulse_etwo = $this->input->post('total_pulse_etwo');

        $area_hifu = $this->input->post('area_hifu');
        $cartridge_hifu = $this->input->post('cartridge_hifu');
        $energy_hifu = $this->input->post('energy_hifu');
        $length_hifu = $this->input->post('length_hifu');
        $spacing_hifu = $this->input->post('spacing_hifu');
        $count_hifu = $this->input->post('count_hifu');

        $indication_main_elite = $this->input->post('indication_main_elite');
        $skin_type_main_elite = $this->input->post('skin_type_main_elite');
        $specify_elite = $this->input->post('specify_elite');
        $skin_reaction_elite = $this->input->post('skin_reaction_elite');
        $area_elite = $this->input->post('area_elite');
        $wavelength_elite = $this->input->post('wavelength_elite');
        $spot_size_elite = $this->input->post('spot_size_elite');
        $fluence_elite = $this->input->post('fluence_elite');
        $pulse_elite = $this->input->post('pulse_elite');
        $rep_rate_elite = $this->input->post('rep_rate_elite');
        $count_elite = $this->input->post('count_elite');

        $indication_main_acclaim = $this->input->post('indication_main_acclaim');
        $skin_type_main_acclaim = $this->input->post('skin_type_main_acclaim');
        $specify_acclaim = $this->input->post('specify_acclaim');
        $skin_reaction_acclaim = $this->input->post('skin_reaction_acclaim');
        $area_acclaim = $this->input->post('area_acclaim');
        $wavelength_acclaim = $this->input->post('wavelength_acclaim');
        $spot_size_acclaim = $this->input->post('spot_size_acclaim');
        $fluence_acclaim = $this->input->post('fluence_acclaim');
        $pulse_acclaim = $this->input->post('pulse_acclaim');
        $rep_rate_acclaim = $this->input->post('rep_rate_acclaim');
        $count_acclaim = $this->input->post('count_acclaim');

        $indication_main_apogee = $this->input->post('indication_main_apogee');
        $skin_type_main_apogee = $this->input->post('skin_type_main_apogee');
        $specify_apogee = $this->input->post('specify_apogee');
        $skin_reaction_apogee = $this->input->post('skin_reaction_apogee');
        $area_apogee = $this->input->post('area_apogee');
        $wavelength_apogee = $this->input->post('wavelength_apogee');
        $spot_size_apogee = $this->input->post('spot_size_apogee');
        $fluence_apogee = $this->input->post('fluence_apogee');
        $pulse_apogee = $this->input->post('pulse_apogee');
        $rep_rate_apogee = $this->input->post('rep_rate_apogee');
        $count_apogee = $this->input->post('count_apogee');

        $area_filler = $this->input->post('area_filler');
        $filler_filler = $this->input->post('filler_filler');
        $quantity_filler = $this->input->post('quantity_filler');

        $botox_botox = $this->input->post('botox_botox');
        $specify_botox = $this->input->post('specify_botox');
        $ml_botox = $this->input->post('ml_botox');

        $hydrafacial_derma = $this->input->post('hydrafacial_derma');
        $mesotherapy_hydrafacial = $this->input->post('mesotherapy_hydrafacial');
        $mask_hydrafacial = $this->input->post('mask_hydrafacial');
        $prp_hydrafacial = $this->input->post('prp_hydrafacial');

        $area_velashape = $this->input->post('area_velashape');
        $measurement_velashape = $this->input->post('measurement_velashape');
        $applicator_velashape = $this->input->post('applicator_velashape');
        $ir_velashape = $this->input->post('ir_velashape');
        $rf_velashape = $this->input->post('rf_velashape');
        $vac_velashape = $this->input->post('vac_velashape');
        $duration_velashape = $this->input->post('duration_velashape');

        $area_prp = $this->input->post('area_prp');
        $prp_set = $this->input->post('prp_set');
        $tubes_prp = $this->input->post('tubes_prp');

        $area_mesotherapy = $this->input->post('area_mesotherapy');

        $area_threading = $this->input->post('area_threading');
        $thread = $this->input->post('thread');
        $size_threading = $this->input->post('size_threading');
        $quantity_threading = $this->input->post('quantity_threading');

        $area_injections = $this->input->post('area_injections');
        $injection = $this->input->post('injection');
        $quantity_injections = $this->input->post('quantity_injections');

        $pl_remark = $this->input->post('pl_remark');
        $pl_before = $this->input->post('pl_before');
        $pl_after = $this->input->post('pl_after');
        $imagepath = $this->input->post('imagepath');
        $botex_imagepath = $this->input->post('imagepathsx');

        $filler_imagepath = $this->input->post('imagepathsxf');
        // $doctor_discount = $this->input->post('doctor_discount');

        $laser_mechine = $this->input->post('laser_mechine');
        $laser_date = $this->input->post('laser_date');
        $laser_session = $this->input->post('laser_session');
        $face_neck = $this->input->post('face_neck');
        $lip_line = $this->input->post('lip_line');
        $beard_line = $this->input->post('beard_line');
        $chest = $this->input->post('chest');
        $abdomen_laser = $this->input->post('abdomen_laser');
        $un_arms = $this->input->post('un_arms');
        $lasert_thigts = $this->input->post('lasert_thigts');
        $laser_legs = $this->input->post('laser_legs');
        $buttocks = $this->input->post('buttocks');
        $lasert_ear = $this->input->post('lasert_ear');
        $lasert_nose = $this->input->post('lasert_nose');
        $lasert_chin = $this->input->post('lasert_chin');
        $lasert_nipples = $this->input->post('lasert_nipples');
        $lasert_hand = $this->input->post('lasert_hand');
        $lasert_bikini = $this->input->post('lasert_bikini');
        //$nurser_laser = $this->input->post('nurser_laser');

        $indication_main_elite = ($indication_main_elite) ? implode(",", $indication_main_elite) : '';
        $skin_type_main_elite = ($skin_type_main_elite) ? implode(",", $skin_type_main_elite) : '';
        $skin_reaction_elite = ($skin_reaction_elite) ? implode(",", $skin_reaction_elite) : '';

        $indication_main_acclaim = ($indication_main_acclaim) ? implode(",", $indication_main_acclaim) : '';
        $skin_type_main_acclaim = ($skin_type_main_acclaim) ? implode(",", $skin_type_main_acclaim) : '';
        $skin_reaction_acclaim = ($skin_reaction_acclaim) ? implode(",", $skin_reaction_acclaim) : '';

        $indication_main_apogee = ($indication_main_apogee) ? implode(",", $indication_main_apogee) : '';
        $skin_type_main_apogee = ($skin_type_main_apogee) ? implode(",", $skin_type_main_apogee) : '';
        $skin_reaction_apogee = ($skin_reaction_apogee) ? implode(",", $skin_reaction_apogee) : '';
        $botox_botox = ($botox_botox) ? implode(",", $botox_botox) : '';
        $hydrafacial_derma = ($hydrafacial_derma) ? implode(",", $hydrafacial_derma) : '';

        $discount = $this->input->post('discount');
        $discount_per = $this->input->post('discount_per');
        $orig_price = $this->input->post('orig_price');
        $follow_up = $this->input->post('followup');
        $assigned_package = $this->input->post('assigned_package');

        date_default_timezone_set('Asia/Kuwait');
        $date_string = '%Y-%m-%d';
        $curr_date = mdate($date_string);
        $curr_time = date("H:i");

        $this->db->trans_begin();
        try {

            if (true) { //$this->session->userdata('permission') == 2
                // $get_doctor_id = $this->doctor_retrive->get_row_data('doctors', 'employee_id', $this->session->userdata('emp_id'));
                // $doctor_id = $get_doctor_id->doctor_id;
                $user_id = $this->session->userdata('user_Id');
                $nurse = $this->DermatologyModel->retrieve_data_unique_row('tbl_users', 'user_Id', $nurse_id);

                if (!empty($fees)) {
                    $total = '';
                    while (list($key, $val) = each($fees)) {

                        $total += $val;
                    }
                } else {

                    $data['alert_msg'] = '';

                    $error = '';
                    $this->session->set_flashdata('error', 'Treatments fee required.');
                    redirect('admin/Patients/PatientsController/medical_book/'.encrypt_and_url_encode($pid, $this));
                }

               if (is_array($orig_price) && is_array($derm_qty)) {
                    $total = 0; // Initialize total as numeric
                    foreach ($orig_price as $key => $price) {
                        // Ensure the quantity exists and is numeric
                        $quantity = isset($derm_qty[$key]) ? (int)$derm_qty[$key] : 0;
                        $total += $price * $quantity; // Multiply price and quantity
                    }
                }

                if (is_array($discount)) {
                    $doctor_discount = 0; // Initialize as numeric
                    foreach ($discount as $key => $val) {
                        $quantity = isset($derm_qty[$key]) ? (int)$derm_qty[$key] : 0;
                        $doctor_discount += $val * $quantity;  // Sum up the values
                    }
                }
                //$check_fileid = $this->doctor_retrive->get_row_data('patient_file', 'patient_id', $pid);
                $check_fileid = $this->PatientsModel->retrieve_data_unique_row('tbl_patient_file', 'patient_id', $pid);

                if ($check_fileid == FALSE) {
                    $newdata = array(
                        'create_date' => $curr_date,
                        'patient_id'  => $pid,
                    );

                    //$file_id = $this->doctor_insert->get_id_insert('patient_file', $newdata);
                    $file_id = $this->PatientsModel->insert_data('tbl_patient_file', $newdata);
                } else {
                    $file_id = $check_fileid->file_id;
                }

                // $this->form_validation->set_rules('fees_derma', 'Fee', 'required');
                $this->form_validation->set_rules('fees_derma[]', 'Fee', 'callback_validate_fees_derma');

                if ($this->form_validation->run() == FALSE) {
                    $data['alert_msg'] = '';
                    $data['treat_pay'] = FALSE;

                    $errors = $this->form_validation->error_array();
                    //echo $total;exit;
                    //print_r($errors);
                    //return $this->medical_book(encrypt_and_url_encode($pid, $this), $data);

                } else {

                    // $get_last_treatment = $this->doctor_retrive->get_last_treatment($pid);
                    // $treatment_payment_id = $get_last_treatment[0]['treatment_payment_id'];

                

                    $treatmentLogData = array(
                        'treatment_date' => $date_derma,
                        'treatment_time' => $time_derma,
                        'doctor_id' => $doctor_id,
                        'file_id' => $file_id,
                        'patient_identifier' => "FN" . $pid,
                        'insurance_type' => $insurance_current_id
                    );
                    //$log_id = $this->doctor_insert->get_id_insert('treatment_log', $treatmentLogData);
                    $log_id = $this->PatientsModel->insert_data('tbl_treatment_log', $treatmentLogData);
                    if($follow_up == 0){
                        $treatment_payment_id = $this->PatientsModel->getLastTreatment($pid)->treatement_payment_id;
                   
                    $treatmentPayment = array(
                        'patient_id'  => $pid,
                        'user_id' => $user_id,
                        'treat_date' => $date_derma,
                        'treat_time' => date('H:i:s'),
                        'total' => $total,
                        'log_id'  => $log_id,
                        'department_id'  => 2,
                        'discount' => $doctor_discount,
                        'created_by' => $user_id,
                        'insurance_type' => $this->PatientsModel->retrieve_data_unique_row('tbl_patients', 'patient_id', $pid)->insurance_type
                    );
              

                    // $treatement_payment_id = $this->doctor_insert->get_id_insert('treatment_payment', $treatmentPayment);
                    // $treatment_payment_id = $treatement_payment_id;
                  
                }else{
                    $treatment_payment_id = $this->PatientsModel->getLastTreatment($pid)->treatement_payment_id;
                   
                    $treatmentPayment = array(
                        'patient_id'  => $pid,
                        'user_id' => $user_id,
                        'treat_date' => $date_derma,
                        'treat_time' => date('H:i:s'),
                        'total' => 0,
                        'log_id'  => $log_id,
                        'department_id'  => 2,
                        'discount' => 0,
                        'created_by' => $user_id,
                        'insurance_type' => $this->PatientsModel->retrieve_data_unique_row('tbl_patients', 'patient_id', $pid)->insurance_type
                    );
              
                }


                $treatment_payment_id = $this->PatientsModel->insert_data('tbl_treatment_payment', $treatmentPayment);
                    $arrayData = array(
                        'treatment_payment_id' => $treatment_payment_id ?? 0,
                        'nurse_id' => $nurse_id,
                        'doctor_id' => $doctor_id,
                        'remarks' => $remarks_derma,
                        'chief_complaint' => $chief_complaint_derma,
                        'prog_note' => $prog_note_derma,
                        'fees' => $total,
                        'patient_id' => $pid,
                        'log_id'  => $log_id,
                    );

                    //$derma_id = $this->doctor_insert->get_id_insert('treat_derma', $arrayData);
                    $derma_id = $this->PatientsModel->insert_data('tbl_treat_derma', $arrayData);

                    for ($i = 0; $i < count($diagnosis_name); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'diagnosis_id' => $diagnosis_id[$i],
                            'diagnosis_name' => $diagnosis_name[$i],
                            'treatment_id' => $treatment_id[$i],
                            'treatment_name' => $treatment_name[$i],
                           'fee' => (int)$fees[$i] * (int)$derm_qty[$i],
                            'orig_price' => (int)$orig_price[$i] * (int)$derm_qty[$i],
                            'quantity' => $derm_qty[$i],
                             'discount_qr' => (int)$discount[$i] * (int)$derm_qty[$i],
                            'discount_per' => $discount_per[$i],
                        );


                        $this->PatientsModel->insert_data('tbl_treat_derma_subs', $arrayData);
                    }

                    for ($i = 0; $i < count($treatment_id); $i++) {

                        $newdata = array(
                            // 'episode_id' => $episode_id,
                            'procedure_id' => $treatment_id[$i],
                            'episode_type' => 1,
                            'diagnostise_id' => $diagnosis_id[$i],
                            'aditional_diagnostise_name' => $diagnosis_name[$i],
                            'fees' => $fees[$i] * (int)$derm_qty[$i],
                           'orig_price' => $orig_price[$i] * (int)$derm_qty[$i],
                            'quantity' => $derm_qty[$i],
                             'discount_qr' => (int)$discount[$i] * (int)$derm_qty[$i],
                            'discount_per' => $discount_per[$i],
                            'treatement_payment_id'  => $treatment_payment_id ?? 0
                        );

                        $this->PatientsModel->insert_data('tbl_episode_payment', $newdata);
                    }

                    if ($check_cooltech == 1) {
                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'machine_id' => 1,
                        );

                        $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                        for ($i = 0; $i < count($area_cooltech); $i++) {

                            $arrayData = array(
                                'derma_id' => $derma_id,
                                'area' => $area_cooltech[$i],
                                'sessions' => $sessions_cooltech[$i],
                                'measurement' => $measurement_cooltech[$i],
                                'pads' => $pads_cooltech[$i],
                                'duration' => $duration_cooltech[$i],
                                'treat_derma_machine_id' => $derma_machine_id
                            );

                            $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                        }
                    }
                }

                if ($check_etwo == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 2,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($skin_type_etwo); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'sub_category' => $sub_category,
                            'skin_type' => $skin_type_etwo[$i],
                            'indication' => $indication_etwo[$i],
                            'program' => $program_etwo[$i],
                            'area' => $area_etwo[$i],
                            'intensity' => $intensity_etwo[$i],
                            'total_pulse' => $total_pulse_etwo[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );
                        if ($area_etwo[$i]) {
                            $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                        }
                    }
                }
                if ($check_hifu == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 3,
                        'area_main' => $area_hifu,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($cartridge_hifu); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'cartridge' => $cartridge_hifu[$i],
                            'energy' => $energy_hifu[$i],
                            'length' => $length_hifu[$i],
                            'spacing' => $spacing_hifu[$i],
                            'count' => $count_hifu[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                    }
                }

                if ($check_elite == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 4,
                        'indication_main' => $indication_main_elite,
                        'skin_type_main' => $skin_type_main_elite,
                        'specify_derma' => $specify_elite,
                        'skin_reaction' => $skin_reaction_elite,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($wavelength_elite); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_elite[$i],
                            'wavelength' => $wavelength_elite[$i],
                            'spot_size' => $spot_size_elite[$i],
                            'fluence' => $fluence_elite[$i],
                            'pulse' => $pulse_elite[$i],
                            'rep_rate' => $rep_rate_elite[$i],
                            'count' => $count_elite[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                    }
                }

                if ($check_acclaim == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 13,
                        'indication_main' => $indication_main_acclaim,
                        'skin_type_main' => $skin_type_main_acclaim,
                        'specify_derma' => $specify_acclaim,
                        'skin_reaction' => $skin_reaction_acclaim,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($wavelength_acclaim); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_acclaim[$i],
                            'wavelength' => $wavelength_acclaim[$i],
                            'spot_size' => $spot_size_acclaim[$i],
                            'fluence' => $fluence_acclaim[$i],
                            'pulse' => $pulse_acclaim[$i],
                            'rep_rate' => $rep_rate_acclaim[$i],
                            'count' => $count_acclaim[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                    }
                }

                if ($check_apogee == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 14,
                        'indication_main' => $indication_main_apogee,
                        'skin_type_main' => $skin_type_main_apogee,
                        'specify_derma' => $specify_apogee,
                        'skin_reaction' => $skin_reaction_apogee,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($wavelength_apogee); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_apogee[$i],
                            'wavelength' => $wavelength_apogee[$i],
                            'spot_size' => $spot_size_apogee[$i],
                            'fluence' => $fluence_apogee[$i],
                            'pulse' => $pulse_apogee[$i],
                            'rep_rate' => $rep_rate_apogee[$i],
                            'count' => $count_apogee[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                    }
                }

                if ($check_filler == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 5,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($area_filler); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_filler[$i],
                            'filler' => $filler_filler[$i],
                            'quantity' => $quantity_filler[$i],
                            'filler_mark' => $this->canvan_images($filler_imagepath, $pid, 'filler/'),
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                    }
                }

                if ($check_botox == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 6,
                        'botox' => $botox_botox,
                        'specify_derma' => $specify_botox,
                        'botox_mark' => $this->canvan_images($botex_imagepath, $pid, 'botox/'),
                        'ml' => $ml_botox
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);
                }

                if ($check_hydrafacial == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 7,
                        'hydrafacial' => $hydrafacial_derma,
                        'mesotherapy' => $mesotherapy_hydrafacial,
                        'mask' => $mask_hydrafacial,
                        'prp' => $prp_hydrafacial,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);
                }

                if ($check_velashape == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 8,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($area_velashape); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_velashape[$i],
                            'measurement' => $measurement_velashape[$i],
                            'applicator' => $applicator_velashape[$i],
                            'ir' => $ir_velashape[$i],
                            'rf' => $rf_velashape[$i],
                            'vac' => $vac_velashape[$i],
                            'duration' => $duration_velashape[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                    }
                }

                if ($check_prp == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 9,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0, $ctr = 1; $i < count($area_prp); $i++, $ctr++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_prp[$i],
                            'prp_set' => $prp_set[$i],
                            'tubes' => $tubes_prp[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);

                        $name = $this->input->post('vitamin_name-' . $ctr);
                        $ml = $this->input->post('vitamin_ml-' . $ctr);

                        for ($x = 0; $x < count($name); $x++) {

                            $arrayData = array(
                                'derma_sub_id' => $derma_sub_id,
                                'name' => $name[$x],
                                'ml' => $ml[$x]
                            );

                            $this->PatientsModel->insert_data('tbl_treat_derma_vitamins', $arrayData);
                        }
                    }
                }

                if ($check_mesotherapy == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 10,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0, $ctr = 1; $i < count($area_mesotherapy); $i++, $ctr++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_mesotherapy[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);

                        $name = $this->input->post('vitamin_name_mesotherapy-' . $ctr);
                        $ml = $this->input->post('vitamin_ml_mesotherapy-' . $ctr);

                        for ($x = 0; $x < count($name); $x++) {

                            $arrayData = array(
                                'derma_sub_id' => $derma_sub_id,
                                'name' => $name[$x],
                                'ml' => $ml[$x]
                            );

                            $this->PatientsModel->insert_data('tbl_treat_derma_vitamins', $arrayData);
                        }
                    }
                }


                if ($check_threading == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 11,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($area_threading); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_threading[$i],
                            'thread' => $thread[$i],
                            'size' => $size_threading[$i],
                            'quantity' => $quantity_threading[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                    }
                }

                if ($check_injections == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 12,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($area_injections); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_injections[$i],
                            'injection' => $injection[$i],
                            'quantity' => $quantity_injections[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                    }
                }

                if ($check_plastic_surg == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 15,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    //for ($i=0; $i <count($pl_remark) ; $i++) {

                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'pl_remark' => $pl_remark,
                        'mark_iname' => $this->canvan_images($imagepath, $pid, 'marks/'),
                        'after_iname' => $this->derma_images('pl_after', $pid, 'after/'),
                        'before_iname' => $this->derma_images('pl_before', $pid, 'before/'),
                        'treat_derma_machine_id' => $derma_machine_id
                    );

                    $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);

                    //}
                }

                if ($this->input->post('check_laser') == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 16,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    //for ($i=0; $i <count($pl_remark) ; $i++) {


                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'treat_derma_machine_id' => $derma_machine_id,
                        'sessions' => $laser_session,
                        'laser_mechine' => $laser_mechine,
                        'laser_date' => $laser_date,
                        'face_neck' => $face_neck,
                        'lip_line' => $lip_line,
                        'beard_line' => $beard_line,
                        'chest' => $chest,
                        'abdomen_laser' => $abdomen_laser,
                        'un_arms' => $un_arms,
                        'lasert_thigts' => $lasert_thigts,
                        'laser_legs' => $laser_legs,
                        'buttocks' => $buttocks,
                        'lasert_bikini' => $lasert_bikini,
                        'lasert_ear' => $lasert_ear,
                        'lasert_nose' => $lasert_nose,
                        'lasert_chin' => $lasert_chin,
                        'lasert_nipples' => $lasert_nipples,
                        'lasert_hand' => $lasert_hand,
                        //'nurser_laser' => $nurser_lase
                    );

                    // print_r($arrayData);die();

                    $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);

                    //}
                }

                if ($this->input->post('check_secret') == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 17,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    $secret_treat = ($this->input->post('secret_treat')) ? implode(",", $this->input->post('secret_treat')) : '';

                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'treat_derma_machine_id' => $derma_machine_id,
                        'area' => $secret_treat,
                        'short_note_id' => '1',
                        'short_note' => $this->input->post('prog_secret_rf')
                    );

                    $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                }

                if ($this->input->post('check_dermapen') == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 18,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    $derma_pen = ($this->input->post('derma_pen')) ? implode(",", $this->input->post('derma_pen')) : '';
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'treat_derma_machine_id' => $derma_machine_id,
                        'area' => $derma_pen,
                        'short_note_id' => '2',
                        'short_note' => $this->input->post('prog_derma_pen')
                    );

                    $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                }

                if ($this->input->post('check_tattoo') == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 19,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    $tattoo_treat = ($this->input->post('tattoo_treat')) ? implode(",", $this->input->post('tattoo_treat')) : '';
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'treat_derma_machine_id' => $derma_machine_id,
                        'area' => $tattoo_treat,
                        'short_note_id' => '3',
                        'short_note' => $this->input->post('prog_tattoo')
                    );

                    $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                }

                if ($this->input->post('check_carbon') == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 20,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    $carbon_treat = ($this->input->post('carbon_treat')) ? implode(",", $this->input->post('carbon_treat')) : '';
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'treat_derma_machine_id' => $derma_machine_id,
                        'area' => $carbon_treat,
                        'short_note_id' => '4',
                        'short_note' => $this->input->post('prog_carbon')
                    );

                    $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                }

                if ($this->input->post('check_bleaching') == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 21,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    $bleaching_treat = ($this->input->post('bleaching_treat')) ? implode(",", $this->input->post('bleaching_treat')) : '';
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'treat_derma_machine_id' => $derma_machine_id,
                        'area' => $bleaching_treat,
                        'short_note_id' => '5',
                        'short_note' => $this->input->post('prog_bleaching')
                    );

                    $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                }

                if ($this->input->post('check_peeling') == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 22,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    $secret_treat = ($this->input->post('secret_treat')) ? implode(",", $this->input->post('secret_treat')) : '';
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'treat_derma_machine_id' => $derma_machine_id,
                        'area' => $secret_treat,
                        'short_note_id' => '6',
                        'short_note' => $this->input->post('prog_secret_rf')
                    );

                    $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                }

                if ($drug_id) {
                    $newdata = array(
                        'enter_date' => $curr_date,
                        'patient_id' => $pid,
                        'doctor_id'  => $doctor_id

                    );

                    $prescription_main_id = $this->PatientsModel->insert_data('tbl_prescription_main', $newdata);

                    if (is_array($drug_id)) {
                        for ($i = 0; $i < count($drug_id); $i++) {
                            $newdata = array(
                                'prescription_main_id' => $prescription_main_id,
                                'drug_id' => $drug_id[$i],
                                'log_id' => $log_id,
                                'drug_qty' => $drugs_qty[$i],
                                'drug_note' => $drug_notes[$i],
                                'after_before' => $meals[$i]

                            );

                            $this->PatientsModel->insert_data('tbl_prescription', $newdata);
                        }
                    }
                }

                $files = $_FILES;
                $file_exist = $_FILES['attach_derma']['size'];
                $db_attachment = array();
                if (array_filter($file_exist)) {

                    $this->load->library('upload');

                    $cpt = count($_FILES['attach_derma']['name']);
                    $config = array();
                    $config['upload_path'] = './'.UPLOAD_PATH.'derma/';
                    $config['allowed_types'] = '*';
                    $config['max_size']      = '*';
                    $config['overwrite']     = TRUE;

                    $last_id = $this->DermatologyModel->get_last_attachment($pid, '5');
                    if (isset($last_id) and $last_id != NULL) {
                        $ctr_array = explode("-", $last_id->attachment);
                        $j = $ctr_array[1] + 1;
                    } else {
                        $j = 1;
                    }


                    for ($i = 0; $i < $cpt; $i++) {
                        $_FILES['attach_derma']['name'] = $files['attach_derma']['name'][$i];
                        $_FILES['attach_derma']['type'] = $files['attach_derma']['type'][$i];
                        $_FILES['attach_derma']['tmp_name'] = $files['attach_derma']['tmp_name'][$i];
                        $_FILES['attach_derma']['error'] = $files['attach_derma']['error'][$i];
                        $_FILES['attach_derma']['size'] = $files['attach_derma']['size'][$i];

                        $ext = strtolower(pathinfo($_FILES['attach_derma']['name'], PATHINFO_EXTENSION));
                        $newfilename = $pid . '-' . $j . '.' . $ext;

                        $config['file_name'] = $newfilename;

                        $this->upload->initialize($config);

                        if (!$this->upload->do_upload('attach_derma')) {

                            echo $this->upload->display_errors();
                        } else {
                            array_push($db_attachment, $newfilename);
                        }
                        $j++;
                    }

                    if (!empty($db_attachment)) {
                        $count_attachment = count($db_attachment);

                        for ($i = 0; $i < $count_attachment; $i++) {
                            $newdata = array(
                                'document' => $db_attachment[$i],
                                'user_id' => $user_id,
                                'category' => 5,
                                'patient_id' => $pid,
                                'treat_id' => $derma_id
                            );

                            $this->PatientsModel->insert_data('tbl_patient_attachments', $newdata);
                        }
                    }
                }

                if($follow_up == 2){
                    $this->PatientsModel->updateSessions($pid,$assigned_package,2);
                     
                     
                  }

                $data['alert_msg'] = '';
                $data['error'] = '';
                $data['success'] = 'The treatment information have added successfully!';

                //$this->patient_files($pid);
                $this->session->set_flashdata('success', 'Treatment saved successfully.');
                $this->db->trans_status() === FALSE ? $this->db->trans_rollback() : $this->db->trans_commit();
                redirect(base_url('index.php/admin/Patients/PatientsController/medical_book/' . encrypt_and_url_encode($pid, $this)));
            } else {


                $data['alert_msg'] = '';
                $data['success'] = '';

                $this->session->set_flashdata('error', 'You can not add or save treatments because you do not have any permission only doctor accounts');
                $this->db->trans_status() === FALSE ? $this->db->trans_rollback() : $this->db->trans_commit();
                redirect(base_url('index.php/admin/Patients/PatientsController/medical_book/' . encrypt_and_url_encode($pid, $this)));
            }
        } catch (Exception $e) {
            $this->db->trans_rollback();
            echo $e;
            exit;
        }
    }

    public function get_drugs()
    {

        $type = $this->input->get('type');
        $nameStartsWith = $this->input->get('name_startsWith');

        $data = $this->PatientsModel->get_drugs($type, $nameStartsWith);

        echo json_encode($data);
    }

    public function edit($treatment_id)
    {
        $treatment_id = decrypt_and_url_decode($treatment_id, $this);
       
        $treatment =  $this->DermatologyModel->getTreatment($treatment_id);

        $log_id = $treatment->log_id;
        $id = $treatment->patient_id;

        $data['profile'] = $this->DermatologyModel->get_profile_main($id);
        $data['treatment_list'] = $this->DermatologyModel->get_pedia_list('tbl_treat_derma', 'treatment_payment_id', $treatment->treatement_payment_id);
       
        //$data['doctor_list'] = $this->DermatologyModel->employee_doctor();

        $data['doctors'] = $this->PatientsModel->getDoctors();
        $data['nurses'] =  $this->PatientsModel->getNurses();

        $data['log_id'] = $log_id;
        $data['pri_id'] = $data['treatment_list'][0]['derma_id'];

        $data['clinic_info'] = $this->DermatologyModel->retrieve_data_unique_row('tbl_company');

        $data['attachment'] = $this->DermatologyModel->get_attachment($id, 5, $data['pri_id']);

        $data['follow_up'] = $this->DermatologyModel->follow_up_derma($log_id);

        $data['prescription_id'] = $this->DermatologyModel->retrieve_data_unique_row('tbl_prescription', 'log_id', $log_id)->prescription_main_id;

        $data['treatment_id'] = $treatment_id;
        $this->load->view('admin/Modules/Dermatology/dermatologyEdit', $data);
    }

    public function load_private_procedure_list()
    {

        $private_category_id = $this->input->post('loadId');
        $insurance_id = $this->input->post('insurance_id');

        $result = $this->DermatologyModel->get_insurance_prices($insurance_id, $private_category_id);
        if ($result != FALSE) {
            $HTML = "<option value='-1'>Please Select Procedure</option>";

            foreach ($result as $row) {
                $HTML .= "<option value='" . $row['treatment_id'] . " | " . $row['treatment_name'] . " | " . $row['lqdc_gross'] . "'>" . $row['treatment_id'] . " | " . $row['treatment_name'] . " | " . $row['lqdc_gross'] . "</option>";
            }
            echo $HTML;
        } else {
            echo 'No Data';
        }
    }

    public function get_derma_diagnosis_multi()
    {

        $searchTerm = $this->input->get('name_startsWith') ? strtoupper($this->input->get('name_startsWith')) : strtoupper($this->input->get('term'));

        $data = $this->DermatologyModel->getDiagnoses($searchTerm);

        $result = array();
        foreach ($data as $row) {
            array_push($result, $row['diagnostise_id'] . ' - ' . $row['name']);
        }

        echo json_encode($result);
    }

    public function delete_attachment_derma($derma_type = null)
    {
        $id = $this->input->post('id');

        $file = $this->DermatologyModel->retrieve_data_unique_row('tbl_patient_attachments', 'id', $id);
        $delete_file = $file->document;
        $pri_id = $file->treat_id;
        $patient_id = explode("-", $file->document);


        // unlink("'.UPLOAD_PATH.'derma/{$derma_type}/" . $delete_file);
        $file_path = "'.UPLOAD_PATH.'derma/" . $delete_file;
        try {
            if (is_file($file_path)) {
                unlink($file_path);
            }
        } catch (Exception $e) {
            
        }

        $this->DermatologyModel->delete_data_where('tbl_patient_attachments', 'id', $id);

        $attach = $this->DermatologyModel->retrieve_data_unique_row('tbl_patient_attachments', 'treat_id', $pri_id);
        $html = '';


        if (isset($attach) and $attach != NULL) {
            foreach ($attach as $row) {
                $html .=  $row['document'];
                $html .=  " <a href='" . base_urL() .UPLOAD_PATH."derma/" . $row['document'] . "' id='single_1' title='View'>View</a>";
                $html .=  " <a href='" . base_urL() .UPLOAD_PATH."derma/" . $row['document'] . "' title='Download' download>Download</a>";
                $html .=  " <a href='javascript:void(0);' title='Delete' onclick='deleteAtt(" . $row['id'] . ");'>Delete</a><br>";
            }
        }

        echo $html;
    }

    public function update_derma()
    {

        $data['title'] = 'Patient Profile::: Hospital Managemnt Software';
        $data['page_header'] = 'Dermatology';

        $pid = $this->input->post('patient_id');
        $derma_id = $this->input->post('derma_id');
        $treatment_payment_id = $this->input->post('treatment_payment_id');
        $log_id = $this->input->post('log_id');
        $prescription_main_id = $this->input->post('prescription_id');

        $data['profile'] = $this->DermatologyModel->get_profile_main($pid);
        $data['treatment_list'] = $this->DermatologyModel->get_pedia_list('tbl_treat_derma', 'derma_id', $derma_id);
        $data['doctor_list'] = $this->DermatologyModel->employee_doctor();

        $data['log_id'] = $treatment_payment_id;
        $data['pri_id'] = $derma_id;
        
        $nurse_id = $this->input->post('nurse_id');
        $doctor_id = $this->input->post('doctor_id');

        $nurse_name = $this->input->post('nurse_name');
        $doctor_name = $this->input->post('doctor_name');
        $remarks_derma = $this->input->post('remarks_derma');

        $area_derma = $this->input->post('area_derma');
        $sessions_derma = $this->input->post('sessions_derma');
        $measurement_derma = $this->input->post('measurement_derma');
        $pads_derma = $this->input->post('pads_derma');
        $duration_derma = $this->input->post('duration_derma');

        $area_main = $this->input->post('area_main');
        $cartridge_derma = $this->input->post('cartridge_derma');
        $energy_derma = $this->input->post('energy_derma');
        $length_derma = $this->input->post('length_derma');
        $spacing_derma = $this->input->post('spacing_derma');
        $count_derma = $this->input->post('count_derma');

        $skin_type_derma = $this->input->post('skin_type_derma');
        $indication_derma = $this->input->post('indication_derma');
        $program_derma = $this->input->post('program_derma');
        $intensity_derma = $this->input->post('intensity_derma');
        $total_pulse_derma = $this->input->post('total_pulse_derma');

        $indication_main_derma = $this->input->post('indication_main_derma');
        $skin_type_main_derma = $this->input->post('skin_type_main_derma');
        $specify_derma = $this->input->post('specify_derma');
        $skin_reaction_derma = $this->input->post('skin_reaction_derma');
        $wavelength_derma = $this->input->post('wavelength_derma');
        $spot_size_derma = $this->input->post('spot_size_derma');
        $fluence_derma = $this->input->post('fluence_derma');
        $pulse_derma = $this->input->post('pulse_derma');
        $rep_rate_derma = $this->input->post('rep_rate_derma');

        $filler_derma = $this->input->post('filler_derma');
        $quantity_derma = $this->input->post('quantity_derma');

        $botox_derma = $this->input->post('botox_derma');
        $ml_derma = $this->input->post('ml_derma');
        $derm_qty = $this->input->post('derm_qty');
        $hydrafacial_derma = $this->input->post('hydrafacial_derma');
        $mesotherapy_derma = $this->input->post('mesotherapy_derma');

        $applicator_derma = $this->input->post('applicator_derma');
        $ir_derma = $this->input->post('ir_derma');
        $rf_derma = $this->input->post('rf_derma');
        $vac_derma = $this->input->post('vac_derma');

        $chief_complaint_derma = $this->input->post('chief_complaint_derma');
        $prog_note_derma = $this->input->post('prog_note_derma');
        $diagnosis_name = $this->input->post('derma_diagnosis_name');
        $diagnosis_id = $this->input->post('derma_diagnosis_id');
        $treatment_name = $this->input->post('derma_treatment_name');
        $treatment_id = $this->input->post('derma_treatment_id');

        $fees = $this->input->post('fees_derma');

        $drug_id = $this->input->post('drug_id_derma');
        $drug_name = $this->input->post('drug_name_derma');
        $drugs_qty = $this->input->post('drugs_qty_derma');
        $meals = $this->input->post('meals_derma');
        $drug_notes = $this->input->post('drug_notes_derma');

        $user_id = $this->session->userdata('user_id');

        $check_cooltech = $this->input->post('check_cooltech');
        $check_etwo = $this->input->post('check_etwo');
        $check_hifu = $this->input->post('check_hifu');
        $check_elite = $this->input->post('check_elite');
        $check_acclaim = $this->input->post('check_acclaim');
        $check_apogee = $this->input->post('check_apogee');
        $check_filler = $this->input->post('check_filler');
        $check_botox = $this->input->post('check_botox');
        $check_hydrafacial = $this->input->post('check_hydrafacial');
        $check_velashape = $this->input->post('check_velashape');
        $check_prp = $this->input->post('check_prp');
        $check_mesotherapy = $this->input->post('check_mesotherapy');
        $check_threading = $this->input->post('check_threading');
        $check_injections = $this->input->post('check_injections');
        $check_plastic_surg = $this->input->post('check_plastic_surg');
        $check_laser = $this->input->post('check_laser');

        $area_cooltech = $this->input->post('area_cooltech');
        $sessions_cooltech = $this->input->post('sessions_cooltech');
        $measurement_cooltech = $this->input->post('measurement_cooltech');
        $pads_cooltech = $this->input->post('pads_cooltech');
        $duration_cooltech = $this->input->post('duration_cooltech');

        $sub_category = $this->input->post('sub_category');
        $skin_type_etwo = $this->input->post('skin_type_etwo');
        $indication_etwo = $this->input->post('indication_etwo');
        $program_etwo = $this->input->post('program_etwo');
        $area_etwo = $this->input->post('area_etwo');
        $intensity_etwo = $this->input->post('intensity_etwo');
        $total_pulse_etwo = $this->input->post('total_pulse_etwo');

        $area_hifu = $this->input->post('area_hifu');
        $cartridge_hifu = $this->input->post('cartridge_hifu');
        $energy_hifu = $this->input->post('energy_hifu');
        $length_hifu = $this->input->post('length_hifu');
        $spacing_hifu = $this->input->post('spacing_hifu');
        $count_hifu = $this->input->post('count_hifu');

        $indication_main_elite = $this->input->post('indication_main_elite');
        $skin_type_main_elite = $this->input->post('skin_type_main_elite');
        $specify_elite = $this->input->post('specify_elite');
        $skin_reaction_elite = $this->input->post('skin_reaction_elite');
        $area_elite = $this->input->post('area_elite');
        $wavelength_elite = $this->input->post('wavelength_elite');
        $spot_size_elite = $this->input->post('spot_size_elite');
        $fluence_elite = $this->input->post('fluence_elite');
        $pulse_elite = $this->input->post('pulse_elite');
        $rep_rate_elite = $this->input->post('rep_rate_elite');
        $count_elite = $this->input->post('count_elite');

        $indication_main_acclaim = $this->input->post('indication_main_acclaim');
        $skin_type_main_acclaim = $this->input->post('skin_type_main_acclaim');
        $specify_acclaim = $this->input->post('specify_acclaim');
        $skin_reaction_acclaim = $this->input->post('skin_reaction_acclaim');
        $area_acclaim = $this->input->post('area_acclaim');
        $wavelength_acclaim = $this->input->post('wavelength_acclaim');
        $spot_size_acclaim = $this->input->post('spot_size_acclaim');
        $fluence_acclaim = $this->input->post('fluence_acclaim');
        $pulse_acclaim = $this->input->post('pulse_acclaim');
        $rep_rate_acclaim = $this->input->post('rep_rate_acclaim');
        $count_acclaim = $this->input->post('count_acclaim');

        $indication_main_apogee = $this->input->post('indication_main_apogee');
        $skin_type_main_apogee = $this->input->post('skin_type_main_apogee');
        $specify_apogee = $this->input->post('specify_apogee');
        $skin_reaction_apogee = $this->input->post('skin_reaction_apogee');
        $area_apogee = $this->input->post('area_apogee');
        $wavelength_apogee = $this->input->post('wavelength_apogee');
        $spot_size_apogee = $this->input->post('spot_size_apogee');
        $fluence_apogee = $this->input->post('fluence_apogee');
        $pulse_apogee = $this->input->post('pulse_apogee');
        $rep_rate_apogee = $this->input->post('rep_rate_apogee');
        $count_apogee = $this->input->post('count_apogee');

        $area_filler = $this->input->post('area_filler');
        $filler_filler = $this->input->post('filler_filler');
        $quantity_filler = $this->input->post('quantity_filler');
        $filler_imagepath = $this->input->post('imagepathsxf');

        $laser_mechine = $this->input->post('laser_mechine');
        $laser_date = $this->input->post('laser_date');
        $laser_session = $this->input->post('laser_session');
        $face_neck = $this->input->post('face_neck');
        $lip_line = $this->input->post('lip_line');
        $beard_line = $this->input->post('beard_line');
        $chest = $this->input->post('chest');
        $abdomen_laser = $this->input->post('abdomen_laser');
        $un_arms = $this->input->post('un_arms');
        $lasert_thigts = $this->input->post('lasert_thigts');
        $laser_legs = $this->input->post('laser_legs');
        $buttocks = $this->input->post('buttocks');
        $lasert_ear = $this->input->post('lasert_ear');
        $lasert_nose = $this->input->post('lasert_nose');
        $lasert_chin = $this->input->post('lasert_chin');
        $lasert_nipples = $this->input->post('lasert_nipples');
        $lasert_hand = $this->input->post('lasert_hand');
        $lasert_bikini = $this->input->post('lasert_bikini');

        $check_old_fimage = 0;
        $filler_imagepath_old = "";
        if (!empty($filler_imagepath)) {
            $filler_imagepath = $this->input->post('imagepathsxf');
        } else {
            $check_old_fimage = 1;
            $filler_imagepath_old = $this->input->post('filler_up_image');
        }

        $botox_botox = $this->input->post('botox_botox');
        $specify_botox = $this->input->post('specify_botox');
        $ml_botox = $this->input->post('ml_botox');
        $botox_image = $this->input->post('botox_image');
        $botox_imagepath = $this->input->post('imagepathsx');
        $check_old_bimage = 0;
        $botox_imagepath_old = "";

        if (!empty($this->input->post('imagepathsx'))) {
            $botox_imagepath = $this->input->post('imagepathsx');
        } else {
            $check_old_bimage = 1;
            $botox_imagepath_old = $this->input->post('botox_up_image');
        }

        $plastic_imagepath = $this->input->post('imagepath');
        $pl_remark =  $this->input->post('pl_remark');
        $user_id = $this->session->userdata('user_Id');

        $check_old_pimage = 0;
        $plastic_imagepath_old = "";
        if (!empty($plastic_imagepath)) {

            $plastic_imagepath = $this->input->post('imagepath');
        } else {
            $check_old_pimage = 1;
            $plastic_imagepath_old = $this->input->post('plastic_up_image');
            $pl_before_old = $this->input->post('pl_before_old');
            $pl_after_old = $this->input->post('pl_after_old');
        }

        $pl_before_file = $_FILES['pl_before'];
        $pl_after_file = $_FILES['pl_after'];

        $hydrafacial_derma = $this->input->post('hydrafacial_derma');
        $mesotherapy_hydrafacial = $this->input->post('mesotherapy_hydrafacial');
        $mask_hydrafacial = $this->input->post('mask_hydrafacial');
        $prp_hydrafacial = $this->input->post('prp_hydrafacial');

        $area_velashape = $this->input->post('area_velashape');
        $measurement_velashape = $this->input->post('measurement_velashape');
        $applicator_velashape = $this->input->post('applicator_velashape');
        $ir_velashape = $this->input->post('ir_velashape');
        $rf_velashape = $this->input->post('rf_velashape');
        $vac_velashape = $this->input->post('vac_velashape');
        $duration_velashape = $this->input->post('duration_velashape');

        $area_prp = $this->input->post('area_prp');
        $prp_set = $this->input->post('prp_set');
        $tubes_prp = $this->input->post('tubes_prp');

        $area_mesotherapy = $this->input->post('area_mesotherapy');

        $area_threading = $this->input->post('area_threading');
        $thread = $this->input->post('thread');
        $size_threading = $this->input->post('size_threading');
        $quantity_threading = $this->input->post('quantity_threading');

        $area_injections = $this->input->post('area_injections');
        $injection = $this->input->post('injection');
        $quantity_injections = $this->input->post('quantity_injections');

        $follow_up_id = $this->input->post('follow_up_id');
        $follow_derma_id = $this->input->post('follow_derma_id');
        $follow_up_date_derma = $this->input->post('follow_up_date_derma');
        $follow_up_time_derma = $this->input->post('follow_up_time_derma');
        $chief_complaint_derma_follow = $this->input->post('chief_complaint_derma_follow');
        $present_history_follow = $this->input->post('present_history_follow');
        $physical_examination_follow = $this->input->post('physical_examination_follow');
        $impression_follow = $this->input->post('impression_follow');
        $plan_follow = $this->input->post('plan_follow');
        $prog_note_follow = $this->input->post('prog_note_follow');

        $date_derma = $this->input->post('date_derma');
        $time_derma = $this->input->post('time_derma');

        $indication_main_elite = ($indication_main_elite) ? implode(",", $indication_main_elite) : '';
        $skin_type_main_elite = ($skin_type_main_elite) ? implode(",", $skin_type_main_elite) : '';
        $skin_reaction_elite = ($skin_reaction_elite) ? implode(",", $skin_reaction_elite) : '';

        $indication_main_acclaim = ($indication_main_acclaim) ? implode(",", $indication_main_acclaim) : '';
        $skin_type_main_acclaim = ($skin_type_main_acclaim) ? implode(",", $skin_type_main_acclaim) : '';
        $skin_reaction_acclaim = ($skin_reaction_acclaim) ? implode(",", $skin_reaction_acclaim) : '';

        $indication_main_apogee = ($indication_main_apogee) ? implode(",", $indication_main_apogee) : '';
        $skin_type_main_apogee = ($skin_type_main_apogee) ? implode(",", $skin_type_main_apogee) : '';
        $skin_reaction_apogee = ($skin_reaction_apogee) ? implode(",", $skin_reaction_apogee) : '';
        $botox_botox = ($botox_botox) ? implode(",", $botox_botox) : '';
        $hydrafacial_derma = ($hydrafacial_derma) ? implode(",", $hydrafacial_derma) : '';

        $discount = $this->input->post('discount');
        $discount_per = $this->input->post('discount_per');
        $orig_price = $this->input->post('orig_price');

        date_default_timezone_set('Asia/Kuwait');
        $date_string = '%Y-%m-%d';
        $curr_date = mdate($date_string);
        $curr_time = date("H:i");

        $this->db->trans_begin();
        try {
            if (!empty($fees)) {
                $totals = '';
                while (list($key, $val) = each($fees)) {
                    $totals += $val;
                }
            } else {

                $data['alert_msg'] = '';

                $this->session->set_flashdata('error', 'Treatments fee required.');
                redirect('admin/Modules/Dermatology/DermatologyController/edit/'.encrypt_and_url_encode($treatment_payment_id, $this));
            }

            if (is_array($orig_price) && is_array($derm_qty)) {
                $total = 0; // Initialize total as numeric
                foreach ($orig_price as $key => $price) {
                    // Ensure the quantity exists and is numeric
                    $quantity = isset($derm_qty[$key]) ? (int)$derm_qty[$key] : 0;
                    $total += $price * $quantity; // Multiply price and quantity
                }
            }
            if (is_array($discount)) {
                $doctor_discount = 0; // Initialize as numeric
                foreach ($discount as $key => $val) {
                    $quantity = isset($derm_qty[$key]) ? (int)$derm_qty[$key] : 0;
                    $doctor_discount += $val * $quantity;  // Sum up the values
                }
            }

            $check_fileid = $this->PatientsModel->retrieve_data_unique_row('tbl_patient_file', 'patient_id', $pid);

            $this->form_validation->set_rules('fees_derma[]', 'Fee', 'required');

            if ($this->form_validation->run() == FALSE) {
                $data['alert_msg'] = '';
                //$this->load->view('patient_profile', $data);
                $errors = $this->form_validation->error_array();
            } else {

                $old_fees = (array)$this->PatientsModel->retrieve_data_unique_row('tbl_treat_derma', 'derma_id', $derma_id);
                $treat_payment = (array)$this->PatientsModel->retrieve_data_unique_row('tbl_treatment_payment', 'treatement_payment_id', $treatment_payment_id);

                //$total = $treat_payment[0]['total'] + $totals - $old_fees[0]['fees'];

                $newdata = array(
                    'treat_date' => $date_derma,
                    'total' => $total,
                    'discount' => $doctor_discount,
                );

                $this->DermatologyModel->update_data('tbl_treatment_payment', 'treatement_payment_id', $treatment_payment_id, $newdata);

                $newdata = array(
                    'treatment_date' => $date_derma,
                    'treatment_time' => $time_derma
                );

                $this->DermatologyModel->update_data('tbl_treatment_log', 'log_id', $treatment_payment_id, $newdata);
                $arrayData = array(

                    'nurse_id' => $nurse_id,
                    'doctor_id' => $doctor_id,
                    'remarks' => $remarks_derma,
                    'chief_complaint' => $chief_complaint_derma,
                    'prog_note' => $prog_note_derma,
                    'fees' => $total,

                );

                $this->DermatologyModel->update_data('tbl_treat_derma', 'derma_id', $derma_id, $arrayData);

                $this->DermatologyModel->delete_treatment_forall('tbl_treat_derma_subs', 'derma_id', $derma_id);

                for ($i = 0; $i < count($diagnosis_name); $i++) {

                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'diagnosis_id' => $diagnosis_id[$i],
                        'diagnosis_name' => $diagnosis_name[$i],
                        'treatment_id' => $treatment_id[$i],
                        'treatment_name' => $treatment_name[$i],
                        'fee' => (int)$fees[$i] * (int)$derm_qty[$i],
                            'orig_price' => (int)$orig_price[$i] * (int)$derm_qty[$i],
                        'quantity' => $derm_qty[$i],
                      
                        'discount_qr' => (int)$discount[$i] * (int)$derm_qty[$i],
                        'discount_per' => $discount_per[$i],
                    );

                    $this->DermatologyModel->add_data_d('tbl_treat_derma_subs', $arrayData);
                }

                $this->DermatologyModel->delete_treatment_forall('tbl_episode_payment', 'treatement_payment_id', $treatment_payment_id);

                for ($i = 0; $i < count($diagnosis_name); $i++) {

                    $newdata = array(
                        'procedure_id' => $treatment_id[$i],
                        'episode_type' => 1,
                        'diagnostise_id' => $diagnosis_id[$i],
                        'aditional_diagnostise_name' => $diagnosis_name[$i],
                        'fees' => $fees[$i] * (int)$derm_qty[$i],
                         'orig_price' => $orig_price[$i] * (int)$derm_qty[$i],
                        'quantity' => $derm_qty[$i],
                        'discount_qr' => (int)$discount[$i] * (int)$derm_qty[$i],
                        'discount_per' => $discount_per[$i],
                        'treatement_payment_id'  => $treatment_payment_id
                    );

                    $this->DermatologyModel->add_data_d('tbl_episode_payment', $newdata);
                }

                $this->DermatologyModel->delete_treatment_forall('tbl_treat_derma_sub', 'derma_id', $derma_id);
                $this->DermatologyModel->delete_treatment_forall('tbl_treat_derma_machine', 'derma_id', $derma_id);

                if ($check_cooltech == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 1,
                    );

                    $derma_machine_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($area_cooltech); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_cooltech[$i],
                            'sessions' => $sessions_cooltech[$i],
                            'measurement' => $measurement_cooltech[$i],
                            'pads' => $pads_cooltech[$i],
                            'duration' => $duration_cooltech[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $this->DermatologyModel->add_data_d('tbl_treat_derma_sub', $arrayData);
                    }
                }
                if ($check_etwo == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 2,
                    );

                    $derma_machine_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($skin_type_etwo); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'sub_category' => $sub_category,
                            'skin_type' => $skin_type_etwo[$i],
                            'indication' => $indication_etwo[$i],
                            'program' => $program_etwo[$i],
                            'area' => $area_etwo[$i],
                            'intensity' => $intensity_etwo[$i],
                            'total_pulse' => $total_pulse_etwo[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );
                        if ($area_etwo[$i]) {
                            $this->DermatologyModel->add_data_d('tbl_treat_derma_sub', $arrayData);
                        }
                    }
                }
                if ($check_hifu == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 3,
                        'area_main' => $area_hifu,
                    );

                    $derma_machine_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($cartridge_hifu); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'cartridge' => $cartridge_hifu[$i],
                            'energy' => $energy_hifu[$i],
                            'length' => $length_hifu[$i],
                            'spacing' => $spacing_hifu[$i],
                            'count' => $count_hifu[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $this->DermatologyModel->add_data_d('tbl_treat_derma_sub', $arrayData);
                    }
                }

                if ($check_elite == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 4,
                        'indication_main' => $indication_main_elite,
                        'skin_type_main' => $skin_type_main_elite,
                        'specify_derma' => $specify_elite,
                        'skin_reaction' => $skin_reaction_elite,
                    );

                    $derma_machine_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($wavelength_elite); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_elite[$i],
                            'wavelength' => $wavelength_elite[$i],
                            'spot_size' => $spot_size_elite[$i],
                            'fluence' => $fluence_elite[$i],
                            'pulse' => $pulse_elite[$i],
                            'rep_rate' => $rep_rate_elite[$i],
                            'count' => $count_elite[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $this->DermatologyModel->add_data_d('tbl_treat_derma_sub', $arrayData);
                    }
                }

                if ($check_acclaim == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 13,
                        'indication_main' => $indication_main_acclaim,
                        'skin_type_main' => $skin_type_main_acclaim,
                        'specify_derma' => $specify_acclaim,
                        'skin_reaction' => $skin_reaction_acclaim,
                    );

                    $derma_machine_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($wavelength_acclaim); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_acclaim[$i],
                            'wavelength' => $wavelength_acclaim[$i],
                            'spot_size' => $spot_size_acclaim[$i],
                            'fluence' => $fluence_acclaim[$i],
                            'pulse' => $pulse_acclaim[$i],
                            'rep_rate' => $rep_rate_acclaim[$i],
                            'count' => $count_acclaim[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $this->DermatologyModel->add_data_d('tbl_treat_derma_sub', $arrayData);
                    }
                }

                if ($check_apogee == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 14,
                        'indication_main' => $indication_main_apogee,
                        'skin_type_main' => $skin_type_main_apogee,
                        'specify_derma' => $specify_apogee,
                        'skin_reaction' => $skin_reaction_apogee,
                    );

                    $derma_machine_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($wavelength_apogee); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_apogee[$i],
                            'wavelength' => $wavelength_apogee[$i],
                            'spot_size' => $spot_size_apogee[$i],
                            'fluence' => $fluence_apogee[$i],
                            'pulse' => $pulse_apogee[$i],
                            'rep_rate' => $rep_rate_apogee[$i],
                            'count' => $count_apogee[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $this->DermatologyModel->add_data_d('tbl_treat_derma_sub', $arrayData);
                    }
                }
                if ($check_filler == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 5,
                    );

                    $derma_machine_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_machine', $arrayData);


                    for ($i = 0; $i < count($area_filler); $i++) {

                        if ($check_old_fimage == 1) {
                            $arrayData = array(
                                'derma_id' => $derma_id,
                                'area' => $area_filler[$i],
                                'filler' => $filler_filler[$i],
                                'quantity' => $quantity_filler[$i],
                                'filler_mark' => $filler_imagepath_old,
                                'treat_derma_machine_id' => $derma_machine_id
                            );
                        } else {
                            $arrayData = array(
                                'derma_id' => $derma_id,
                                'area' => $area_filler[$i],
                                'filler' => $filler_filler[$i],
                                'quantity' => $quantity_filler[$i],
                                'filler_mark' => $this->canvan_images($filler_imagepath, $pid, 'filler/'),
                                'treat_derma_machine_id' => $derma_machine_id
                            );
                        }

                        $this->DermatologyModel->add_data_d('tbl_treat_derma_sub', $arrayData);
                    }
                }

                if ($check_botox == 1) {
                    if ($check_old_bimage == 1) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'machine_id' => 6,
                            'botox' => $botox_botox,
                            'specify_derma' => $specify_botox,
                            'botox_mark' => $botox_imagepath_old,
                            'ml' => $ml_botox,
                        );
                    } else {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'machine_id' => 6,
                            'botox' => $botox_botox,
                            'specify_derma' => $specify_botox,
                            'botox_mark' => $this->canvan_images($botox_imagepath, $pid, 'botox/'),
                            'ml' => $ml_botox,
                        );
                    }

                    $derma_machine_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_machine', $arrayData);
                }
                if ($check_hydrafacial == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 7,
                        'hydrafacial' => $hydrafacial_derma,
                        'mesotherapy' => $mesotherapy_hydrafacial,
                        'mask' => $mask_hydrafacial,
                        'prp' => $prp_hydrafacial,
                    );

                    $derma_machine_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_machine', $arrayData);
                }

                if ($check_velashape == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 8,
                    );

                    $derma_machine_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($area_velashape); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_velashape[$i],
                            'measurement' => $measurement_velashape[$i],
                            'applicator' => $applicator_velashape[$i],
                            'ir' => $ir_velashape[$i],
                            'rf' => $rf_velashape[$i],
                            'vac' => $vac_velashape[$i],
                            'duration' => $duration_velashape[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $this->DermatologyModel->add_data_d('tbl_treat_derma_sub', $arrayData);
                    }
                }
                if ($check_prp == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 9,
                    );

                    $derma_machine_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0, $ctr = 1; $i < count($area_prp); $i++, $ctr++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_prp[$i],
                            'prp_set' => $prp_set[$i],
                            'tubes' => $tubes_prp[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $derma_sub_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_sub', $arrayData);

                        $name = $this->input->post('vitamin_name-' . $ctr);
                        $ml = $this->input->post('vitamin_ml-' . $ctr);

                        for ($x = 0; $x < count($name); $x++) {

                            $arrayData = array(
                                'derma_sub_id' => $derma_sub_id,
                                'name' => $name[$x],
                                'ml' => $ml[$x]
                            );

                            $this->DermatologyModel->get_id_insert('tbl_treat_derma_vitamins', $arrayData);
                        }
                    }
                }

                if ($check_mesotherapy == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 10,
                    );

                    $derma_machine_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0, $ctr = 1; $i < count($area_mesotherapy); $i++, $ctr++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_mesotherapy[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $derma_sub_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_sub', $arrayData);

                        $name = $this->input->post('vitamin_name_mesotherapy-' . $ctr);
                        $ml = $this->input->post('vitamin_ml_mesotherapy-' . $ctr);

                        for ($x = 0; $x < count($name); $x++) {

                            $arrayData = array(
                                'derma_sub_id' => $derma_sub_id,
                                'name' => $name[$x],
                                'ml' => $ml[$x]
                            );

                            $this->DermatologyModel->get_id_insert('tbl_treat_derma_vitamins', $arrayData);
                        }
                    }
                }
                if ($check_threading == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 11,
                    );

                    $derma_machine_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($area_threading); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_threading[$i],
                            'thread' => $thread[$i],
                            'size' => $size_threading[$i],
                            'quantity' => $quantity_threading[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $derma_sub_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_sub', $arrayData);
                    }
                }

                if ($check_plastic_surg == 1) {

                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 15,
                    );

                    $derma_machine_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_machine', $arrayData);

                    if ($check_old_pimage == 1) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'pl_remark' => $pl_remark,
                            'mark_iname' => $plastic_imagepath_old,
                            'after_iname' => $pl_after_old,
                            'before_iname' => $pl_before_old,
                            'treat_derma_machine_id' => $derma_machine_id
                        );
                    } else {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'pl_remark' => $pl_remark,
                            'mark_iname' => $this->canvan_images($plastic_imagepath, $pid, 'marks/'),
                            'after_iname' => $this->derma_images('pl_after', $pid, 'after/'),
                            'before_iname' => $this->derma_images('pl_before', $pid, 'before/'),
                            'treat_derma_machine_id' => $derma_machine_id
                        );
                    }

                    $plastic_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_sub', $arrayData);
                }

                if ($check_injections == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 12,
                    );

                    $derma_machine_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_machine', $arrayData);

                    for ($i = 0; $i < count($area_injections); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'area' => $area_injections[$i],
                            'injection' => $injection[$i],
                            'quantity' => $quantity_injections[$i],
                            'treat_derma_machine_id' => $derma_machine_id
                        );

                        $derma_sub_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_sub', $arrayData);
                    }
                }

                if ($check_laser == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 16,
                    );

                    $derma_machine_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_machine', $arrayData);

                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'treat_derma_machine_id' => $derma_machine_id,
                        'sessions' => $laser_session,
                        'laser_mechine' => $laser_mechine,
                        'laser_date' => $laser_date,
                        'face_neck' => $face_neck,
                        'lip_line' => $lip_line,
                        'beard_line' => $beard_line,
                        'chest' => $chest,
                        'abdomen_laser' => $abdomen_laser,
                        'un_arms' => $un_arms,
                        'lasert_thigts' => $lasert_thigts,
                        'laser_legs' => $laser_legs,
                        'buttocks' => $buttocks,
                        'lasert_bikini' => $lasert_bikini,
                        'lasert_ear' => $lasert_ear,
                        'lasert_nose' => $lasert_nose,
                        'lasert_chin' => $lasert_chin,
                        'lasert_nipples' => $lasert_nipples,
                        'lasert_hand' => $lasert_hand,
                    );

                    $derma_sub_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma_sub', $arrayData);
                }



                if ($this->input->post('check_secret') == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 17,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    $secret_treat = ($this->input->post('secret_treat')) ? implode(",", $this->input->post('secret_treat')) : '';

                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'treat_derma_machine_id' => $derma_machine_id,
                        'area' => $secret_treat,
                        'short_note_id' => '1',
                        'short_note' => $this->input->post('prog_secret_rf')
                    );

                    $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                }

                if ($this->input->post('check_dermapen') == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 18,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    $derma_pen = ($this->input->post('derma_pen')) ? implode(",", $this->input->post('derma_pen')) : '';
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'treat_derma_machine_id' => $derma_machine_id,
                        'area' => $derma_pen,
                        'short_note_id' => '2',
                        'short_note' => $this->input->post('prog_derma_pen')
                    );

                    $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                }

                if ($this->input->post('check_tattoo') == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 19,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    $tattoo_treat = ($this->input->post('tattoo_treat')) ? implode(",", $this->input->post('tattoo_treat')) : '';
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'treat_derma_machine_id' => $derma_machine_id,
                        'area' => $tattoo_treat,
                        'short_note_id' => '3',
                        'short_note' => $this->input->post('prog_tattoo')
                    );

                    $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                }

                if ($this->input->post('check_carbon') == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 20,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    $carbon_treat = ($this->input->post('carbon_treat')) ? implode(",", $this->input->post('carbon_treat')) : '';
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'treat_derma_machine_id' => $derma_machine_id,
                        'area' => $carbon_treat,
                        'short_note_id' => '4',
                        'short_note' => $this->input->post('prog_carbon')
                    );

                    $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                }

                if ($this->input->post('check_bleaching') == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 21,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    $bleaching_treat = ($this->input->post('bleaching_treat')) ? implode(",", $this->input->post('bleaching_treat')) : '';
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'treat_derma_machine_id' => $derma_machine_id,
                        'area' => $bleaching_treat,
                        'short_note_id' => '5',
                        'short_note' => $this->input->post('prog_bleaching')
                    );

                    $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                }

                if ($this->input->post('check_peeling') == 1) {
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'machine_id' => 22,
                    );

                    $derma_machine_id = $this->PatientsModel->insert_data('tbl_treat_derma_machine', $arrayData);

                    $secret_treat = ($this->input->post('secret_treat')) ? implode(",", $this->input->post('secret_treat')) : '';
                    $arrayData = array(
                        'derma_id' => $derma_id,
                        'treat_derma_machine_id' => $derma_machine_id,
                        'area' => $secret_treat,
                        'short_note_id' => '6',
                        'short_note' => $this->input->post('prog_secret_rf')
                    );

                    $derma_sub_id = $this->PatientsModel->insert_data('tbl_treat_derma_sub', $arrayData);
                }


                if ($drug_id) {
                    $this->DermatologyModel->delete_treatment_forall('tbl_prescription', 'log_id', $log_id);

                    if (is_array($drug_id)) {
                        for ($i = 0; $i < count($drug_id); $i++) {
                            $newdata = array(
                                'prescription_main_id' => $prescription_main_id,
                                'drug_id' => $drug_id[$i],
                                'log_id' => $log_id,
                                'drug_qty' => $drugs_qty[$i],
                                'drug_note' => $drug_notes[$i],
                                'after_before' => $meals[$i]

                            );

                            $this->PatientsModel->insert_data('tbl_prescription', $newdata);
                        }
                    }
                }

                for ($i = 0; $i < count($follow_up_id); $i++) {

                    $arrayData = array(
                        'treatment_date' => $follow_up_date_derma[$i],
                        'treatment_time' => $follow_up_time_derma[$i]
                    );

                    $this->DermatologyModel->update_data('tbl_treatment_log', 'log_id', $follow_up_id[$i], $arrayData);

                    $arrayData = array(
                        'treat_date' => $follow_up_date_derma[$i]
                    );

                    $this->DermatologyModel->update_data('tbl_treatment_payment', 'log_id', $follow_up_id[$i], $arrayData);

                    $arrayData = array(

                        'chief_complaint' => $chief_complaint_derma_follow[$i],
                        'present_history' => $present_history_follow[$i],
                        'physical_examination' => $physical_examination_follow[$i],
                        'impression' => $impression_follow[$i],
                        'plan' => $plan_follow[$i],
                        'prog_note' => $prog_note_follow[$i]
                    );

                    $this->DermatologyModel->update_data('tbl_treat_derma', 'treatment_payment_id', $follow_up_id[$i], $arrayData);
                }


                $files = $_FILES;
                $file_exist = $_FILES['attach_derma']['size'];
                $db_attachment = array();
                if (array_filter($file_exist)) {

                    $this->load->library('upload');

                    $cpt = count($_FILES['attach_derma']['name']);
                    $config = array();
                    $config['upload_path'] = './'.UPLOAD_PATH.'derma/';
                    $config['allowed_types'] = '*';
                    $config['max_size']      = '*';
                    $config['overwrite']     = TRUE;

                    $last_id = $this->DermatologyModel->get_last_attachment($pid, '5');
                    if (isset($last_id) and $last_id != NULL) {
                        $ctr_array = explode("-", $last_id->attachment);
                        $j = $ctr_array[1] + 1;
                    } else {
                        $j = 1;
                    }

                    for ($i = 0; $i < $cpt; $i++) {
                        $_FILES['attach_derma']['name'] = $files['attach_derma']['name'][$i];
                        $_FILES['attach_derma']['type'] = $files['attach_derma']['type'][$i];
                        $_FILES['attach_derma']['tmp_name'] = $files['attach_derma']['tmp_name'][$i];
                        $_FILES['attach_derma']['error'] = $files['attach_derma']['error'][$i];
                        $_FILES['attach_derma']['size'] = $files['attach_derma']['size'][$i];

                        $ext = strtolower(pathinfo($_FILES['attach_derma']['name'], PATHINFO_EXTENSION));
                        $newfilename = $pid . '-' . $j . '.' . $ext;

                        $config['file_name'] = $newfilename;

                        $this->upload->initialize($config);

                        if (!$this->upload->do_upload('attach_derma')) {
                            echo $this->upload->display_errors();
                        } else {
                            array_push($db_attachment, $newfilename);
                        }
                        $j++;
                    }

                    if (!empty($db_attachment)) {
                        $count_attachment = count($db_attachment);

                        for ($i = 0; $i < $count_attachment; $i++) {
                            $newdata = array(
                                'document' => $db_attachment[$i],
                                'date' => $curr_date,
                                'user_id' => $user_id,
                                'category' => 5,
                                'patient_id' => $pid,
                                'treat_id' => $derma_id

                            );

                            $this->DermatologyModel->get_id_insert('tbl_patient_attachments', $newdata);
                        }
                    }
                }

                $this->session->set_flashdata('success', 'The treatment information have updated successfully!');
                $this->db->trans_status() === FALSE ? $this->db->trans_rollback() : $this->db->trans_commit();
                redirect(base_url('index.php/admin/Patients/PatientsController/medical_book/' . encrypt_and_url_encode($pid, $this)));
            }
        } catch (Exception $e) {
            $this->db->trans_rollback();

            $this->session->set_flashdata('error', 'Failed to update the treatment.');
            redirect('admin/Modules/Dermatology/DermatologyController/edit/' . encrypt_and_url_encode($treatment_payment_id));

        }
    }

    public function insert_derma_follow()
    {

        $pid = $this->input->post('patient_id');
        $insurance_current_id = $this->input->post('insurance_current_id');

        $follow_up_date_derma = $this->input->post('follow_up_date_derma');
        $follow_up_time_derma = $this->input->post('follow_up_time_derma');
        $chief_complaint_derma_follow = $this->input->post('chief_complaint_derma_follow');
        $present_history_follow = $this->input->post('present_history_follow');
        $physical_examination_follow = $this->input->post('physical_examination_follow');
        $impression_follow = $this->input->post('impression_follow');
        $plan_follow = $this->input->post('plan_follow');
        $ref_no = $this->input->post('ref_no');
        $pri_id = $this->input->post('pri_id');

        $prog_note_derma = $this->input->post('prog_note_derma');
        $user_id = $this->session->userdata('user_id');

        $treatment_name = $this->input->post('treat_derma_name');
        $diagnosis_id = $this->input->post('treat_derma_diagnosis_id');
        $diagnosis_name = $this->input->post('treat_derma_diagnosis_name');
        $treatment_id = $this->input->post('treat_derma_id');
        $tid = $this->input->post('tid');
        $fees = $this->input->post('fees_follow_derma');

        $drug_id = $this->input->post('drug_id_derma_follow');
        $drug_name = $this->input->post('drug_name_derma_follow');
        $drugs_qty = $this->input->post('drugs_qty_derma_follow');
        $meals = $this->input->post('meals_derma_follow');
        $drug_notes = $this->input->post('drug_notes_derma_follow');
        $total = '';

        if (!empty($fees)) {
            while (list($key, $val) = each($fees)) {
                $total += $val;
            }
        } else {
            $data['alert_msg'] = '';
            $this->session->set_flashdata('error', 'The treatment fee is required');
            redirect('admin/Patients/PatientsController/medical_book/' . encrypt_and_url_encode($pid, $this));
        }

        date_default_timezone_set('Asia/Kuwait');
        $date_string = '%Y-%m-%d';
        $curr_date = mdate($date_string);
        $curr_time = date("H:i");

        // If you need implement permissions to save follow up derma treatment, implement the logic here.
        //$this->session->userdata('permission') == 2 (from old code)
        if (true) {

            $this->db->trans_begin();
            try {
                $doctor_id = $this->session->userdata('user_Id');

                $check_fileid = $this->DermatologyModel->retrieve_data_unique_row('tbl_patient_file', 'patient_id', $pid);

                if ($check_fileid == FALSE) {
                    $newdata = array(
                        'create_date' => $curr_date,
                        'patient_id'  => $pid,
                    );

                    $file_id = $this->DermatologyModel->get_id_insert('tbl_patient_file', $newdata);
                } else {
                    $file_id = $check_fileid->file_id;
                }
                $this->form_validation->set_rules('follow_up_date_derma', 'Date', 'required');

                if ($this->form_validation->run() == FALSE) {
                    $data['alert_msg'] = '';
                    $this->load->view('admin/Modules/Dermatology/dermatologyEdit', $data);
                } else {
                    $treatmentLogData = array(
                        'treatment_date' => $follow_up_date_derma,
                        'treatment_time' => $follow_up_time_derma,
                        'doctor_id' => $doctor_id,
                        'file_id' => $file_id,
                        'patient_identifier' => "FN" . $pid,
                        'insurance_type' => $insurance_current_id
                    );

                    $log_id = $this->DermatologyModel->get_id_insert('tbl_treatment_log', $treatmentLogData);

                    $treatmentPayment = array(
                        'patient_id'  => $pid,
                        'user_id' => $doctor_id,
                        'treat_date' => $follow_up_date_derma,
                        'total' => $total,
                        'log_id'  => $log_id,
                        'followup' => 1,
                        'discount' => 0.00
                    );

                    $treatement_payment_id = $this->DermatologyModel->get_id_insert('tbl_treatment_payment', $treatmentPayment);
                    $treatment_payment_id = $treatement_payment_id;

                    //$insurance_id = $this->doctor_retrive->patients_insurance($pid);
                    // $newdata = array(
                    //         'insurance_type_id' => $insurance_id->insurance_type_id,
                    //         'treatment_payment_id' => $treatment_payment_id,
                    //         'user_id' => $user_id
                    //    	 );
                    // $this->doctor_insert->add_data_d('insurance_payment', $newdata);

                    $arrayData = array(
                        'treatment_payment_id' => $treatment_payment_id,
                        'fees' => $total,
                        'prog_note' => $prog_note_derma,
                        'present_history' => $present_history_follow,
                        'physical_examination' => $physical_examination_follow,
                        'impression' => $impression_follow,
                        'plan' => $plan_follow,
                        'ref_no' => $ref_no,
                        'chief_complaint' => $chief_complaint_derma_follow,
                        'follow_up' => '1'
                    );

                    $derma_id = $this->DermatologyModel->get_id_insert('tbl_treat_derma', $arrayData);

                    for ($i = 0; $i < count($treatment_id); $i++) {

                        $arrayData = array(
                            'derma_id' => $derma_id,
                            'diagnosis_id' => $diagnosis_id[$i],
                            'diagnosis_name' => $diagnosis_name[$i],
                            'treatment_id' => $treatment_id[$i],
                            'treatment_name' => $treatment_name[$i],
                            'fee' => $fees[$i]
                        );

                        $this->DermatologyModel->add_data_d('tbl_treat_derma_subs', $arrayData);
                    }

                    $e_num = 0;
                    if ($treatment_payment_id > 0) {
                        $count_episode = $this->DermatologyModel->numberofepisode($pid, '1');
                        $e_num = $count_episode + 1;
                    } else {
                        $e_num = 1;
                    }

                    for ($i = 0; $i < count($diagnosis_name); $i++) {
                        $newdata = array(
                            // 'episode_id' => $episode_id,
                            'procedure_id' => $treatment_id[$i],
                            'episode_type' => 1,
                            'diagnostise_id' => $diagnosis_id[$i],
                            'aditional_diagnostise_name' => $diagnosis_name[$i],
                            'fees' => $fees[$i],
                            'treatement_payment_id'  => $treatment_payment_id
                        );
                        $this->DermatologyModel->add_data_d('tbl_episode_payment', $newdata);
                    }

                    if ($drug_id) {
                        $newdata = array(
                            'enter_date' => $curr_date,
                            'patient_id' => $pid,
                            'doctor_id'  => $doctor_id

                        );

                        $prescription_main_id = $this->DermatologyModel->get_id_insert('tbl_prescription_main', $newdata);

                        if (is_array($drug_id)) {
                            for ($i = 0; $i < count($drug_id); $i++) {
                                $newdata = array(
                                    'prescription_main_id' => $prescription_main_id,
                                    'drug_id' => $drug_id[$i],
                                    'log_id' => $log_id,
                                    'drug_qty' => $drugs_qty[$i],
                                    'drug_note' => $drug_notes[$i],
                                    'after_before' => $meals[$i]
                                );

                                $this->DermatologyModel->get_id_insert('tbl_prescription', $newdata);
                            }
                        }
                    }
                    $files = $_FILES;
                    $file_exist = $_FILES['attach_derma_follow']['size'];
                    $db_attachment = array();
                    if (array_filter($file_exist)) {

                        $this->load->library('upload');

                        $cpt = count($_FILES['attach_derma_follow']['name']);
                        $config = array();
                        $config['upload_path'] = './'.UPLOAD_PATH.'derma/';
                        $config['allowed_types'] = 'gif|jpg|png|doc|docx|pdf|bdo|avi|mvo';
                        $config['max_size']      = '3072';
                        $config['overwrite']     = TRUE;

                        $last_id = $this->DermatologyModel->get_last_attachment($pid, '5');
                        if (isset($last_id) and $last_id != NULL) {
                            $ctr_array = explode("-", $last_id->attachment);
                            $j = $ctr_array[1] + 1;
                        } else {
                            $j = 1;
                        }

                        for ($i = 0; $i < $cpt; $i++) {
                            $_FILES['attach_derma_follow']['name'] = $files['attach_derma_follow']['name'][$i];
                            $_FILES['attach_derma_follow']['type'] = $files['attach_derma_follow']['type'][$i];
                            $_FILES['attach_derma_follow']['tmp_name'] = $files['attach_derma_follow']['tmp_name'][$i];
                            $_FILES['attach_derma_follow']['error'] = $files['attach_derma_follow']['error'][$i];
                            $_FILES['attach_derma_follow']['size'] = $files['attach_derma_follow']['size'][$i];

                            $ext = strtolower(pathinfo($_FILES['attach_derma_follow']['name'], PATHINFO_EXTENSION));
                            $newfilename = $pid . '-' . $j . '.' . $ext;

                            $config['file_name'] = $newfilename;

                            $this->upload->initialize($config);

                            if (!$this->upload->do_upload('attach_derma_follow')) {

                                echo $this->upload->display_errors();
                            } else {
                                array_push($db_attachment, $newfilename);
                            }
                            $j++;
                        }

                        if (!empty($db_attachment)) {
                            $count_attachment = count($db_attachment);

                            for ($i = 0; $i < $count_attachment; $i++) {
                                $newdata = array(
                                    'document' => $db_attachment[$i],
                                    'date' => $curr_date,
                                    'user_id' => $user_id,
                                    'category' => 5,
                                    'patient_id' => $pid,
                                    'treat_id' => $derma_id

                                );

                                $this->doctor_insert->get_id_insert('tbl_patient_attachments', $newdata);
                            }
                        }
                    }
                    $data['alert_msg'] = '';
                    $data['error'] = '';

                    $this->session->set_flashdata('success', 'The treatment information have added successfully!');
                    $this->db->trans_status() === FALSE ? $this->db->trans_rollback() : $this->db->trans_commit();

                    redirect('admin/Modules/Dermatology/DermatologyController/edit/' . $tid);
                }
            } catch (Exception $e) {
                $this->db->trans_rollback();

                $this->session->set_flashdata('error', 'Failed to create treatment follow up !');
                redirect('admin/Modules/Dermatology/DermatologyController/edit/' . $tid);
            }
        } else {
            // $data['alert_msg'] = '';
            // $data['error'] = 'You can not add or save treatments because you do not have any permission only doctor accounts';
            // $data['success'] = '';

            // $this->load->view('patient_profile', $data);
        }
    }

    public function delete_treatment_derma_followup()
    {

        $this->db->trans_begin();
        try {

            $log_id = $this->input->post('logid');
            $treatment_id = $this->input->post('treatment_id');
            $temp = explode("-", $log_id);

            $user_id = $this->session->userdata('user_Id');
            $emp_name = $this->session->userdata('emp_name');

            date_default_timezone_set('Asia/Kuwait');
            $date_string = '%Y-%m-%d';
            $curr_date = mdate($date_string);
            $curr_time = date("H:i");

            $p_id = $this->DermatologyModel->get_patient_id($temp[2]);

            $newdata = array(
                'delete_date' => $curr_date,
                'delete_time' => $curr_time,
                'delete_reason' => 'Deleted treatment' . $log_id . ' by ' . $emp_name,
                'emp_name' => $emp_name,
                'user_id' => $user_id
            );

            $this->DermatologyModel->add_data_d('tbl_delete_log', $newdata);

            $old_fees = $this->DermatologyModel->retrieve_data_unique('tbl_treat_derma', 'derma_id', $temp[1]);
            $treat_payment = $this->DermatologyModel->retrieve_data_unique('tbl_treatment_payment', 'treatement_payment_id', $temp[0]);

            $total = $treat_payment[0]['total'] - $old_fees[0]['fees'];

            $newdata = array(
                'deleted' => 1,
                'total' => $total
            );

            $this->DermatologyModel->update_data('tbl_treatment_payment', 'treatement_payment_id', $temp[0], $newdata);

            $this->DermatologyModel->delete_treatment_forall('tbl_treat_derma', 'derma_id', $temp[1]);
            $this->DermatologyModel->delete_treatment_forall('tbl_episode_payment', 'treatement_payment_id', $temp[0]);
            $this->DermatologyModel->delete_treatment_forall('tbl_patient_payment', 'treatment_payment_id', $temp[0]);
            
            $this->session->set_flashdata('success', 'The follow up treatment deleted successfully!');
            $this->db->trans_status() === FALSE ? $this->db->trans_rollback() : $this->db->trans_commit();
            
            redirect('admin/Modules/Dermatology/DermatologyController/edit/' . $treatment_id);

        } catch (Exception $e) {
            $this->db->trans_rollback();

            $this->session->set_flashdata('error', 'Failed to delete follow up treatment.');
            redirect('admin/Modules/Dermatology/DermatologyController/edit/' . $treatment_id);
        }
    }


    public function ProgressHistory($treatment_id_enc){
        $treatment_id = decrypt_and_url_decode($treatment_id_enc,$this);

        $this->load->view('admin/Modules/Progress/Form.php');
    }
}
