<?php

class DietitianController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Patients/PatientsModel');
        $this->load->model('admin/Patients/PatientsModel');

        $this->load->library('upload');
    }

    public function index()
    {
        //Commen -------------------------------------
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 22;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $data['dataList'] = $this->PatientsModel->get_dataList();

        $this->load->view('admin/Patients/PatientsList', $data);
    }


    public function save()
    {

        $patient_id = $this->input->post('patient_id');
        $decryptedId = decrypt_and_url_decode($patient_id, $this);
        $patient = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);

        $result['active_menu'] = 15;
        $result['active_submenu'] = 1;

        $treatment_date_general = $this->input->post('treatment_date');
        $cheif_compalin = $this->input->post('cheif_compalin');
        $subjective = $this->input->post('subjective');
        $objective = $this->input->post('objective');
        $assessment = $this->input->post('assessment');

        $diagnosis_id = $this->input->post('general_diagnosis_id');
        $diagnosis_name = $this->input->post('general_diagnosis_name');
        $procedure_id = $this->input->post('general_treatment_id');
        $fees = $this->input->post('orig_price');

        $assigned_package = $this->input->post('assigned_package');
        $followup = $this->input->post('followup');
        

        $discount = $this->input->post('discount');
        $discount_per = $this->input->post('discount_per');
        $user_id = $this->session->userdata('user_id');

        $note = $this->input->post('note');
        $treatment_id = $this->input->post('treatment_payment_id');

        if($update) {
            unset($treatmentPayment['patient_id']);
            unset($treatmentPayment['insurance_type']);
        }

        $treatment_date = $this->input->post('treatment_date');
        $treatment_time = $this->input->post('treatment_time');
        if (is_array($fees)) {
            $total = array_sum($fees);
        }

        if (is_array($fees)) {
            $orig_price_total = array_sum($fees);
        }

        if (is_array($discount)) {
            $total_discount = array_sum($discount);
        }

        $this->db->trans_start();
        try {
            if($followup == 0){
            $treatment_payment_data = array(
                'patient_id'  => $decryptedId,
                'user_id' => $this->loginId,
                'treat_date' => $treatment_date_general,
                'treat_time' => $treatment_time,
                'total' => $orig_price_total,
                'discount' => $total_discount,
                'followup'  => $followup,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => 5,
                'notes' => $note
            );
        }else{
            $treatment_payment_data = array(
                'patient_id'  => $decryptedId,
                'user_id' => $this->loginId,
                'treat_date' => $treatment_date_general,
                'treat_time' => $treatment_time,
                'total' => 0,
                'discount' => 0,
                'followup'  => $followup,
                'insurance_type'  => $patient->insurance_type,
                'department_id' => 5,
                'notes' => $note
            );
        }


            if ($treatment_id != "") {
                $this->PatientsModel->update_data_where('tbl_treatment_payment', 'treatement_payment_id', $treatment_id, $treatment_payment_data);
                $this->PatientsModel->delete_data_where('tbl_episode_payment', 'treatement_payment_id', $treatment_id);
                $this->session->set_flashdata('success', 'Dietitian Treatment Updated Succesfully.');
                $treatement_payment_id = $treatment_id;

            } else {

                $treatement_payment_id = $this->PatientsModel->insert_data('tbl_treatment_payment', $treatment_payment_data);
                $this->session->set_flashdata('success', 'Dietitian Treatment Saved Succesfully.');
            }


            for ($i = 0; $i < count($procedure_id); $i++) {

                $newdata = array(
                    'procedure_id' => $procedure_id[$i],
                    'episode_type' => 1,
                    'diagnostise_id' => $diagnosis_id[$i],
                    'fees' => $fees[$i],
                    'discount_qr' => $discount[$i] ?? 0,
                    'discount_per' => $discount_per[$i] ?? 0,
                    'treatement_payment_id' => $treatement_payment_id,
                    'aditional_diagnostise_name' => $diagnosis_name[$i],
                    'program' => $program[$i],
                    'orig_price' => $fees[$i]
                );
                // print_r($newdata);
                $this->PatientsModel->insert_data('tbl_episode_payment', $newdata);
            }

            $dietitian = array(
                'treatment_payment_id' => $treatement_payment_id,
                'patient_id'  => $decryptedId,
                'chief_complain' => $cheif_compalin,
                  'subjective' => $subjective,
                  'objective' => $objective,
                  'assesment' => $assessment,
                  
              );
              $this->PatientsModel->insert_data('tbl_dietitian', $dietitian);
            // die;

            $files = $_FILES;
			$file_exist = $_FILES['attach_physio']['size'];
			$db_attach_physioment = array();
			if (array_filter($file_exist)) {

				$this->load->library('upload');
                $upload_path = './'.UPLOAD_PATH.'physiotherapy/';
				$cpt = count($_FILES['attach_physio']['name']);
				$config = array();
				
                $config['upload_path'] = $upload_path;
				$config['allowed_types'] = '*';
				$config['max_size']      = '*';
				$config['overwrite']     = TRUE;
                
                if (!is_dir($upload_path)) {
                    mkdir($upload_path, 0755, true); // Creates the directory with 0755 permissions and recursive set to true
                }
				$last_id = $this->CommonModel->get_last_attachment($decryptedId, '10');
				if (isset($last_id) and $last_id != NULL) {
					$ctr_array = explode("-", $last_id->attach_physioment);
					$j = $ctr_array[1] + 1;
				} else {
					$j = 1;
				}
                

				for ($i = 0; $i < $cpt; $i++) {
					$_FILES['attach_physio']['name'] = $files['attach_physio']['name'][$i];
					$_FILES['attach_physio']['type'] = $files['attach_physio']['type'][$i];
					$_FILES['attach_physio']['tmp_name'] = $files['attach_physio']['tmp_name'][$i];
					$_FILES['attach_physio']['error'] = $files['attach_physio']['error'][$i];
					$_FILES['attach_physio']['size'] = $files['attach_physio']['size'][$i];

					$ext = strtolower(pathinfo($_FILES['attach_physio']['name'], PATHINFO_EXTENSION));
					$newfilename = $decryptedId . '-' . $j . '.' . $ext;

					$config['file_name'] = $newfilename;

					$this->upload->initialize($config);

					if (!$this->upload->do_upload('attach_physio')) {

						echo $this->upload->display_errors();
					} else {
						array_push($db_attach_physioment, $newfilename);
					}
					$j++;
				}

				if (!empty($db_attach_physioment)) {
					$count_attach_physioment = count($db_attach_physioment);

					for ($i = 0; $i < $count_attach_physioment; $i++) {
						$newdata = [
                            'document' => $db_attach_physioment[$i],
                            'date' => date('Y-m-d'),
                            'user_id' => $user_id,
                            'category' => 14,
                            'patient_id' => $decryptedId,
                            'treat_id' => $treatement_payment_id,
                            'document_type' => 1,
                        ];

                        $this->CommonModel->insert_data('tbl_patient_attachments', $newdata);					
                    }
				}
			}
            if($followup == 2){
                $this->PatientsModel->updateSessions($decryptedId,$assigned_package,14);
                 
                 
              }
            if ($this->db->trans_status() === FALSE) {
                $this->db->trans_rollback();
            } else {
                $this->db->trans_commit();
            }
      
            
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
        } catch (Exception $e) {
            $this->db->trans_rollback();
            echo $e;
            $this->session->set_flashdata('Error', 'Dietitian Treatment not saved.');
            redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
            exit;
        }

        $this->db->trans_complete();
    }


    public function edit($treatement_payment_id)
    {
        $decryptedId = decrypt_and_url_decode($treatement_payment_id, $this);
        $data['invoice'] = $this->PatientsModel->retrieve_data_unique_row('tbl_treatment_payment', 'treatement_payment_id', $decryptedId);
        $data['treat_data'] = $this->PatientsModel->retrieve_data_unique_row('tbl_dietitian', 'treatment_payment_id', $decryptedId);
        $data['episodes'] = $this->PatientsModel->get_treatment_episodes($decryptedId);
        $data['patient_id'] = $data['invoice']->patient_id;
        $data['treatment_payment_id'] = $decryptedId;

        $data['attachment'] = $this->CommonModel->get_attachment($data['invoice']->patient_id, 10, $decryptedId);

        $this->load->view('admin/Modules/Dietitian/dietitianEdit', $data);
    }

    public function delete_physiotherapy_attachment($document_id)
    {

        $decrypted_documenet_id = decrypt_and_url_decode($document_id, $this);

        $document = $this->db->select('*')
            ->from('tbl_patient_attachments')
            ->where('id', $decrypted_documenet_id)
            ->get()
            ->row();

        $treatment_id = $document->treat_id;

            if(file_exists(''.UPLOAD_PATH.'physiotherapy/'.$document->document)) {
                
                try {
                    unlink($document->document);
                    $this->db->where('id', $document->id)->delete('tbl_patient_attachments');
                    $this->session->set_flashdata('success', 'Attachment deleted successfully.');
                } catch (Exception $e) {
                    $this->session->set_flashdata('error', 'Failed to delete attachment.');
                }

            }else{
                $this->session->set_flashdata('error', 'Attachment not found.');
            }

            redirect('admin/Modules/Physiotherapy/PhysiotherapyController/edit/' . encrypt_and_url_encode($treatment_id, $this));
    }
}
