<?php

class OphthalmologyController extends MY_Controller
{

    private $patient_id = null;
    private $treatment_id = null;
    private $department_id = 9;
    private $insurance_type = null;

    public function __construct()
    {
        parent::__construct();

        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Modules/Ophthalmology/OphthalmologyModel');

        $this->load->library('upload');

        if(!empty($this->input->post('treatement_payment_id'))) {
            $this->treatment_id = decrypt_and_url_decode($this->input->post('treatement_payment_id'), $this);
        }

        if(!empty($this->input->post('insurance_current_id'))) {
            $this->insurance_type = decrypt_and_url_decode($this->input->post('insurance_current_id'), $this);
        }

        $this->patient_id = decrypt_and_url_decode($this->input->post('patient_id'), $this);
    }


    public function insert_opthalmology()
    {
        $doctor_id = $this->session->userdata('user_Id');
        $patient_id = $this->patient_id;

        $user_id = $this->session->userdata('user_Id');
        $treatment_date = $this->input->post('treatment_date');
        $treatment_time = $this->input->post('treatment_time');

        $gen_opth_name = $this->input->post('gen_opth_name');
        $gen_opth_treatment_id = $this->input->post('gen_opth_treatment_id');
        $orig_price_opth = $this->input->post('orig_price_opth');
        $discount_opth = $this->input->post('discount_opth');
        $discount_per_opth = $this->input->post('discount_per_opth');
        $fees_opth = $this->input->post('orig_price_opth');

        $treatment_id = $this->input->post('gen_opth_treatment_id');
        $update = $treatment_id ? true : false;

        $assigned_package = $this->input->post('assigned_package');
        $followup = $this->input->post('followup');
  
        if (is_array($fees_opth)) {
            $total = 0;
            foreach ($fees_opth as $val) $total += $val;
        }

        if (is_array($discount_opth)) {
            $doctor_discount = 0;
            foreach ($discount_opth as $val) $doctor_discount += $val;
        }

        if(empty($total)) {
           // $this->session->set_flashdata('error', 'You must select procedure!');
            redirect('admin/Patients/PatientsController/medical_book/' . encrypt_and_url_encode($patient_id, $this));
        }

        try {
            $this->db->trans_start();
            if($followup == 0){
            $treatmentPayment = [
                'patient_id'  => $patient_id,
                'user_id' => $doctor_id,
                'treat_date' => $treatment_date,
                'treat_time' => $treatment_time,
                'total' => $total,
                'department_id'  => $this->department_id,
                'discount'  => $doctor_discount,
                'followup'  => $followup,
                'insurance_type' => $this->insurance_type
            ];
        }else{
            $treatmentPayment = [
                'patient_id'  => $patient_id,
                'user_id' => $doctor_id,
                'treat_date' => $treatment_date,
                'treat_time' => $treatment_time,
                'total' => 0,
                'department_id'  => $this->department_id,
                'discount'  => 0,
                'followup'  => $followup,
                'insurance_type' => $this->insurance_type
            ];
        }

            if($update) {
                unset($treatmentPayment['patient_id']);
                unset($treatmentPayment['insurance_type']);
            }

            if ($treatment_id != "") {
                $this->OphthalmologyModel->update_data_where('tbl_treatment_payment', 'treatement_payment_id', $treatment_id, $treatmentPayment);
                $this->session->set_flashdata('success', 'Examination Updated Succesfully.');
            } else {
                $treatment_payment_id = $this->OphthalmologyModel->insert_data('tbl_treatment_payment', $treatmentPayment);
                $this->session->set_flashdata('success', 'Examination Saved Succesfully.');
            }

            $filter_arr = ['gen_opth_name', 'gen_opth_treatment_id', 'orig_price_opth', 'discount_opth', 'discount_per_opth', 'fees_opth', 'treatment_date', 'treatment_time', 'procedure_gen_surg', 'insurance_current_id'];
            $data = array_diff_key($_POST, array_flip($filter_arr));

            $new_data = [
                'data' => json_encode($data),
                'patient_id' => $patient_id
            ];

            if ($treatment_id != "") {
                $this->OphthalmologyModel->update_data_where('tbl_ophthalmology', 'treatment_payment_id', $treatment_id, $new_data);
                $this->OphthalmologyModel->delete_data_where('tbl_episode_payment', 'treatement_payment_id', $treatment_id);
                $treatment_payment_id = $treatment_id;
            } else {
                $new_data['treatment_payment_id'] = $treatment_payment_id;
                $this->OphthalmologyModel->insert_data('tbl_ophthalmology', $new_data);
            }

            foreach ($gen_opth_name as $x => $row) {
                $episode_data = [
                    'aditional_diagnostise_name' => $gen_opth_name[$x],
                    'procedure_id' => $gen_opth_treatment_id[$x],
                    'discount_qr' => $discount_opth[$x],
                    'discount_per' => $discount_per_opth[$x],
                    'fees' => $fees_opth[$x],
                    'treatement_payment_id' => $treatment_payment_id
                ];
                $this->OphthalmologyModel->insert_data('tbl_episode_payment', $episode_data);
            }

            $files = $_FILES;
            $file_exist = $_FILES['attach_opthalmology']['size'];
            
            $db_attachment = [];
            if (array_filter($file_exist)) {

                $this->load->library('upload');

                $cpt = count($_FILES['attach_opthalmology']['name']);
                $config = [];
                $config['upload_path'] = './'.UPLOAD_PATH.'opth/';
                $config['allowed_types'] = '*';
                $config['max_size']      = '*';
                $config['overwrite']     = TRUE;

                $last_id = $this->OphthalmologyModel->get_last_attachment($patient_id, '9');
                
                if (isset($last_id) and $last_id != NULL) {
                    $ctr_array = explode("-", $last_id->attachment);
                    $j = $ctr_array[1] + 1;
                } else {
                    $j = 1;
                }

                for ($i = 0; $i < $cpt; $i++) {
                    $_FILES['attach_opthalmology']['name'] = $files['attach_opthalmology']['name'][$i];
                    $_FILES['attach_opthalmology']['type'] = $files['attach_opthalmology']['type'][$i];
                    $_FILES['attach_opthalmology']['tmp_name'] = $files['attach_opthalmology']['tmp_name'][$i];
                    $_FILES['attach_opthalmology']['error'] = $files['attach_opthalmology']['error'][$i];
                    $_FILES['attach_opthalmology']['size'] = $files['attach_opthalmology']['size'][$i];

                    $ext = strtolower(pathinfo($_FILES['attach_opthalmology']['name'], PATHINFO_EXTENSION));
                    $newfilename = $patient_id . '-' . $j . '.' . $ext;

                    $config['file_name'] = $newfilename;

                    $this->upload->initialize($config);

                    if (!$this->upload->do_upload('attach_opthalmology')) {
                        echo $this->upload->display_errors();
                    } else {
                        array_push($db_attachment, $newfilename);
                    }
                    $j++;
                }

                if (!empty($db_attachment)) {
                    $count_attachment = count($db_attachment);

                    for ($i = 0; $i < $count_attachment; $i++) {
                        $newdata = [
                            'document' => $db_attachment[$i],
                            'date' => date('Y-m-d'),
                            'user_id' => $user_id,
                            'category' => 9,
                            'patient_id' => $patient_id,
                            'treat_id' => $treatment_payment_id
                        ];

                        $this->OphthalmologyModel->insert_data('tbl_patient_attachments', $newdata);
                    }
                }
            }
            if($followup == 2){
                $this->PatientsModel->updateSessions($patient_id,$assigned_package,$this->department_id);
                 
                 
              }

            if ($this->db->trans_status() === FALSE) {
                throw new Exception('Transaction failed.');
            }

            $this->db->trans_complete();

            if(!$update) {
                redirect('admin/Patients/PatientsController/medical_book/' . encrypt_and_url_encode($patient_id, $this));
            }else{
                redirect('admin/Modules/Ophthalmology/OphthalmologyController/edit/' . encrypt_and_url_encode($treatment_id, $this));
            }
        } catch (Exception $e) {
            $this->db->trans_rollback();
            $this->session->set_flashdata('error', $e->getMessage());
            echo $e->getMessage();exit;
            redirect('admin/Patients/PatientsController/medical_book/' . encrypt_and_url_encode($patient_id, $this));
        }
    }

    public function edit($treatment_payment_id)
    {
        $data['title'] = 'Patient Profile::: Hospital Management Software';
        $data['page_header'] = 'Opthamology';

        $data['treatment_payment_id'] = $treatment_payment_id;
        $treatment_payment_id = decrypt_and_url_decode($treatment_payment_id, $this);

        $data['treatment'] = $this->OphthalmologyModel->get_treatments_examinations_by_id($treatment_payment_id);

        //$data['profile'] = $this->OphthalmologyModel->get_profile_main($patient_id);
        $data['opthamolgy'] = $this->OphthalmologyModel->retrieve_data_unique_row('tbl_ophthalmology', 'treatment_payment_id', $treatment_payment_id);
        $data['episodes'] = $this->OphthalmologyModel->retrieve_data_unique('tbl_episode_payment', 'treatement_payment_id', $treatment_payment_id);

        $data['procedures'] = $this->OphthalmologyModel->retrieve_produress();
        $data['clinic_info'] = $this->CommonModel->get_company_info();
        $data['attachment'] = $this->OphthalmologyModel->get_attachment($data['treatment']->patient_id, 9, $treatment_payment_id);
        $data['patient_id'] = $data['treatment']->patient_id;
        $data['ophthalmology_procedures'] = $this->OphthalmologyModel->get_treatments();

        $this->load->view('admin/Modules/Ophthalmology/opthmologyEdit', $data);
    }

    public function delete_optho_attachment($document_id)
    {

        $decrypted_documenet_id = decrypt_and_url_decode($document_id, $this);

        $document = $this->db->select('*')
            ->from('tbl_patient_attachments')
            ->where('id', $decrypted_documenet_id)
            ->get()
            ->row();

        $treatment_id = $document->treat_id;

            if(file_exists(''.UPLOAD_PATH.'opth/'.$document->document)) {
                
                try {
                    unlink($document->document);
                    $this->db->where('id', $document->id)->delete('tbl_patient_attachments');
                    $this->session->set_flashdata('success', 'Attachment deleted successfully.');
                } catch (Exception $e) {
                    $this->session->set_flashdata('error', 'Failed to delete attachment.');
                }

            }else{
                $this->session->set_flashdata('error', 'Attachment not found.');
            }

            redirect('admin/Modules/Ophthalmology/OphthalmologyController/edit/' . encrypt_and_url_encode($treatment_id, $this));
    }
}
