<?php

class RefferalController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('admin/CommonModel');
        $this->load->model('admin/Patients/PatientsModel');
        $this->load->model('admin/Patients/PatientsModel');

   
    }

   


    public function save()
    {

        $patient_id = $this->input->post('patient_id');
        $decryptedId = decrypt_and_url_decode($patient_id, $this);
        $patient = $this->PatientsModel->get_patient_details('patient_id', $decryptedId);
        $doctor_id = $this->input->post('doctor_id');
        $comment = $this->input->post('comment');
        $attachment = $this->input->post('attachment');

        $loginId = $this->session->userdata('user_Id');
       

        $data = [
            
            'patient_id' => $decryptedId,
            'reffered_by' =>  $loginId , // Assuming user_id is stored in session
            'notes' => $comment,
          
            'created_at' => date('Y-m-d H:i:s')
        ];
       $this->db->insert('refferals', $data);
        $refferal_id =$this->db->insert_id();
        
        $data = [
            
            'refferal_id' => $refferal_id,
            'doctor_id' =>  $doctor_id , // Assuming user_id is stored in session
          
        ];
    
        $this->db->insert('referred_item_doctors', $data);

        if($refferal_id){



            // File upload configuration
        $config['upload_path'] = './uploads/discussion/';
        $config['allowed_types'] = 'gif|jpg|png|pdf|doc|docx';
        $config['max_size'] = 2048; // Max size in KB (2MB)
        $fileName=null;
        $this->load->library('upload', $config);

        if ($this->upload->do_upload('attachment')) {
            $fileData = $this->upload->data();
            $fileName = $fileData['file_name'];
            // Save comment and file name to database
        } else {
            $error = $this->upload->display_errors();
            // Handle the error, possibly return an error message
        }
        $data = [
            
            'refferal_id' => $refferal_id,
            'user_id' =>  $loginId , // Assuming user_id is stored in session
            'comment' => $this->input->post('comment'),
            'atttachment' => $fileName,
            'created_at' => date('Y-m-d H:i:s')
        ];

            $sent_by= getLoginUser($this)->full_name;
        $notification= array(
            'url'=>'admin/Patients/PatientsController/medical_book/'.$patient_id,
            'message'=>'Reffered A Patient Check Details',
            'sent_by'=>$sent_by,
        );
        $this->createNotification($doctor_id,$notification);
    
        $this->db->insert('refferal_discussion', $data);
    }

        $this->session->set_flashdata('success', 'Reffered successfully.');
        redirect('admin/Patients/PatientsController/medical_book/' . $patient_id, 'refresh');
    }


    public function mark_as_complete(){
        $id = $this->input->post('id');

        $newdata= array('status'=>'1');
        $this->PatientsModel->update_data_where('refferals', 'id', $id, $newdata);
        $data= array('status'=>'success','message'=>'Discussion Completed');
        echo json_encode($data);
    }

    public function add_doctor_to_discussion(){
        $doctorId = $this->input->post('doctor_id');
        $referredItemId = $this->input->post('referred_item_id');
        $loginId = $this->session->userdata('user_Id');
    
        if ($doctorId && $referredItemId) {
            // Assuming you have a model method to handle this
        
            $result = $this->PatientsModel->addDoctorToDiscussion($doctorId, $referredItemId,$loginId);

            $sent_by= getLoginUser($this)->full_name;
            $notification= array(
                'url'=>'admin/Patients/PatientsController/view_refferal_details/'.$referredItemId,
                'message'=>'Added You In a Disccussion',
                'sent_by'=>$sent_by,
            );
            $this->createNotification($doctorId,$notification);
    
            if ($result) {
                echo json_encode(['status' => 'success']);
            } else {
                echo json_encode(['status' => 'error']);
            }
        } else {
            echo json_encode(['status' => 'error', 'message' => 'Invalid input.']);
        }

    }


    public function createNotification($doctor_id, $notification){

            $notification = json_encode($notification);
        $data= array(
            'type'=>'Notification',
            'user_id'=>$doctor_id,
            'response'=>$notification,
        );

        $this->db->insert('tbl_notifications', $data);

    }
    
   

   
}
