<?php

class PharmacyController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();

        $this->load->model('admin/Pharmacy/PharmacyModel');
        $this->load->model('admin/Patients/PatientsModel');
        $this->load->model('admin/Payments/PaymentsModel');
        $this->load->model('admin/Reports/ReportsModel','report_retrive');
        $this->load->model('admin/ConsentForm/ConfigurationRetriveModel');
        $this->load->model('admin/Pharmacy/SubModels/inquiry', 'inquiry_model');
        $this->load->model('admin/Pharmacy/SubModels/bill', 'bill_model');
        $this->load->model('admin/Pharmacy/SubModels/financial', 'financial_model');
        $this->load->model('admin/Pharmacy/SubModels/supplier', 'supplier_model');
        $this->load->model('admin/Pharmacy/SubModels/inventory', 'inventory_model');
        $this->load->model('admin/Pharmacy/SubModels/quantity', 'quantity_model');
        $this->load->model('admin/Pharmacy/SubModels/statement', 'statement_model');
        $this->load->model('admin/Pharmacy/SubModels/categories', 'categories_model');
        $this->load->model('admin/Pharmacy/SubModels/items', 'items_model');
        $this->load->model('admin/Pharmacy/SubModels/locations', 'locations_model');
        $this->load->model('admin/Pharmacy/SubModels/pos', 'PosModel');
        $this->load->model('admin/Pharmacy/SubModels/drugsmodel');
   

        $this->load->library('upload');
    }

    public function index()
    {
        //Commen -------------------------------------
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 27;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $data['dataList'] = $this->PaymentsModel->getPaymentsList();
        $data['expiry'] = $this->expiry();

        $data['expiredCount'] = $this->PharmacyModel->expiring();
        
        $this->load->view('admin/Pharmacy/Pharmacy', $data);
    }

    public function view($treatment_payment_id)
    {

        try {
            $paymentId = decrypt_and_url_decode($treatment_payment_id, $this);
            $treatments =  $this->PaymentsModel->getTreatmentList($paymentId);
            $recipts =  $this->PaymentsModel->getTreatmentRecipts($paymentId);

            $data['active_menu'] = 24;
            $data['active_submenu'] = 1;

            $result = $this->PatientsModel->get_patient_details('patient_id', $treatments->patient_id);
            $result->documents = $this->PatientsModel->get_patient_documents($treatments->patient_id);
            $result->payment_types = $this->ReportsModel->payment_types();
            $result->total_advance = $this->calculate_totals($treatments->patient_id)['total_advance'];
            $result->recipts = $recipts;
            $result->patient_id = $treatments->patient_id;
            $result->treatments = $treatments;
            $result->payment_id = '';

            $this->load->view('admin/Payments/Payment', $result);
        } catch (Exception $e) {
            echo $e;
            exit;
        }
    }

    public function itemExpiry()
    {

        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 28;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $this->load->view('admin/Pharmacy/Store/itemExpire', $data);
    }

    public function expiry()
    {

        $items_exp = $this->PharmacyModel->items_expiry();
        $items = array();
        $today = new DateTime("now");
        foreach ($items_exp as $values) {
            $x_date = new DateTime($values['x_date']);
            $diff = $x_date->diff($today);
            $days = $diff->format('%a');
            if ($values['qty'] > 0 && $days < $values['expiry']) {
                if (strtotime($values['x_date']) < strtotime(date('m/d/Y'))) {
                    $days = "Expired";
                } else {
                    $days = $days . " days";
                }
                $values['diff'] = $days;
                array_push($items, $values);
            }
            return $items;
        }
    }
    public function get_expired_items(){
        $items_exp = $this->PharmacyModel->items_expiry();
        $items = array();
        $today = new DateTime("now");
        foreach ($items_exp as $values) {
            $x_date = new DateTime($values['x_date']);
            $diff = $x_date->diff($today);
            $days = $diff->format('%a');
            if ($values['expired'] == 1 ) {
                $values['diff'] = $days;
                array_push($items, $values);
            }
            
        }
        $total_records =count($items);
        $response = array(
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $items
        );

      
        $this->output
        ->set_content_type('application/json')
        ->set_output(json_encode($response));
        
    }
    public function expiring()
    {
        
			$status = $this->input->post('status');
      
        $items_exp = $this->PharmacyModel->items_expiring();
        $items = array();
        $today = new DateTime("now");

        if($status == -1){
            foreach ($items_exp as $values) {
                $x_date = new DateTime($values['x_date']);
                $diff = $x_date->diff($today);
                $days = $diff->format('%a');
                if ($values['qty'] > 0 && $days < $values['expiry']) {
                    if (strtotime($values['x_date']) < strtotime(date('m/d/Y'))) {
                        $days = "Expired";
                    } else {
                        $days = $days . " days";
                    }
                    $values['diff'] = $days;
                    array_push($items, $values);
                }
            }
        }
        else if($status == 1){
            foreach ($items_exp as $values) {
                $x_date = new DateTime($values['x_date']);
                $diff = $x_date->diff($today);
                $days = $diff->format('%a');
                if ($values['qty'] > 0 && $days < $values['expiry']) {
                    if (strtotime($values['x_date']) < strtotime(date('m/d/Y'))) {
                        $days = "Expired";
                        $values['diff'] = $days;
                        array_push($items, $values);
                    } 
                  
                }
            }
        } else if($status == 2){
            foreach ($items_exp as $values) {
                $x_date = new DateTime($values['x_date']);
                $diff = $x_date->diff($today);
                $days = $diff->format('%a');
                if ($values['qty'] > 0 && $days < $values['expiry']) {
                    if (strtotime($values['x_date']) > strtotime(date('m/d/Y'))) {
                        $days = $days . " days";
                        $values['diff'] = $days;
                        array_push($items, $values);
                    } 
                  
                }
            }

        }
      
           
        
        $total_records =count($items);
        $response = array(
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $items
        );

      
        $this->output
        ->set_content_type('application/json')
        ->set_output(json_encode($response));

        
    }
    public function moveExpired($id){
        $moveItems = $this->PharmacyModel->moveExpireItems($id);
        if($moveItems){
            echo json_encode('true');
        }else{
            echo json_encode('false');
        }
    }
    public function low_quantity_list()
    {
        $list = $this->quantity_model->get_datatables();
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $bill) {
            $no++;
            $row = array();
            $row[] = $bill->drugs_code;
            $row[] = $bill->drug_name;
            $row[] = $bill->quantity;

            //add html for action
            // $row[] = '<a class="btn btn-sm btn-info" href="javascript:void(0)" title="Edit" onclick="pay_bill('."'".$bill->bill_id."'".')">Inquire</a>';
            $row[] = "<a class='btn btn-sm btn-dark' href='" . site_url('admin/Pharmacy/PharmacyController/inquire') . "'>Inquire</a>";

            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->quantity_model->count_all(),
            "recordsFiltered" => $this->quantity_model->count_filtered(),
            "data" => $data,
        );
        //output to json format
        echo json_encode($output);
    }

    public function items()
    {

        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 27;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $data['dataList'] = $this->PaymentsModel->getPaymentsList();
        $data['expiry'] = $this->expiry();

        $this->load->view('admin/Pharmacy/Store/items', $data);
    }
    public function inquire() {
       
            $msg = '';
            $items_model = $this->items_model;
            $supplier = $this->input->post('supplier');
            $supplier_edit = $this->input->post('supplier_edit');
            $items = $this->input->post('items');
            $quantity = $this->input->post('quantity');
            $inq_date = $this->input->post('inq_date');
            $inq_date_edit = $this->input->post('inq_date_edit');
            $check_edit = $this->input->post('check_edit');
            if($check_edit == null){
                if ($supplier && $items && $quantity) {
                    $ret = 0;
                    $x = count($quantity);
                    $set = array('supplier_id' => $supplier,'inquiry_date' => $inq_date);
                    $inquiry_id = $items_model->add_inquiry($set);
                    if ($inquiry_id > 0) {
                        for ($i = 0; $i < $x; $i++) {
                            $get_items = array('item_id' => $items[$i], 'quantity' => $quantity[$i], 'inquiry_id' => $inquiry_id);
                            $ret+= $items_model->add_inquiry_items($get_items);
                        }
                    }
                    ($ret >= 1) ? $msg = '<div class="alert alert-success">Inquiry Added Successfully.</div>' : $msg = '<div class="alert alert-danger">Inquiry Not Added.</div>';
                }
            }else{
                if ($supplier_edit && $items && $quantity) {
                    $ret = 0;
                    $x = count($quantity);
                    $set = array('supplier_id' => $supplier_edit,'inquiry_date' => $inq_date_edit);
                    $this->db->where('inquiry_id', $check_edit);
                    $this->db->update('sh_inquiry', $set);
                    $this->db->delete('sh_inquiry_items', array('inquiry_id' => $check_edit)); 
                    if ($check_edit > 0) {
                        for ($i = 0; $i < $x; $i++) {
                            $get_items = array('item_id' => $items[$i], 'quantity' => $quantity[$i], 'inquiry_id' => $check_edit);
                            $ret+= $items_model->add_inquiry_items($get_items);
                        }
                    }
                    ($ret >= 1) ? $msg = '<div class="alert alert-success">Inquiry Updated Successfully.</div>' : $msg = '<div class="alert alert-danger">Inquiry Not Added.</div>';
                }
            }
            $data['msg'] = $msg;
            $data['title'] = 'Pharmacy Store ::: Hospital Management Software';
            $data['page_header'] = 'Purchase Order';
            $this->load->view('admin/Pharmacy/Store/Inquiry', $data);
            // $this->load->view('email_form', $data);

    
    }
    public function returnBill()
    {

        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 27;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $data['dataList'] = $this->PaymentsModel->getPaymentsList();
        $data['expiry'] = $this->expiry();

        $this->load->view('admin/Pharmacy/Store/returnBill', $data);
    }
   



    public function drugs()
    {
        //Load our library EditorLib 
        $this->load->library('EditorLib');

        //`Call the process method to process the posted data
        $this->editorlib->process($_POST);
    }

    public function category()
    {
        $this->load->library('EditorLib');
        $this->editorlib->process_category($_POST);
    }

    public function location()
    {
        $this->load->library('EditorLib');
        $this->editorlib->process_location($_POST);
    }

    public function brand()
    {
        $this->load->library('EditorLib');
        $this->editorlib->process_brand($_POST);
    }

    public function supplier_json()
    {
        $search = $_GET['search'];
        $result = $this->supplier_model->search_json($search);
        $data = array();
        if (is_array($result)) {
            foreach ($result as $value) {
                array_push($data, $value['supplier_id'] . ' ||| ' . $value['supplier_name']);
            }
        }
        echo json_encode($data);
    }
    
	public function inquiry_list()
	{
		$list = $this->inquiry_model->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $inquiry) {
			$no++;
			$row = array();
			$row[] = $inquiry->inquiry_id;
			$row[] = $inquiry->inquiry_date;
			$row[] = $inquiry->supplier_name;
			$row[] = $inquiry->mobile;

			//add html for action
			$row[] = '<a class="btn btn-sm btn-light" href="javascript:void(0)" title="Edit" onclick="view_inquiry('."'".$inquiry->inquiry_id."'".')"><i class="fa fa-eye"></i></a>
				<a class="btn btn-sm btn-light" href="javascript:void(0)" title="Edit" onclick="edit_inquiry('."'".$inquiry->inquiry_id."'".')"><i class="fa fa-pencil"></i></a>
				  <a class="btn btn-sm btn-light" href="'.site_url("email/send_mail")."/".$inquiry->inquiry_id.'" title="Mail"><i class="fa fa-envelope"></i></a>
				   <a class="btn btn-sm btn-danger" href="javascript:void(0)" title="Delete" onclick="delete_inquiry('."'".$inquiry->inquiry_id."'".')"><i class="fa fa-trash"></i></a>';
		
			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->inquiry_model->count_all(),
						"recordsFiltered" => $this->inquiry_model->count_filtered(),
						"data" => $data,
				);
		//output to json format
		echo json_encode($output);
	}
    
    public function ajax_delete($id)
	{
		$this->inquiry_model->delete_by_id($id);
		echo json_encode(array("status" => TRUE));
	}
    public function ajax_edit($id)
	{
		$data = $this->inquiry_model->get_by_id($id);

		echo json_encode($data);
	}
    public function ajax_view($id)
	{
		$HTML = "";
		$data = $this->inquiry_model->get_by_id_view($id);
		$num=1;
				if(isset($data) and $data != null){
	            	foreach($data as $val){
		$HTML .= "<tr>
					  <td>".$num."</td>
					  <td>".$val['drug_name']."</td>
					  <td>".$val['quantity']."</td>
				  </tr>";
				  $num++;
	            	}
	            }

		echo $HTML;
	}
    public function ajax_update($id)
	{
		$HTML = "";
		$data = $this->inquiry_model->get_by_id_view($id);
		$num=1;
				if(isset($data) and $data != null){
	            	foreach($data as $val){
		$HTML .= "<tr id='".$val['item_id']."'>
					  <td><button id='r".$val['item_id']."' class='btn btn-sm delete_row btn-danger'><span class='fa fa-trash'></span></button></td>
					  <td>".$val['drug_name']."</td>
					  <td id='q".$val['item_id']."'>".$val['quantity']."</td>
				  </tr>";
				  $num++;
	            	}
	            }

		echo $HTML;
	}


    public function items_json()
    {
        $search = $_GET['search'];
        $result = $this->items_model->search_json($search);
        $data = array();
        if (is_array($result)) {
            foreach ($result as $value) {
                array_push($data, $value['drug_id'] . ' ||| ' . $value['drugs_code'] . ' ||| ' . $value['drug_name']);
            }
        }
        echo json_encode($data);
    }

    public function category_list()
    {

        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 27;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $this->load->view('admin/Pharmacy/Store/categories', $data);
    }

    public function locations_list()
    {

        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 27;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $this->load->view('admin/Pharmacy/Store/locations', $data);
    }

    public function brands()
    {

        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 27;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $this->load->view('admin/Pharmacy/Store/brands', $data);
    }

    public function expired()
    {

        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 27;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);
        $data['expiredItems'] = $this->PharmacyModel->countExpired();

        $this->load->view('admin/Pharmacy/Store/expired', $data);
    }
   
    public function statements()
    {
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 27;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $this->load->view('admin/Pharmacy/POS/statements', $data);
    }

    public function search_bill() {
        $search = $_GET['search'];
        $result = $this->items_model->search_bill($search);
        $data = array();
        if (is_array($result)) {
            foreach ($result as $value) {
                array_push($data, $value['bill_id'] . ' ||| ' . $value['drug_name'] . ' ||| ' . $value['batch'] . ' ||| ' . $value['supplier_name']);
            }
        }
        echo json_encode($data);
    }

    public function returnItemProvider($bill_id = 0)
    {
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 27;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);
        
        
        $msg = '';
        $data['result'] = FALSE;

        $refund_bill = $this->input->post('bill');
        $refund_amount = $this->input->post('amount');
        $refund_type = $this->input->post('type');

        $items = $this->input->post('items');
        $r_bill = $this->input->post('r_bill');
        $batchs = $this->input->post('batch');
        $qty = $this->input->post('qty');
        $cost = $this->input->post('cost');
        $user_id = $this->session->userdata('user_Id');

       
        if ($refund_bill) {
            $table = 'sh_return_stock';
            $refund_data = array('bill_id' => $refund_bill, 'amount' => $refund_amount, 'user_id' => $user_id, 'type' => $refund_type);
            $refund_id = $this->supplier_model->insert_record($table, $refund_data);
            $items_table = 'sh_return_stock_items';
            for ($i = 0; $i < count($items); $i++) {
                $items_array = array(
                    'return_stock_id' => $refund_id,
                    'item_id' => $items[$i],
                    'batch' => $batchs[$i],
                    'quantity' => $qty[$i],
                    'cost' => $cost[$i]
                );
                $this->supplier_model->insert_record($items_table, $items_array);
                $qtys = $this->ConfigurationRetriveModel->get_row_data('sh_drugs', 'drug_id', $items[$i]);
                $tot_qty = $qtys->quantity - $qty[$i];
                $set = array('quantity' => $tot_qty);
                $this->db->where('drug_id', $items[$i]);
                $this->db->update('sh_drugs', $set);
                $qtys = $this->ConfigurationRetriveModel->get_row_data('sh_receive_bill_items', 'bill_items_id', $r_bill[$i]);
                $tot_qty = $qtys->remaining - $qty[$i];
                $set = array('remaining' => $tot_qty);
                $this->db->where('bill_items_id', $r_bill[$i]);
                $this->db->update('sh_receive_bill_items', $set);
            }
            // $y = 0;
            // if ($refund_type = 'account') {
            //     $table = 'sh_bill_paid';
            //     $payment = array('bill_id' => $refund_bill, 'payment_id' => 0, 'paid_amount' => $refund_amount);
            //     $y = $this->supplier_model->insert_record($table, $payment);
            // } else {
            //     $table = 'sh_refund';
            //     $payment = array('return_stock_id' => $refund_id, 'type' => $refund_type, 'amount' => $refund_amount);
            //     $y = $this->supplier_model->insert_record($table, $payment);
            // }
            // ($y != 0) ? $msg = '<div class="alert alert-success">Items Returned Successfully.</div>' : $msg = '<div class="alert alert-danger">Some Problem Occured in Refund.</div>';
            ($refund_id != 0) ? $msg = 'Items Returned Successfully' : $msg = 'Some Problem Occured in Refund';
            ($refund_id != 0) ? $type = 'success' : $type = 'error';
            $this->session->set_flashdata($type, $msg);
            redirect('admin/Pharmacy/PharmacyController/returnItemProvider', 'refresh');
        } else {

            $bill = $this->input->post('search');
            if ($bill || $bill_id != 0) {
                $bill_id = ($bill) ? $bill : $bill_id;
                $result = $this->items_model->get_return_bill_items($bill_id);
            }
          
            
            if (isset($result) && is_array($result) && count($result) > 0) {
                $data['result'] = TRUE;
                $data['items'] = $result;
                $bill_data = $this->supplier_model->get_bill($bill_id);

               
                foreach ($bill_data as $value) {
                    $supplier = $value['supplier_id'];
                    $data['bill'] = $value['bill_id'];
                    $data['supplier'] = $value['supplier_name'];
                    $data['date'] = $value['receive_date'];
                    $data['status'] = ($value['amount'] > $value['paid_amount']) ? 'Not Paid' : 'Paid';
                    $data['amount'] = $value['amount'];
                    $data['paid'] = $value['paid_amount'];
                }
                if ($supplier) {
                    $supplier_data = $this->supplier_model->supplier_account($supplier);
                    foreach ($supplier_data as $values) {
                        $data['account'] = $values['amount'] - $values['paid'];
                    }
                }
            }
         
            
            $data['purchase_return'] = $this->PharmacyModel->purchase_return_list();
            $data['bill_data'] =$bill_data;
            
            $this->load->view('admin/Pharmacy/Supplier/returnItemProvider', $data);
        }
    }


    public function returnItem()
    {
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 27;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $this->load->view('admin/Pharmacy/POS/returnItems', $data);
    }
    public function returnSaleItems() {
     
            $data['title'] = 'Pharmacy Store ::: Hospital Management Software';
            $data['page_header'] = 'Return Item Wise';
            $data['sales_return'] = $this->ConfigurationRetriveModel->sales_return_list();

            $this->load->view('admin/Pharmacy/POS/returnItems', $data);
        
    }
    public function insert_return_items()
    {
       
            $data['title'] = 'Pharmacy Store ::: Hospital Management Software';
            $data['page_header'] = 'Transfer Items';

            $drug_qty = $this->input->post('drug_qty');
            $drug_id = $this->input->post('drug_id');
            $bill_id = $this->input->post('bill_id');
            $batch = $this->input->post('batch');
            $drug_cost = $this->input->post('drug_cost');
            $user_id = $this->session->userdata('user_Id');
            

            $supplier_id = $this->input->post('supplier_id');
            $item_return_date = $this->input->post('item_return_date');

            date_default_timezone_set('Asia/Kuwait');
            $date_string = '%Y-%m-%d %H:%i';
            $curr_date = mdate($date_string);
            $curr_time = date("H:i");

            if (is_array($drug_id)) {
                $total='';
                for ($i=0; $i <count($drug_id) ; $i++) {
                    $total += $drug_cost[$i]*$drug_qty[$i];
                }
            }

            $newdata = array(
               'amount' => $total,
               'return_date' => $item_return_date.' '.$curr_time,
               'type' => "cash",
               'supplier_id' => $supplier_id,
               'user_id'  => $user_id
            );

            $return_stock_id = $this->ConfigurationRetriveModel->get_id_insert('sh_return_stock', $newdata);

            if (is_array($drug_id)) {
                for ($i=0; $i <count($drug_id) ; $i++) {

                    $newdata = array(
                       'return_stock_id' => $return_stock_id,
                       'item_id' => $drug_id[$i],
                       'batch' => $batch[$i],
                       'quantity' => $drug_qty[$i],
                       'cost' => $drug_cost[$i],
                       'bills_id' => $bill_id[$i],
                    );

                    $this->ConfigurationRetriveModel->get_id_insert('sh_return_stock_items', $newdata);

                    //add sh_drugs
                    $result = $this->ConfigurationRetriveModel->get_row_data('sh_drugs', 'drug_id', $drug_id[$i]);
                    $newData = array(
                        'quantity' => $result->quantity - $drug_qty[$i],
                    );
                    $this->ConfigurationRetriveModel->update_data('sh_drugs','drug_id',$drug_id[$i],$newData);

                    //add sh_receive_bill_items
                    $result = $this->ConfigurationRetriveModel->receive_bill_add($bill_id[$i],$drug_id[$i]);
                    $newData = array(
                        'remaining' => $result->remaining - $drug_qty[$i],
                    );
                    $this->ConfigurationRetriveModel->update_data('sh_receive_bill_items','bill_items_id',$result->bill_items_id,$newData);

                }                           
            }

            $data['alert_msg'] = '';
            $data['error'] = '';
            $success = 'The Items is returned successfully!';

            $data['purchase_return'] = $this->ConfigurationRetriveModel->purchase_return_list();
            $data['supplier_list'] = $this->ConfigurationRetriveModel->retrieve_data('sh_supplier');
            $this->session->set_flashdata('success', $success);
          
            redirect('admin/Pharmacy/PharmacyController/returnItems', 'refresh');

        
    }
    public function insert_sales_return_items()
    {
     
            $data['title'] = 'Pharmacy Store ::: Hospital Management Software';
            $data['page_header'] = 'Transfer Items';

            $drug_qty = $this->input->post('drug_qty');
            $drug_id = $this->input->post('drug_id');
            $bill_id = $this->input->post('bill_id');
            $sell_bill_id = $this->input->post('sell_bill_id');
            $batch = $this->input->post('batch');
            $drug_cost = $this->input->post('drug_cost');

            $user_id = $this->session->userdata('user_Id');

            date_default_timezone_set('Asia/Kuwait');
            $date_string = '%Y-%m-%d';
            $curr_date = mdate($date_string);

            $newdata = array(
               'return_date' => $curr_date,
               'user_id'  => $user_id,
                'sell_bill_id'=>$sell_bill_id[0],
            );
        
            $return_sale_id = $this->ConfigurationRetriveModel->get_id_insert('sh_return_sale', $newdata);

            if (is_array($drug_id)) {
                for ($i=0; $i <count($drug_id) ; $i++) {

                    $newdata = array(
                       'return_sale_id' => $return_sale_id,
                       'item_id' => $drug_id[$i],
                       'batch' => $batch[$i],
                       'qty' => $drug_qty[$i],
                       'sell_price' => $drug_cost[$i],
                       'sell_bills_id' => $bill_id[$i],
                    );

                    $sellbill_data = $this->ConfigurationRetriveModel->get_row_data('sh_sell_bill', 'sell_bill_id', $sell_bill_id[$i]);
                    $amount= (int)$drug_qty[$i] * (int)$drug_cost[$i];
                    $newData = array(
                        'amount' => $sellbill_data->amount - $amount ,
                    );
                    

                    $this->ConfigurationRetriveModel->update_data('sh_sell_bill','sell_bill_id',$sell_bill_id[$i],$newData);

                    $sellbill_items = $this->ConfigurationRetriveModel->get_row_data('sh_sell_bill_items', 'sell_bill_id', $sell_bill_id[$i]);
                    $bill_qty=$sellbill_items->qty - $drug_qty[$i];
                    if($sellbill_items->qty > 0){
                        $newData = array(
                            'qty' =>  $bill_qty,
                        );

                        
                    $this->ConfigurationRetriveModel->update_data('sh_sell_bill_items','sell_bill_id',$sell_bill_id[$i],$newData);
                    }else{
                        $this->ConfigurationRetriveModel->data_delete_other('sh_sell_bill_items','sell_bill_id',$sell_bill_id[$i]);
                        $this->ConfigurationRetriveModel->data_delete_other('sh_sell_bill','sell_bill_id',$sell_bill_id[$i]);
                        $data['sales_return'] = $this->ConfigurationRetriveModel->sales_return_list();

                        $success = 'This Bill is Empty!';
                        $this->session->set_flashdata('error', $success);
                    
                        redirect('admin/Pharmacy/PharmacyController/returnSaleItems', 'refresh'); 
                    }
                   


                    $this->ConfigurationRetriveModel->get_id_insert('sh_return_sale_items', $newdata);

                    //add sh_drugs
                    $result = $this->ConfigurationRetriveModel->get_row_data('sh_drugs', 'drug_id', $drug_id[$i]);
                    $newData = array(
                        'quantity' => $result->quantity + $drug_qty[$i],
                    );
                    $this->ConfigurationRetriveModel->update_data('sh_drugs','drug_id',$drug_id[$i],$newData);

                    //add sh_receive_bill_items

                    $result = $this->ConfigurationRetriveModel->get_row_data('sh_receive_bill_items', 'bill_items_id', $bill_id[$i]);
                   
                    $newData = array(
                        'remaining' => $result->remaining + $drug_qty[$i],
                    );
                    $this->ConfigurationRetriveModel->update_data('sh_receive_bill_items','bill_items_id',$result->bill_items_id,$newData);
                    
                }                           
            }

            $data['alert_msg'] = '';
            $data['error'] = '';
            $success = 'The Items is returned successfully!';

            $data['sales_return'] = $this->ConfigurationRetriveModel->sales_return_list();
            $this->session->set_flashdata('success', $success);
         
            redirect('admin/Pharmacy/PharmacyController/returnSaleItems', 'refresh');
          
        
    }

    public function update_return_sale_items()
    {
        if ($this->session->userdata('emp_name')=='') {
            redirect(site_url());
        }else{
            $data['title'] = 'Pharmacy Store ::: Hospital Management Software';
            $data['page_header'] = 'Transfer Items';

            $drug_qty = $this->input->post('drug_qty');
            $drug_id = $this->input->post('drug_id');
            $bill_id = $this->input->post('bill_id');
            $batch = $this->input->post('batch');
            $drug_cost = $this->input->post('drug_cost');

            $return_sale_id = $this->input->post('return_sale_id');

            $user_id = $this->session->userdata('user_id');

            date_default_timezone_set('Asia/Kuwait');
            $date_string = '%Y-%m-%d';
            $curr_date = mdate($date_string);

            $newdata = array(
               'return_date' => $curr_date,
               'user_id'  => $user_id
            );

            $this->insert_process->update_data('sh_return_sale','return_sale_id',$return_sale_id,$newdata);

            //delete
            $results = $this->retrive_process->retrieve_data_unique('sh_return_sale_items', 'return_sale_id', $return_sale_id);

            foreach ($results as $value) {
           
                //add sh_drugs
                $result = $this->retrive_process->get_row_data('sh_drugs', 'drug_id', $value['item_id']);
                $newData = array(
                    'quantity' => $result->quantity - $value['qty'],
                );
                $this->insert_process->update_data('sh_drugs','drug_id',$value['item_id'],$newData);

                //add sh_receive_bill_items
                $result = $this->retrive_process->get_row_data('sh_receive_bill_items', 'bill_items_id', $value['sell_bills_id']);
                $newData = array(
                    'remaining' => $result->remaining - $value['qty'],
                );
                $this->insert_process->update_data('sh_receive_bill_items','bill_items_id',$result->bill_items_id,$newData);

            }
            $this->retrive_process->data_delete_other('sh_return_sale_items', 'return_sale_id', $return_sale_id);


            if (is_array($drug_id)) {
                for ($i=0; $i <count($drug_id) ; $i++) {

                    $newdata = array(
                       'return_sale_id' => $return_sale_id,
                       'item_id' => $drug_id[$i],
                       'batch' => $batch[$i],
                       'qty' => $drug_qty[$i],
                       'sell_price' => $drug_cost[$i],
                       'sell_bills_id' => $bill_id[$i],
                    );

                    $this->insert_process->get_id_insert('sh_return_sale_items', $newdata);

                    //add sh_drugs
                    $result = $this->retrive_process->get_row_data('sh_drugs', 'drug_id', $drug_id[$i]);
                    $newData = array(
                        'quantity' => $result->quantity + $drug_qty[$i],
                    );
                    $this->insert_process->update_data('sh_drugs','drug_id',$drug_id[$i],$newData);

                    //add sh_receive_bill_items
                    $result = $this->retrive_process->get_row_data('sh_receive_bill_items', 'bill_items_id', $value['sell_bills_id']);
                    $newData = array(
                        'remaining' => $result->remaining + $drug_qty[$i],
                    );
                    $this->insert_process->update_data('sh_receive_bill_items','bill_items_id',$result->bill_items_id,$newData);

                }                           
            }

            $data['alert_msg'] = '';
            $data['error'] = '';
            $data['success'] = 'The Items is updated successfully!';

            $data['sales_return'] = $this->retrive_process->sales_return_list();

            $this->load->view('pharmacy/store/return_sales_item', $data);

        }
    }
    public function supplier_list() {
       
            $data['title'] = 'Pharmacy Store ::: Hospital Management Software';
            $data['page_header'] = 'Add / Edit Supplier';

            $this->load->view('admin/Pharmacy/Supplier/viewSupplier', $data);
        
    }
    public function suppliers()
	{	
		$this->load->library('EditorLib');
		$this->editorlib->process_supplier($_POST);
	}
    public function POS()
    {
       
        $patient = $this->input->post('patient');
        $type = $this->input->post('type');
        $total = $this->input->post('paid_amount');
        $items = $this->input->post('items');
        $item_name = $this->input->post('item_name');
        $batchs = $this->input->post('batch');
        $r_bill = $this->input->post('r_bill');
        $qty = $this->input->post('quantity');
        $discount = $this->input->post('discount');
        $prices = $this->input->post('price');
        $pres = $this->input->post('pres');
        $in_out = $this->input->post('in_or_out');
        $user_id = $this->session->userdata('user_Id');

        $doctor_id = $this->input->post('doctor_id');
        $percentage = $this->input->post('percentage');
        $total_amount = $this->input->post('V');

        $bill_date = $this->input->post('bill_date');

        $paid_amount = $this->input->post('paid_amount');
        $paid_cash = $this->input->post('paid_cash');
        $paid_card = $this->input->post('paid_card');

        $valid_loose = $this->input->post('valid_loose');

        date_default_timezone_set('Asia/Kuwait');
        $date_string = '%Y-%m-%d %H:%i';
        $curr_date = mdate($date_string);
        $curr_time = date("H:i");
        $print = $this->input->post('print');
        // $data['doctor_list'] = $this->report_retrive->get_doctors();



        try {
            if ($total) {
            
                
                $this->db->trans_start();
                $bill_id = $this->PharmacyModel->insert_data('sh_sell_bill', array('amount' => $total, 'user_id' => $user_id, 'in_or_out' => $in_out[0], 'sell_date' =>  $curr_date, 'type' => $type, 'sell_time' => $curr_time, 'prescription_id' => $pres));
                for ($i = 0; $i < count($items); $i++) {
                    $bill_items = array(
                        'item_id' => $items[$i],
                        'batch' => $batchs[$i],
                        'qty' => $qty[$i],
                        'discount' => $discount[$i],
                        'sell_price' => $prices[$i],
                        'r_bill' => $r_bill[$i],
                        'sell_bill_id' => $bill_id
                    );
                    $this->PharmacyModel->insert_data('sh_sell_bill_items', $bill_items);
                    $this->PharmacyModel->update_data('tbl_prescription_main', 'prescription_main_id', $pres, array('status' => 0));
                    $qtys = $this->PharmacyModel->retrieve_data_unique('sh_drugs', 'drug_id', $items[$i]);
                    $remain_qtys = $this->PharmacyModel->retrieve_data_unique('sh_receive_bill_items', 'bill_items_id', $r_bill[$i]);
                 
                  
                    if (empty($valid_loose[$i])) {
                        $tot_qty = $qtys->quantity - $qty[$i];
                        $set = array('quantity' => $tot_qty);
                        $remain_tot_qty = $remain_qtys[$i]['remaining'] - $qty[$i];
                        $remain_set = array('remaining' => $remain_tot_qty);
                    } else {
                        if (is_array($valid_loose)) {
                            if ($valid_loose[$i] > 0) {
                                $total_loose = $qty[$i] * $valid_loose[$i];
                                $tot_qty = $qtys->quantity - $total_loose;
                                $set = array('quantity' => $tot_qty);

                                $remain_tot_qty = $remain_qtys->remaining - $total_loose;
                                $remain_set = array('remaining' => $remain_tot_qty);
                            } else {
                                $tot_qty = $qtys->quantity - $qty[$i];
                                $set = array('quantity' => $tot_qty);

                                $remain_tot_qty = $remain_qtys->remaining - $qty[$i];
                                $remain_set = array('remaining' => $remain_tot_qty);
                            }
                        } else {
                            $tot_qty = $qtys->quantity - $qty[$i];
                            $set = array('quantity' => $tot_qty);

                            $remain_tot_qty = $remain_qtys->remaining - $qty[$i];
                            $remain_set = array('remaining' => $remain_tot_qty);
                        }
                    }
                    //$tot_qty = $qtys->quantity - $qty[$i];
                    //$set = array('quantity' => $tot_qty);
                    $this->db->where('drug_id', $items[$i]);
                    $this->db->update('sh_drugs', $set);


                    $this->db->where('bill_items_id', $r_bill[$i]);
                    $this->db->update('sh_receive_bill_items', $remain_set);
                }
                // if ($type == 'credit') {
                //     $id = $this->PharmacyModel->insert_data('sh_sell_bill_credit', array('bill_id' => $bill_id, 'patient_id' => $patient));
                //     ($id > 0) ? $msg = '<div class="alert alert-success">POS Bill Added Successfully.</div>' : $msg = '<div class="alert alert-danger">Bill Not Added.</div>';
                // } 
                if ($type == 'cash_card') {
                    $payment_id = $this->PharmacyModel->insert_data('sh_sell_bill_payment', array('amount' => $paid_cash, 'type' => 'cash', 'user_id' => $user_id, 'payment_date' => date('Y-m-d', strtotime(str_replace('/', '-', $bill_date)))));
                    $id = $this->PharmacyModel->insert_data('sh_sell_bill_paid', array('payment_id' => $payment_id, 'bill_id' => $bill_id, 'paid_amount' => $paid_cash, 'patient_id' => $patient));

                    $payment_id = $this->PharmacyModel->insert_data('sh_sell_bill_payment', array('amount' => $paid_card, 'type' => 'card', 'user_id' => $user_id, 'payment_date' => date('Y-m-d', strtotime(str_replace('/', '-', $bill_date)))));
                    $id = $this->PharmacyModel->insert_data('sh_sell_bill_paid', array('payment_id' => $payment_id, 'bill_id' => $bill_id, 'paid_amount' => $paid_card, 'patient_id' => $patient));
                } else {
                    $payment_id = $this->PharmacyModel->insert_data('sh_sell_bill_payment', array('amount' => $paid_amount, 'type' => $type, 'user_id' => $user_id, 'payment_date' => date('Y-m-d', strtotime(str_replace('/', '-', $bill_date)))));
                    $id = $this->PharmacyModel->insert_data('sh_sell_bill_paid', array('payment_id' => $payment_id, 'bill_id' => $bill_id, 'paid_amount' => $paid_amount, 'patient_id' => $patient));
                    ($id > 0) ? $msg = '<div class="alert alert-success">POS Bill Added Successfully.</div>' : $msg = '<div class="alert alert-danger">Bill Not Added.</div>';
                }
                if ($this->db->trans_status() === FALSE) {
                    $this->db->trans_rollback();
                } else {
                    $this->db->trans_commit();
                }
                if($print ==0){
                    $this->session->set_flashdata('success', 'Bill Created Successfully.');
                    redirect('admin/Pharmacy/PharmacyController/statements', 'refresh');
                }else if($print ==1){
                    $this->session->set_flashdata('success', 'Bill Created Successfully.');
                    redirect('admin/Pharmacy/PharmacyController/thermalPrint/'.$bill_id, 'refresh');
                }
               
            } else {

                // $this->session->set_flashdata('error', 'Please Provide total to procceed!');
                $this->load->view('admin/Pharmacy/POS/posBill');
            }
        } catch (Exception $e) {
            $this->db->trans_rollback();
            echo $e;
            exit;
        }
    }


    public function search_stock_items()
    {
        $search = $_GET['search'];
        $result = $this->items_model->search_stock_items($search);
       
        $data = array();
        if (is_array($result)) {
            foreach ($result as $value) {
                array_push($data, $value['bill_items_id'] . ' ||| ' . $value['drugs_code'] . ' ||| ' . html_entity_decode($value['drug_name']) . ' ||| ' . $value['batch'] . ' ||| ' . $value['x_date'] . ' ||| ' . $value['price'] . ' ||| ' . $value['drug_id'] . ' ||| ' . $value['loose'] . ' ||| ' . $value['remaining'] . ' ||| ' . $value['loose_active'] . ' ||| ' . $value['quantity']);
            }
        }
        echo json_encode($data);
    }
    public function search_stock_items_return()
    {
        $search = $_GET['search'];
        $result = $this->items_model->search_sale_items($search);
        
        $data = array();
        if (is_array($result)) {
            foreach ($result as $value) {
                array_push($data, $value['bill_items_id'] . ' ||| ' . $value['drugs_code'] . ' ||| ' . html_entity_decode($value['drug_name']) . ' ||| ' . $value['batch'] . ' ||| ' . $value['x_date'] . ' ||| ' . $value['price'] . ' ||| ' . $value['drug_id'] . ' ||| ' . $value['loose'] . ' ||| ' . $value['remaining'] . ' ||| ' . $value['loose_active'] . ' ||| ' . $value['quantity']);
            }
        }
        echo json_encode($data);
    }
    public function search_pharmacy_bill()
    {
        $search = $_GET['search'];
        $result = $this->items_model->search_pharmacy_bill($search);
        $data = array();
        if (is_array($result)) {
            foreach ($result as $value) {
                array_push($data, $value['bill_id'] . ' ||| ' . $value['bill_amount'] . ' ||| ' . html_entity_decode($value['type']) );
            }
        }
        echo json_encode($data);
    }

    public function patientsStatements()
    {
        $list = $this->statement_model->get_datatables();
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $bill) {
            $no++;
            $row = array();
            /* <a href="<?php $this->load->helper('url'); echo site_url('pharmacy/patientStatement_view/'.$value['sell_bill_id']);?>"><?php echo $value['sell_bill_id'];?></a> */
            $row[] = "<a href='" . site_url('pharmacy/patientStatement_view') . "/" . $bill->sell_bill_id . "'>" . $bill->sell_bill_id . "</a>";
            // $row[] = $bill->sell_bill_id;
            $row[] = $bill->sell_date;
            $row[] = $bill->full_name;
            $row[] = $bill->amount;

            $row[] = "<a class='btn btn-sm btn-dark' title='Edit' href='" . site_url('admin/Pharmacy/PharmacyController/posBillEdit') . "/" . $bill->sell_bill_id . "'><i class='ri-edit-line'></i>Edit</a> 
            <a class='btn btn-sm btn-dark text-light' title='Delete' onclick='delete_row(".$bill->sell_bill_id.")'><i class='ri-delete-bin-line'></i>Delete</a> 
            <a target='_blank' class='btn btn-sm btn-dark' title='Print' href='" . site_url('admin/Pharmacy/PharmacyController/thermalPrint') . "/" . $bill->sell_bill_id . "'><i class='ri-printer-line'></i>Print</a>";
            // 	  <a class="btn btn-sm btn-danger" href="javascript:void(0)" title="Delete" onclick="delete_bill('."'".$bill->sell_bill_id."'".')">Delete</a>';
            // $row[] = '<a class="btn btn-sm btn-primary" href="javascript:void(0)" title="Edit" onclick="edit_bill('."'".$bill->sell_bill_id."'".')">Edit</a>

            //add html for action
            // $row[] = '<a class="btn btn-sm btn-info" href="javascript:void(0)" title="Edit" onclick="pay_bill('."'".$bill->bill_id."'".')">Inquire</a>';
            // $row[] = "<a class='btn btn-info' href='".site_url('pharmacy/inquire')."'>Inquire</a>";

            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->statement_model->count_all(),
            "recordsFiltered" => $this->statement_model->count_filtered(),
            "data" => $data,
        );
        //output to json format
        echo json_encode($output);
    }


    public function posBillEdit($id)
    {

        $msg = '';

        $patient = $this->input->post('patient');
        $type = $this->input->post('type');
        $total = $this->input->post('total');
        $items = $this->input->post('items');
        $batchs = $this->input->post('batch');
        $r_bill = $this->input->post('r_bill');
        $qty = $this->input->post('quantity');
        $discount = $this->input->post('discount');
        $prices = $this->input->post('price');
        $pres = $this->input->post('pres');
        $in_out = $this->input->post('in_or_out');
        $user_id = $this->session->userdata('user_Id');

        $doctor_id = $this->input->post('doctor_id');
        $percentage = $this->input->post('percentage');
        $total_amount = $this->input->post('total_amount');

        $bill_date = $this->input->post('bill_date');

        $paid_amount = $this->input->post('paid_amount');
        $paid_cash = $this->input->post('paid_cash');
        $paid_card = $this->input->post('paid_card');

        $bill_id = $this->input->post('bill_id');

        date_default_timezone_set('Asia/Kuwait');
        $date_string = '%Y-%m-%d %H:%i';
        $curr_date = mdate($date_string);

        if ($total) {

            $newData = array(
                'amount' => $total,
                'user_id' => $user_id,
                'in_or_out' => $in_out[0],
                'type' => $type
            );
            $this->PharmacyModel->update_data('sh_sell_bill', 'sell_bill_id', $bill_id, $newData);

            $result = $this->ConfigurationRetriveModel->retrieve_data_unique('sh_sell_bill_items', 'sell_bill_id', $bill_id);
            foreach ($result as $value) {
                $qtys = $this->ConfigurationRetriveModel->get_row_data('sh_drugs', 'drug_id', $value['item_id']);
                $tot_qty = $qtys->quantity + $value['qty'];
                $set = array('quantity' => $tot_qty);
                $this->db->where('drug_id', $value['item_id']);
                $this->db->update('sh_drugs', $set);
                $qtys = $this->ConfigurationRetriveModel->get_row_data('sh_receive_bill_items', 'bill_items_id', $value['r_bill']);
                $tot_qty = $qtys->remaining + $value['qty'];
                $set = array('remaining' => $tot_qty);
                $this->db->where('bill_items_id', $value['r_bill']);
                $this->db->update('sh_receive_bill_items', $set);
            }
            $this->ConfigurationRetriveModel->data_delete_other('sh_sell_bill_items', 'sell_bill_id', $bill_id);

            for ($i = 0; $i < count($items); $i++) {
                $bill_items = array(
                    'item_id' => $items[$i],
                    'batch' => $batchs[$i],
                    'qty' => $qty[$i],
                    'discount' => $discount[$i],
                    'sell_price' => $prices[$i],
                    'r_bill' => $r_bill[$i],
                    'sell_bill_id' => $bill_id
                );
                $this->PharmacyModel->insert_data('sh_sell_bill_items', $bill_items);

                $this->PharmacyModel->update_data('tbl_prescription_main', 'prescription_main_id', $pres, array('status' => 0));
                $qtys = $this->ConfigurationRetriveModel->get_row_data('sh_drugs', 'drug_id', $items[$i]);
                $tot_qty = $qtys->quantity - $qty[$i];
                $set = array('quantity' => $tot_qty);
                $this->db->where('drug_id', $items[$i]);
                $this->db->update('sh_drugs', $set);
                $qtys = $this->ConfigurationRetriveModel->get_row_data('sh_receive_bill_items', 'bill_items_id', $r_bill[$i]);
                $tot_qty = $qtys->remaining - $qty[$i];
                $set = array('remaining' => $tot_qty);
                $this->db->where('bill_items_id', $r_bill[$i]);
                $this->db->update('sh_receive_bill_items', $set);
            }

            if ($type == 'cash_card') {

                $result = $this->ConfigurationRetriveModel->get_payment($id);
                $results = $this->ConfigurationRetriveModel->retrieve_data_unique('sh_sell_bill_paid', 'bill_id', $id);

                $this->ConfigurationRetriveModel->data_delete_other('sh_sell_bill_paid', 'bill_id', $id);

                foreach ($results as $value) {
                    $this->ConfigurationRetriveModel->data_delete_other('sh_sell_bill_payment', 'payment_id', $value['bill_paid_id']);
                }

                $payment_id = $this->PharmacyModel->insert_data('sh_sell_bill_payment', array('amount' => $paid_cash, 'type' => 'cash', 'user_id' => $user_id, 'payment_date' => date('Y-m-d', strtotime(str_replace('/', '-', $bill_date)))));
                $id = $this->PharmacyModel->insert_data('sh_sell_bill_paid', array('payment_id' => $payment_id, 'bill_id' => $bill_id, 'paid_amount' => $paid_cash, 'patient_id' => $patient));

                $payment_id = $this->PharmacyModel->insert_data('sh_sell_bill_payment', array('amount' => $paid_card, 'type' => 'card', 'user_id' => $user_id, 'payment_date' => date('Y-m-d', strtotime(str_replace('/', '-', $bill_date)))));
                $id = $this->PharmacyModel->insert_data('sh_sell_bill_paid', array('payment_id' => $payment_id, 'bill_id' => $bill_id, 'paid_amount' => $paid_card, 'patient_id' => $patient));

                $newData = array(
                    'type' => $type
                );
                $this->PharmacyModel->update_data('sh_sell_bill', 'sell_bill_id', $result[0]['payment_id'], $newData);
            } else {

                $result = $this->PharmacyModel->get_payment($id);
                $results = $this->ConfigurationRetriveModel->retrieve_data_unique('sh_sell_bill_paid', 'bill_id', $id);

                $this->ConfigurationRetriveModel->data_delete_other('sh_sell_bill_paid', 'bill_id', $id);

                foreach ($results as $value) {
                    $this->ConfigurationRetriveModel->data_delete_other('sh_sell_bill_payment', 'payment_id', $value['bill_paid_id']);
                }

                $payment_id = $this->PharmacyModel->insert_data('sh_sell_bill_payment', array('amount' => $paid_amount, 'type' => $type, 'user_id' => $user_id, 'payment_date' => date('Y-m-d', strtotime(str_replace('/', '-', $bill_date)))));
                $id = $this->PharmacyModel->insert_data('sh_sell_bill_paid', array('payment_id' => $payment_id, 'bill_id' => $bill_id, 'paid_amount' => $paid_amount, 'patient_id' => $patient));

                $newData = array(
                    'type' => $type
                );
                $this->PharmacyModel->update_data('sh_sell_bill', 'sell_bill_id', $result[0]['payment_id'], $newData);
            }

            $commission = ($percentage / 100) * $total_amount;
            $newData = array(
                'doctor_id' => $doctor_id,
                'amount' => $total_amount,
                'commission' => $commission
            );
            $this->PharmacyModel->update_data('drugs_commission', 'pos_id', $bill_id, $newData);


            $data['title'] = 'Pharmacy Store ::: Hospital Management Software';
            $data['page_header'] = 'Patient Statement';

            $data['patient_statement'] = $this->ConfigurationRetriveModel->retrieve_data_order('sh_sell_bill', 'sell_bill_id', 'DESC');

            // $data['reciept'] = $this->PharmacyModel->get_reciept($bill_id);
            // $this->load->view('print_pharm', $data);
            $this->session->set_flashdata('success', 'Sale Updated Successfully.');
           redirect('admin/Pharmacy/PharmacyController/statements', 'refresh');
        } else {

            $data['msg'] = $msg;
            $data['title']  = 'Pharmacy Store ::: Hospital Management Software';
            $data['page_header'] = 'POS Bill';

            $data['sell_items'] = $this->PharmacyModel->get_sell_bill_items($id);
            // echo $this->db->last_query();die();
            $data['drugs_com'] = $this->ConfigurationRetriveModel->get_row_data("drugs_commission", "pos_id", $id);
            $data['payment'] = $this->ConfigurationRetriveModel->get_payment($id);
            $data['payments'] = $this->ConfigurationRetriveModel->retrieve_data_unique('sh_sell_bill', 'sell_bill_id', $id);
            $data['bill_id'] = $id;

            //  print_r($data);die;
            
            $this->load->view('admin/Pharmacy/POS/posBillEdit', $data);
        }
    }

    public function deleteStatement($s_id)
    {
        $user_id = $this->session->userdata('user_Id');
        $emp_name = $this->session->userdata('emp_name');

        date_default_timezone_set('Asia/Kuwait');
        $date_string = '%Y-%m-%d';
        $curr_date = mdate($date_string);
        $curr_time = date("H:i");

        $result = $this->ConfigurationRetriveModel->retrieve_data_unique('sh_sell_bill_items', 'sell_bill_id', $s_id);
        foreach ($result as $value) {
            $qtys = $this->ConfigurationRetriveModel->get_row_data('sh_drugs', 'drug_id', $value['item_id']);
            $tot_qty = $qtys->quantity + $value['qty'];
            $set = array('quantity' => $tot_qty);
            $this->db->where('drug_id', $value['item_id']);
            $this->db->update('sh_drugs', $set);
            $qtys = $this->ConfigurationRetriveModel->get_row_data('sh_receive_bill_items', 'bill_items_id', $value['r_bill']);
            $tot_qty = $qtys->remaining + $value['qty'];
            $set = array('remaining' => $tot_qty);
            $this->db->where('bill_items_id', $value['r_bill']);
            $this->db->update('sh_receive_bill_items', $set);
        }

        $result = $this->ConfigurationRetriveModel->retrieve_data_unique('sh_sell_bill_paid', 'bill_id', $s_id);
        foreach ($result as $value) {
            $this->ConfigurationRetriveModel->data_delete_other('sh_sell_bill_payment', 'payment_id', $value['payment_id']);
        }

        $this->ConfigurationRetriveModel->data_delete_other('sh_sell_bill', 'sell_bill_id', $s_id);

        echo json_encode(array("status" => TRUE));
    }

    //STORE STARTS HERE

    public function Purchase()
    {
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 27;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $data['dataList'] = $this->PaymentsModel->getPaymentsList();
        $data['expiry'] = $this->expiry();

        $this->load->view('admin/Pharmacy/Supplier/purchaseBill', $data);
    }


    public function purchaseBill()
    {
        $x = 0;
        $msg = '';
        $supplier = $this->input->post('supplier');
        $amount = $this->input->post('amounts');
        $discount = $this->input->post('discount');
        $invoice_no = $this->input->post('invoice_no');
        if ($amount)
            $ratio = $amount / ($amount + $discount);

        $items = $this->input->post('items');
        $batch = $this->input->post('batchs');
        $xdate = $this->input->post('xdate');
        $quantity = $this->input->post('quantitys');
        $bonus = $this->input->post('bonuses');
        $cost = $this->input->post('cost');
        $bonus_cost = $this->input->post('bonus_cost');
        $discount_cost = $this->input->post('discount_cost');
        $price = $this->input->post('prices');
        $loose = $this->input->post('looses');

        $bill_date = $this->input->post('bill_date');



        $type = $this->input->post('type');
        $payment = $this->input->post('payment');
        $bill_id = $this->input->post('bill_id');
        
        $files = $_FILES;
        $file_exist = $_FILES['userfile']['size'];
        $db_attachment = array();
        $newfilename = null;
        $newfilenamecheck = null;
        if (isset($files) and $files != null) {
            if (array_filter($file_exist)) {

                $this->load->library('upload');

                $cpt = count($_FILES['userfile']['name']);
                $config = array();
                $config['upload_path'] = './'.UPLOAD_PATH.'supplier_bill/';
                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size']      = '3072';
                $config['overwrite']     = TRUE;

                for ($i = 0; $i < $cpt; $i++) {
                    $_FILES['userfile']['name'] = $files['userfile']['name'][$i];
                    $_FILES['userfile']['type'] = $files['userfile']['type'][$i];
                    $_FILES['userfile']['tmp_name'] = $files['userfile']['tmp_name'][$i];
                    $_FILES['userfile']['error'] = $files['userfile']['error'][$i];
                    $_FILES['userfile']['size'] = $files['userfile']['size'][$i];

                    $ext = strtolower(pathinfo($_FILES['userfile']['name'], PATHINFO_EXTENSION));
                    $newfilename = $supplier . '-' . $invoice_no . '.' . $ext;

                    $config['file_name'] = $newfilename;

                    $this->upload->initialize($config);

                    if (!$this->upload->do_upload()) {
                        $data['alert_msg'] = '';
                        $data['error'] = $this->upload->display_errors();
                        $data['success'] = '';
                    } else {
                        array_push($db_attachment, $newfilename);
                    }
                }

                //check
                $db_attachment = array();
                $cpt = count($_FILES['checkupload']['name']);
                $config = array();
                $config['upload_path'] = './'.UPLOAD_PATH.'checks/';
                $config['allowed_types'] = 'gif|jpg|png';
                $config['max_size']      = '3072';
                $config['overwrite']     = TRUE;

                for ($i = 0; $i < $cpt; $i++) {
                    $_FILES['checkupload']['name'] = $files['checkupload']['name'][$i];
                    $_FILES['checkupload']['type'] = $files['checkupload']['type'][$i];
                    $_FILES['checkupload']['tmp_name'] = $files['checkupload']['tmp_name'][$i];
                    $_FILES['checkupload']['error'] = $files['checkupload']['error'][$i];
                    $_FILES['checkupload']['size'] = $files['checkupload']['size'][$i];

                    $ext = strtolower(pathinfo($_FILES['checkupload']['name'], PATHINFO_EXTENSION));
                    $newfilenamecheck = $supplier . '-' . $invoice_no . '.' . $ext;

                    $config['file_name'] = $newfilenamecheck;

                    $this->upload->initialize($config);

                    if (!$this->upload->do_upload('checkupload')) {
                        $data['alert_msg'] = '';
                        $data['error'] = $this->upload->display_errors();
                        $data['success'] = '';
                    } else {
                        array_push($db_attachment, $newfilenamecheck);
                    }
                }
            }
        } else {
            // $newfilename = NULL;
        }

        if (is_array($items))
            $x = count($items);
        if ($x > 0) {
            $set_bill = array('supplier_id' => $supplier, 'bill_date' => date('Y-m-d', strtotime(str_replace('/', '-', $bill_date))), 'amount' => $amount, 'discount' => $discount, 'discount_ratio' => $ratio, 'invoice_no' => $invoice_no, 'file_upload' => $newfilename);
            $bill_id = $this->supplier_model->add_bill($set_bill);
            $n = 0;
            for ($i = 0; $i < $x; $i++) {
                if (is_null($loose[$i]) || empty($loose[$i]) || $loose[$i] == 0) {
                    $loose_type = 0;
                } else {
                    $loose_type = 1;
                }
                $date = DateTime::createFromFormat('m/d/Y', $xdate[$i]);
               
                $date = $date->format('Y-m-d');
              
                // $set_items = array(
                //     'bill_id' => $bill_id,
                //     'item_id' => $items[$i],
                //     'batch' => $batch[$i],
                //     'x_date' => $date,
                //     'quantity' => $quantity[$i],
                //     'bonus' => $bonus[$i],
                //     'cost' => $cost[$i],
                //     'bonus_cost' => $bonus_cost[$i],
                //     'discount_cost' => $discount_cost[$i],
                //     'unit_type' => $price[$i],
                //     'loose' => $loose[$i],
                //     'loose_active' => $loose_type,
                //     'remaining' => $quantity[$i]+$bonus[$i]
                // );
                // $n+= $this->items_model->add_bill_items($set_items);

                if (is_null($loose[$i]) || empty($loose[$i]) || $loose[$i] == 0) {
                    $set_items = array(
                        'bill_id' => $bill_id,
                        'item_id' => $items[$i],
                        'batch' => $batch[$i],
                        'x_date' => $date,
                        'quantity' => $quantity[$i],
                        'bonus' => $bonus[$i],
                        'cost' => $cost[$i],
                        'bonus_cost' => $bonus_cost[$i],
                        'discount_cost' => $discount_cost[$i],
                        'unit_type' => $price[$i],
                        'loose' => $loose[$i],
                        'loose_active' => $loose_type,
                        'remaining' => $quantity[$i] + $bonus[$i]
                    );
                    $n += $this->items_model->add_bill_items($set_items);

                    $qty = $this->ConfigurationRetriveModel->get_row_data('sh_drugs', 'drug_id', $items[$i]);
                    $tot_qty = $quantity[$i] + $bonus[$i] + $qty->quantity;
                    $quant = $quantity[$i] + $bonus[$i] + $qty->total_quantity;
                    $set = array('quantity' => $tot_qty, 'total_quantity' => $quant, 'drug_loose' => $loose[$i], 'loose_active' => $loose_type);
                    $this->db->where('drug_id', $items[$i]);
                    $this->db->update('sh_drugs', $set);
                } else {
                    $set_items = array(
                        'bill_id' => $bill_id,
                        'item_id' => $items[$i],
                        'batch' => $batch[$i],
                        'x_date' => $xdate,
                        'quantity' => $quantity[$i],
                        'bonus' => $bonus[$i],
                        'cost' => $cost[$i],
                        'bonus_cost' => $bonus_cost[$i],
                        'discount_cost' => $discount_cost[$i],
                        'unit_type' => $price[$i],
                        'loose' => $loose[$i],
                        'loose_active' => $loose_type,
                        'remaining' => ($quantity[$i] + $bonus[$i]) * $loose[$i]
                    );
                    $n += $this->items_model->add_bill_items($set_items);

                    $qty = $this->ConfigurationRetriveModel->get_row_data('sh_drugs', 'drug_id', $items[$i]);
                    $tot_qty = ($quantity[$i] + $bonus[$i] + $qty->quantity) * $loose[$i];
                    $quant = $quantity[$i] + $bonus[$i] + $qty->total_quantity;
                    $set = array('quantity' => $tot_qty, 'total_quantity' => $quant, 'drug_loose' => $loose[$i], 'loose_active' => $loose_type);
                    $this->db->where('drug_id', $items[$i]);
                    $this->db->update('sh_drugs', $set);
                }
            }
            if ($n == $x) {
                $msg = '<div class="alert alert-success">Items Added Successfully.</div>';
                $bill_data = array('bill_id' => $bill_id);
                $this->items_model->add_receive_bill($bill_data);
            } else {
                $msg = '<div class="alert alert-danger">Some Items Not Added.</div>';
            }
        }
        if ($type && $payment) {
            $set_payment = array('type' => $type, 'amount' => $payment, 'file_upload' => $newfilenamecheck);
            $payment_id = $this->financial_model->add_payment($set_payment);
            $set_paid = array('bill_id' => $bill_id, 'payment_id' => $payment_id, 'paid_amount' => $payment);
            $bill_payment = $this->financial_model->add_bill_payment($set_paid);
        }
        if ($bill_id) {
            foreach ($this->financial_model->get_bill($bill_id) as $data) {
            }
            $data['items'] = $this->items_model->get_receive_bill_items($bill_id);
        }
        $this->session->set_flashdata('success', 'Purchase Statment Saved Successfully.');
        $this->createLog('Pharmacy-Purchase', $this->loginId, 'Create', $set_bill);
        redirect('admin/Pharmacy/PharmacyController/purchaseStatments', 'refresh');
    }

    public function purchaseBilEdit()
    {
        $x = 0;
        $msg = '';
        $supplier = $this->input->post('supplier');
        $amount = $this->input->post('amount');
        $discount = $this->input->post('discount');
        $invoice_no = $this->input->post('invoice_no');
        if ($amount)
            $ratio = $amount / ($amount + $discount);

        $items = $this->input->post('items');
        $batch = $this->input->post('batch');
        $xdate = $this->input->post('xdate');
        $quantity = $this->input->post('quantity');
        $bonus = $this->input->post('bonus');
        $cost = $this->input->post('cost');
        $bonus_cost = $this->input->post('bonus_cost');
        $discount_cost = $this->input->post('discount_cost');
        $price = $this->input->post('price');
        $bill_date = $this->input->post('bill_date_edit');

        $type = $this->input->post('type');
        $payment = $this->input->post('payment');
        $bill_id = $this->input->post('bill_id');
        if (is_array($items))
            $x = count($items);
        if ($x > 0) {
            $set_bill = array('supplier_id' => $supplier, 'bill_date' => date('Y-m-d', strtotime(str_replace('/', '-', $bill_date))), 'amount' => $amount, 'discount' => $discount, 'discount_ratio' => $ratio, 'invoice_no' => $invoice_no);
            // $bill_id = $this->supplier_model->add_bill($set_bill);
            $this->db->where('bill_id', $bill_id);
            $this->db->update('sh_bill', $set_bill);

            $result = $this->ConfigurationRetriveModel->retrieve_data_unique('sh_receive_bill_items', 'bill_id', $bill_id);

            foreach ($result as $val) {
                $qty = $this->ConfigurationRetriveModel->get_row_data('sh_drugs', 'drug_id', $val['item_id']);
                $tot_qty = $qty->quantity - $val['quantity'] - $val['bonus'];
                $set = array('quantity' => $tot_qty);
                $this->db->where('drug_id', $val['item_id']);
                $this->db->update('sh_drugs', $set);
            }

            $this->db->delete('sh_receive_bill_items', array('bill_id' => $bill_id));
            $this->db->delete('sh_receive_bill', array('bill_id' => $bill_id));
            $n = 0;
            for ($i = 0; $i < $x; $i++) {
                $set_items = array(
                    'bill_id' => $bill_id,
                    'item_id' => $items[$i],
                    'batch' => $batch[$i],
                    'x_date' => date('Y-m-d', strtotime(str_replace('/', '-', $xdate[$i]))),
                    'quantity' => $quantity[$i],
                    'bonus' => $bonus[$i],
                    'cost' => $cost[$i],
                    'bonus_cost' => $bonus_cost[$i],
                    'discount_cost' => $discount_cost[$i],
                    'unit_type' => $price[$i],
                    'remaining' => $quantity[$i] + $bonus[$i]
                );
                $n += $this->items_model->add_bill_items($set_items);
                $qty = $this->ConfigurationRetriveModel->get_row_data('sh_drugs', 'drug_id', $items[$i]);
                $tot_qty = $quantity[$i] + $bonus[$i] + $qty->quantity;
                $set = array('quantity' => $tot_qty);
                $this->db->where('drug_id', $items[$i]);
                $this->db->update('sh_drugs', $set);
            }
            if ($n == $x) {
                $msg = '<div class="alert alert-success">Items Updated Successfully.</div>';
                $bill_data = array('bill_id' => $bill_id);
                $this->items_model->add_receive_bill($bill_data);
                $this->createLog('Pharmacy-Purchase', $this->loginId, 'Update', $set_bill);

                $this->session->set_flashdata('success', 'Purchase Statment Updated Successfully.');
                redirect('admin/Pharmacy/PharmacyController/purchaseStatments', 'refresh');
            } else {
                $msg = '<div class="alert alert-danger">Some Items Not Added.</div>';
                redirect('admin/Pharmacy/PharmacyController/purchaseStatments', 'refresh');
            }
        }
    }


    public function purchaseStatments()
    {
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 27;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $data['dataList'] = $this->PaymentsModel->getPaymentsList();
        $data['expiry'] = $this->expiry();

        $this->load->view('admin/Pharmacy/Supplier/purchaseStatment', $data);
    }


    public function bill_list()
    {
        $list = $this->bill_model->get_datatables();
        $data = array();
        $no = $_POST['start'];
        foreach ($list as $bill) {
            $no++;
            $row = array();
            $row[] = $bill->bill_id;
            $row[] = date('d/m/Y', strtotime($bill->bill_date));
            $row[] = $bill->supplier_name;
            $row[] = $bill->mobile;
            $row[] = $bill->amount;

            //add html for action
            $actions = '<a class="btn btn-sm btn-dark" href="javascript:void(0)" title="Edit" onclick="view_bill(' . "'" . $bill->bill_id . "'" . ')">View</a> ';
            $actions .= '<a class="btn btn-sm btn-dark" href="' . site_url('admin/Pharmacy/PharmacyController/receive_bill_view_print') . "/" . $bill->bill_id . '" title="Print">Print</a> ';
            $actions .= '<a class="btn btn-sm btn-dark" href="javascript:void(0)" title="Edit" onclick="edit_bill(' . "'" . $bill->bill_id . "'" . ')">Edit</a> ';

            $actions .= '<a class="btn btn-sm btn-dark" href="javascript:void(0)" title="Delete" onclick="delete_bill(' . "'" . $bill->bill_id . "'" . ')">Delete</a>';

            // $row[] = "<a class='btn btn-sm btn-primary' href='".site_url('pharmacy/statement_views')."/".$bill->supplier_id."'>View</a>";
            $row[] = $actions;
            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => $this->bill_model->count_all(),
            "recordsFiltered" => $this->bill_model->count_filtered(),
            "data" => $data,
        );
        //output to json format
        echo json_encode($output);
    }
    public function receive_bill_view_print($bill_id) {
            $query = $this->db->query("SELECT *
            FROM sh_bill
            LEFT JOIN sh_supplier
            ON sh_supplier.supplier_id = sh_bill.supplier_id
            WHERE bill_id = '$bill_id'");
            $data['bill'] =  $query->result_array();
            $data['bill_id'] = $bill_id;
            $template = $this->ConfigurationRetriveModel->retrieve_data_unique('tbl_invoice_templates', 'invoice_type', 2);
            $data['invoice_template']= $this->ConfigurationRetriveModel->parser_template_values_invoice($template[0]['template']);
            $this->load->view('admin/Pharmacy/ReceiptBill.php', $data);
      
    }

    public function ajax_edit_bill($id)
    {
        $data = $this->bill_model->get_by_id($id);
        echo json_encode($data);
    }

    public function ajax_view_bill($id)
    {
        $HTML = "";
        $data = $this->bill_model->get_by_id_view($id);
        $num = 1;
        if (isset($data) and $data != null) {
            foreach ($data as $val) {
                if ($val['x_date'] != "0000-00-00") {
                    $date = date('d/m/Y', strtotime($val['x_date']));
                } else {
                    $date = "";
                }
                $HTML .= "<tr>
					  <td>" . $num . "</td>
					  <td>" . $val['drug_name'] . "</td>
					  <td>" . $val['batch'] . "</td>
					  <td>" . $date . "</td>
					  <td>" . $val['quantity'] . "</td>
					  <td>" . $val['bonus'] . "</td>
					  <td>" . $val['cost'] . "</td>
					  <td>" . $val['unit_type'] . "</td>
					  <td>" . $val['quantity'] * $val['cost'] . "</td>
				  </tr>";
                $num++;
            }
        }

        echo $HTML;
    }

    public function ajax_delete_bill($id)
    {
        $result = $this->ConfigurationRetriveModel->retrieve_data_unique('sh_receive_bill_items', 'bill_id', $id);

        foreach ($result as $val) {
            $qty = $this->ConfigurationRetriveModel->get_row_data('sh_drugs', 'drug_id', $val['item_id']);
            $tot_qty = $qty->quantity - $val['quantity'] - $val['bonus'];
            $set = array('quantity' => $tot_qty);
            $this->db->where('drug_id', $val['item_id']);
            $this->db->update('sh_drugs', $set);
        }

        $this->bill_model->delete_by_id($id);
        echo json_encode(array("status" => TRUE));
    }


    public function ajax_update_bill($id)
    {
        $HTML = "";
        $total = 0;
        $data = $this->bill_model->get_by_id_view($id);
        $num = 1;
        if (isset($data) and $data != null) {
            foreach ($data as $val) {

                $tot = $val['quantity'] * $val['cost'];
                $total_quantity = $val['quantity'] + $val['bonus'];
                $net = number_format($tot / $total_quantity, 2);
                $total += $val['quantity'] * $val['cost'];

                $HTML .= "<tr id='" . $val['item_id'] . "-" . $val['batch'] . "'>
	    		<td>
	    		<form class='delete_row'><input type='hidden' name='row_id' value='" . $val['item_id'] . "-" . $val['batch'] . "'>
                <button type='submit' class='btn delete_row btn-sm btn-danger'><span class='fa fa-trash'></span></button>
                </form></td>
                <td>" . $val['drug_name'] . "</td>
                <td id='b" . $val['item_id'] . "-" . $val['batch'] . "'>" . $val['batch'] . "</td>
                <td>" . date('d/m/Y', strtotime($val['x_date'])) . "</td>
                <td id='q" . $val['item_id'] . "-" . $val['batch'] . "'>" . $val['quantity'] . "</td>
                <td id='s" . $val['item_id'] . "-" . $val['batch'] . "'>" . $val['bonus'] . "</td>
                <td id='a" . $val['item_id'] . "-" . $val['batch'] . "'>" . $val['cost'] . "</td>
                <td id='n" . $val['item_id'] . "-" . $val['batch'] . "'>" . $net . "</td>
                <td id='d" . $val['item_id'] . "-" . $val['batch'] . "'>" . $net . "</td>
                <td id='p" . $val['item_id'] . "-" . $val['batch'] . "'>" . $val['unit_type'] . "</td>
                <td id='t" . $val['item_id'] . "-" . $val['batch'] . "'>" . $val['quantity'] * $val['cost'] . "</td>
                </tr>";
            }
        }

        echo $HTML;
    }

    public function ajax_update_bills($id)
    {
        $HTML = "";
        $total = 0;
        $data = $this->bill_model->get_by_id_view($id);
        $num = 1;

        if (isset($data) and $data != null) {
            foreach ($data as $val) {

                $total += $val['quantity'] * $val['cost'];
            }
        }
        $HTML .= "<tr><th colspan='10'>Sub Total:</th><th id='total'>$total</th></tr>";

        echo $HTML;
    }

    public function ajax_update_bill_discount($id)
    {
        $HTML = "";
        $total = 0;
        $data = $this->bill_model->get_by_id_view($id);
        $num = 1;

        if (isset($data) and $data != null) {
            foreach ($data as $val) {

                $total += $val['quantity'] * $val['cost'];
            }
        }
        $HTML .= "<fieldset><label>Discount By QAR:</label><input name='discount' type='text' id='discount_qar' value='0'>
	    <label>Discount Percentage %:</label><input name='ratio' type='text' id='discount_per' value='0'></fieldset>
	    <fieldset><label>Net Total:</label><p style='color:red;' id='calculated'>$total</p></fieldset>";

        echo $HTML;
    }

    public function returnItems(){
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 27;
        $data['active_submenu'] = 1;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $data['dataList'] = $this->PaymentsModel->getPaymentsList();
        $data['expiry'] = $this->expiry();
        $data['purchase_return'] = $this->ConfigurationRetriveModel->purchase_return_list();
       
        $data['supplier_list'] = $this->ConfigurationRetriveModel->retrieve_data('sh_supplier');

        $this->load->view('admin/Pharmacy/Supplier/returnItems', $data);
    }

    public function sales_return($id) {
        
            $data['title'] = 'Pharmacy Store ::: Hospital Management Software';
            $data['page_header'] = 'Sales Return Invoice';

            $data['sales_return_info'] = $this->ConfigurationRetriveModel->sales_return_info($id);
            $data['template'] = $this->PharmacyModel->get_active_template();
            $data['invoice_template']= $this->ConfigurationRetriveModel->parser_template_values_invoice($data['template']);
            $data['content']=   $this->load->view('admin/Pharmacy/Store/invoice', $data,true);
            $this->load->view('admin/Pharmacy/Store/sales_return_invoice', $data);
        
    }
    public function delete_sales_return($return_sale_id)
    {
       
            $data['title'] = 'Pharmacy Store ::: Hospital Management Software';
            $data['page_header'] = 'Transfer Items';

            $results = $this->ConfigurationRetriveModel->retrieve_data_unique('sh_return_sale_items', 'return_sale_id', $return_sale_id);

            foreach ($results as $value) {
           
                //add sh_drugs
                $result = $this->ConfigurationRetriveModel->get_row_data('sh_drugs', 'drug_id', $value['item_id']);
                $newData = array(
                    'quantity' => $result->quantity - $value['qty'],
                );
                $this->ConfigurationRetriveModel->update_data('sh_drugs','drug_id',$value['item_id'],$newData);

                //add sh_receive_bill_items
                $result = $this->ConfigurationRetriveModel->get_row_data('sh_receive_bill_items', 'bill_items_id', $value['sell_bills_id']);
                $newData = array(
                    'remaining' => $result->remaining - $value['qty'],
                );
                $this->ConfigurationRetriveModel->update_data('sh_receive_bill_items','bill_items_id',$result->bill_items_id,$newData);

            }
      
            $this->ConfigurationRetriveModel->data_delete_other('sh_return_sale', 'return_sale_id', $return_sale_id);
            $this->ConfigurationRetriveModel->data_delete_other('sh_return_sale_items', 'return_sale_id', $return_sale_id);

            $data['alert_msg'] = '';
            $data['error'] = '';
            $data['success'] = 'The Items is deleted successfully!';

            $data['sales_return'] = $this->ConfigurationRetriveModel->sales_return_list();
            echo json_encode(array("status" => TRUE));

        
    }
    public function search_drug_items()
    {
       
                $search_data = $this->input->post('search_data');

                $result = $this->items_model->get_item_return_sale($search_data);

                $HTML = '';
                    if ($result !=FALSE and $search_data!="") {
                        $HTML.='<br>
                                    <table class="table table-striped table-bordered table-hover">
                                      <thead>
                                          <tr>
                                              <th>Item Code</th>
                                              <th>Item Name</th>
                                              <th>Batch</th>
                                              <th>Price</th>
                                              <th>Action</th>
                                          </tr>
                                      </thead>
                                      <tbody>
                            ';
                        foreach ($result as $row) {

                            $HTML.='
                                        <tr>
                                            <td>'.$row['drug_id'].'</td>
                                            <td>'.$row['drug_name'].'</td>
                                            <td>'.$row['batch'].'</td>
                                            <td>'.$row['sell_price'].'</td>
                                            <td>
                                                <button type="button" class="btn btn-sm btn-primary add_item" value="'.$row['drug_id']."||".$row['drug_name']."||".$row['batch']."||".$row['sell_price']."||".$row['r_bill']."||".$row['sell_bill_id'].'">Add</button>
                                            </td>
                                         </tr>
                            ';
                        }

                        $HTML.='
                                      </tbody>
                                    </table>
                        ';
                        echo $HTML;
                    }else{
                        $HTML.='Not Found Any Records';
                        echo $HTML;
                    }
    }

    public function delete_purchase_return($return_stock_id)
    {
        
 
            $results = $this->ConfigurationRetriveModel->retrieve_data_unique('sh_return_stock_items', 'return_stock_id', $return_stock_id);

            foreach ($results as $value) {
           
                //add sh_drugs
                $result = $this->ConfigurationRetriveModel->get_row_data('sh_drugs', 'drug_id', $value['item_id']);
                $newData = array(
                    'quantity' => $result->quantity + $value['quantity'],
                );
                $this->PharmacyModel->update_data('sh_drugs','drug_id',$value['item_id'],$newData);

                //add sh_receive_bill_items
                $result = $this->PharmacyModel->receive_bill_add($value['bills_id'],$value['item_id']);
                $newData = array(
                    'remaining' => $result->remaining + $value['quantity'],
                );
                $this->PharmacyModel->update_data('sh_receive_bill_items','bill_items_id',$result->bill_items_id,$newData);

            }
      
            $this->ConfigurationRetriveModel->data_delete_other('sh_return_stock', 'return_stock_id', $return_stock_id);
            $this->ConfigurationRetriveModel->data_delete_other('sh_return_stock_items', 'return_stock_id', $return_stock_id);

            $success = 'The Items is deleted successfully!';
            echo json_encode(array("status" => TRUE));
           

        
    }
    public function thermalPrint($id) {
       

            $data['sell_items'] = $this->ConfigurationRetriveModel->get_sell_bill_items_thermal($id);
            $data['drugs_com'] = $this->ConfigurationRetriveModel->get_row_data("drugs_commission", "pos_id", $id);
            $data['payment'] = $this->ConfigurationRetriveModel->get_payment_thermal($id);
            $data['paymentss'] = $this->ConfigurationRetriveModel->get_payment($id);
            $data['payments'] = $this->ConfigurationRetriveModel->retrieve_data_unique('sh_sell_bill', 'sell_bill_id', $id);
            $template = $this->ConfigurationRetriveModel->retrieve_data_unique('tbl_invoice_templates', 'invoice_type', 2);
            $data['bill_id'] = $id;
            $data['invoice_template']= $this->ConfigurationRetriveModel->parser_template_values_invoice($template[0]['template']);
          

            $this->load->view('admin/Pharmacy/ReceiptPharmacy', $data);

       
    }

    // public function view_purchase_return($id){
    //     $data['purchase_return_info'] = $this->PharmacyModel->purchase_return_list();
    //     $this->load->view('admin/Pharmacy/Supplier/purchaseReturnInvoice', $data);
    // }
    public function purchase_return($id) {
    
            $data['title'] = 'Pharmacy Store ::: Hospital Management Software';
            $data['page_header'] = 'Purchase Return Invoice';

            $data['purchase_return_info'] = $this->ConfigurationRetriveModel->purchase_return_list_row($id);
            $data['template'] = $this->PharmacyModel->get_active_template();
            $data['invoice_template']= $this->ConfigurationRetriveModel->parser_template_values_invoice($data['template']);
            $data['content']=   $this->load->view('admin/Pharmacy/Supplier/invoice', $data,true);
            $this->load->view('admin/Pharmacy/Supplier/purchaseReturnInvoice', $data);
      
    }
    public function return_bill() {
      
            $msg = '';
            $data['result'] = FALSE;
            $bill_search = $this->input->post('search');

            $bill = $this->input->post('bill');
            $amount = $this->input->post('amount');
            $amount = -$amount;
            $items = $this->input->post('items');
            $batch = $this->input->post('batch');
            $quantity = $this->input->post('quantity');
            $price = $this->input->post('price');
            $user_id = $this->session->userdata('user_Id');
            $x = 0;

            date_default_timezone_set('Asia/Kuwait');
            $date_string = '%Y-%m-%d %H:%i';
            $curr_date = mdate($date_string);

            if ($bill) {
                $return_id = $this->PosModel->insert_data('sh_return_sale', array('sell_bill_id' => $bill, 'return_date' => $curr_date, 'user_id' => $user_id));
                $payment_id = $this->PosModel->insert_data('sh_sell_bill_payment', array('type' => 'cash', 'amount' => $amount, 'user_id' => $user_id));
                $this->PosModel->insert_data('sh_sell_bill_paid', array('bill_id' => $bill, 'payment_id' => $payment_id, 'paid_amount' => $amount));
                for ($i = 0; $i < count($items); $i++) {
                    $return_items = array(
                        'item_id' => $items[$i],
                        'batch' => $batch[$i],
                        'qty' => $quantity[$i],
                        'sell_price' => $price[$i],
                        'return_sale_id' => $return_id
                    );
                    $this->PosModel->insert_data('sh_return_sale_items', $return_items);
                    $x++;

                    $qtys = $this->ConfigurationRetriveModel->get_row_data('sh_drugs', 'drug_id', $items[$i]);
                    $tot_qty = $qtys->quantity + $quantity[$i];
                    $set = array('quantity' => $tot_qty);
                    $this->db->where('drug_id', $items[$i]);
                    $this->db->update('sh_drugs', $set);

                    $qtys = $this->ConfigurationRetriveModel->get_row_data('sh_sell_bill_items', 'sell_bill_id', $bill);
                    $tot_qty = $qtys->returned + $quantity[$i];
                    $set = array('returned' => $tot_qty);
                    $this->db->where('sell_bill_id', $bill);
                    $this->db->update('sh_sell_bill_items', $set);

                    $get_remainig = $this->ConfigurationRetriveModel->get_row_data('sh_receive_bill_items', 'batch', $batch[$i]);
                    $now_qty =$get_remainig->remaining + $quantity[$i];  
                    $set = array('quantity' => $now_qty,'remaining' => $now_qty);
                    $this->db->where('batch', $batch[$i]);
                    $this->db->update('sh_receive_bill_items', $set);

                }
                $success = 'The Items is Returned successfully!';
            $this->session->set_flashdata('success',  $success);
            }

            if ($bill_search) {
                $bill_string= explode("|||", $bill_search);
                $bill_search= $bill_string[0];
                $result = $this->PosModel->get_bill($bill_search);
            
                if (is_array($result)) {
                    foreach ($result as $data) {
                        $data['result'] = TRUE;
                        $data['payment'] = (is_null($data['payment'])) ? 'Not Paid' : $data['payment'];
                        $data['patient'] = (is_null($data['patient'])) ? 'Out Patient' : $data['patient'];
                    }
                    $result = $this->PosModel->get_bill_items($bill_search);
                    if (is_array($result)) {
                        $data['bill_items'] = $result;
                    }
                }
            }
        


          
            $this->load->view('admin/Pharmacy/Store/returnBill', $data);
        
    }
    //print return bill
    public function print_return_bill($return_id){

		$data = [];
        $data['template'] = $this->PharmacyModel->get_active_template();
        $data['company'] = $this->CommonModel->get_company_info();

        $advance_id = decrypt_and_url_decode($advance_id, $this);

        $data['receiptHeader'] = $this->PharmacyModel->get_receipt_advance_details($advance_id);
        $data['view'] =  'advance1Details.php';
        // return $this->output->set_content_type('application/json')
        // ->set_output(json_encode($data['receiptData']));

        $this->load->view('admin/Receipt/receipt1', $data);
	}

    public function financial() {
       
 
            if(isset($msg) and $msg !=null){
            }else{
                $msg = '';
            }
            $data['msg'] = $msg;
            $data['title'] = 'Pharmacy Store ::: Hospital Management Software';
            $data['page_header'] = 'Pay Bill';
            $this->load->view('admin/Pharmacy/Financial/financial', $data);
        
    }
    public function financial_list()
	{
		$list = $this->financial_model->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $bill) {
			$no++;
			$row = array();
			$row[] = $no;
			$row[] = $bill->invoice_no;
			$row[] = $bill->bill_id;
			// $row[] = $bill->quantity;
			$row[] = $bill->amount;
			$row[] = $bill->paid_amount;
			$row[] = $bill->balance;

			//add html for action
			if($bill->balance>0){
				$row[] = '<a class="btn btn-sm btn-dark" href="javascript:void(0)" title="Edit" onclick="pay_bill('."'".$bill->bill_id."'".')">Pay</a>';
			}else{
				$row[] = '<a class="btn btn-sm btn-dark disabled" href="javascript:void(0)" title="Edit" >Pay</a>';
			}
			
		
			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->financial_model->count_all(),
						"recordsFiltered" => $this->financial_model->count_filtered(),
						"data" => $data,
				);
		//output to json format
		echo json_encode($output);
	}

    
    public function pay_bill() {
      
            $msg = '';
            $type = $this->input->post('type');
            $payment = $this->input->post('payment');
            $bill_id = $this->input->post('bill_id');

            if ($type && $payment) {
                $set_payment = array('type' => $type, 'amount' => $payment);
                $payment_id = $this->financial_model->add_payment($set_payment);
                $set_paid = array('bill_id' => $bill_id, 'payment_id' => $payment_id, 'paid_amount' => $payment);
                $bill_payment = $this->financial_model->add_bill_payment($set_paid);
                $success="";
                $success.=($bill_payment > 0) ? 'Payment Updated Successfully.' : 'Error in Payment.';
                
                $this->session->set_flashdata('success',  $success);
                $this->load->view('admin/Pharmacy/Financial/financial', $data);
            }
        
    }
    public function statement() {
       
            if(isset($msg) and $msg !=null){
            }else{
                $msg = '';
            }
            $data['msg'] = $msg;
            $data['title'] = 'Pharmacy Store ::: Hospital Management Software';
            $data['page_header'] = 'Statement';
            $this->load->view('admin/Pharmacy/Financial/statement', $data);
    }
    public function statement_list()
	{
		$list = $this->supplier_model->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $bill) {
			$no++;
			$row = array();
			$row[] = $bill->supplier_id;
			$row[] = $bill->supplier_name;
			$row[] = $bill->mobile;


			//add html for action
			// $row[] = '<a class="btn btn-sm btn-primary" href="javascript:void(0)" title="View" onclick="view_statement('."'".$bill->supplier_id."'".')">View</a>';
			$row[] = "<a class='btn btn-sm btn-dark' href='".site_url('admin/Pharmacy/PharmacyController/statement_views')."/".$bill->supplier_id."'>View</a>";
		
			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->supplier_model->count_all(),
						"recordsFiltered" => $this->supplier_model->count_filtered(),
						"data" => $data,
				);
		//output to json format
		echo json_encode($output);
	}
    public function statement_views($id) {
      
          
            $data['total_gross'] = $this->supplier_model->get_gross($id);
            $data['statement'] = $this->supplier_model->get_statement($id);
            $data['paid_list'] = $this->supplier_model->paid_list($id);
            $data['returned_list'] = $this->supplier_model->returned_list($id);

            $data['msg'] = $msg;
            $data['title'] = 'Pharmacy Store ::: Hospital Management Software';
            $data['page_header'] = 'Statement';
            $this->load->view('admin/Pharmacy/Financial/statement_views', $data);
        
    }
    
    public function inventory() {
    
            $data['msg'] = '';
            $data['title'] = 'Pharmacy Store ::: Hospital Management Software';
            $data['page_header'] = 'Adjust Inventory';
            // $this->load->view('pharmacy/store/inventory_view', $data);
            $this->load->view('admin/Pharmacy/Financial/inventory_adjust', $data);
    }

    public function inventory_list()
	{
		$list = $this->inventory_model->get_datatables();
		$data = array();
		$no = $_POST['start'];
		foreach ($list as $bill) {
			$no++;
			$row = array();
			$row[] = $bill->drugs_code;
			$row[] = $bill->drug_name;
			$row[] = $bill->category_name;
			$row[] = $bill->location_name;
			$row[] = $bill->quantity;
			$row[] = $bill->old_val;

			//add html for action
			// $row[] = '<a class="btn btn-sm btn-primary" href="javascript:void(0)" title="View" onclick="adj_inv('."'".$bill->bill_items_id."'".')">Edit</a>';
			$row[] = "<a class='btn btn-sm btn-dark' href='javascript:void(0)' title='Edit' onclick='adj_inv(".$bill->drug_id.",".$bill->quantity.",".$bill->drug_id.",".$bill->loose_active.")'>Edit</a>";
		
			$data[] = $row;
		}

		$output = array(
						"draw" => $_POST['draw'],
						"recordsTotal" => $this->inventory_model->count_all(),
						"recordsFiltered" => $this->inventory_model->count_filtered(),
						"data" => $data,
				);
		//output to json format
		echo json_encode($output);
	}
    
    
    public function adjust_inventory() {
        
            $msg = '';
            $batch = $this->input->post('batch_id');
            $payment = $this->input->post('payment');
            $old_qty = $this->input->post('old_qty');
            $item_id = $this->input->post('item_id');
            $id = $this->input->post('adj_id');
            $new_val = $old_qty-$payment;
            $batch_arr = explode(' | ', $batch);

            $diff = $payment - $batch_arr[3];
            $total = $old_qty + $diff;

            if ($payment) {
                $sets = array('remaining' => $payment);
                $this->db->where('bill_items_id', $batch_arr[0]);
                $updated = $this->db->update('sh_receive_bill_items', $sets);

                $result = $this->report_retrive->get_sum_adj($item_id);
                $total_remaining = $result->total;

                $sets = array('quantity' => $total_remaining,'old_val' => $total_remaining-$old_qty);
                $this->db->where('drug_id', $item_id);
                $updated = $this->db->update('sh_drugs', $sets);

                $msg.=($updated > 0) ? '<div class="alert alert-success">Inventory Updated Successfully.</div>' : '<div class="alert alert-danger">Error in Inventory.</div>';
                $data['msg'] = $msg;
                $data['title'] = 'Pharmacy Store ::: Hospital Management Software';
                $data['page_header'] = 'Supplier Bill';
                $this->load->view('pharmacy/store/inventory_adjust', $data);
            }
        
    }
    public function load_batch_no_list()
    {
        
       
            
            $item_id = $this->input->post('item_id');

            $data = $this->ConfigurationRetriveModel->get_row_data('sh_drugs', 'drug_id', $item_id);

            if($data->loose_active == 1){
                $result = $this->ConfigurationRetriveModel->retrieve_data_unique('sh_receive_bill_items', 'item_id', $item_id);
                if ($result !=FALSE) {
                    // $HTML = "<option value='-1'>Please Select Batch No.</option>";
                    $HTML = "";

                    foreach ($result as $row) {
                        $HTML.="<option value='".$row['bill_items_id']." | ".$row['item_id']." | ".$row['batch']." | ".$row['remaining']."'>".$row['remaining']." | ".$row['batch']."</option>";
                    }
                    echo $HTML;
                }
                else{
                    echo 'No Data';
                }
            }else{
            
                $result = $this->ConfigurationRetriveModel->retrieve_data_unique('sh_receive_bill_items', 'item_id', $item_id);
                if ($result !=FALSE) {
                    // $HTML = "<option value='-1'>Please Select Batch No.</option>";
                    $HTML = "";

                    foreach ($result as $row) {
                        // $HTML.="<option value='".$row['bill_items_id']." | ".$row['item_id']." | ".$row['batch']."'>".$row['bill_items_id']." | ".$row['item_id']." | ".$row['batch']."</option>";
                        $HTML.="<option value='".$row['bill_items_id']." | ".$row['item_id']." | ".$row['batch']." | ".$row['remaining']."'>".$row['remaining']." | ".$row['batch']."</option>";
                    }
                    echo $HTML;
                }
                else{
                    echo $HTML = '<option value="">No Batch number</option>';
                }
            }
   
        
    }

    // public function get_presciption_drugs(){

    // }
    
    public function get_prescription() {
        $search = $_GET['pres_id'];
        $result = $this->items_model->search_prescription_items($search);
        $data = array();
        if (is_array($result)) {
            foreach ($result as $value) {
                array_push($data, $value['drug_id'] . ' ||| ' . $value['drug_name'] . ' ||| ' . $value['bills_id'] . ' ||| ' . $value['batch'] . ' ||| ' . $value['x_date'] . ' ||| ' . $value['drug_qty'] . ' ||| ' . $value['price']);
            }
        }
        
        echo json_encode($data);
    }
    public function search_prescription() {
        $search = $_GET['search'];
        $result = $this->items_model->search_prescription($search);
        $data = array();
        if (is_array($result)) {
            foreach ($result as $value) {
                array_push($data, $value['prescription'] . ' ||| ' . $value['patient_id'] . ' ||| ' . $value['patient'] . ' ||| ' . $value['date'] . ' ||| ' . $value['doctor']);
            }
        }
        echo json_encode($data);
    }
}
