<?php

class ConfigurationsController extends MY_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->check_permission($this->session->userdata('user_Id'), 'configurations');
        $this->load->model('admin/Setting/Configurations/ConfigurationsModel');
        $this->load->model('admin/Setting/Treatments/TreatmentsModel');
        $this->load->model('admin/ConsentForm/ConfigurationRetriveModel');

        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->helper(array('form', 'url'));
        $this->load->library('csvimport');
    }

    public function index($data = null)
    {

        //Commen -------------------------------------
        $data['active_menu'] = 9;
        $data['active_submenu'] = 2;

        //Locals -------------------------------------
        //$data['List'] = $this->CompanyModel->get_list();

        // //Invoice data
        $data['invoice_templates'] = $this->ConfigurationsModel->getInvoiceTemplates();
        $data['invoice_types'] = $this->ConfigurationsModel->getInvoiceTypes();
        $data['consents'] = $this->ConfigurationRetriveModel->retrieve_data('tbl_consent_forms');
        $data['modules'] = $this->ConfigurationRetriveModel->retrieve_data('tbl_modules');
        $data['laser_resources'] = $this->ConfigurationRetriveModel->retrieve_data('tbl_consent_forms');
        $data['departments'] = $this->ConfigurationRetriveModel->retrieve_data_unique_fields('tbl_modules', 'department_id as value,module_name as label', 'is_module', 1);
        $data['insurance_types'] = $this->ConfigurationRetriveModel->retrieve_data_unique_fields('tbl_insurance_types', 'insurance_type_id as value,insurance_name as label', '1', '1');
        $data['event_types'] = $this->ConfigurationRetriveModel->retrieve_data('tbl_event_names');
       
        $modules = $this->ConfigurationRetriveModel->retrieve_data('general_settings');
        $data['is_package']=0;
        $data['is_referal']=0;

        foreach($modules as $module){
            
            if($module['type']== 'package' && $module['name']== 'is_enable' && $module['value']== '1'  ){
                $data['is_package'] =1;
            }
            if($module['type']== 'referal' && $module['name']== 'is_enable' && $module['value']== '1'){
                $data['is_referal']=1;
            }
          }
       
        $this->load->view('admin/Setting/Configurations/Configurations', $data);
        }

    public function CreateNew()
    {
        //Commen -------------------------------------
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 9;
        $data['active_submenu'] = 2;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);


        //Locals =========================================================================
        $data['company_id_val'] = 0;
        $data['company_name_val'] = '';
        $data['company_description_val'] = '';
        $data['company_address_val'] = '';
        $data['mobile_no_val'] = '';
        $data['phone_no_val'] = '';
        $data['fax_val'] = '';
        $data['email_val'] = '';
        $data['web_val'] = '';

        //image
        $data['image_path_val'] = '';

        $this->load->view('admin/Setting/Company/Company', $data);
    }

    public function name_exists_check()
    {
        $this->db->where('company_name', trim($this->input->post('company_name')));
        $this->db->where_not_in('company_id', $this->input->post('company_id'));
        $query = $this->db->get('tbl_company');

        if ($query->num_rows() > 0) {
            $this->form_validation->set_message('name_exists_check', 'Name Already Added.');
            return FALSE;
        } else {
            return TRUE;
        }
    }

    public function Save()
    {
        //Commen =========================================================================
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 9;
        $data['active_submenu'] = 2;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        //Validation ====================================================================
        $this->form_validation->set_rules('company_name', 'Company Name', 'required|min_length[4]|callback_name_exists_check');
        $this->form_validation->set_rules('company_description', 'Description', 'required|max_length[450]');
        $this->form_validation->set_rules('company_address', 'Address', 'required|max_length[450]');
        $this->form_validation->set_rules('mobile_no', 'Mobile number', 'required|max_length[10]|min_length[10]');
        $this->form_validation->set_rules('phone_no', 'Phone number', 'required|max_length[10]|min_length[10]');
        $this->form_validation->set_rules('fax', 'Fax number', 'max_length[10]|min_length[10]');
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        $this->form_validation->set_rules('web', 'Web', 'valid_url');

        //Locals =========================================================================
        $company_id = trim($this->input->post('company_id'));
        $data['company_id_val'] = trim($this->input->post('company_id'));
        $data['company_name_val'] = trim($this->input->post('company_name'));
        $data['company_description_val'] = trim($this->input->post('company_description'));
        $data['company_address_val'] = trim($this->input->post('company_address'));
        $data['mobile_no_val'] = trim($this->input->post('mobile_no'));
        $data['phone_no_val'] = trim($this->input->post('phone_no'));
        $data['fax_val'] = trim($this->input->post('fax'));
        $data['email_val'] = trim($this->input->post('email'));
        $data['web_val'] = trim($this->input->post('web'));
        $data['is_new_image'] = trim($this->input->post('is_new_image'));
        $is_new_image  = trim($this->input->post('is_new_image'));

        //image
        $data['image_path_val'] = trim($this->input->post('image_path'));
        $logo = trim($this->input->post('image_path'));


        if ($this->form_validation->run() == FALSE) {
            $this->load->view('admin/Setting/Company/Company', $data);
            return;
        }

        //Save =========================================================================
        $data_save = array(
            'company_name' => $this->input->post('company_name'),
            'description' => $this->input->post('company_description'),
            'address' => $this->input->post('company_address'),
            'mobile_no' => $this->input->post('mobile_no'),
            'phone_no' => $this->input->post('phone_no'),
            'fax' => $this->input->post('fax'),
            'email' => $this->input->post('email'),
            'web' => $this->input->post('web'),
            'logo' => $logo,
            'create_user_Id' => $loginId,
            'create_datetime' => date('Y-m-d H:i:s')
        );

        if ($company_id > 0) {
            $this->CompanyModel->update($company_id, $data_save, $is_new_image);
        } else {
            $company_id = $this->CompanyModel->save($data_save, $is_new_image);
        }

        //load screen defaults ============================================================= 
        $data['List'] = $this->CompanyModel->get_list();
        $this->load->view('admin/Setting/Company/Company', $data);
    }

    public function Load()
    {
        //Commen =========================================================================
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 9;
        $data['active_submenu'] = 2;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        //Load ===========================================================================
        $load_data = $this->CompanyModel->get_by_id();

        $data['is_new_image'] = 'false';

        //load screen defaults ============================================================ 
        foreach ($load_data as $row) {
            $data['company_id_val'] = $row['company_id'];
            $data['company_name_val'] = $row['company_name'];
            $data['company_description_val'] = $row['description'];
            $data['company_address_val'] = $row['address'];
            $data['mobile_no_val'] = $row['mobile_no'];
            $data['phone_no_val'] = $row['phone_no'];
            $data['fax_val'] = $row['fax'];
            $data['email_val'] = $row['email'];
            $data['web_val'] = $row['web'];
            $data['image_path_val'] = $row['logo'];
        }

        $this->load->view('admin/Setting/Company/Company', $data);
    }

    /**
     * INVOICE CONFIGURATIONS
     */

    // Load invoice templates
    public function invoiceTemplateCreateOrUpdate()
    {

        $this->form_validation->set_rules('template_name', 'Template Name', 'required');
        $this->form_validation->set_rules('invoice_template', 'Invoice Template', 'required');
        $this->form_validation->set_rules('template_type', 'Template Type', 'required');

        $data = [
            'name' => $this->input->post('template_name'),
            'template' => $this->input->post('invoice_template', FALSE),
            'invoice_type' => $this->input->post('template_type')
        ];

        if ($this->form_validation->run() == false) {
            $this->index($data);
            return;
        }

        if (empty($this->input->post('template_id'))) {
            $this->ConfigurationsModel->createInvoiceTemplate($data) ? $this->session->set_flashdata('success', 'New templated created.') : $this->session->set_flashdata('error', 'Faild to create new template.');
        } else {

            try {
                $id = $this->encryption->decrypt($this->input->post('template_id'));
                $this->ConfigurationsModel->updateInvoiceTemplate($id, $data) ? $this->session->set_flashdata('success', 'Templated updated.') : $this->session->set_flashdata('error', 'Faild to update template.');
            } catch (Exception $e) {
                $this->session->set_flashdata('success', 'Invalid Template ID. :' . $e);
            }
        }

        $this->redirect_back();
    }

    // Load specific invoice template
    public function getInvoiceTemplate()
    {
        try {
            $json_data = file_get_contents("php://input");
            $data = json_decode($json_data);
            $this->form_validation->set_data(['id' => $data->id])->set_rules('id', 'ID', 'required|string');

            if ($this->form_validation->run() == false) {
                $this->output
                    ->set_status_header(400)
                    ->set_content_type('application/json')
                    ->set_output(json_encode(['error' => validation_errors()]));
            }

            $id = $data->id;

            try {
                $id = $this->encryption->decrypt($id);
            } catch (Exception $e) {
                $this->output
                    ->set_status_header(400)
                    ->set_content_type('application/json')
                    ->set_output(json_encode(['error' => $e]));
            }

            $invoiceTemplate = $this->ConfigurationsModel->getInvoiceTemplate($id);

            if (!$invoiceTemplate) {
                $this->output
                    ->set_status_header(404)
                    ->set_content_type('application/json')
                    ->set_output(json_encode(['error' => 'Invoice template not found.']));
            }

            // Encrypt id
            $invoiceTemplate->id = $this->encryption->encrypt($invoiceTemplate->id);

            $this->output
                ->set_status_header(200)
                ->set_content_type('application/json')
                ->set_output(json_encode($invoiceTemplate));
        } catch (Exception $e) {
            $this->output
                ->set_status_header(400)
                ->set_content_type('application/json')
                ->set_output(json_encode(['error' => $e]));
        }

        return $this->output;
    }

    // Delete invoice template
    public function deleteInvoiceTemplate()
    {
        $this->form_validation->set_rules('template_id', 'Template ID', 'required');
        $id = $this->input->post('template_id');

        if ($this->form_validation->run() == false) {
            $this->session->set_flashdata('errors', validation_errors());
            $this->redirect_back();
        } else {
            try {
                $decryptedId = $this->encryption->decrypt($id);

                if (!$decryptedId) {
                    $this->session->set_flashdata('errors', 'Invalid template ID');
                } else {
                    $this->ConfigurationsModel->deleteInvoiceTemplate($decryptedId) ? $this->session->set_flashdata('success', 'Templated deleted.') : $this->session->set_flashdata('errors', 'Failed to delete template.');
                }
            } catch (Exception $e) {
                $this->session->set_flashdata('errors', 'Exception Occured. :' . $e);
            }
        }

        $this->redirect_back();
    }

    public function laserResourcesSaveUpdate()
    {
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 9;
        $data['active_submenu'] = 2;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        //Validation ====================================================================
        $this->form_validation->set_rules('resource_name', 'Resource Name', 'required|max_length[450]');
        $this->form_validation->set_rules('resource_order', 'Resource Order', 'required|max_length[4]|callback_is_numeric_check');
        //Locals =========================================================================
        $resource_id = trim($this->input->post('resource_id'));
        $data['resource_name'] = trim($this->input->post('resource_name'));
        $data['resource_order'] = trim($this->input->post('resource_order'));
        $data['resource_color'] = trim($this->input->post('resource_color'));

        $result = $this->CommonModel->retrieve_data_unique_row('tbl_resources', 'resource_id', $resource_id);
        $patient = $this->CommonModel->retrieve_data_unique_row('tbl_patients', 'patient_id', $result->patient_id);
        $invoice_templates = $this->ConfigurationsModel->getInvoiceTemplates();
        $invoice_types = $this->ConfigurationsModel->getInvoiceTypes();
        $consents = $this->ConfigurationRetriveModel->retrieve_data('tbl_consent_forms');
        $laser_resources = $this->ConfigurationRetriveModel->retrieve_data('tbl_consent_forms');

        $data = array_merge($data, (array)$invoice_templates);
        $data = array_merge($data, (array)$invoice_types);
        $data = array_merge($data, (array)$consents);
        $data = array_merge($data, (array)$laser_resources);
        $data = array_merge($data, (array)$result);
        $data = array_merge($data, (array)$patient);

        if ($this->form_validation->run() == FALSE) {
            // $this->load->view('admin/Setting/Configurations/Configurations', $data);
            $this->editResource($this->input->post('resource_id'));
            return;
        }



        //Save =========================================================================
        $data_save = array(
            'resource_name' => $this->input->post('resource_name'),
            'resource_order' => $this->input->post('resource_order'),
            'resource_color' => $this->input->post('resource_color'),
        );

        if ($resource_id > 0) {
            $this->session->set_flashdata('success', 'Resource Updated successfully.');
            $this->ConfigurationsModel->update_data_where('tbl_resources', 'resource_id', $resource_id, $data_save);
        } else {
            $this->session->set_flashdata('success', 'Resource Saved successfully.');
            $resource_id = $this->ConfigurationsModel->insert_data('tbl_resources', $data_save);
        }

        redirect('admin/Setting/Configurations/ConfigurationsController', 'refresh');
    }


    public function editResource($encrypt_id)
    {

        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 9;
        $data['active_submenu'] = 2;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $resource_id = decrypt_and_url_decode($encrypt_id, $this);
        $result = $this->CommonModel->retrieve_data_unique_row('tbl_resources', 'resource_id', $resource_id);
        $patient = $this->CommonModel->retrieve_data_unique_row('tbl_patients', 'patient_id', $result->patient_id);
        $invoice_templates = $this->ConfigurationsModel->getInvoiceTemplates();
        $invoice_types = $this->ConfigurationsModel->getInvoiceTypes();
        $consents = $this->ConfigurationRetriveModel->retrieve_data('tbl_consent_forms');
        $laser_resources = $this->ConfigurationRetriveModel->retrieve_data('tbl_consent_forms');

        $data['departments'] = $this->ConfigurationRetriveModel->retrieve_data_unique_fields('tbl_modules', 'department_id as value,module_name as label', 'is_module', 1);
        $data['insurance_types'] = $this->ConfigurationRetriveModel->retrieve_data_unique_fields('tbl_insurance_types', 'insurance_type_id as value,insurance_name as label', '1', '1');

        $data = array_merge($data, (array)$invoice_templates);
        $data = array_merge($data, (array)$invoice_types);
        $data = array_merge($data, (array)$consents);
        $data = array_merge($data, (array)$laser_resources);
        $data = array_merge($data, (array)$result);
        $data = array_merge($data, (array)$patient);

        $this->load->view('admin/Setting/Configurations/Configurations', $data);
    }

    public function deleteResource($resource_id)
    {

        $resource_id = decrypt_and_url_decode($resource_id, $this);

        try {

            if (!$resource_id) {
                $this->session->set_flashdata('errors', 'Invalid Resource Id');
            } else {
                $this->CommonModel->update_data_where('tbl_resources', 'resource_id', $resource_id, array('status' => 0)) ? $this->session->set_flashdata('success', 'Resource deleted.') : $this->session->set_flashdata('errors', 'Failed to delete Resource.');
            }
        } catch (Exception $e) {
            $this->session->set_flashdata('errors', 'Exception Occured. :' . $e);
        }

        $this->redirect_back();
    }

    public function get_companies_list()
    {

        $draw = $this->input->get('draw');
        $length = $this->input->get('length');
        $start = $this->input->get('start');
        $search = $this->input->get('search')['value'];
        $order_column = $this->input->get('columns')[$this->input->get('order')[0]['column']]['data'];
        $order = $this->input->get('order')[0]['dir'];

        $records = $this->ConfigurationRetriveModel->getCompaniesList($search, $length, $start, $order_column, $order);
        foreach ($records as $key => $row) {
            $row->company_id = encrypt_and_url_encode($row->company_id, $this);
            $records[$key] = $row;
        }

        $total_records = count($records); // Get total records

        $response = array(
            "draw" => intval($draw),
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $records
        );

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    public function CompaniesSaveUpdate()
    {
        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 9;
        $data['active_submenu'] = 2;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        //Validation ====================================================================
        $this->form_validation->set_rules('company_name', 'Company Name', 'required|max_length[450]');
        $this->form_validation->set_rules('discount', 'Discount', 'required|max_length[5]');
        //Locals =========================================================================
        $company_id = trim(decrypt_and_url_decode($this->input->post('company_no'), $this));
        $data['company'] = trim($this->input->post('company_name'));
        $data['discount'] = trim($this->input->post('discount'));

        $result = $this->CommonModel->retrieve_data_unique_row('tbl_companies', 'company_id', $company_id);
        $patient = $this->CommonModel->retrieve_data_unique_row('tbl_patients', 'patient_id', $result->patient_id);
        $invoice_templates = $this->ConfigurationsModel->getInvoiceTemplates();
        $invoice_types = $this->ConfigurationsModel->getInvoiceTypes();
        $consents = $this->ConfigurationRetriveModel->retrieve_data('tbl_consent_forms');
        $laser_resources = $this->ConfigurationRetriveModel->retrieve_data('tbl_consent_forms');

        $data = array_merge($data, (array)$invoice_templates);
        $data = array_merge($data, (array)$invoice_types);
        $data = array_merge($data, (array)$consents);
        $data = array_merge($data, (array)$laser_resources);
        $data = array_merge($data, (array)$result);
        $data = array_merge($data, (array)$patient);

        if ($this->form_validation->run() == FALSE) {
            // $this->load->view('admin/Setting/Configurations/Configurations', $data);
            $this->editCompanies($this->input->post('company_no'));
            return;
        }


        $data_save = array(
            'company_name' => $this->input->post('company_name'),
            'discount' => $this->input->post('discount')
        );

        if ($company_id > 0) {
            $this->session->set_flashdata('success', 'Company Updated successfully.');
            $this->ConfigurationsModel->update_data_where('tbl_companies', 'company_id', $company_id, $data_save);
        } else {
            $this->session->set_flashdata('success', 'Company Saved successfully.');
            $company_id = $this->ConfigurationsModel->insert_data('tbl_companies', $data_save);
        }

        redirect('admin/Setting/Configurations/ConfigurationsController', 'refresh');
    }

    public function deleteCompanies($company_id)
    {

        $company_id = decrypt_and_url_decode($company_id, $this);

        try {

            if (!$company_id) {
                $this->session->set_flashdata('errors', 'Invalid Resource Id');
            } else {
                $this->CommonModel->update_data_where('tbl_companies', 'company_id', $company_id, array('status' => 0)) ? $this->session->set_flashdata('success', 'Company deleted.') : $this->session->set_flashdata('errors', 'Failed to delete Company.');
            }
        } catch (Exception $e) {
            $this->session->set_flashdata('errors', 'Exception Occured. :' . $e);
        }

        $this->redirect_back();
    }


    public function editCompanies($encrypt_id)
    {

        $loginId = $this->session->userdata('user_Id');
        $data['active_menu'] = 9;
        $data['active_submenu'] = 2;
        $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
        $data['profile'] = $this->CommonModel->profile($loginId);

        $company_id = decrypt_and_url_decode($encrypt_id, $this);
        $result = $this->CommonModel->retrieve_data_unique_row('tbl_companies', 'company_id', $company_id);
        $patient = $this->CommonModel->retrieve_data_unique_row('tbl_patients', 'patient_id', $result->patient_id);
        $invoice_templates = $this->ConfigurationsModel->getInvoiceTemplates();
        $invoice_types = $this->ConfigurationsModel->getInvoiceTypes();
        $consents = $this->ConfigurationRetriveModel->retrieve_data('tbl_consent_forms');
        $laser_resources = $this->ConfigurationRetriveModel->retrieve_data('tbl_consent_forms');
        $result->company = $result->company_name;
        $result->company_no = $result->company_id;

        $data['departments'] = $this->ConfigurationRetriveModel->retrieve_data_unique_fields('tbl_modules', 'department_id as value,module_name as label', 'is_module', 1);
        $data['insurance_types'] = $this->ConfigurationRetriveModel->retrieve_data_unique_fields('tbl_insurance_types', 'insurance_type_id as value,insurance_name as label', '1', '1');

        $data = array_merge($data, (array)$invoice_templates);
        $data = array_merge($data, (array)$invoice_types);
        $data = array_merge($data, (array)$consents);
        $data = array_merge($data, (array)$laser_resources);
        $data = array_merge($data, (array)$result);
        $data = array_merge($data, (array)$patient);

        $this->load->view('admin/Setting/Configurations/Configurations', $data);
    }

    public function priceList()
    {
        $this->load->library('EditorLib');
        $this->editorlib->process_treatments($_POST);
    }

    public function ImportPriceList()
    {
        $config['upload_path']   = './'.UPLOAD_PATH.'csv/';
        $config['allowed_types'] = 'csv';
        $config['max_size']      = 1024;

        if (!is_dir('./'.UPLOAD_PATH.'')) {
            mkdir('./'.UPLOAD_PATH.'');
        }

        if (!is_dir($config['upload_path'])) {
            mkdir($config['upload_path']);
        }

        $this->load->library('upload', $config);
        $ignored_txt = "<span>Ignored the following price list rows due to database existence</span> : <br> <ol class='mb-0 text-dark'>";
        $ignored = FALSE;
        try {
            if (!$this->upload->do_upload('csv_file')) {
                $error = array('error' => $this->upload->display_errors());
                $this->session->set_flashdata('errors', 'Failed to Import CSV Data.');
            } else {
                $file_data = $this->upload->data();
                $file_path = $config['upload_path'] . $file_data['file_name'];

                $column_headers = array(); // Provide alternate column headers if needed

                $data['csvData'] = $this->csvimport->get_array($file_path, $column_headers);

                foreach ($data['csvData'] as $row) {
                    $row = json_encode($row);
                    $row = str_replace('\ufeff', '', $row);
                    $row = (array)json_decode($row);

                    $existingRecord = $this->db->get_where('tbl_insurance_prices', array('treatment_id' => $row['treatment_id'], 'insurance_type_id' => $row['insurance_type_id'], 'treatment_category' => $row['treatment_category']))->row();

                    if (!$existingRecord) {

                        $this->db->insert('tbl_insurance_prices', $row);
                    } else {
                        // Handle the case when qatar_id already exists (ignore or update as needed)
                        $ignored = TRUE;
                        $ignored_txt .= '<li><p>Treatment Code: ' . $row['treatment_id'] . ' | Insurance : ' . $row['insurance_type_id'] . ' Department : ' . $row['treatment_category'] . '</p></li>';
                    }
                }

                $ignored_txt .= '</ol>';
                $ignored_txt = !$ignored ? null : $ignored_txt;

                if ($ignored) {
                    $this->session->set_flashdata('ignored', $ignored_txt);
                }
                $this->session->set_flashdata('success', "CSV Data Imported Successfully. " . $ignored_txt);
            }
            redirect(base_url('index.php/admin/Setting/Configurations/ConfigurationsController'));
        } catch (Exception $e) {
            $this->session->set_flashdata('errors', 'Critical Error: Failed to Import CSV Data.');
        }
    }

    // Notifications Templates
    public function LoadNotificationTemplates()
    {
        $templates = $this->ConfigurationsModel->LoadNotiicationTemplates($this->input->post('notification_type'));
        foreach ($templates as $key => $template) {
            $templates[$key]->e_id = encrypt_and_url_encode($template->id, $this);
        }

        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($templates));
    }

    // Create new notification template
    public function createNewNotificationTemplate()
    {
        $this->form_validation->set_rules('name', 'Template Name', 'required');
        $this->form_validation->set_rules('template', 'Template Content', 'required');
        $this->form_validation->set_rules('type', 'Template Type', 'required');
        $this->form_validation->set_rules('event_type', 'Template Event Type', 'required');
        $this->form_validation->set_rules('language', 'Template Language Type', 'required');

        if ($this->form_validation->run() == FALSE) {
            set_old($this);
            errors_to_flashdata($this);
            redirect('admin/Setting/Configurations/ConfigurationsController');
        }

        $data = $this->input->post();
        $id = $data['id'];
        unset($data['id']);

        if (empty($id)) {
            $this->ConfigurationsModel->insert_data('tbl_notification_templates', $this->input->post());
            $this->session->set_flashdata('success', 'New notification template created!');
        } else {
            $decrypted_id = decrypt_and_url_decode($id, $this);
            $this->ConfigurationsModel->update_data_where('tbl_notification_templates', 'id', $decrypted_id, $data);
            $this->session->set_flashdata('success', 'Notification template updated!');
        }

        redirect('admin/Setting/Configurations/ConfigurationsController');
    }

    public function editNotificationTempalte()
    {
        return  $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($this->ConfigurationsModel->loadTemplate($template_id)));
    }

    public function deleteNotificationTemplate($template_id)
    {
        $id = decrypt_and_url_decode($template_id, $this);
        $this->ConfigurationsModel->delete_data_where('tbl_notification_templates', 'id', $id);
        $this->session->set_flashdata('success', 'Notification template deleted!');
        redirect('admin/Setting/Configurations/ConfigurationsController');
    }

    public function ChangeActiveTemplate()
    {
        try {
            $this->db->trans_start();

            $template_id = decrypt_and_url_decode($this->input->post('template_id'), $this);
            $template_event_type = $this->input->post('template_event_type');
            $template_language = $this->input->post('template_language');


            //$this->ConfigurationsModel->update_data_where('tbl_notification_templates', 'event_type', $template_event_type, ['is_default' => 0]);

            // Perform the update
            $this->db->where(['event_type' => $template_event_type, 'language' => $template_language]);
            $this->db->update('tbl_notification_templates', ['is_default' => 0]);

            $this->ConfigurationsModel->update_data_where('tbl_notification_templates', 'id', $template_id, ['is_default' => 1]);

            $this->db->trans_commit();

            return $this->output
                ->set_content_type('application/json')
                ->set_output(json_encode(['message' => 'success']));
        } catch (Exception $e) {
            $this->db->trans_rollback();
            return $this->output
                ->set_content_type('application/json')
                ->set_output(json_encode(['message' => $e->getMessage()]));
        }
    }

    public function GetPlaceHolders()
    {
        return $this->output
                ->set_content_type('application/json')
                ->set_output(json_encode($this->ConfigurationsModel->GetPlaceholders($this->input->post('event'))));
    }

    public function SaveModules()
    {
        $modules = $this->input->post('id');
			$is_enable = $this->input->post('is_enable');

			foreach ($modules as $k => $q) {
				if ($q != 0) {
					$module_id = $modules[$k];
					$new_data = array(
						'is_enable' => $is_enable[$k]
					);

                    
					$this->ConfigurationsModel->update_data('tbl_modules', 'module_id', $module_id, $new_data);
				}
			}

            $this->session->set_flashdata('success', 'Modules Updated!');
            redirect('admin/Setting/Configurations/ConfigurationsController');
    }


    public function general_settings_view(){
        // $data['discounts'] = $this->ConfigurationsModel->retrieve_data('lab_units');
        $data['multiple'] = $this->ConfigurationsModel->retrieve_data_unique_row('discount_general', 'name', 'multiple');
    
        $this->load->view('admin/Setting/Configurations/Tabs/general_discounts',$data);
    }
    public function discount_categories_view(){
        // $data['discounts'] = $this->ConfigurationsModel->retrieve_data('lab_units');
        
        $this->load->view('admin/Setting/Configurations/Tabs/discount_categories_view');
    }
    public function discount_range_view(){
         $data['mulitple'] = $this->ConfigurationsModel->retrieve_data_unique_row('discount_general', 'name', 'multiple');
      
        $this->load->view('admin/Setting/Configurations/Tabs/discount_range_view',$data);
    }

    public function SaveGeneralDiscount(){
        // $data['discounts'] = $this->ConfigurationsModel->retrieve_data('lab_units');

       
        
        // Retrieve the data from the POST request
        $multipleDiscountsEnabled = $this->input->post('multiple_enable') ? 1 : 0;

        // Prepare the data array
        $data = array(
           
            'status'=>$multipleDiscountsEnabled
        );

        // Call the model method to save the data
        $result = $this->ConfigurationsModel->saveGeneralDiscount($data);

        

        // Check the result and respond accordingly
        if ($result) {
            $response = array('status' => 'success', 'message' => 'General discount settings saved successfully.');
        } else {
            $response = array('status' => 'error', 'message' => 'An error occurred while saving the general discount settings.');
        }

        // Return the response in JSON format
        echo json_encode($response);
        
    
    }

    public function  SaveDiscountCategories(){
        // $data['discounts'] = $this->ConfigurationsModel->retrieve_data('lab_units');

       
        
        // Retrieve the data from the POST request
        $name = $this->input->post('category_name') ;
        $discount = $this->input->post('discount') ;
        $category_id = $this->input->post('cat_id') ;
        // Prepare the data array
        $data = array(
           
            'category'=>$name,
            'discount'=>$discount,

        );
        if ($category_id) {
            // Update existing discount range
            $this->ConfigurationsModel->updateDiscountCategory($category_id,$name, $discount);
            $response = array('status' => 'success', 'message' => 'Disocunt Category Updates successfully.');
        } else {
        // Call the model method to save the data
            $result = $this->ConfigurationsModel->SaveDiscountCategories($data);
            $response = array('status' => 'success', 'message' => 'Disocunt Category saved successfully.');
        }

        // Check the result and respond accordingly
       
        // Return the response in JSON format
        echo json_encode($response);
        
    
    }

    public function  SaveDiscountRange(){
        // $data['discounts'] = $this->ConfigurationsModel->retrieve_data('lab_units');

       
        
        // Retrieve the data from the POST request
        $user_id = $this->input->post('user_id') ;
        $discount = $this->input->post('discount') ;
        $employee_type = $this->input->post('employee_type') ;
        $discount_id = $this->input->post('discount_id');

      

        // Prepare the data array
        $data = array(
           
            'user_id'=>$user_id,
            'max_value'=>$discount,
            'employee_type'=>$employee_type,

        );

        if ($discount_id) {
            // Update existing discount range
            $this->ConfigurationsModel->updateDiscountRange($discount_id,$employee_type, $user_id, $discount);
            $response = array('status' => 'success', 'message' => 'Disocunt Limit Updates successfully.');
        } else {
            $existing_data= $this->ConfigurationsModel->retrieve_data_unique_row('discount_range','user_id', $user_id);
        // Call the model method to save the data
        if($existing_data){
            $response = array('status' => 'warning', 'message' => 'This User has already discount limit.');
        }else{
            $result = $this->ConfigurationsModel->SaveDiscountRange($data);
            $response = array('status' => 'success', 'message' => 'Disocunt Limit saved successfully.');
            
        }
       
        }
        

        // Return the response in JSON format
        echo json_encode($response);
        
    
    }

   

    public function get_discount_categories(){

        $result = $this->ConfigurationsModel->retrieve_data('discount_category');

           
            if (!isset($result) || $result == null) {
                $result = [];
            }
            $total_records = count($result);
            $response = [
               
                "recordsTotal" => $total_records,
                "recordsFiltered" => $total_records,
                "data" => $result
            ];

          
            $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    public function get_discount_range(){

        $result = $this->ConfigurationsModel->getDiscountRangeWithUsers();
           
            if (!isset($result) || $result == null) {
                $result = [];
            }
            $total_records = count($result);
            $response = [
               
                "recordsTotal" => $total_records,
                "recordsFiltered" => $total_records,
                "data" => $result
            ];

          
            $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($response));
    }

    public function getUsersByType() {
        $type = $this->input->post('type');
        
        
        $users = $this->ConfigurationsModel->getUsersByType($type);
        
        // Return the response in JSON format
        echo json_encode($users);
    }

    public function getDiscountById() {
        $id = $this->input->post('id');
        
        // Load the model
 
        
        // Retrieve discount data by ID
        $discount = $this->ConfigurationsModel->retrieve_data_unique_row('discount_range','id',$id);
        
        // Return the response in JSON format
        echo json_encode($discount);
    }

    public function getDiscountCatById() {
        $id = $this->input->post('id');
        
        // Load the model
 
        
        // Retrieve discount data by ID
        $discount = $this->ConfigurationsModel->retrieve_data_unique_row('discount_category','id',$id);
        
        // Return the response in JSON format
        echo json_encode($discount);
    }

    public function deleteDiscountRange() {
        $id = $this->input->post('id');
        
        // Load the model
      
        
        // Delete discount range by ID
        $this->ConfigurationsModel->deleteDiscountRange($id);
        
        // Return the response in JSON format
        $response = ['message' => 'Discount range deleted successfully'];
        echo json_encode($response);
    }
    
    public function deleteDiscountCategory() {
        $id = $this->input->post('id');
        
        // Load the model
      
        
        // Delete discount range by ID
        $this->ConfigurationsModel->deleteDiscountCategory($id);
        
        // Return the response in JSON format
        $response = ['message' => 'Discount range deleted successfully'];
        echo json_encode($response);
    }


    public function SaveGeneral(){
        // $data['discounts'] = $this->ConfigurationsModel->retrieve_data('lab_units');

       
        
        // Retrieve the data from the POST request
       

        // Prepare the data array
        $data = array(
           
            'slot_gap'=>$this->input->post('appointment_gap'),
            'type'=>'appointment',
            'start_time'=>$this->input->post('start_time'),
            'end_time'=>$this->input->post('end_time'),
        );

        // Call the model method to save the data
        $result = $this->ConfigurationsModel->saveGeneral($data);

        

        // Check the result and respond accordingly
        if ($result) {
            $response = array('status' => 'success', 'message' => 'General  settings saved successfully.');
        } else {
            $response = array('status' => 'error', 'message' => 'An error occurred while saving the general  settings.');
        }

        // Return the response in JSON format
        echo json_encode($response);
        
    
    }

    public function whatsapp_details(){
        $data['messagecount'] = $this->CommonModel->get_whatsapp_plan();
       

        $this->load->view('admin/Setting/Messages/whatsapp_details', $data);
    }
    public function sms_details(){
        $data['subscriptions'] = $this->CommonModel->get_sms_plan();

     

        $this->load->view('admin/Setting/Messages/sms_details', $data);
    }

    public function new_packages(){
        $data['packages'] = $this->CommonModel->retrieve_data('message_packages');

     

        $this->load->view('admin/Setting/Messages/new_packages', $data);
    }


    public function SavePackage(){

        $is_limited = $this->input->post('limited') ? 1 : 0;
        $packageData = array(
            'name' => $this->input->post('name'),
            'price' => $this->input->post('price'),
            'is_limited' => $is_limited,
            'days' => $this->input->post('days'),
           
        );

      $package_id=  $this->ConfigurationsModel->savePackage($packageData);
        

        
      $departments = $this->input->post('departments');
      $nameSessions = $this->input->post('name_session');
  
      foreach ($departments as $department) {
          if (!empty($nameSessions[$department])) {
              $detailsData = array(
                  'package_id' => $package_id,
                  'department_id' => $department,
                  'sessions' => $nameSessions[$department]
              );

           
              $this->ConfigurationsModel->savePackageDetails($detailsData);
          }
      }
 

        

        // Check the result and respond accordingly
        if ($package_id) {
            $response = array('status' => 'success', 'message' => 'Package saved successfully.');
        } else {
            $response = array('status' => 'error', 'message' => 'An error occurred while saving.');
        }

        // Return the response in JSON format
        echo json_encode($response);
        
    
    }

    public function get_packages(){
        $result = $this->ConfigurationsModel->getPackages();
           
        if (!isset($result) || $result == null) {
            $result = [];
        }
        $total_records = count($result);
        $response = [
           
            "recordsTotal" => $total_records,
            "recordsFiltered" => $total_records,
            "data" => $result
        ];

      
        $this->output
        ->set_content_type('application/json')
        ->set_output(json_encode($response));
    }
    public function deletePackage() {
        $id = $this->input->post('id');
        
        // Load the model
      
        
        // Delete discount range by ID
        $this->ConfigurationsModel->deletePackage($id);
        
        // Return the response in JSON format
        $response = ['message' => 'Discount range deleted successfully'];
        echo json_encode($response);
    }

    public function enableModule(){

        $type = $this->input->post('type');
        $data = array(
           
            'value'=>$this->input->post('enabled'),
            'name'=>'is_enable',
            'type'=>$type,
           
        );

        // Call the model method to save the data
        $result = $this->ConfigurationsModel->saveGeneral_($data);

        // Check the result and respond accordingly
        if ($result) {
            $response = array('status' => 'success', 'message' => 'Module Updated Successfully.');
        } else {
            $response = array('status' => 'error', 'message' => 'An error occurred while processing.');
        }

        // Return the response in JSON format
        echo json_encode($response);
    }


public function checkNotification() {
    $type = $this->input->post('type');
    $eventType = $this->input->post('event_type');

    // Query the table to check if the same event_type has another channel active
    $this->db->where('reminder', $eventType);
    $this->db->where('status =', 0); // Check for different notification type
    $existing = $this->db->get('notification_reminders')->row();

    if ($existing) {
        // Return a response that a notification for this event type with another channel exists
        echo json_encode(['status' => 'exists']);
    } else {
        echo json_encode(['status' => 'not_exists']);
    }
}


public function createNotificationReminder(){
    $type = $this->input->post('type');
    $eventType = $this->input->post('event_type');
    $time = $this->input->post('time');
    
    $data= array(
        'time'=>$time,
        'type'=>$type,
        'reminder'=>$eventType,
        'reminder_type'=>1
    );
    $name = $this->db->insert('notification_reminders',$data);
    $this->session->set_flashdata('success', 'Reminder Created Successfully.');
    $this->redirect_back();

}

public function LoadNotificationReminders()
{
    $templates = $this->ConfigurationsModel->LoadNotificationReminders($this->input->post('notification_type'));
  

    $this->output
        ->set_content_type('application/json')
        ->set_output(json_encode($templates));
}
public function updateReminderStatus() {
    $id = $this->input->post('id');
    $status = $this->input->post('status');

    // Update the reminder's active status in the database
    $this->db->where('id', $id);
    $this->db->update('notification_reminders', ['status' => $status]);

   
    if ($this->db->affected_rows() > 0) {
        echo json_encode(['status' => 'success']);
    } else {
        echo json_encode(['status' => 'error']);
    }
}


public function createAutomatedMessage(){
    $create_appointment = $this->input->post('create_appointment');
    $payment_receive = $this->input->post('payment_receive');
    $queue_token = $this->input->post('queue_token');
    $appt_confirmation = $this->input->post('appt_confirmation');
    
    $data = array(
        array(
            'time' => '0', 
            'reminder' => 'create_appointment', // First item (Appointment Creation)
            'type' => $create_appointment,
            'reminder_type' => 2 // Adjust this field according to your logic
        ),
        array(
            'time' => '0', 
            'reminder' => 'payment_receive', // Second item (On Payment Receiving)
            'type' => $payment_receive,
            'reminder_type' => 2 // Adjust this field according to your logic
        ),
        array(
            'time' => '0', 
            'reminder' => 'queue_token', // Third item (Queue Token)
            'type' => $queue_token,
            'reminder_type' => 2 // Adjust this field according to your logic
        ),
        array(
            'time' => '0', 
            'reminder' => 'appt_confirmation', // Third item (Confirmation)
            'type' => $appt_confirmation,
            'reminder_type' => 2 // Adjust this field according to your logic
        )
    );


    foreach ($data as $row) {
        // Check if the record exists
        $this->db->where('reminder', $row['reminder']);
        $query = $this->db->get('notification_reminders');
        
        if ($query->num_rows() > 0) {
            // Record exists, perform an update
            $this->db->where('reminder', $row['reminder']);
            $this->db->update('notification_reminders', $row);
        } else {
            // Record does not exist, perform an insert
            $this->db->insert('notification_reminders', $row);
        }
    }
   
   
    $this->session->set_flashdata('success', 'Saved Successfully.');
    $this->redirect_back();

}
   
}
