<?php

class GeneralController extends CI_Controller {

    function __construct() {
        parent::__construct();

        $this->load->model('admin/Setting/GeneralModel');

        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
    }

    public function index() {

        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 9;
            $data['active_submenu'] = 2;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			 //Locals =========================================================================
			
			$date = date('Y-m-d');
			$data['fire_date'] = $date;
			$data['btn_text'] = 'Fire';
			$data['btn_disabled'] = '';
			
			$check_data = $this->GeneralModel->check_fired_daily_time_table($date);
			
			foreach ($check_data AS $row) {
				$data['btn_text'] = 'Already fired';
				$data['fire_date'] = 'Daily time table already created';
				$data['btn_disabled'] = 'disabled';
			}
			

            $this->load->view('admin/Setting/GeneralSettings', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }

    public function fire_sp() {

        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 9;
            $data['active_submenu'] = 2;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			 //Locals =========================================================================
			
			$date = date('Y-m-d');
			
			$data_save = array(
                'fired_date' => $date,
				'create_user_Id' => $loginId,
				'create_datetime' => date('Y-m-d H:i:s')
			);
			
			$_id = $this->GeneralModel->fire_save($data_save);
			

            self::index();
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
    }
	
	
	
	public function timeTable_daily_fire_sp() {

        

            //Commen -------------------------------------
            $loginId = 77; //$this->session->userdata('user_Id');
            $data['active_menu'] = 9;
            $data['active_submenu'] = 2;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
            
             //Locals =========================================================================
            
            $date = date('Y-m-d');
            
            $data_save = array(
                'fired_date' => $date,
                'create_user_Id' => $loginId,
                'create_datetime' => date('Y-m-d H:i:s')
            );
            
            $_id = $this->GeneralModel->fire_save($data_save);
            

            self::index();
            
       

            
         
    }

}
