<?php

class SiteImagesController extends MY_Controller {

    function __construct() {
        parent::__construct();

        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');

        $this->load->model('admin/SiteImages/SiteImagesModel');
    }

    public function index() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 30;
            $data['active_submenu'] = 0;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$data['list'] = $this->SiteImagesModel->get_list(); 

            $this->load->view('admin/SiteImages/SiteImagesList', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	public function createnew() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 30;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = 0;
			$title = '';
			$description = '';
			$item_image = 'dist/img/empty.png';
			$is_new_image = 'false';
			$is_active = '';
			$site_image_type = 0;
			$width =0;
			$height =0;
			$boundary_width =0;
			$boundary_height =0;
			$updated_datetime = date('Y-m-d');
			
			$data['_id'] = $_id;
			$data['description'] = $description;
			$data['title'] = $title;
			$data['item_image'] = $item_image;
			$data['is_new_image'] = $is_new_image;
			$data['is_active'] = $is_active;
			$data['site_image_type'] = $site_image_type;
			$data['width'] = $width;
			$data['height'] = $height;
			$data['boundary_width'] = $boundary_width;
			$data['boundary_height'] = $boundary_height;
			$data['updated_datetime'] = $updated_datetime;
			
			$data['site_images'] = $this->CommonModel->get_site_images();
			
            $this->load->view('admin/SiteImages/SiteImages', $data);
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	public function save() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 30;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = $this->input->post('_id');
			$description = $this->input->post('description');
			$title = $this->input->post('title');
			$item_image = $this->input->post('item_image');
			$is_new_image = $this->input->post('is_new_image');
			$is_active = $this->input->post('is_active');
			$site_image_type = $this->input->post('site_image_type');
			$width = $this->input->post('width');
			$height = $this->input->post('height');
			$boundary_width = $this->input->post('boundary_width');
			$boundary_height = $this->input->post('boundary_height');
			$updated_datetime = $this->input->post('updated_datetime');
			
			
			$data['_id'] = $_id;
			$data['description'] = $description;
			$data['title'] = $title;
			$data['item_image'] = $item_image;
			$data['is_new_image'] = $is_new_image;
			$data['is_active'] = $is_active;
			$data['site_image_type'] = $site_image_type;
			$data['width'] = $width;
			$data['height'] = $height;
			$data['boundary_width'] = $boundary_width;
			$data['boundary_height'] = $boundary_height;
			$data['updated_datetime'] = $updated_datetime;
			
			
			$data['site_images'] = $this->CommonModel->get_site_images();
			
			//print_r($data['brand_name']);die;
			$this->form_validation->set_rules('title', 'Title', 'trim|required');
			$this->form_validation->set_rules('description', 'Description', 'trim|required');
			$this->form_validation->set_rules('site_image_type', 'Status ID', 'callback_image_type_check');
			$this->form_validation->set_rules('item_image', 'Item Image', 'callback_item_image_check');
			
			
			if ($this->form_validation->run() == FALSE) {
				
                $this->load->view('admin/SiteImages/SiteImages', $data);
                return;
				
            }
			
			
			$data_save = array (

				'title' => $title,
				'description' => $description,
				'image_path' => '',
				'is_active' => $is_active == 'active' ? 1 : 0,
				'site_image_type' => $site_image_type,
				'updated_datetime' => date('Y-m-d H:i:s')
		
			);
			
			//print_r($data_save);die;
			
			if($_id > 0 ) {
								
				$this->SiteImagesModel->update($_id,$data_save,$is_new_image,$item_image);
				
			} else {
				
				$this->SiteImagesModel->save($data_save,$is_new_image,$item_image);
				
			}
			
			
			redirect('admin/SiteImages/SiteImagesController', 'refresh');

			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	public function image_type_change() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 30;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = $this->input->post('_id');
			$description = $this->input->post('description');
			$title = $this->input->post('title');
			$item_image = $this->input->post('item_image');
			$is_new_image = $this->input->post('is_new_image');
			$is_active = $this->input->post('is_active');
			$site_image_type = $this->input->post('site_image_type');
			$updated_datetime = $this->input->post('updated_datetime');
			
			
			$data['_id'] = $_id;
			$data['description'] = $description;
			$data['title'] = $title;
			$data['item_image'] = 'dist/img/empty.png';
			$data['is_new_image'] = false;
			$data['is_active'] = $is_active;
			$data['site_image_type'] = $site_image_type;
			$data['updated_datetime'] = $updated_datetime;
			
			
			$width = '';
			$height = '';
			$boundary_width = '';
			$boundary_height = '';
			
			$site_image_type = $this->input->post('site_image_type');
			
			$details = $this->SiteImagesModel->get_site_image_type_details($site_image_type);
				
			foreach ($details->result() as $row) {

				
					$width = $row->width;
					$height = $row->height;
					$boundary_width = $row->boundary_width;
					$boundary_height = $row->boundary_height;
				}
			
			$data['site_image_type'] = $site_image_type;
			$data['width'] = $width;
			$data['height'] = $height;
			$data['boundary_width'] = $boundary_width;
			$data['boundary_height'] = $boundary_height;
			
			$data['site_images'] = $this->CommonModel->get_site_images();
			
			$this->load->view('admin/SiteImages/SiteImages', $data);
	
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	public function edit() {
		
        if ($this->session->userdata('user_Id') != '') {

            //Commen -------------------------------------
            $loginId = $this->session->userdata('user_Id');
            $data['active_menu'] = 30;
            $data['active_submenu'] = 1;
            $data['user_right'] = $this->CommonModel->logged_user_right($loginId);
            $data['profile'] = $this->CommonModel->profile($loginId);
			
			$_id = base64_decode(urldecode($this->input->post('selected_id')));
			
			if($_id != null && $_id != ''){
			
				$details = $this->SiteImagesModel->get_details_by_id($_id);
				
		
				foreach ($details->result() as $row) {

					$title = $row->title;
					$description = $row->description;
					$item_image = $row->image_path;
					$is_new_image = false;
					$is_active = $row->is_active == 1 ? 'active' : '';
					$site_image_type = $row->site_image_type;
					$width = $row->width;
					$height = $row->height;
					$boundary_width = $row->boundary_width;
					$boundary_height = $row->boundary_height;
					$updated_datetime = $row->updated_datetime;
				}
					//print($item_image);die;
				$data['_id'] = $_id;
				$data['title'] = $title;
				$data['description'] = $description;
				$data['item_image'] = $item_image;
				$data['is_new_image'] = $is_new_image;
				$data['is_active'] = $is_active;
				$data['site_image_type'] = $site_image_type;
				$data['width'] = $width;
				$data['height'] = $height;
				$data['boundary_width'] = $boundary_width;
				$data['boundary_height'] = $boundary_height;
				$data['updated_datetime'] = $updated_datetime;
				
				$data['site_images'] = $this->CommonModel->get_site_images();
				
				$this->load->view('admin/SiteImages/SiteImages', $data);
				
			} else {
				
				redirect('admin/CommenController/page_not_found', 'refresh');
				
			}
			
        } else {
            redirect('admin/Login/LoginController', 'refresh');
        }
		
    }
	
	
	public function image_type_check() {
		
        if (trim($this->input->post('site_image_type')) == 0) {
            $this->form_validation->set_message('image_type_check', 'Image Type required.');
            return FALSE;
        } else {
            return TRUE;
        }
    }
	
	public function item_image_check() {
		
        if (trim($this->input->post('item_image')) == 'dist/img/empty.png') {
            $this->form_validation->set_message('item_image_check', 'Image required.');
            return FALSE;
        } else {
            return TRUE;
        }
    }
	

}
