<?php

require_once APPPATH . 'controllers/admin/Jobs/Job/SmsNotification.php';

class SmsPortalController extends MY_Controller
{
    private $job = null;

    function __construct()
    {
        parent::__construct();
        $this->job = new Job($this);

        //Commen -------------------------------------
        $this->load->model('admin/CommonModel');
        $this->load->model('admin/SmsPortal/SmsPortalModel');

        $this->load->helper(array('form', 'url'));
        $this->load->library('form_validation');
         $this->load->model('admin/Job/NotificationJob');
    }


public function index()
    {
        $data['datajobs'] = $this->NotificationJob->get_bulkBatches_count();
      
        
        $this->load->view('admin/SmsPortal/portal',$data);
    }

    public function getPatients()
    {
        $query = $this->input->get('query');
        
        $this->output
            ->set_content_type('application/json')
            ->set_output(json_encode($this->SmsPortalModel->load_patients($query)));
    }

    public function sendIndividualSms()
    {
        $this->form_validation->set_rules('patient', 'Patient', 'required');
        $this->form_validation->set_rules('message', 'Message', 'required');

     

        //echo json_encode($this->input->post());exit;
        $patient_mobile_number = $this->input->post('patient');
        $message = $this->input->post('message');
          
            // foreach($patient_mobile_number as $item){
            //     $data= array(
            //         'message'=>$message,
            //         'phone'=>$item
            //     );
            //     $this->createSms($data);
            // }
            $batchSize = 100;  // Define the batch size
            $batches = array_chunk($patient_mobile_number, $batchSize);
           
        foreach ($batches as $batch) {
            $this->createBatchSmsJob($batch, $message,true);
        }
      $baseUrl = base_url(); // Automatically gets the current domain
    $url = rtrim($baseUrl, '/') . '/admin/Jobs/NotificationController/send_bulkSMS';

    // Trigger the dynamic URL
    $this->triggerUrl($url);
         
        $this->session->set_flashdata('success', 'SMS Scheduled!');
        redirect('admin/SmsPortal/SmsPortalController/index');
    }
    
    private function triggerUrl($url)
{
  
    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Optional: if HTTPS and SSL issues
    curl_setopt($ch, CURLOPT_TIMEOUT, 0);

    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        log_message('error', 'Error hitting URL: ' . curl_error($ch));
    } else {
        log_message('info', 'URL triggered successfully. Response: ' . $response);
    }

    curl_close($ch);
}

    public function createSms($data){
        $smsjob = array(
            'message'=>$data['message'],
            'phone'=>$data['phone'],
        );
        $smsjob = json_encode($smsjob);
        $job= array(
            'queue'=>'DEFAULT',
            'payload'=>$smsjob,
            'event'=>'bulk_sms',
        
        );
         $smsJob= $this->SmsPortalModel->insert_data('tbl_jobs', $job);
    }

    public function validate_bulk_patients($bulk_patients) {
        if (empty($bulk_patients)) {
            $this->form_validation->set_message('validate_bulk_patients', 'Please select at least one patient.');
            return false;
        }
        return true;
    }
    
    
   public function sendBulkSmsAjax()
{
    $this->output->set_content_type('application/json');

    $message = $this->input->post('message');
    $patients = $this->input->post('patients'); // This will be a JSON array from JS

    if (empty($patients) || !$message) {
        echo json_encode(['status' => 'error', 'message' => 'Missing patients or message']);
        return;
    }
        $this->createBatchSmsJobNew([$patients], $message); // assume it accepts 1 or many
        // $baseUrl = base_url(); // Automatically gets the current domain
        // $url = rtrim($baseUrl, '/') . '/admin/Jobs/NotificationController/send_bulkSMS';
    
        // Trigger the dynamic URL
    // $this->triggerUrl($url); 

    echo json_encode(['status' => 'success']);
}
public function getBulkPatients()
{
    $type = $this->input->get('type');
    if ($type === 'vip') {
        $patients = $this->CommonModel->get_valid_vip_patients();
    } else {
        $patients = $this->CommonModel->get_valid_patients();
    }

    $mobiles = array_map(function($p) {
        return $p->mobile; // Adjust this according to your actual DB field
    }, $patients);

    $this->output->set_content_type('application/json')->set_output(json_encode($mobiles));
}

    // public function sendBulkSms()
    // {

    //     $bulk_sms = $this->input->post('bulk_patients');
    //     if($bulk_sms == 'all'){
    //         $patients= $this->CommonModel->get_valid_patients();
    //     }if($bulk_sms == 'vip'){
    //         $patients= $this->CommonModel->get_valid_vip_patients();
         
    //     }
    //     //var_dump($patient_mobile_numbers);exit;
    //     $message = $this->input->post('bulk_message');
    //     $batchSize = 100;  // Define the batch size
    //     $batches = array_chunk($patients, $batchSize);
       
    // foreach ($batches as $batch) {
    //     $this->createBatchSmsJob($batch, $message);
    // }
 
    //       $baseUrl = base_url(); // Automatically gets the current domain
    // $url = rtrim($baseUrl, '/') . '/admin/Jobs/NotificationController/send_bulkSMS';

    // // Trigger the dynamic URL
    // $this->triggerUrl($url);        
    //     $this->session->set_flashdata('success', 'Bulk SMS Sending Starts!');
    //     redirect('admin/SmsPortal/SmsPortalController/index');
    // }

    public function send_sms_number()
    {

        $bulk_numbers = $this->input->post('phoneNumbers');
     
        //var_dump($patient_mobile_numbers);exit;
        $message = $this->input->post('message');
        $batchSize = 100;  // Define the batch size
        $batches = array_chunk($bulk_numbers, $batchSize);
       
    foreach ($batches as $batch) {
    
        $this->createBatchSmsJob($batch, $message,true);
    }
 
          $baseUrl = base_url(); // Automatically gets the current domain
    $url = rtrim($baseUrl, '/') . '/admin/Jobs/NotificationController/send_bulkSMS';

    // Trigger the dynamic URL
    $this->triggerUrl($url);         
      echo 'Message Sent';
    }
    
    
    public function createBatchSmsJobNew($batch, $message,$isDirectNumbers = false)
{
    // Prepare job data for each batch
    
    $smsJobs = [];
    foreach ($batch as $item) {
        $phone = $isDirectNumbers ? $item : $item;  // Check if we are using direct numbers or patient objects
        $smsJobs[] = [
            'message' => $message,
            'phone' => $phone
        ];
    }

    // Encode the job data as JSON
    $smsJobData = json_encode($smsJobs,JSON_UNESCAPED_UNICODE);

    // Create a job entry in the jobs table for this batch
    $job = [
        'queue' => 'DEFAULT',
        'payload' => $smsJobData,
        'event' => 'bulk_sms_batch',
    ];

    $this->SmsPortalModel->insert_data('tbl_jobs', $job);
}

    public function createBatchSmsJob($batch, $message,$isDirectNumbers = false)
{
    // Prepare job data for each batch
    $smsJobs = [];
    foreach ($batch as $item) {
        $phone = $isDirectNumbers ? $item : $item->mobile;  // Check if we are using direct numbers or patient objects
        $smsJobs[] = [
            'message' => $message,
            'phone' => $phone
        ];
    }

    // Encode the job data as JSON
    $smsJobData = json_encode($smsJobs,JSON_UNESCAPED_UNICODE);

    // Create a job entry in the jobs table for this batch
    $job = [
        'queue' => 'DEFAULT',
        'payload' => $smsJobData,
        'event' => 'bulk_sms_batch',
    ];

    $this->SmsPortalModel->insert_data('tbl_jobs', $job);
}
public function getPatientCount()
{
    $patientType = $this->input->post('patientType');
    
    if ($patientType === 'all') {
        $count = count($this->CommonModel->get_valid_patients());
    } elseif ($patientType === 'vip') {
        $count = count($this->CommonModel->get_valid_vip_patients());
    } else {
        $count = 0;
    }

    // Return the count as a JSON response
    echo json_encode(['count' => $count]);
}

    public function load_view($view){
        if($view == 'patient'){
            $this->load->view('admin/SmsPortal/patient_sms');
        }elseif($view == 'numbers'){
            $this->load->view('admin/SmsPortal/number_sms');
        }else if($view == 'smsTask'){
            $this->load->view('admin/SmsPortal/sms_task');
        }
    }

    public function upload_csv() {
        // Load upload library
        $config['upload_path'] = './uploads/csv';
        $config['allowed_types'] = 'csv';
        $config['max_size'] = 1000;

        $this->load->library('upload', $config);
        if (file_exists($config['upload_path'] . $_FILES['csv_file']['name'])) {
            unlink($config['upload_path'] . $_FILES['csv_file']['name']);
        }
        if (!$this->upload->do_upload('csv_file')) {
            echo 'Failed to upload file.';
        } else {
            // File successfully uploaded
            $file = $this->upload->data();

            // Open the uploaded CSV file
            $file_path = './uploads/csv/' . $file['file_name'];
            $csvData = array_map('str_getcsv', file($file_path));
            
            // Remove the header row if exists and count the rows
            $totalNumbers = count($csvData) - 1; // Subtract 1 if the first row is a header
            $phoneNumbers = array_column($csvData, 0); // Assume phone numbers are in the first column

            echo '<h4>Total Numbers: ' . $totalNumbers . '</h4>';
            echo '<form id="numberForm"><table class="table table-bordered table-striped">';
            echo '<tr><th>Select</th><th>Phone Number</th></tr>';
            foreach ($phoneNumbers as $number) {
                echo '<tr><td><input type="checkbox" class="numberCheckbox" value="' . htmlspecialchars($number) . '" checked></td><td>' . htmlspecialchars($number) . '</td></tr>';
            }
            echo '</table>';
            echo '</form>';
        }
    }

  public function clearPending()
{
    $this->db->where('event', 'bulk_sms_batch')
    ->where('is_sent', 0) // Ensures only unsent batches are deleted
    ->delete('tbl_jobs');

echo json_encode(['success' => true]);
}

}
