<?php

if (!defined('BASEPATH')) exit('No direct script access allowed');




function get_subscription_expiry($CI)
{

	$data = $CI->CommonModel->subscriptions();

	$expiry_date = date_create($data->expired_at);
	$f_date = date_format($expiry_date, "d-M-Y ");

	$start_date = date_create($data->start_date);
	$s_date = date_format($start_date, "d-M-Y ");

	$start_date = strtotime(date('Y-m-d')); // Convert start date to timestamp
	$end_date = strtotime($f_date); // Convert end date to timestamp

	$datediff = $end_date - $start_date; // Calculate difference in seconds

	$days = round($datediff / (60 * 60 * 24));

	$data = array('ex_date' => $f_date,'plan'=>$data->plan, 'days' => $days);
	return $data;
}

function date_formate_days($date,$CI){
	$timestamp = strtotime($date);
$today = strtotime('today midnight');
$yesterday = strtotime('yesterday midnight');

$new_date='';
if ($timestamp >= $today) {
    $new_date= "Today at " . date('g:i A', $timestamp);
} elseif ($timestamp >= $yesterday) {
    $new_date= "Yesterday at " . date('g:i A', $timestamp);
} else {
    $new_date= date('d-m-Y H:i', $timestamp); // Default fallback to full date if older than yesterday
}
return $new_date;
}

function encrypt_and_url_encode($value, $CI)
{
	// if(empty($value)){
	// 	throw "Cannot encrypt a empty value.";
	// }

	return rawurlencode(base64_encode($CI->encryption->encrypt($value)));
}

function get_discount_limt($CI){

	$data = $CI->CommonModel->retrieve_data_unique_row('discount_range','user_id',$CI->session->userdata('user_Id'));
           

	return $data->max_value ?? '';

}

function decrypt_and_url_decode($encoded_value, $CI)
{
	try {
		$decoded_value = base64_decode(rawurldecode($encoded_value));
		return $CI->encryption->decrypt($decoded_value);
	} catch (Throwable $th) {
		throw $th;
	}
}

function check_right($right_name, $CI)
{
	try {
		$user_id = $CI->session->userdata('user_Id');
		$other_right = $CI->CommonModel->logged_user_rights($right_name, $user_id);
		return $other_right != FALSE ? TRUE : FALSE;
	} catch (Throwable $th) {
		throw $th;
	}
}

function print_header($CI)
{
	// $CI->load->model('admin/CommonModel');

	$company = $CI->CommonModel->get_company_info();
	// $template = $CI->CommonModel->get_common_document_printable_header_template();

	// $template = str_replace('{{_COMPANY_NAME_}}', $company->company_name, $template);
	// $template = str_replace('{{_ADDRESS_}}', $company->address, $template);
	// $template = str_replace('{{_PHONE_NO_}}', $company->phone_no, $template);
	// $template = str_replace('{{_MOBILE_NO_}}', $company->mobile_no, $template);
	// $template = str_replace('{{_EMAIL_}}', $company->email, $template);
	// $template = str_replace('{{_FAX_}}', $company->fax, $template);
	// $template = str_replace('{{_LOGO_}}', base_url($company->logo), $template);
	// $template = str_replace('{{_WEB_}}', $company->web, $template);
	// $template = str_replace('{{_PRINT_DATE_}}', date('Y-m-d H:i:s'), $template);

	// echo $template;
	$htmlContent = '<div class="container" id="invoice">
    <div class="row">
        <div class="col-lg-12">
            <div class="custom-card">
                <div class="card-body" id="print-card">
                    <div class="invoice-title">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="text-muted">
                                    <p class="mb-1 fw-bold"><i class="ri-map-pin-2-line me-2"></i>&nbsp;' . $company->address . '</p>
                                    <p class="mb-1 fw-bold"><i class="ri-mail-line me-2"></i>&nbsp;' . $company->email . '</p>
                                    <p class="mb-1 fw-bold"><i class="ri-phone-line me-2"></i>&nbsp;' . $company->mobile_no . '</p>
                                </div>
                            </div>
                            <div class="col-md-4 d-flex justify-content-center">
                                <img style="width: 70%; object-fit: contain;" src="' . base_url($company->logo) . '" class="img-fluid" alt="Company Logo" />
                            </div>
							<div class="col-md-4 d-flex flex-column text-right" style="font-size:12px">
								<small class="text-muted">Printed by H-Mate Hospital Management System</small>
                                <small class="text-muted">Print Date: '.date("d-m-Y H:i a").'</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div><!-- end col -->
    </div>
</div><hr  class="mb-3 mt-0">';


	return $htmlContent;
}

function set_old($CI)
{
	$CI->session->set_flashdata('hmate_form_flash_data', $CI->input->post());
}

function old($CI, $field)
{
	$form_submit_data = $CI->session->flashdata('hmate_form_flash_data');
	if ($form_submit_data !== NULL) {
		return !empty($form_submit_data[$field]) ? $form_submit_data[$field] : null;
	}
	return null;
}

function errors_to_flashdata($CI)
{
	// $errors = [];
	// $fields = $CI->input->post(NULL, TRUE);

	// foreach ($fields as $field => $value) {
	// 	$error = form_error($field);
	// 	if (!empty($error)) {
	// 		$errors[$field] = $error;
	// 	}
	// }
	$errors = $CI->form_validation->error_array();
	$CI->session->set_flashdata('flash_errors', $errors);
}

function _e($CI, $field)
{
	$e = null;
	if (!empty($CI->session->flashdata('flash_errors')[$field])) {
		$e = "<span class='text-danger font-weight-bold'>" . $CI->session->flashdata('flash_errors')[$field] . "</span>";
	}
	return $e;
}

function getLoginUser($CI){

	$data = $CI->CommonModel->retrieve_data_unique_row('tbl_users','user_Id',$CI->session->userdata('user_Id'));
           

	return $data;

}
function get_notifications($CI){

	$data = $CI->CommonModel->retrieve_data_unique('tbl_notifications','user_Id',$CI->session->userdata('user_Id'));
	
	$CI->db->from('tbl_notifications');
	$CI->db->where('user_id', $CI->session->userdata('user_Id'));
	$CI->db->where('type', 'Notification');
	$CI->db->where('is_read', '0');

	$query = $CI->db->get();
    return $query->result(); 
}
function is_whatsapp($CI){
	$CI->db->from('tbl_config_services');
	$CI->db->where('service_name', 'whatsapp_service');
	$query = $CI->db->get();
	$reuslt =  $query->result();

	if(count($reuslt)>0){
		return true;
	}else{
		return false;
	}
}

function get_loyalty_points($patient_id,$CI){
	$CI->db->from('user_loyalty_points');
	$CI->db->where('user_id',$patient_id);
	$query = $CI->db->get();
	$reuslt =  $query->row();

	if(!empty($reuslt)){
		return $reuslt->points_balance;
	}else{
		return 0;
	}

}

function get_procedure_name($id,$CI){
	$CI->db->from('tbl_insurance_prices');
	$CI->db->where('id',$id);
	$query = $CI->db->get();
	$reuslt =  $query->row();

	if(!empty($reuslt)){
		return  $reuslt->treatment_id.'-'.$reuslt->treatment_name;
	}else{
		return 0;
	}

}

function convert_number_to_words($number) {
   
    $hyphen      = '-';
    $conjunction = ' and ';
    $separator   = ', ';
    $negative    = 'negative ';
    $decimal     = ' point ';
    $dictionary  = array(
        0                   => 'Zero',
        1                   => 'One',
        2                   => 'Two',
        3                   => 'Three',
        4                   => 'Four',
        5                   => 'Five',
        6                   => 'Six',
        7                   => 'Seven',
        8                   => 'Eight',
        9                   => 'Nine',
        10                  => 'Ten',
        11                  => 'Eleven',
        12                  => 'Twelve',
        13                  => 'Thirteen',
        14                  => 'Fourteen',
        15                  => 'Fifteen',
        16                  => 'Sixteen',
        17                  => 'Seventeen',
        18                  => 'Eighteen',
        19                  => 'Nineteen',
        20                  => 'Twenty',
        30                  => 'Thirty',
        40                  => 'Fourty',
        50                  => 'Fifty',
        60                  => 'Sixty',
        70                  => 'Seventy',
        80                  => 'Eighty',
        90                  => 'Ninety',
        100                 => 'Hundred',
        1000                => 'Thousand',
        1000000             => 'Million',
        1000000000          => 'Billion',
        1000000000000       => 'Trillion',
        1000000000000000    => 'Quadrillion',
        1000000000000000000 => 'Quintillion'
    );
   
    if (!is_numeric($number)) {
        return false;
    }
   
    if (($number >= 0 && (int) $number < 0) || (int) $number < 0 - PHP_INT_MAX) {
        // overflow
        trigger_error(
            'convert_number_to_words only accepts numbers between -' . PHP_INT_MAX . ' and ' . PHP_INT_MAX,
            E_USER_WARNING
        );
        return false;
    }

    if ($number < 0) {
        return $negative . convert_number_to_words(abs($number));
    }
   
    $string = $fraction = null;
   
    if (strpos($number, '.') !== false) {
        list($number, $fraction) = explode('.', $number);
    }
   
    switch (true) {
        case $number < 21:
            $string = $dictionary[$number];
            break;
        case $number < 100:
            $tens   = ((int) ($number / 10)) * 10;
            $units  = $number % 10;
            $string = $dictionary[$tens];
            if ($units) {
                $string .= $hyphen . $dictionary[$units];
            }
            break;
        case $number < 1000:
            $hundreds  = $number / 100;
            $remainder = $number % 100;
            $string = $dictionary[$hundreds] . ' ' . $dictionary[100];
            if ($remainder) {
                $string .= $conjunction . convert_number_to_words($remainder);
            }
            break;
        default:
            $baseUnit = pow(1000, floor(log($number, 1000)));
            $numBaseUnits = (int) ($number / $baseUnit);
            $remainder = $number % $baseUnit;
            $string = convert_number_to_words($numBaseUnits) . ' ' . $dictionary[$baseUnit];
            if ($remainder) {
                $string .= $remainder < 100 ? $conjunction : $separator;
                $string .= convert_number_to_words($remainder);
            }
            break;
    }
   
    if (null !== $fraction && is_numeric($fraction)) {
        $string .= $decimal;
        $words = array();
        foreach (str_split((string) $fraction) as $number) {
            $words[] = $dictionary[$number];
        }
        $string .= implode(' ', $words);
    }
   
    return $string;
}
