<?php

class SMSAPI
{

    private $lang = null; // en - 1 , ar - 2 [Type - Integer]
    private $api_key = null; // [Type - String]
    private $sender = null; // [Type - String]
    private $phone_number = null; // [Type - Integer or Array or string ('all', 'vip') : ]
    private $message = null; // [Type - Integer]
    private $CI;
    public function __construct($CI = null, $lang = null, $sender = null, $phone_number = null, $message = null)
    {
        $this->CI = &get_instance();
        $this->CI->load->model('admin/NotificationServices/NotificationServicesModel');

        $configObj = $this->CI->NotificationServicesModel->get_configurations('SMS Service');
        $config = json_decode($configObj->service_configuration);

        $this->lang = $lang ?? ($config->lang ?? null);
        $this->api_key = $config->api_key ?? null;
        $this->sender = $sender ?? ($config->sender ?? null);
        $this->phone_number = $phone_number ?? null;
        $this->message = $message ?? null;


        $unsetParams = [];
        if (empty($config->lang)) {
            $unsetParams[] = 'lang';
        }
        if (empty($config->api_key)) {
            $unsetParams[] = 'api_key';
        }
        if (empty($config->sender)) {
            $unsetParams[] = 'sender';
        }
        
        if (!empty($unsetParams)) {
            throw new Exception("The following required properties are not set: " . implode(', ', $unsetParams));
        }
    }

    public function send_sms($phone_number,$message)
    {
        $this->lang = preg_match('/[\x{0600}-\x{06FF}]/u', $message) ? 2 : 1;
        $url = "https://www.api-server14.com/api/send.aspx?apikey={$this->api_key}&language={$this->lang}&sender={$this->sender}&mobile=+974$phone_number&message=" . urlencode($message);
        
        try {
            // Use curl instead of file_get_contents for better error handling
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Follow redirects
            $response = curl_exec($ch);
            if ($response === false) {
                throw new Exception('SMS sending failed: ' . curl_error($ch));
            }
            curl_close($ch);

            // Save the response to the database
            $this->CI->NotificationServicesModel->save_sms_notification_response(json_encode(['response' => $response, 'url' => $url]));
            return true;
        } catch (Exception $e) {
            echo "Message: " . $e->getMessage();
             $this->CI->NotificationServicesModel->save_sms_notification_response(json_encode(['response' => $e->getMessage(), 'url' => $url]));
            return false;
        }
    }
    public function send_bulk_sms($batch)
    {
        // Decode the batch payload
      
        $batch = json_decode($batch->payload);
       
        
        // Initialize an empty string for storing the phone numbers
        $phones = '';
        
        // Loop through the batch and build a comma-separated list of phone numbers
        foreach ($batch as $item) {
            // Add each phone number to the list
            $phones .= "+974{$item->phone},";
        }
        
        // Remove the trailing comma from the phone numbers list
        $phones = rtrim($phones, ',');
         $this->lang = preg_match('/[\x{0600}-\x{06FF}]/u', $item->message) ? 2 : 1;
        
        // Prepare the URL with all the necessary parameters
    $url = "https://www.api-server14.com/api/send.aspx?apikey={$this->api_key}&language={$this->lang}&sender=" . urlencode($this->sender) . "&mobile={$phones}&message=" . urlencode($item->message);

       
        try {
            // Use cURL instead of file_get_contents for better error handling
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Follow redirects
          $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
            $response = curl_exec($ch);
            
            if ($response === false) {
                throw new Exception('SMS sending failed: ' . curl_error($ch));
            }
            
            // Close the cURL session
            curl_close($ch);
    
            // Save the response to the database
            $this->CI->NotificationServicesModel->save_sms_notification_response(json_encode(['response' => $response,  'http_code' => $http_code, 'url' => $url],JSON_UNESCAPED_UNICODE));
            return true;
        } catch (Exception $e) {
            echo "Message: " . $e->getMessage();
            $this->CI->NotificationServicesModel->save_sms_notification_response(json_encode(['response' => $e->getMessage().'error',   'http_code' => $http_code, 'url' => $url],JSON_UNESCAPED_UNICODE));
            return false;
        }
    }
    
     public function send_bulk_sms_new($batch)
    {
        // Decode the batch payload
      
        $batch = json_decode($batch->payload);
       
        
        // Initialize an empty string for storing the phone numbers
        $message = $batch[0]->message;
    $phones = $batch[0]->phone;
        
         $formattedPhones = array_map(function ($phone) {
        return '+974' . $phone;
    }, $phones);
        // Remove the trailing comma from the phone numbers list
     
         $this->lang = preg_match('/[\x{0600}-\x{06FF}]/u', $message) ? 2 : 1;
         $phones = implode(',', $formattedPhones);
        // Prepare the URL with all the necessary parameters
        $url = "https://www.api-server14.com/api/send.aspx?apikey={$this->api_key}&language={$this->lang}&sender=" . urlencode($this->sender) . "&mobile={$phones}&message=" . urlencode($message);
            
       
        try {
            // Use cURL instead of file_get_contents for better error handling
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true); // Follow redirects
            $response = curl_exec($ch);
            
             $curl_error = curl_error($ch); // Capture error before closing
                curl_close($ch);
            
            if ($response === false) {
                throw new Exception('SMS sending failed: ' . curl_error($ch));
            }
            
            // Close the cURL session
            
    
            // Save the response to the database
            $this->CI->NotificationServicesModel->save_sms_notification_response(json_encode(['response' => $response, 'url' => $url],JSON_UNESCAPED_UNICODE));
            return true;
        } catch (Exception $e) {
            echo "Message: " . $e->getMessage();
            $this->CI->NotificationServicesModel->save_sms_notification_response(json_encode(['response' => 'error', 'url' => $url],JSON_UNESCAPED_UNICODE));
            return false;
        }
    }
}
