<?php

class TwilioWhatsApp {
    private $CI;

    // Twilio API credentials
    protected $account_sid;
    protected $auth_token;
    protected $from_number;

    // Constructor to initialize the Twilio API credentials
    public function __construct($params = array()) {

        $this->CI = &get_instance();
        $this->CI->load->model('admin/NotificationServices/NotificationServicesModel');

        $configObj = $this->CI->NotificationServicesModel->get_configurations('whatsapp_service');
        $config = json_decode($configObj->service_configuration);

        $this->account_sid = $config->secret_key;
        $this->auth_token =  $config->key_id;
        $this->from_number = $config->business_number; // Your Twilio WhatsApp number
    }

    // Function to send a regular WhatsApp message
    public function send_message($to, $body) {
        $url = 'https://api.twilio.com/2010-04-01/Accounts/' . $this->account_sid . '/Messages.json';

        // Data for the message
        $data = array(
            'To' => 'whatsapp:' . $to,
            'From' => $this->from_number,
            'Body' => $body
        );

        return $this->send_request($url, $data);
    }

    // Function to send a template-based WhatsApp message
    public function send_template_message($to, $content_sid, $template_data = array()) {
        $url = 'https://api.twilio.com/2010-04-01/Accounts/' . $this->account_sid . '/Messages.json';

        $content_variables = json_encode($template_data);
        // Data for the template message (customize as per your template needs)

        $data = array(
            'To' => 'whatsapp:' . $to,
            // 'From' => 'whatsapp:+97439939074',
            'From' => 'whatsapp:'.$this->from_number,
            'ContentSid' => $content_sid,               // The template ID (ContentSid)
            'ContentVariables' => $content_variables    // The dynamic variables for the template
        );
     
        
        $dataCount= $this->CI->NotificationServicesModel->retrieve_data_unique_row('user_message_details','type','1');
        $available_message= (int)$dataCount->available_whatsapp - (int)$dataCount->sent;
        if($available_message >0 ){
           if(!empty($to)){
            $response= $this->send_request($url, $data);
            if($response){
                $this->CI->NotificationServicesModel->save_whatsapp_notification_response(json_encode(['response' => $response]));
                $this->incrementCounter();
            }
           }else{
            $this->CI->NotificationServicesModel->save_whatsapp_notification_response(json_encode(['response' => ['message'=>'Patient Whatsapp Number']]));
           }
            
        }else{
            $this->CI->NotificationServicesModel->save_whatsapp_notification_response(json_encode(['response' => ['message'=>'Inssufficient Balance']]));
        }
        
       
    }
    public function send_template_message_with_content($to, $content_sid, $patient_name,$file,$fileName) {
        $url = 'https://api.twilio.com/2010-04-01/Accounts/' . $this->account_sid . '/Messages.json';

        $template_data=array(
            "1" => $patient_name, // Ensure these match the variables in your template
             "3" => $fileName,
        );
        $content_variables = json_encode($template_data);
        // Data for the template message (customize as per your template needs)
        $data = array(
            'To' => 'whatsapp:' . $to,
            // 'From' => 'whatsapp:+97439939074',
            'From' => 'whatsapp:'.$this->from_number,
            'ContentSid' => $content_sid,               // The template ID (ContentSid)
            'ContentVariables' => $content_variables,
            'media_url'=>$file,
                // The dynamic variables for the template
        );
         $dataCount= $this->CI->NotificationServicesModel->retrieve_data_unique_row('user_message_details','type','1');
        $available_message= (int)$dataCount->available_whatsapp - (int)$dataCount->sent;
        if($available_message >0 ){
       
            $response= $this->send_request($url, $data);
        if($response){
                $this->CI->NotificationServicesModel->save_whatsapp_notification_response(json_encode(['response' => $response]));
                $this->incrementCounter();
            }else{
            $this->CI->NotificationServicesModel->save_whatsapp_notification_response(json_encode(['response' => ['message'=>'Patient Whatsapp Number']]));
           }
        }else{
            $this->CI->NotificationServicesModel->save_whatsapp_notification_response(json_encode(['response' => ['message'=>'Inssufficient Balance']]));
        }
    }

    // Function to build the template message with placeholders (replace with your logic)
    private function build_template_message($template_id, $template_data) {
        // This example assumes your template message has placeholders like {name}, {date}, etc.
        $template = $this->get_template_by_id($template_id); // You can implement your logic here

        // Replace placeholders with actual data
        foreach ($template_data as $key => $value) {
            $template = str_replace('{' . $key . '}', $value, $template);
        }

        return $template;
    }

    // Sample function to retrieve template by ID (customize this)
    private function get_template_by_id($template_id) {
        // Sample templates (replace with your actual templates)
        $templates = array(
            'appointment_reminder' => 'Your appointment is coming up on {date} at {time}.',
            'order_confirmation' => 'Thank you for your order. Your order ID is {order_id}.',
        );

        return isset($templates[$template_id]) ? $templates[$template_id] : '';
    }

    // Function to send the API request
    private function send_request($url, $data) {
        $ch = curl_init();

        // Set the options for cURL
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_USERPWD, $this->account_sid . ':' . $this->auth_token);

        // Execute the request and capture the response
        $response = curl_exec($ch);

        // Check for errors
        if ($response === false) {
            $error = curl_error($ch);
            curl_close($ch);
            return array('status' => 'error', 'message' => $error);
        }

        // Close cURL and return the response
        curl_close($ch);
        return array('status' => 'success', 'message' => $response);
    }
    public function incrementCounter(){
       $data= $this->CI->NotificationServicesModel->retrieve_data_unique_row('user_message_details','type','1');
       $sent = (int)$data->sent + 1;
       $newsent= array('sent'=>$sent);
       $this->CI->NotificationServicesModel->update_data_where('user_message_details','type','1',$newsent);
    }
}
