<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class AnnouncementModel extends CI_Model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    public function createOrUpdateAnnouncement($data)
    {
        return $this->db->insert('tbl_announcements' ,$data);
    }

    public function LoadAnnouncements()
    {
        return $this->db
            ->select('tbl_announcements.*, tbl_user_groups.user_group_name')
            ->from('tbl_announcements')
            ->join('tbl_user_groups', 'tbl_announcements.user_group = tbl_user_groups.user_group_id', 'left')
            ->get()
            ->result_array();
    }

    public function GetAnnouncementForUserGroups($user_group)
    {
        $this->DeleteExpiredAnnouncements();
        return $this->db->select('announcement')
        ->from('tbl_announcements')
        ->where('start_at <= NOW()')
        ->where('(user_group = ' . $this->db->escape($user_group) . ' OR user_group = 0)')
        ->get()
        ->result();
    }

    private function DeleteExpiredAnnouncements()
    {
        $this->db->where('expire_at < NOW()');
        $this->db->delete('tbl_announcements');
    }
   
}
