<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class LaserCalenderModel extends CI_Model
{

	function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	public function getList($params)
	{

		$str_quary = "";

		$str_quary .= " select tbl_orders.*,tbl_order_status.status as status ";
		$str_quary .= " from tbl_orders ";
		$str_quary .= " inner join tbl_order_status on tbl_order_status.order_status_id = tbl_orders.status_id ";
		$str_quary .= " where tbl_orders.is_delete = 0 ";
		$str_quary .= " and tbl_orders.dp_date = '" . $params['selectedDate'] . "'";

		$query = $this->db->query($str_quary);
		return $query;
	}

	public function get_pending_orders()
	{

		$str_quary = "";

		$str_quary .= " select tbl_orders.dp_date ";
		$str_quary .= " from tbl_orders ";
		$str_quary .= " where tbl_orders.dp_date >= curdate() ";
		$str_quary .= " group by tbl_orders.dp_date ";

		$query = $this->db->query($str_quary);
		return $query;
	}

	public function get_appointments($resources_str, $start_date, $end_date)
	{

		if ($start_date != '' && $end_date != '') {
			$start = '  tbl_appointment.appointment_date BETWEEN "' . $start_date . '" AND "' . $end_date . '"';
		}

		$query = $this->db->query("SELECT tbl_appointment.patient_id,
		tbl_appointment.appointment_id,
		tbl_appointment.appointment_date,
		tbl_appointment.appointment_time,
		tbl_appointment.appointment_etime,
		tbl_appointment_patient_info.app_patient_id,
		tbl_appointment_patient_info.patient_id,
		tbl_appointment_patient_info.app_patient_name,
		tbl_users.full_name AS username,
		tbl_appointment_patient_info.app_patient_contact,
		tbl_appointment_patient_info.app_patient_category_id,
		IFNULL(tbl_appointment_patient_info.app_patient_qatar_id, tbl_patients.qatar_id ) AS app_patient_qatar_id,
		tbl_appointment.resource_id,
		tbl_appointment.note,
		tbl_appointment.nurse_id,
		tbl_patients.backup_id,
		tbl_appointment_treatment.col_code,
		tbl_appointment_treatment.treatment_name,
		tbl_appointment.app_treat_id,
		tbl_patients.insurance_type,
		tbl_insurance_types.insurance_name,
		tbl_appointment_patient_info.now_waiting,
		tbl_appointment_patient_info.black_mark,
		tbl_patients.company_id,
		tbl_company.company_name,
		tbl_appointment.sms_active,
		tbl_appointment.sms_lang,
		tbl_appointment.procedure_id,
		tbl_appointment.department
FROM tbl_appointment
LEFT JOIN tbl_patients
ON tbl_appointment.patient_id = tbl_patients.patient_id
JOIN tbl_resources
ON tbl_appointment.resource_id = tbl_resources.resource_id
LEFT JOIN tbl_appointment_treatment
ON tbl_appointment.app_treat_id = tbl_appointment_treatment.app_treat_id
JOIN tbl_appointment_patient_info
ON tbl_appointment.app_info_id = tbl_appointment_patient_info.app_patient_id
LEFT JOIN tbl_insurance_types
ON tbl_insurance_types.insurance_type_id = tbl_patients.insurance_type
LEFT JOIN tbl_users
ON tbl_appointment.user_id = tbl_users.user_id
LEFT JOIN tbl_company
ON tbl_company.company_id = tbl_patients.company_id
WHERE
$start
AND tbl_appointment.resource_id IN ($resources_str)
ORDER BY tbl_appointment.appointment_id DESC;
");


		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return FALSE;
		}
	}


	public function save($data)
	{
		$this->db->insert('tbl_appointment', $data);
		$appointment_id = $this->db->insert_id();;

		return $appointment_id;
	}

	public function get_block_appointments($resources_str, $start_date, $end_date)
	{

		if ($start_date != '' && $end_date != '') {
			$start = '  tbl_appointment_block.app_block_date BETWEEN "' . $start_date . '" AND "' . $end_date . '"';
		}

		$query = $this->db->query("SELECT * from tbl_appointment_block WHERE $start AND tbl_appointment_block.resource_id IN ($resources_str);");
		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return FALSE;
		}
	}

	public function get_booking_status()
	{
		return $this->db->select('*')
			->from('tbl_booking_status')
			->get()
			->result();
	}
		public function get_resources()
	{
		return $this->db->select('*')
			->from('tbl_resources')
			->where('status',1)
			->order_by('resource_order','DESC')
			->get()
		->result_array();
	}


	public function getResourcesList($search, $length, $start, $order_column, $order)
	{
		$this->db->select('*,tbl_resources.resource_id as resource_no')
			->from('tbl_resources');

		if ($length != -1)
			$this->db->limit($length, $start);

		if (!empty($search)) {
			$this->db->like('tbl_resources.resource_name', $search);
			$this->db->or_like('tbl_resources.resource_id', $search);
		}

		$this->db->where('status', 1);
		$this->db->order_by($order_column, $order);


		return $this->db->get()->result();
	}
	
		public function getAppointment($id)
	{
		$query = $this->db->query("
			SELECT 
				tbl_appointment.appointment_id,
				tbl_appointment.appointment_date,
				tbl_appointment.appointment_time,
				tbl_patients.patient_name,
				tbl_patients.mobile,
				tbl_patients.second_mobile,
					tbl_patients.wa_code,
						tbl_patients.wa_mobile,
				tbl_resources.resource_name AS doctor_name
			FROM tbl_appointment
			LEFT JOIN tbl_patients ON tbl_patients.patient_id = tbl_appointment.patient_id
			LEFT JOIN tbl_resources ON tbl_resources.resource_id = tbl_appointment.resource_id
			WHERE tbl_appointment.appointment_id = '$id'
		");
	
		if ($query->num_rows() > 0) {
			return $query->row();
		} else {
			return FALSE;
		}
	}
		public function getNewAppointment($id)
	{
		$query = $this->db->query("
			SELECT 
				tbl_appointment.appointment_id,
				tbl_appointment.appointment_date,
				tbl_appointment.appointment_time,
				tbl_appointment_patient_info.app_patient_contact as mobile,
				tbl_appointment_patient_info.app_patient_name as patient_name,
				tbl_resources.resource_name AS doctor_name
			FROM tbl_appointment
			LEFT JOIN tbl_appointment_patient_info ON tbl_appointment_patient_info.app_patient_id = tbl_appointment.app_info_id
			LEFT JOIN tbl_resources ON tbl_resources.resource_id = tbl_appointment.resource_id
			WHERE tbl_appointment.appointment_id = '$id'
		");
	
		if ($query->num_rows() > 0) {
			return $query->row();
		} else {
			return FALSE;
		}
	}
}
