<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class CommonModel extends CI_Model
{

	function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	public function profile($user_Id)
	{

		$query = $this->db->query("call get_loged_details(" . $user_Id . ")");
		$query->next_result();
		return $query;
	}

	public function get_whatsapp_plan()
	{

		return $this->db
            ->select('*')
            ->from('user_message_details')
            ->get()
            ->row();
	}
	public function get_sms_plan()
	{

		return 0;
	}

	public function user_name($user_Id)
	{

		$query = $this->db->select('*')
			->from('tbl_users')
			->where('tbl_users.user_Id', $user_Id)
			->get();
		$load_data = $query->result_array();


		foreach ($load_data as $row) {
			return $row['full_name'];
		}

		return "";
	}

	public function logged_user_right($user_Id)
	{
		$query = $this->db->query("call get_user_rights(" . $user_Id . ")");
		$query->next_result();
		//  print_r($query);
		return $query;
	}

	public function District()
	{
		$query = $this->db->select('*')
			->from('tbl_district')
			->get();
		return $query;
	}

	public function targetDocumentPath($parent_id, $_id, $targetFolder, $imageType)
	{

		$directoryFolder = FCPATH . $this->config->item('documents_path');

		$falder_id = $parent_id == 0 ? $_id : $parent_id;

		if (is_dir($directoryFolder . $targetFolder)) {
		} else {
			mkdir($directoryFolder . $targetFolder, 0777);
		}

		$directory = FCPATH . $this->config->item('documents_path') . $targetFolder . "/";

		if (is_dir($directory . $falder_id)) {
		} else {
			mkdir($directory . $falder_id, 0777);
		}

		$image_directory = FCPATH . $this->config->item('documents_path') . $targetFolder . "/" . $falder_id . "/";

		if (is_dir($image_directory . $imageType)) {
		} else {
			mkdir($image_directory . $imageType, 0777);
		}

		$falder_path = $this->config->item('documents_path') . $targetFolder . "/" . $falder_id . "/" . $imageType . "/";

		return $falder_path;
	}


	//search dropdowns
	public function items_dropdown($text)
	{

		$str_quary = "";

		if (strlen(trim($text)) == 0) {

			$str_quary .= " select * ";
			$str_quary .= " from (select ";
			$str_quary .= " tbl_flavours.flavour_price as price ";
			$str_quary .= " ,tbl_products.product_name as product_name ";
			$str_quary .= " ,tbl_products.product_code as product_code ";
			$str_quary .= " ,tbl_flavours.flavour_code as item_code ";
			$str_quary .= " ,tbl_flavours.flavour_name as item_name ";
			$str_quary .= " ,tbl_flavours.flavour_name as flavour_name ";
			$str_quary .= " ,tbl_flavours.flavour_code as flavour_code ";
			$str_quary .= " ,'flavour' as item_type ";
			$str_quary .= " from tbl_flavours ";
			$str_quary .= " inner join tbl_products on tbl_products.product_id = tbl_flavours.product_id ";
			$str_quary .= " union ";
			$str_quary .= " select ";
			$str_quary .= " tbl_products.price as price ";
			$str_quary .= " ,tbl_products.product_name as product_name ";
			$str_quary .= " ,tbl_products.product_code as product_code ";
			$str_quary .= " ,tbl_products.product_code as item_code ";
			$str_quary .= " ,tbl_products.product_name as item_name ";
			$str_quary .= " ,'' as flavour_name ";
			$str_quary .= " ,'' as flavour_code ";
			$str_quary .= " ,'product' as item_type ";
			$str_quary .= " from tbl_products ";
			$str_quary .= " where tbl_products.is_delete = 0) tblitem ";
		} else {

			$str_quary .= " select * ";
			$str_quary .= " from (select ";
			$str_quary .= " tbl_flavours.flavour_price as price ";
			$str_quary .= " ,tbl_products.product_name as product_name ";
			$str_quary .= " ,tbl_products.product_code as product_code ";
			$str_quary .= " ,tbl_flavours.flavour_code as item_code ";
			$str_quary .= " ,tbl_flavours.flavour_name as item_name ";
			$str_quary .= " ,tbl_flavours.flavour_name as flavour_name ";
			$str_quary .= " ,tbl_flavours.flavour_code as flavour_code ";
			$str_quary .= " ,'flavour' as item_type ";
			$str_quary .= " from tbl_flavours ";
			$str_quary .= " inner join tbl_products on tbl_products.product_id = tbl_flavours.product_id ";
			$str_quary .= " union ";
			$str_quary .= " select ";
			$str_quary .= " tbl_products.price as price ";
			$str_quary .= " ,tbl_products.product_name as product_name ";
			$str_quary .= " ,tbl_products.product_code as product_code ";
			$str_quary .= " ,tbl_products.product_code as item_code ";
			$str_quary .= " ,tbl_products.product_name as item_name ";
			$str_quary .= " ,'' as flavour_name ";
			$str_quary .= " ,'' as flavour_code ";
			$str_quary .= " ,'product' as item_type ";
			$str_quary .= " from tbl_products ";
			$str_quary .= " where tbl_products.is_delete = 0) tblitem ";
			$str_quary .= " where (tblitem.item_code like '%" . $text . "%'";
			$str_quary .= " or tblitem.item_name like '%" . $text . "%')";
		}

		$query = $this->db->query($str_quary);
		return $query;
	}


	/*check other rights*/
	public function check_user_other_rights($user_Id, $user_right_code)
	{

		$query = $this->db->query("call get_other_rights(" . $user_Id . ",'" . $user_right_code . "')");
		$query->next_result();

		$is_available = 0;



		//affter delete right add and delete this
		if ($user_right_code == 'is_delete_available') {
			$is_available = 0;
			return;
		}
		////////////////////////////////////////////////////////



		foreach ($query->result() as $value) {
			$is_available = 1;
		}

		return $is_available;
	}

	public function update_column($where_table, $where_column, $where_value, $update_column, $update_value)
	{

		$this->db->set($update_column, $update_value);

		$this->db->where($where_column, $where_value);
		$this->db->update($where_table);
	}

	/*generate reference*/
	public function get_trnsaction_reference($type, $id, $_send_date)
	{

		$this->db->where('type', $type);
		$query = $this->db->get('tbl_reference_prifix');
		$load_data = $query->result_array();

		$prifix = "";
		$number_padding = 6;
		$_date = $_send_date;

		foreach ($load_data as $row) {
			$prifix = $row['prifix'];
			$number_padding = $row['number_padding'];
		}

		$finance_year = self::finance_year($_date);

		$prifix = str_replace("{month_mmm}", date_format(new DateTime($_date), "M"), $prifix);
		$prifix = str_replace("{month_m}", date_format(new DateTime($_date), "m"), $prifix);
		$prifix = str_replace("{finance_year}", $finance_year, $prifix);

		$prifix = str_replace("{trn_id}", str_pad($id, $number_padding, "0", STR_PAD_LEFT), $prifix);

		return $prifix;
	}


	public function get_list_where($table, $filed_name, $filed_value)
	{

		$query = $this->db->query("SELECT *FROM $table WHERE $filed_name = '$filed_value'");

		if ($query->num_rows() > 0) {
			return $query->result_array();
		} else {
			return FALSE;
		}
	}




	public function get_list($table)
	{

		$query = $this->db->query("SELECT *FROM $table");

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return FALSE;
		}
	}

	public function get_tags()
	{

		$str_quary = "";

		$str_quary .= " select * ";
		$str_quary .= " from tbl_tags ";
		$str_quary .= " where tbl_tags.is_active = 1 ";

		$query = $this->db->query($str_quary);
		return $query;
	}

	public function get_categories()
	{

		$str_quary = "";

		$str_quary .= " select * ";
		$str_quary .= " from tbl_categories ";
		$str_quary .= " where tbl_categories.status = 1 ";

		$query = $this->db->query($str_quary);
		return $query;
	}

	public function get_order_status()
	{

		$str_quary = "";

		$str_quary .= " select * ";
		$str_quary .= " from tbl_order_status ";

		$query = $this->db->query($str_quary);
		return $query;
	}

	public function get_site_images()
	{

		$str_quary = "";

		$str_quary .= " select * ";
		$str_quary .= " from tbl_site_images_type ";

		$query = $this->db->query($str_quary);
		return $query;
	}

	public function get_locations()
	{

		$str_quary = "";

		$str_quary .= " select * ";
		$str_quary .= " from tbl_locations ";
		$str_quary .= " where tbl_locations.is_active = 1 ";

		$query = $this->db->query($str_quary);
		return $query;
	}

	public function get_colors()
	{

		$query = $this->db->select('*')
			->from('tbl_colors')
			->get();
		return $query;
	}

	public function get_sizes()
	{

		$query = $this->db->select('*')
			->from('tbl_size')
			->get();
		return $query;
	}

	public function get_diagnosis()
	{

		$str_quary = "";

		$str_quary .= " select * ";
		$str_quary .= " from tbl_diagnostise ";
		$str_quary .= " where tbl_diagnostise.name LIKE '" . strtoupper($_GET['q']) . "%'";
		$str_quary .= " or tbl_diagnostise.diagnostise_id LIKE '%" . strtoupper($_GET['q']) . "%'";

		$query = $this->db->query($str_quary);
		return $query;
	}

	// public function get_procedures($insurance_type_id){
	// 	$str_quary = "";

	// 	$str_quary .= " select * ";
	// 	$str_quary .= " from tbl_insurance_prices ";
	// 	$str_quary .= "WHERE  tbl_insurance_prices.insurance_type_id = ".$insurance_type_id;

	// 	$str_quary .= " AND (tbl_insurance_prices.treatment_name LIKE '" . strtoupper($_GET['q']) . "%'";
	// 	$str_quary .= " OR tbl_insurance_prices.treatment_id LIKE '" . strtoupper($_GET['q']) . "%')";

	// 	$query = $this->db->query($str_quary);
	//     return $query;
	// }
	public function get_procedures($insurance_type_id, $query, $treatment_category)
	{
		
		$this->db->select('*');
		$this->db->from('tbl_insurance_prices');
		$this->db->where('tbl_insurance_prices.insurance_type_id', $insurance_type_id);
	   // 	$this->db->where('tbl_insurance_prices.treatment_category', $treatment_category);
		$this->db->group_start();
		$this->db->like('treatment_name', strtoupper($_GET['q']));
		$this->db->or_like('treatment_id', strtoupper($_GET['q']));
		$this->db->group_end();
		$this->db->order_by('treatment_category', 'DESC');
		$query = $this->db->get();
		return $query;
	}
	public function getPatients($nameStartsWith)
    {
        $this->db->select('patient_id,patient_name,insurance_type,qatar_id');
        $this->db->from('tbl_patients');
        $this->db->where('patient_id', $nameStartsWith);
      
      

        $query = $this->db->get()->result();
       

		return $query;
	}

      

	public function get_common_document_printable_header_template()
	{
		return $this->db->select('*')
			->from('tbl_invoice_templates')
			->where('invoice_type', 4)
			->where('is_default', 1)
			->where('is_active', 1)
			->get()
			->row()->template;
	}

	public function get_company_info()
	{
		return $this->db->select('*')
			->from('tbl_company')
			->get()
			->row();
	}

	public function get_patient_advance($patient_id)
	{
		return $this->db->select('sum(amount) as total_advance')
			->from('tbl_advance')
			->join('tbl_patients', 'tbl_patients.patient_id = tbl_advance.patient_id')
			->where('tbl_patients.patient_id', $patient_id)
			->group_by('tbl_patients.patient_id')
			->get()
			->row()->total_advance;
	}

	public function get_payed_by_advance($patient_id)
	{
		return $this->db->select('IFNULL((sum(total)-sum(discount)),0) as total_applied_advances')
			->from('tbl_patient_payment')
			->join('tbl_patients', 'tbl_patients.patient_id = tbl_patient_payment.patient_id')
			->where('tbl_patients.patient_id', $patient_id)
			->where('tbl_patient_payment.pay_type', 5)
			->group_by('tbl_patients.patient_id')
			->get()
			->row()->total_applied_advances;
	}

	public function get_last_attachment($patient_id, $cat)
    {
        $this->db->select('*');
        $this->db->from('tbl_patient_attachments');
        $this->db->where("document LIKE '$patient_id-%'");
        $this->db->where('category', $cat);
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }

	public function get_attachment($id, $cat, $pri_id)
    {
        $query = $this->db->query("SELECT * FROM tbl_patient_attachments WHERE patient_id = $id AND category = $cat AND treat_id = $pri_id");

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }

	public function logged_user_rights($right_name, $user_id)
	{
		$query = $this->db->query("
		select * from
		tbl_user_rights 
		join tbl_user_group_rights on tbl_user_rights.user_right_Id = tbl_user_group_rights.user_right_id
		join tbl_users on tbl_user_group_rights.user_group_Id = tbl_users.user_group_Id 
		where tbl_user_rights.user_right_code = '".$right_name."' and tbl_users.user_Id = ".$user_id."");

		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return FALSE;
		}
	}
	public function subscriptions()
	{
		$query = $this->db->query("
		select * from
		company_subscription");

		if ($query->num_rows() > 0) {
			return $query->row();
		} else {
			return FALSE;
		}
	}

	public function get_doctor_by_id($doctor_id)
	{

		$query = $this->db->query("SELECT *FROM tbl_users LEFT JOIN tbl_employees ON tbl_users.user_Id = tbl_employees.user_id where tbl_employees.employee_id='".$doctor_id."'");

		if ($query->num_rows() > 0) {
			return $query->row();
		} else {
			return FALSE;
		}
	}

	public function get_constant($table,$constant, $value){

		$this->db->select('name');
        $this->db->from('general_settings');
        $this->db->where('type', $constant);
        $this->db->where('value', $value);

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->row()->name;
        } else {
            return null;
        }
	}
	
	public function get_valid_patients(){
		$this->db->select('mobile,patient_name');
		$this->db->from('tbl_patients');
		$this->db->where('LENGTH(mobile) =', 8); // Check if the mobile number has exactly 8 digits
        $this->db->group_by('mobile');
		$query = $this->db->get();
		return $query->result(); // Return the result

	}
	public function get_valid_vip_patients(){
		$this->db->select('mobile,patient_name');
		$this->db->from('tbl_patients');
		$this->db->where('vip', 1);
		$this->db->where('LENGTH(mobile) =', 8); // Check if the mobile number has exactly 8 digits

		$query = $this->db->get();
		return $query->result(); // Return the result

	}
}
