<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class InvoiceModel extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function get_active_template()
    {
        return $this->db->select('*')
        ->from('tbl_invoice_templates')
        ->where('invoice_type', 1)
        ->where('is_default', 1)
        ->where('is_active', 1)
        ->get()
        ->row()->template;
    }
    
     public function get_content_id($eid)
    {
        return $this->db->select('*')
        ->from('tbl_notification_templates')
        ->where('type', 'whatsapp')
        ->where('event_type', $eid)
        ->where('is_active', 1)
        ->get()
        ->row()->template_id;
    }

    public function get_invoice_details($treatment_payment_id)
    { //, tbl_episode_payment.discount as episode_discount
        return $this->db->select('tbl_treatment_payment.*,cb.full_name as cashier, tbl_episode_payment.*, tbl_patients.patient_name, tbl_insurance_types.insurance_name, tbl_users.full_name as doctor, tbl_insurance_prices.treatment_name, tbl_episode_payment.discount_qr as episode_discount,discount_category.discount as category_discount_p,
		tbl_companies.discount as company_discount_p')
        
        ->from('tbl_treatment_payment')
        ->join('tbl_episode_payment', 'tbl_treatment_payment.treatement_payment_id = tbl_episode_payment.treatement_payment_id','left')
        ->join('tbl_patients', 'tbl_treatment_payment.patient_id = tbl_patients.patient_id','left')
        ->join('tbl_insurance_types', 'tbl_treatment_payment.insurance_type = tbl_insurance_types.insurance_type_id','left')
        ->join('discount_category', 'discount_category.id = tbl_treatment_payment.category_discount','left')
        ->join('tbl_companies', 'tbl_companies.company_id = tbl_treatment_payment.company_discount','left')
        ->join('tbl_users', 'tbl_treatment_payment.user_id = tbl_users.user_Id')
        ->join('tbl_users cb', 'cb.user_Id = tbl_treatment_payment.created_by','left')
       
        ->join('tbl_insurance_prices', 'tbl_episode_payment.procedure_id = tbl_insurance_prices.id','left')
        ->where('tbl_treatment_payment.treatement_payment_id', $treatment_payment_id)
        ->get()
        ->result();
      
   
    }

    public function get_case_test($case_id)
    { //, tbl_episode_payment.discount as episode_discount
        return $this->db->select('case_has_tests.*,lab_test.name,lab_test.price')
        ->from('case_has_tests')
        ->join('lab_test', 'case_has_tests.test_id = lab_test.id','left')
        ->where('case_has_tests.case_id', $case_id)
        ->get()
        ->result();
    }
    public function get_case_test_by_payment($treatment_payment_id)
    { //, tbl_episode_payment.discount as episode_discount
        return $this->db->select('case_has_tests.*,lab_test.name,lab_test.price')
        ->from('case_has_tests')
        ->join('lab_test', 'case_has_tests.test_id = lab_test.id','left')
        ->join('lab_cases', 'case_has_tests.case_id = lab_cases.id','left')
        ->where('lab_cases.treatment_payment_id', $treatment_payment_id)
        ->get()
        ->result();
    }

    

}

?>