<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class NotificationJob extends CI_Model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }
    public function getActiveReminders() {
        $this->db->where('status', 1);  // Active reminders only
        $this->db->where('reminder_type', 1);
        return $this->db->get('notification_reminders')->result();
    }
    
     public function get_content_id($eid)
    {
        return $this->db->select('*')
        ->from('tbl_notification_templates')
        ->where('type', 'whatsapp')
        ->where('event_type', $eid)
        ->where('is_active', 1)
        ->get()
        ->row()->template_id;
    }
      public function get_bulkBatches_count() {
        $this->db->select('COUNT(*) as total_batches, MAX(created_at) as last_batch_date')
                 ->from('tbl_jobs')
                 ->where('event', 'bulk_sms_batch')
                 ->where('is_sent', 0);
    
        return $this->db->get()->row();
    }

    public function getAppointmentsBefore($hoursBefore) {
        $targetTime = date('Y-m-d H:i:s', strtotime("+$hoursBefore hours"));
        $currentTime = date('Y-m-d H:i:s');

        $this->db->where('appointment_date >=', $currentTime);
        $this->db->where('appointment_date <=', $targetTime);
       
        $this->db ->join('tbl_appointment_patient_info', 'tbl_appointment_patient_info.app_patient_id = tbl_appointment.app_info_id','left');
        return $this->db->get('tbl_appointment')->result();
    }

    public function get_whatsapp_template($event){
        $this->db->where('type', 'whatsapp');
        $this->db->where('event_type', $event);
        return $this->db->get('tbl_notification_templates')->row();

    }

    public function getActiveTemplate($event){
        $this->db->where('type', 'sms');
        $this->db->where('is_active', 1);
        $this->db->where('event_type', $event);
        return $this->db->get('tbl_notification_templates')->row();

    }

    public function getTodayBirthdayPatients()
    {
        // Get current day and month
        $today = date('m-d'); // Format: 'MM-DD'
    
        // Query to get patients whose birthday is today (ignoring the year)
        $this->db->select('*')
                 ->from('tbl_patients')
                 ->where('DATE_FORMAT(dob, "%m-%d") =', $today);
    
        $query = $this->db->get();
        return $query->result(); // Return the result as an array of objects (or adjust as needed)
    }
    
    
    public function get_bulkBatches(){
        $this->db->select('*')
                 ->from('tbl_jobs')
                 ->where('event','bulk_sms_batch')
                 ->where('is_sent',0);

                 $query = $this->db->get();
        return $query->result();

    }
     public function get_events(){
        $this->db->select('*')
                 ->from('tbl_jobs')
                 ->where('event !=','bulk_sms_batch')
                 ->where('is_sent',0);

                 $query = $this->db->get();
        return $query->result();

    }


  
}
