<?php

class OphthalmologyModel extends CI_Model
{

    function __construct()
    {
        parent::__construct();
        $this->load->database();
    }

    public function getTreatmentList($insurance_type, $department)
    {
        return $this->db->select('id, treatment_id, treatment_name, lqdc_gross')
            ->from('tbl_insurance_prices')
            ->where('insurance_type_id', $insurance_type)
            ->where('treatment_category', $department)
            ->get()
            ->result();
    }

    public function get_treatments_examinations_by_id($id)
    { // Need to remove log , doctor table, join tbl_employees with tbl_users table
        $this->db->select('*');
        $this->db->from('tbl_treatment_payment');
        $this->db->join('tbl_users', 'tbl_treatment_payment.user_id = tbl_users.user_id');
        $this->db->join('tbl_ophthalmology', 'tbl_ophthalmology.treatment_payment_id = tbl_treatment_payment.treatement_payment_id');
        $this->db->where('tbl_treatment_payment.treatement_payment_id', $id);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
    }


    public function get_profile_main($id)
    {
        $this->db->select('tbl_patients.patient_id, tbl_patients.patient_name, tbl_patients.dob, tbl_patients.profile_img, TIMESTAMPDIFF(YEAR, tbl_patients.dob, CURDATE()) AS age, tbl_patients.insurance_type_id, tbl_patients.sex, tbl_patients.qatar_id, insurance_type.insurance_name, tbl_patients.backup_id, patient_contact.mobile, countries.name, tbl_patients.company_id, company.company_name, tbl_patients.qid_front_image, tbl_patients.member_id, tbl_patients.registerd_date');
        $this->db->from('patients');
        $this->db->join('patient_contact', 'tbl_patients.patient_id = patient_contact.patient_id', 'left');
        $this->db->join('patient_file', 'tbl_patients.patient_id = patient_file.patient_id', 'left');

        $this->db->join('treatment_log', 'patient_file.file_id = treatment_log.file_id', 'left');
        $this->db->join('doctors', 'treatment_log.doctor_id = doctors.doctor_id', 'left');
        $this->db->join('employee', 'employee.employee_id = doctors.employee_id', 'left');

        $this->db->join('insurance_type', 'tbl_patients.insurance_type_id = insurance_type.insurance_type_id', 'left');
        $this->db->join('countries', 'tbl_patients.nationality_code = countries.country_id', 'left');
        $this->db->join('company', 'company.company_id = tbl_patients.company_id', 'left');
        $this->db->where('tbl_patients.patient_id', $id);
        $this->db->order_by('log_id', 'DESC');
        $this->db->limit(1);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }


    public function retrieve_produress()
    {

        $query = $this->db->query("SELECT * FROM tbl_insurance_prices WHERE treatment_category = 9 ORDER BY treatment_name ASC");

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }

    public function get_attachment($id, $cat, $pri_id)
    {
        $query = $this->db->query("SELECT * FROM tbl_patient_attachments WHERE patient_id = $id AND category = $cat AND treat_id = $pri_id");

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return FALSE;
        }
    }

    public function get_treatments(){
        return $this->db->select('*')
            ->from('tbl_insurance_prices')
            ->where('treatment_category', 9)
            ->get()
            ->result();
    }

    public function get_last_attachment($patient_id,$cat)
	{
		$query = $this->db->query("SELECT * FROM tbl_patient_attachments
			WHERE document LIKE '$patient_id-%' AND category = '$cat'
			ORDER BY id DESC LIMIT 1
		");
			
			if($query->num_rows() > 0)
			{
				return $query->row();
				
			} else{
				return FALSE;
			}
	}

}
