<?php

class NotificationServicesModel extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function get_configurations($service_name)
    {
        return $this->db->select('*')
        ->from('tbl_config_services')
        ->where('service_name', $service_name)
        ->get()
        ->row();
    }

   public function save_sms_notification_response($response) {
        $this->db->insert('tbl_notifications', [
            'type' => 'SMS',
            'notification' => null,
            'response' => $response,
            'status' => 'SENT',
            'created_at' => date('Y-m-d H:i:s')
        ]);
   }
   public function save_whatsapp_notification_response($response,$status='SENT') {
    $this->db->insert('tbl_notifications', [
        'type' => 'whatsapp',
        'notification' => null,
        'response' => $response,
        'status' => $status,
        'created_at' => date('Y-m-d H:i:s')
    ]);
}

}

?>