<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Bill extends CI_Model {

	var $table = 'sh_bill';
	var $column_order = array('bill_id','bill_date','supplier_name','mobile','amount',null); //set column field database for datatable orderable
	var $column_search = array('bill_id','bill_date','supplier_name','mobile','amount'); //set column field database for datatable searchable just firstname , lastname , address are searchable
	var $order = array('bill_id' => 'desc'); // default order 

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	private function _get_datatables_query()
	{
		
		$this->db->from($this->table);
		$this->db->join('sh_supplier', 'sh_bill.supplier_id = sh_supplier.supplier_id', 'left');
		$i = 0;
	
		foreach ($this->column_search as $item) // loop column 
		{
			if($_POST['search']['value']) // if datatable send POST for search
			{				
				$this->db->or_like($item, $_POST['search']['value']);
			}
			$i++;
		}
		
		if(isset($_POST['order'])) // here order processing
		{
			$this->db->order_by($this->column_order[$_POST['order']['0']['column']], $_POST['order']['0']['dir']);
		} 
		else if(isset($this->order))
		{
			$order = $this->order;
			$this->db->order_by(key($order), $order[key($order)]);
		}
	}

	function get_datatables()
	{
		$this->_get_datatables_query();
		if($_POST['length'] != -1)
		$this->db->limit($_POST['length'], $_POST['start']);
		$query = $this->db->get();
		return $query->result();
	}

	function count_filtered()
	{
		$this->_get_datatables_query();
		$query = $this->db->get();
		return $query->num_rows();
	}

	public function count_all()
	{
		$this->db->from($this->table);
		return $this->db->count_all_results();
	}

	public function get_by_id($id)
	{
		$this->db->from($this->table);
		$this->db->where('sh_bill.bill_id',$id);
		$this->db->join('sh_supplier', 'sh_bill.supplier_id = sh_supplier.supplier_id', 'left');
		$query = $this->db->get();

		return $query->row();
	}

	public function get_by_id_view($id)
	{
		$this->db->select("sh_receive_bill_items.item_id,sh_receive_bill_items.quantity,sh_drugs.drug_name,batch,x_date,bonus,cost,unit_type");
		$this->db->from("sh_receive_bill_items");
		$this->db->where('bill_id',$id);
		$this->db->join('sh_drugs', 'sh_drugs.drug_id = sh_receive_bill_items.item_id', 'left');
		$query = $this->db->get();

		return $query->result_array();
	}

	public function save($data)
	{
		$this->db->insert($this->table, $data);
		return $this->db->insert_id();
	}

	public function update($where, $data)
	{
		$this->db->update($this->table, $data, $where);
		return $this->db->affected_rows();
	}

	public function delete_by_id($id)
	{
		$this->db->where('sh_bill.bill_id', $id);
		$this->db->delete($this->table);
	}


}
