<?php

use
    DataTables\Editor,
    DataTables\Editor\Field,
    DataTables\Editor\Format,
    DataTables\Editor\Join,
    DataTables\Editor\Upload,
    DataTables\Editor\Validate;
    
class drugs extends CI_Model 
{
    private $editorDb = null;
    
    //constructor which loads the CodeIgniter database class (not required)
    public function __construct()	{
        $this->load->database();
    }    
    
    public function init($editorDb)
    {
        $this->editorDb = $editorDb;
    }
    
    public function getDrugs($post)
    {
		// Build our Editor instance and process the data coming from _POST
		// Use the Editor database class
		Editor::inst( $this->editorDb, 'drug_inventory' )
		->fields(
		    // Field::inst( 'first_name' )->validator( 'Validate::notEmpty' ),
		    // Field::inst( 'last_name' )->validator( 'Validate::notEmpty' ),
		    Field::inst( 'drug_id' ),
		    Field::inst( 'availability' ),
		    Field::inst( 'price' ),
		    Field::inst( 'drug_type' ),
		    Field::inst( 'new_old' )
		    ->validator( 'Validate::numeric' )
		    ->setFormatter( 'Format::ifEmpty', null ),
		    // Field::inst( 'salary' )
		    // ->validator( 'Validate::numeric' )
		    // ->setFormatter( 'Format::ifEmpty', null ),
		    Field::inst( 'update_date' )
		    ->validator( 'Validate::dateFormat', array(
		        "format"  => Format::DATE_ISO_8601,
		        "message" => "Please enter a date in the format yyyy-mm-dd"
		    ) )
		    ->getFormatter( 'Format::date_sql_to_format', Format::DATE_ISO_8601 )
		    ->setFormatter( 'Format::date_format_to_sql', Format::DATE_ISO_8601 )
		)
		->process( $post )
		->json();    
    }

}