<?php

use
    DataTables\Editor,
    DataTables\Editor\Field,
    DataTables\Editor\Format,
    DataTables\Editor\Join,
    DataTables\Editor\Upload,
    DataTables\Editor\Validate;
    
class TreatmentsModel extends CI_Model 
{
    private $editorDb = null;
    
    //constructor which loads the CodeIgniter database class (not required)
    public function __construct()	{
        $this->load->database();
    }    
    
    public function init($editorDb)
    {
        $this->editorDb = $editorDb;
    }
    
    public function getTreatments($post)
    {
        Editor::inst($this->editorDb, 'tbl_insurance_prices')
        ->fields(
            Field::inst('tbl_insurance_prices.treatment_id')->validator( 'Validate::notEmpty')->validator('Validate::unique', array(
                'message' => 'Treatment code already exists'
                )  ),
            Field::inst('tbl_insurance_prices.treatment_name')->validator( 'Validate::notEmpty'),
            Field::inst('tbl_insurance_prices.treatment_name_ar')->validator(  'Validate::notEmpty'),
            Field::inst('tbl_insurance_prices.lqdc_gross')->validator('Validate::notEmpty'),
            Field::inst('tbl_insurance_prices.treatment_category')->validator('Validate::notEmpty'),
            Field::inst('tbl_insurance_prices.insurance_type_id')->validator('Validate::notEmpty'),
            Field::inst('tbl_insurance_prices.deleted')->validator('Validate::notEmpty'),
            Field::inst('tbl_modules.module_name')->validator('Validate::notEmpty'),
			Field::inst('tbl_status.status_name'),
			Field::inst('tbl_insurance_types.insurance_name')
        )
        ->leftJoin('tbl_insurance_types', 'tbl_insurance_types.insurance_type_id', '=', 'tbl_insurance_prices.insurance_type_id')
        ->leftJoin('tbl_modules', 'tbl_modules.department_id', '=', 'tbl_insurance_prices.treatment_category')
        ->leftJoin('tbl_status', 'tbl_status.status_id', '=', 'tbl_insurance_prices.deleted')
        ->pkey('tbl_insurance_prices.id')
        ->process($post)
        ->json();   
    }

}