<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class SmsPortalModel extends CI_Model
{

	function __construct()
	{
		parent::__construct();
		$this->load->database();
	}

	public function load_patients($query)
	{
		return $this->db
			->select('mobile, patient_name')
			->from('tbl_patients')
			->group_start()
			->like('patient_name', $query)
			->or_like('mobile', $query)
			->or_like('qatar_id', $query)
			->or_like('passport_number', $query)
			->or_like('first_name', $query)
			->or_like('middle_name', $query)
			->or_like('last_name', $query)
			->group_end()
			->limit(20)
			->get()
			->result();
	}

	public function getTemplate($eventType, $language) {
		return $this->db
		->select('template')
		->from('tbl_notification_templates')
		->where('event_type', $eventType)
		->where('is_default', 1)
		->where('type', 'sms')
		->where('language', $language)
		->get()
		->row();
	}

}
