<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title> Category List</title>
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

  <!--image crop-->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.css" rel="stylesheet" type="text/css" />
  <script src="https://cdnjs.cloudflare.com/ajax/libs/croppie/2.6.2/croppie.js"></script>
  <?php require_once(APPPATH . "views/admin/header.php"); ?>
  <style>
    .ui-autocomplete{
      max-height: 500px;
      overflow: scroll;
    }
  </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
  <!-- Site wrapper -->

  <!-- Header Navbar: style can be found in header.less -->
  <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Right side column. Contains the navbar and content of the page -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1><strong>Credit</strong></h1>
      <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
    </section>

    <section class="content">

      <!--buttons-->

      <div class="row">
        <div class="col-12">
          <div class="box box-info">
            <div class="box-body">
              <ul class="nav nav-tabs tab_list0" id="myTab" role="tablist">
                <li class="nav-item">
                  <a class="nav-link font-weight-bold active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">Advance</a>
                </li>
                <li class="nav-item">
                  <a class="nav-link font-weight-bold" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">Refund</a>
                </li>
              </ul>

              <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                  <div class="row mt-2">
                    <div class="col-md-12">
                      <?php require_once(APPPATH . "views/admin/Credits/Advance/Advance.php"); ?>
                    </div>
                  </div>
                </div>
                <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                  <div class="row mt-2">
                    <div class="col-md-12">
                      <?php require_once(APPPATH . "views/admin/Credits/Refund/Refund.php"); ?>
                    </div>
                  </div>
                </div>
                <div class="tab-pane fade" id="contact" role="tabpanel" aria-labelledby="contact-tab">...</div>
              </div>
            </div>
          </div>
          <input type="hidden" id="selected_id" name="selected_id">
          <input type="hidden" id="formSubmit" name="formSubmit" value="submitForm">
          <input type="hidden" id="form" name="form" value="Category">
        </div>
      </div>
    </section>
  </div>

  <!-- ./wrapper -->

  <?php require_once(APPPATH . "views/admin/footer.php"); ?>
</body>
<script>
  var settings = {};
  new TomSelect('#payment_type', settings);
  new TomSelect('#refund_type', settings);
  

  $("#patient_idx").autocomplete({
    source: function(request, response) {
      $.ajax({
        url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/get_patients'); ?>",
        dataType: "json",
        data: {
          name_startsWith: request.term,
          type: 'patient_id'
        },
        success: function(data) {
          response($.map(data, function(item) {
            var pat_name = item.split(' - ');
            return {
              label: item,
              value: pat_name[1]
            }
          }));
        }
      });
    },
    select: function(event, ui) {
      var patient_id = ui.item.label.split(' - ');

      $('#patient_id').val(patient_id[0]);
    },
    autoFocus: false,
    minLength: 1
  });

  $("#patient_idx_refund").autocomplete({
    source: function(request, response) {
      $.ajax({
        url: "<?= base_url('index.php/admin/ConsentForm/ConsentFormController/get_patients'); ?>",
        dataType: "json",
        data: {
          name_startsWith: request.term,
          type: 'patient_id'
        },
        success: function(data) {
          response($.map(data, function(item) {
            var pat_name = item.split(' - ');
            return {
              label: item,
              value: pat_name[1]
            }
          }));
        }
      });
    },
    select: function(event, ui) {
      var patient_id = ui.item.label.split(' - ');

      $('#patient_id').val(patient_id[0]);
    },
    autoFocus: false,
    minLength: 1
  });

  var dataTableTreatment = $('#advance_list').DataTable({
    'ajax': {
      'url': '<?= site_url('admin/Credits/CreditsController/get_advance_list'); ?>',
      'type': 'GET',
      'data': function(d) {
        d.is_insurance = 0
      }
    },

    'columns': [{
        'data': 'advance_no',
        'title': 'Ad.No',
      },
      {
        'data': 'patient_name',
        'title': 'Patient Name'
      },
      {
        'data': 'patient_id',
        'title': 'File No'
      },
      {
        'data': 'amount',
        'title': 'Advance Amount'
      },
      {
        'data': 'type_name',
        'title': 'Payment Type'
      },
      {
        'data': 'pay_date',
        'title': 'Payment Date'
      },
      {
        'data': null,
        'title': 'Actions',
        'render': function(data, type, row) {
          return `
                <a href="<?= base_url('index.php/admin/Credits/CreditsController/editAdvance') ?>/${row.advance_id}" class="btn btn-sm btn-light" title="Edit"><i class="fa fa-edit"></i></a>
                <a onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Credits/CreditsController/deleteAdvance') ?>/${row.advance_id}')" class="btn btn-sm btn-light" title="Delete"><i class="fa fa-trash"></i></a>
                <a href="<?= base_url('index.php/admin/Receipt/ReceiptController/print_advance') ?>/${row.advance_id}" target="_blank" class="btn btn-sm btn-light" title="Print"><i class="fa fa-print"></i></a>`;
        }
      }
    ],
    'serverSide': true,
    'pageLength': 10,
    'lengthMenu': [10, 25, 50, 100, -1],
    'pagingType': 'full_numbers',
  });


  
  var dataTableTreatment = $('#refund_list').DataTable({
    'ajax': {
      'url': '<?= site_url('admin/Credits/CreditsController/get_refund_list'); ?>',
      'type': 'GET',
      'data': function(d) {
        d.is_insurance = 0
      }
    },

    'columns': [{
        'data': 'refund_no',
        'title': 'Ref.No',
      },
      {
        'data': 'patient_name',
        'title': 'Patient Name'
      },
      {
        'data': 'patient_id',
        'title': 'File No'
      },
      {
        'data': null,
        'title': 'Refund Amount',
        'render': function(data, type, row) {
          return row['amount'];
        }
      },
      {
        'data': 'type_name',
        'title': 'Payment Type'
      },
      {
        'data': 'pay_date',
        'title': 'Refund Date'
      },
      {
        'data': null,
        'title': 'Actions',
        'render': function(data, type, row) {
          return `
                <a href="<?= base_url('index.php/admin/Credits/CreditsController/editRefund') ?>/${row.id}" class="btn btn-sm btn-light" title="Edit"><i class="fa fa-edit"></i></a>
                <a href="#" onclick="confirmDeleteGenral('<?= base_url('index.php/admin/Credits/CreditsController/deleteRefund') ?>/${row.id}')" class="btn btn-sm btn-light" title="Delete"><i class="fa fa-trash"></i></a>
                <a href="<?= base_url('index.php/admin/Receipt/ReceiptController/print_refund') ?>/${row.id}" target="_blank" class="btn btn-sm btn-light" title="Print"><i class="fa fa-print"></i></a>`;
        }
      }
    ],
    'serverSide': true,
    'pageLength': 10,
    'lengthMenu': [10, 25, 50, 100, -1],
    'pagingType': 'full_numbers',
  });


  $("#invoice_id").autocomplete({
    source: function(request, response) {
      $.ajax({
        url: "<?= base_url('index.php/admin/Credits/CreditsController/get_invoices'); ?>",
        dataType: "json",
        data: {
          name_startsWith: request.term
        },
        success: function(data) {
          response($.map(data, function(item) {
            var pat_name = item.split(' - ');
            return {
              label: item,
              value: pat_name[1]
            }
          }));
        }
      });
    },
    select: function(event, ui) {
      var details = ui.item.label.split(' || ');
      $('.invoice_details').removeClass('hide');
      $('#invoice_amount').val(details[2]);
      $('#paid_amount').val(details[3]);
      $('#treatment_payment_id').val(details[0]);
      
    },
    autoFocus: false,
    minLength: 1
  });


  $('#payment_type').on('change', function() {
    visible_card();
  })

  function visible_card() {
    var type = $('#payment_type').val();
    if (type == '3') {
      $('#card_amount').removeClass('hide')
    } else {
      $('#card_amount').addClass('hide')
    }
  }


    // Store selected tab in localstorage
    $('.tab_list0').on('click', 'li', function() {
        var tabIndex = $(this).index();
        localStorage.setItem('selectedTabIndex0', tabIndex);
    });

    // Load tab index from localstorage
    $(document).ready(function() {
        let selectedTab = localStorage.getItem('selectedTabIndex0') != null ? localStorage.getItem('selectedTabIndex0') : 0;
        $(`.tab_list0 a:eq(${selectedTab})`).tab('show');
    });

    $('.tab_list1').on('click', 'li', function() {
        var tabIndex = $(this).index();
        localStorage.setItem('selectedTabIndex1', tabIndex);
    });

    // Load tab index from localstorage
    $(document).ready(function() {
        let selectedTab = localStorage.getItem('selectedTabIndex1') != null ? localStorage.getItem('selectedTabIndex1') : 0;
        $(`.tab_list1 a:eq(${selectedTab})`).tab('show');
    });
</script>

</html>