<!DOCTYPE html>
<html>

<head>
  <meta charset="UTF-8">
  <title> Dashboard</title>
  <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

  <!--image crop-->





  <?php require_once(APPPATH . "views/admin/header.php"); ?>

  <style>
    .loader {
      border: 8px solid #f3f3f396;
      border-radius: 50%;
      border-top: 8px solid #00000033;
      width: 40px;
      height: 40px;
      -webkit-animation: spin 2s linear infinite;
      /* Safari */
      animation: spin 2s linear infinite;
    }

    /* Safari */
    @-webkit-keyframes spin {
      0% {
        -webkit-transform: rotate(0deg);
      }

      100% {
        -webkit-transform: rotate(360deg);
      }
    }

    @keyframes spin {
      0% {
        transform: rotate(0deg);
      }

      100% {
        transform: rotate(360deg);
      }
    }

    #price_list_paginate {
      font-size: 13px;
    }

    #price_list {
      font-size: 14px;
    }

    #price_list_length {
      font-size: 14px;
    }

    #price_list_filter {
      font-size: 14px;
    }


    #price_list_company_paginate {
      font-size: 13px;
    }

    #price_list_company_info {
      font-size: 14px;
    }

    #price_list_company_length {
      font-size: 14px;
    }

    #price_list_company_filter {
      font-size: 14px;
    }

    #price_list_company th:nth-child(1),
    #price_list_company td:nth-child(1) {
      width: 23%;
    }

    #price_list_company th:nth-child(2),
    #price_list_company td:nth-child(2) {
      width: 20%;
    }

    #price_list_company th:nth-child(3),
    #price_list_company td:nth-child(3) {
      width: 49%;
    }

    #price_list_company th:nth-child(4),
    #price_list_company td:nth-child(4) {
      width: 7% !important;
    }

    #insurance_filter {
      font-size: 14px;
      height: 35px;
    }

    .dashboard_icon {
      font-size: 4vw !important;
      color: #212529
    }

    .small-box {
      box-shadow: 0 1px 11px 0px rgba(0, 0, 0, 0.1) !important;
    }

    .container_flip {
      height: 200px;
      position: relative;
      perspective: 800px;
    }

    #card {
      width: 100%;
      height: 100%;
      position: absolute;
      transform-style: preserve-3d;
      transition: transform 1s;
    }

    #card figure {
      margin: 0;
      display: block;
      position: absolute;
      width: 100%;
      height: 100%;
      backface-visibility: hidden;
    }


    #card .back {

      transform: rotateY(180deg);
    }

    #card.flipped {
      transform: rotateY(180deg);
    }

    .small-box {
      text-decoration: none;
      color: #444444;
      transition-timing-function: ease-in-out;
    }

    .flip-out {
      animation: flipOut 0.7s ease;
    }

    .flip-in {
      animation: flipIn 0.7s ease;
    }

    @keyframes flipOut {
      from {
        transform: perspective(3500px) rotateY(0deg);
        transform-style: preserve-3d;
        opacity: 1;
      }

      to {
        transform: perspective(3500px) rotateY(-90deg);
        transform-style: preserve-3d;
        opacity: 0;
      }
    }

    @keyframes flipIn {
      from {
        transform: perspective(3500px) rotateY(90deg);
        transform-style: preserve-3d;
        opacity: 0;
      }

      to {
        transform: perspective(3000px) rotateY(0deg);
        transform-style: preserve-3d;
        opacity: 1;
      }
    }
  </style>
</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
  <!-- Site wrapper -->


  <!-- Header Navbar: style can be found in header.less -->
  <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Left side column. contains the sidebar -->
  <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

  <!-- =============================================== -->

  <!-- Right side column. Contains the navbar and content of the page -->
  <div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <h1>
        <strong>Dashboard</strong>
      </h1>
      <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
    </section>

    <!-- Main content -->
    <section class="content">
      <!-- Small boxes (Stat box) -->
      <div class="row hide" id="statics">
        <div class="col-lg-2 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-white">
            <div class="inner">
              <div id="l_last_patient_id" class="loader mt-2 ml-4 mb-3"></div>
              <h3 id="last_patient_id"></h3>
              <!-- <h3><?php // $last_patient_id ? sprintf('%02d', $last_patient_id) : '00' 
                        ?></h3> -->
              <p>Patient Number</p>
            </div>
            <div class="icon">
              <!-- <i class="ri-group-line"></i> -->
              <i class="ri-group-line dashboard_icon"></i>
              <!-- <i class="fa fa-group dashboard_icon" style="color: #6b6b6b;"></i> -->
            </div>
            <!-- <a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a> -->
          </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-2 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-white">
            <div class="inner">
              <div id="l_totla_patients" class="loader mt-2 ml-4 mb-3"></div>
              <h3 id="totla_patients"></h3>
              <!-- <h3><?php //echo $totla_patients ? sprintf('%02d', $totla_patients) : '00' 
                        ?></h3> -->
              <p>Patients</p>
            </div>
            <div class="icon">
              <i class="ri-hotel-bed-line dashboard_icon"></i>
              <!-- <i class="fa fa-bed dashboard_icon" style="color: #6b6b6b;"></i> -->
            </div>
            <!-- <a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a> -->
          </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-2 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-white">
            <div class="inner">
              <div id="l_total_doctors" class="loader mt-2 ml-4 mb-3"></div>
              <h3 id="total_doctors"></h3>
              <!-- <h3><?php //echo $total_doctors ? sprintf('%02d', $total_doctors) : '00' 
                        ?></h3> -->
              <p>Doctors</p>
            </div>
            <div class="icon">
              <i class="ri-stethoscope-fill dashboard_icon"></i>
              <!-- <i class="fa fa-user-md dashboard_icon" style="color: #6b6b6b;"></i> -->
            </div>
            <!-- <a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a> -->
          </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-2 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-white">
            <div class="inner">
              <div id="l_total_nurses" class="loader mt-2 ml-4 mb-3"></div>
              <h3 id="total_nurses"></h3>
              <!-- <h3><?php //echo $total_nurses ? sprintf('%02d', $total_nurses) : '00' 
                        ?></h3> -->
              <p>Nurses</p>
            </div>
            <div class="icon">
              <i class="ri-nurse-line dashboard_icon"></i>
              <!-- <i class="fa fa-plus-square-o dashboard_icon" style="color:#6b6b6b;"></i> -->
            </div>
            <!-- <a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a> -->
          </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-2 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-white">
            <div class="inner">
              <div id="l_avialable_sms_count" class="loader mt-2 ml-4 mb-3"></div>
              <h3 id="avialable_sms_count"></h3>
              <h3><?php echo $avialable_sms_count
                  ?></h3>
              <p>SMS Available</p>
            </div>
            <div class="icon">
              <i class="ri-question-answer-line dashboard_icon"></i>
              <!-- <i class="fa fa-comments-o dashboard_icon" style="color:#6b6b6b;"></i> -->
            </div>
            <!-- <a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a> -->
          </div>
        </div>
        <!-- ./col -->
        <div class="col-lg-2 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-white">
            <div class="inner">
              <div id="l_available_appoinments" class="loader mt-2 ml-4 mb-3"></div>
              <h3 id="available_appoinments"></h3>
              <!-- <h3><?php //echo $available_appoinments ? sprintf('%02d', $available_appoinments) : '00' 
                        ?></h3> -->
              <p>Appointments</p>
            </div>
            <div class="icon">
              <i class="ri-calendar-2-fill dashboard_icon"></i>
              <!-- <i class="fa fa-calendar dashboard_icon" style="color:#6b6b6b;"></i> -->
            </div>
            <!-- <a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a> -->
          </div>
        </div>
        <!-- ./col -->
      </div>
      <!-- /.row -->
      <!-- Main row -->
      <div class="row">
        <section class="col-xl-8 connectedSortable">
          <div class=" box box-success hide" id="sales_chart">
            <div class="box-header with-border">
              <h3 class="box-title"><i class="fa fa-line-chart"></i> Sales Chart</h3>
              <div class="box-tools pull-right">
                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                </button>
              </div>
            </div>
            <div class="box-body">
              <div class="chart-responsive">
                <div id="salesChartContent" class="loader mt-2 ml-4 mb-3" style="position: absolute; top:40%; left:40%"></div>
                <canvas id="salesChart" width="250" height="70"></canvas>
              </div>
            </div>
          </div>
          <div class="row">
            <section class="col-lg-6">
              <!-- /.info-box -->

              <div class=" box box-warning hide" id="sales_vs_balance">
                <div class="box-header with-border">
                  <h3 class="box-title"><i class="ri-exchange-line"></i> Sales vs Balance</h3>

                  <div class="box-tools pull-right">
                    <select name="timeRange" id="timeRange">
                      <option value="1">Today</option>
                      <option value="2">This Week</option>
                      <option value="3" selected>This Month</option>
                      <option value="4">This Year</option>
                    </select>
                  </div>
                </div>
                <div class="box-body">
                  <div class="chart-responsive">
                    <div class="row-fluid" style="padding:40px 10px 0px 10px!important;height:172px">
                      <div class="row">
                        <div class="col-md-6">
                          <div class="widget">
                            <h2 style="color:#3ebfbe"><b>QR</b><b id="total_sales"></b></h2><strong class="rewidgt" style="color:#3ebfbe">TOTAL SALES</strong><br>
                            <!-- <strong class="green"><i class="fa fa-arrow-up" style="color:#3ebfbe"></i id="total_sales_percentage">988.49%</strong><br><small>Previous QR15,183</small> |
                                 <small>Last month QR</small><small id="last_month_sales">448,822.37</small> -->
                          </div>
                        </div>

                        <div class="col-md-6">
                          <div class="widget">
                            <h2 style="color:#f33e6f"><b>QR</b><b id="total_balance"></b></h2><strong class="rewidgt" style="color:#f33e6f">TOTAL BALANCE</strong><br>
                            <!-- <strong class="green"><i class="fa fa-arrow-up" style="color:#f33e6f"></i id="total_balance_percentage">196.54%</strong><br><small>Previous QR125,220</small> |  
                                <small>Last month QR</small><small id="last_month_balance">586,349.37</small>-->
                          </div>
                        </div>
                      </div>

                    </div>
                  </div>
                </div>
              </div>
              <div class="box box-info hide" id="rated_treatments">
                <div class="box-header">
                  <i class="fa fa-th"></i>

                  <div class="box-tools pull-right">
                    <select name="timeRangeTop" id="timeRangeTop">
                      <option value="1">Today</option>
                      <option value="2">This Week</option>
                      <option value="3" selected>This Month</option>
                      <option value="4">This Year</option>
                    </select>
                    <button type="button" class="btn btn-box-tool"><i class="fa fa-exchange" id="flip"></i>
                    </button>
                  </div>
                </div>
                <div class="box-body border-radius-none" style="position: relative;height: 250px">
                  <div class="container_flip">
                    <div id="card">
                      <figure class="front">
                        <h6 class="box-title">Top Rated Treatments</h6>
                        <div id="l_receptionist_received_treatment" class="loader mt-2 ml-4 mb-3" style="position: absolute; top:40%; left:40%"></div>
                        <canvas id="donutChart_treatment" width="200" height="150"></canvas>
                        <div></div>
                      </figure>
                      <figure class="back">
                        <h6 class="box-title">Top Rated Patients</h6>
                        <div id="l_receptionist_received_balances" class="loader mt-2 ml-4 mb-3" style="position: absolute; top:40%; left:40%"></div>
                        <canvas id="donutChart_balances" width="200" height="150"></canvas>
                        <div></div>
                      </figure>
                    </div>
                  </div>


                </div>
              </div>

            </section>
            <section class="col-lg-6">
              <div class=" box box-danger hide" id="received_payments">
                <div class="box-header with-border">
                  <h3 class="box-title"><i class="ri-wallet-line"></i> Received Payments</h3>
                  <div class="box-tools pull-right">
                    <select name="timeRangePayments" id="timeRangePayments">
                      <option value="today">Today</option>
                      <option value="week">This Week</option>
                      <option value="month" selected>This Month</option>
                      <option value="year">This Year</option>
                    </select>
                  </div>
                </div>
                <div class="box-body">
                  <div class="row">
                    <div class="col-md-12">
                      <div class="chart-responsive">
                        <div id="l_receptionist_received" class="loader mt-2 ml-4 mb-3" style="position: absolute; top:40%; left:40%"></div>
                        <canvas id="donutChart" width="250" height="170"></canvas>
                        <div></div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div class="box box-primary hide" id="treatment_vs_appoinments">
                <div class="box-header">
                  <i class="fa fa-th"></i>

                  <h3 class="box-title">Treatment vs Appoinments</h3>
                </div>
                <div class="box-body border-radius-none" style="position: relative;">
                  <div class="chart" id="revenue-chart">
                    <div class="loader mt-2 ml-4 mb-3" style="position: absolute; top:40%; left:45%" id="l_treatments_vs_appoinments"></div>
                    <canvas id="treatments_vs_appoinments" style="width:100%;height:230px"></canvas>
                  </div>
                </div>
                <!-- /.box-body -->

                <!-- /.box-footer -->
              </div>

            </section>

            <section class="col-lg-12">
              <!-- <div class=" box box-danger">
                <div class="box-header with-border">
                  <h3 class="box-title"><i class="ri-wallet-line"></i> Received Payments</h3>
                  <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                    </button>
                  </div>
                </div>
                <div class="box-body">
                  <div class="row">
                    <div class="col-md-12">
                      <div class="chart-responsive">
                        <div id="l_chart" class="loader mt-2 ml-4 mb-3" style="position: absolute; top:40%; left:40%"></div>
                        <canvas id="l_donutChart" width="250" height="101"></canvas>
                      </div>
                    </div>
                  </div>
                </div>
              </div> -->

            </section>
          </div>
          <div class="row hide" id="top_doctors">
            <section class="col-lg-12">
              <div class="box box-primary">
                <div class="box-header">
                  <i class="fa fa-th"></i>

                  <h3 class="box-title">Doctors Statics</h3>
                  <div class="box-tools pull-right">
                    <select name="timeRangeDoctors" id="timeRangeDoctors">
                      <option value="1">Today</option>
                      <option value="2">This Week</option>
                      <option value="3" selected>This Month</option>
                      <option value="4">This Year</option>
                    </select>
                  </div>
                </div>
                <div class="box-body border-radius-none" style="position: relative;">
                  <div class="chart" id="doctors-revenue-chart">
                    <div class="loader mt-2 ml-4 mb-3" style="position: absolute; top:40%; left:45%" id="l_doctor_vs_revenue"></div>
                    <canvas id="doctor_vs_revenue" width="250" height="70"></canvas>
                    <div></div>
                  </div>
                </div>
                <!-- /.box-body -->

                <!-- /.box-footer -->
              </div>
            </section>
          </div>
        </section>
        <section class=" col-xl-4">
          <!-- Widget: user widget style 1 -->
          <!-- <div class="box box-widget widget-user-2">
            <div class="widget-user-header bg-blue">
              <div class="widget-user-image">
                <img class="img-circle" src="<?= $this->profile->image_path; ?>" alt="User Avatar">
              </div>
              <h3 class="widget-user-username">Hello <?= $this->profile->profile_name; ?>,</h3>
              <h5 class="widget-user-desc"><b>How are you feeling today?</b></h5>
            </div>
          </div> -->

          <!-- <div class="info-box bg-maroon">
            <span class="info-box-icon"><i class="ion ion-cash"></i></span>

            <div class="info-box-content">
              <span class="info-box-text">Total Sales
                <div class="box-tools pull-right">
                  <button type="button" data-param="t" class="btn btn-primary btn-xs btn-sales">Today</button>
                  <button type="button" data-param="m" class="btn btn-warning btn-xs btn-sales">This month</button>
                  <button type="button" data-param="y" class="btn btn-success btn-xs btn-sales">This year</button>
                </div>
              </span>
              <span class="info-box-number dashboard-total-sales-amount">0</span>

              <div class="progress">
                <div class="progress-bar" style="width: 20%"></div>
              </div>
              <span class="progress-description">
                20% Increase in 30 Days
              </span>
            </div>
             .info-box-content 
          </div> -->


          <!-- /.info-box-->

          <div class="box box-danger hide" id="quick_actions">
            <div class="box-header">
              <i class="fa fa-th"></i>
              <h3 class="box-title">Quick Actions</h3>
            </div>
            <div class="row p-2">
              <div class="col-4">
                <a class="btn btn-light m-1 w-100 border" href="<?php echo base_url('index.php/admin/Calender/CalenderController') ?>"> <i class="ri-calendar-schedule-fill"></i><br>Create Appointment</a>
              </div>
              <div class="col-4">
                <a class="btn btn-light m-1  w-100 border" href="<?php echo base_url('index.php/admin/Payments/PaymentsController/createBill') ?>"><i class="ri-file-text-fill"></i><br>Create Invoice</a>

              </div>
              <div class="col-4">
                <a class="btn btn-light m-1  w-100 border" href="<?php echo base_url('index.php/admin/Patients/PatientsController/createNew') ?>"><i class="ri-user-add-fill"></i><br>Add Patient</a>
              </div>
              <div class="col-4">
                <a class="btn btn-light m-1  w-100 border" href="<?php echo base_url('index.php/admin/Credits/CreditsController') ?>"><i class="ri-wallet-3-fill"></i><br>Create Advance</a>
              </div>
              <div class="col-4">
                <a class="btn btn-light m-1  w-100 border" href="<?php echo base_url('index.php/admin/Payments/PaymentsController') ?>"><i class="ri-bank-card-fill"></i><br>Make Payments</a>
              </div>
              <div class="col-4">
                <a class="btn btn-light m-1 w-100 border" href="<?php echo base_url('index.php/admin/ConsentForm/ConsentFormController/consent_list') ?>"><i class="ri-draft-fill"></i><br>Consent Forms</a>
              </div>
              </tr>
              </tbody>
              </table>
            </div>
          </div>
          <!-- /.info-box -->
          <div class="info-box bg-aqua hide">
            <span class="info-box-icon"><i class="ion-ios-chatbubble-outline"></i></span>

            <div class="info-box-content">
              <span class="info-box-text">Direct Messages</span>
              <span class="info-box-number">163,921</span>

              <div class="progress">
                <div class="progress-bar" style="width: 40%"></div>
              </div>
              <span class="progress-description">
                40% Increase in 30 Days
              </span>
            </div>
          </div>

          <div class="box box-warning hide" id="insurance_list">
            <div id="insurancePrice">
              <div class="box-header with-border">
                <h3 class="box-title">Insurance Price Lists</h3>
                <div class="box-tools pull-right">
                  <button type="button" class="btn btn-light btn-sm changePriceList" data-enable="companyPriceList" data-disable="insurancePrice"><i class="fa fa-refresh"></i> Company
                  </button>
                  <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                  </button>
                </div>
              </div>

              <div class="box-body">
                <div class="panel-group" id="accordion">

                  <div class="d-block mb-3">
                    <select class="form-control" id="insurance_filter">
                      <!-- <option value="0">Choose Insurance Type</option> -->
                      <?php foreach ($insurance_types as $type) : ?>
                        <option value="<?= $type->insurance_type_id; ?>"><?= $type->insurance_name; ?></option>
                      <?php endforeach; ?>
                    </select>
                  </div>

                  <table id="price_list" class="table table-light table-bordered table-striped"></table>

                </div>
              </div>
            </div>
            <div id="companyPriceList" class="hide">
              <div class="box-header with-border">
                <h3 class="box-title">Company Price Lists</h3>
                <div class="box-tools pull-right">
                  <button type="button" class="btn btn-light btn-sm changePriceList" data-enable="insurancePrice" data-disable="companyPriceList"><i class="fa fa-refresh"></i> Insurance
                  </button>
                  <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i>
                  </button>
                </div>
              </div>

              <div class="box-body">
                <div class="panel-group " id="accordion">

                  <div class="d-block mb-3">
                    <select class="form-control" id="company_filter">
                      <option value="0">No Company</option>
                      <?php foreach ($companies as $company) : ?>
                        <option value="<?= $company->company_id; ?>"><?= $company->company_name; ?></option>
                      <?php endforeach; ?>
                    </select>
                  </div>

                  <table id="price_list_company" class="table table-light table-bordered table-striped w-100"></table>

                </div>
              </div>
            </div>
            <!-- /.box-body -->
          </div>

          <!-- /.box -->



        </section>
        <!-- /.col -->

        <!-- /.Left col -->
      </div>
      <!-- /.row (main row) -->

    </section>

  </div>

  <!-- ./wrapper -->


  <?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>

</html>


<script>
  fetchData()


  <?php if (check_right('sales_vs_balance', $this)) { ?>
    $('#sales_vs_balance').removeClass('hide');
  <?php }
  if (check_right('rated_treatments', $this)) { ?>
    $('#rated_treatments').removeClass('hide');
  <?php }
  if (check_right('received_payments', $this)) { ?>
    $('#received_payments').removeClass('hide');
  <?php }
  if (check_right('treatment_vs_appoinments', $this)) { ?>
    $('#treatment_vs_appoinments').removeClass('hide');
  <?php }
  if (check_right('quick_actions', $this)) { ?>
    $('#quick_actions').removeClass('hide');
  <?php }
  if (check_right('statics', $this)) { ?>
    $('#statics').removeClass('hide');
  <?php }
  if (check_right('insurance_list', $this)) { ?>
    $('#insurance_list').removeClass('hide');
  <?php }
  if (check_right('sales_chart', $this)) { ?>
    $('#sales_chart').removeClass('hide');
  <?php } ?>
  <?php if (check_right('sales_chart', $this)) { ?>
    $('#top_doctors').removeClass('hide');
  <?php } ?>

  var card = document.getElementById('card');

  document.getElementById('flip').addEventListener('click', function() {
    card.classList.toggle('flipped');
  }, false);

  $('.flipList').click(function() {

    $('.Listcard').toggleClass('flipped');
  });

  var fetchData;

  function fetchData() {
    $.ajax({
      url: '<?= base_url('index.php/admin/Dashboard/DashboardController/getDashboarddData') ?>',
      type: 'POST',
      contentType: 'application/json',
      success: function(response) {

        console.log('Response:', response);

        $('#last_patient_id').text(response.last_patient_id);
        $('#l_last_patient_id').remove();

        $('#totla_patients').text(response.totla_patients);
        $('#l_totla_patients').remove();

        $('#total_doctors').text(response.total_doctors);
        $('#l_total_doctors').remove();

        $('#total_nurses').text(response.total_nurses);
        $('#l_total_nurses').remove();

        $('#avialable_sms_count').text(response.avialable_sms_count);
        $('#l_avialable_sms_count').remove();

        $('#available_appoinments').text(response.available_appoinments);
        $('#l_available_appoinments').remove();

        generateCharts(response.appoinments_vs_treatments);
        generateCharts2(response.appoinments_vs_treatments);
        generateChartsDoctor(response.doctors);
        console.log(response.doctors);
        receptionistReceivedChart(response.receptionist_received, 'month');
        doctorPerformance(response.doctor_income);
        generateSalesChart(response.totalSales);
        countSalesBalance(response.totalSales, response.totalBalance);
        generateTreatments(response.treatments);
        generatePatients(response.patients);

        fetchData = response;
      },
      error: function(error) {
        console.error('Error:', error);
      }
    });
  }

  function generateCharts(data) {
    const xValues = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
    const appoinments = data.appoinments;
    const treatments = data.treatments;

    new Chart("treatments_vs_appoinments", {
      type: "bar",
      data: {
        responsive: true,
        maintainAspectRatio: false,
        labels: xValues,
        datasets: [{
            label: "Appoinments",
            fill: false,
            lineTension: 0.1,
            backgroundColor: "rgb(54, 162, 235)",
            borderColor: "rgb(54, 162, 235, 0.5)",
            data: appoinments
          },
          {
            label: "Treatments",
            fill: false,
            lineTension: 0.1,
            backgroundColor: "rgb(255, 99, 132)",
            borderColor: "rgb(255, 99, 132, 0.5)",
            data: treatments
          }
        ]
      },
      options: {
        scales: {
          yAxes: [{
            ticks: {
              beginAtZero: true
            }
          }]
        }
      }
    });

    $('#l_treatments_vs_appoinments').remove();
  }


  $('#timeRangeDoctors').on('change', function(e) {

    let period = $(this).val();
    $.ajax({
      url: '<?= base_url('index.php/admin/Dashboard/DashboardController/getDoctorPatients') ?>',
      type: 'GET',
      contentType: 'application/json',
      data: {
        period: period
      },
      success: function(response) {
        generateChartsDoctor(response.doctors)
      },
      error: function(error) {}
    });
  })


  var doctorChart = '';

  function generateChartsDoctor(data) {

    var labels = data.map(function(doctor) {
      return doctor.full_name;
    });

    var datat = data.map(function(doctor) {
      return doctor.total_amount ? parseFloat(doctor.total_amount) : 0;
    });

    if (doctorChart != '') {
      doctorChart.destroy();
    }

    const xValues = labels;
    const appoinments = datat;


    if (data.length > 0) {
      $('#doctor_vs_revenue').parent().find('div').html('');
      doctorChart = new Chart("doctor_vs_revenue", {
        type: "bar",
        data: {
          responsive: false,
          maintainAspectRatio: false,
          labels: xValues,
          datasets: [{
              label: "Doctors",
              fill: false,
              lineTension: 0.1,
              backgroundColor: "rgb(54, 162, 235)",
              borderColor: "rgb(54, 162, 235, 0.5)",
              data: datat
            },

          ]
        },
        options: {
          scales: {
            yAxes: [{
              ticks: {
                beginAtZero: true
              }
            }]
          }
        }
      });
    } else {
      $('#doctor_vs_revenue').parent().find('div').html('<p id="tretno" style="text-align: center; color: #888; font-size: 16px;position: absolute;right: 40%;top: 40%;">No data available</p>')
    };

    $('#l_doctor_vs_revenue').remove();
  }

  function generateCharts2(data) {
    const xValues = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
    const appoinments = data.appoinments;
    const treatments = data.treatments;

    new Chart("l_donutChart", {
      type: "bar",
      data: {
        responsive: true,
        maintainAspectRatio: false,
        labels: xValues,
        datasets: [{
            label: "Appoinments",
            fill: false,
            lineTension: 0.1,
            backgroundColor: "rgb(54, 162, 235)",
            borderColor: "rgb(54, 162, 235, 0.5)",
            data: appoinments,
            type: "line"
          },
          {
            label: "Treatments",
            fill: false,
            lineTension: 0.1,
            backgroundColor: "rgb(255, 99, 132)",
            borderColor: "rgb(255, 99, 132, 0.5)",
            data: treatments,
            type: "bar"
          }
        ]
      },
      options: {
        scales: {
          yAxes: [{
            ticks: {
              beginAtZero: true
            }
          }]
        }
      }
    });

    $('#l_chart').remove();
  }

  function generateSalesChart(data) {
    <?php
    $currentYear = date('Y');
    $currentMonth = date('m');

    // Get the number of days in the current month
    $numberOfDays = date('t', strtotime("$currentYear-$currentMonth-01"));

    // Initialize an array to store the days of the month
    $daysOfMonth = array();

    // Loop through each day of the month and add it to the array
    for ($day = 1; $day <= $numberOfDays; $day++) {
      // Add the day to the array
      $daysOfMonth[] = $day;
    }
    ?>

    const dValues = <?php echo json_encode($daysOfMonth); ?>;
    const xValues = ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'];
    const current_year = <?php echo date('Y') ?>; // replace with the actual year
    const current_month = <?php echo date('m') ?>; // replace with the actual month

    const days = data.today == null ? [] : data.today;
    const month = data.month == null ? [{
      pay_date: 0,
      total: 0
    }] : data.month;
    const year = data.year == null ? [{
      pay_date: 0,
      total: 0
    }] : data.year;

    const dayToChartData = days => {
      return days.map(day => {
        return {
          x: day.pay_date,
          y: day.total
        }
      });
    };

    const monthToChartData = dValues => {
      return dValues.map(day => {
        var day_name = '' + current_year + '-' + current_month + '-' + day + ''
        var value = 0
        month.map(val => {
          var dateObject = new Date(val.pay_date);
          var day_val = dateObject.getDate();
          if (day_val == day)
            value = val.total;
        })
        return {
          x: day_name,
          y: value
        }
      });
    };

    const yearToChartData = xValues => {
      return xValues.map(xV => {
        var last_date = new Date(current_year, xValues.indexOf(xV) + 1, 0).getDate()
        var month = '' + current_year + '-' + xV + '-' + last_date;
        var value = 0
        year.map(val => {
          var dateObject = new Date(val.pay_date);
          var mon_val = dateObject.getMonth() + 1;
          if (mon_val == xValues.indexOf(xV) + 1)
            value = val.total;
        })
        return {
          x: month,
          y: value
        }
      });
    };

    function footer(tooltipItems) {
      let footerText = "";

      if (tooltipItems.length > 0) {
        const firstItem = tooltipItems[0];
        const datasetIndex = firstItem.datasetIndex;

        // Customize footer based on dataset index
        switch (datasetIndex) {
          case 0:
            footerText = "Time: " + firstItem.label;
            break;
          case 1:
            footerText = "Day: " + firstItem.label;
            break;
          case 2:
            footerText = "Month: " + firstItem.label;
            break;
          default:
            break;
        }
      }

      return footerText;
    }

    var myChart = new Chart("salesChart", {
      type: "line",
      data: {
        responsive: true,
        maintainAspectRatio: false,
        labels: [],
        datasets: [{
            label: "Day",
            fill: false,
            backgroundColor: "rgb(54, 162, 235, 0.5)",
            borderColor: "rgb(54, 162, 235)",
            data: dayToChartData(days),
            pointStyle: 'rectRot',
            pointRadius: 6,
            hidden: true
          },
          {
            label: "Month",
            fill: false,
            backgroundColor: "rgb(255, 99, 132, 0.5)",
            borderColor: "#f33e6f",
            data: monthToChartData(dValues),
            type: 'bar',
            pointStyle: 'rectRot',
            pointRadius: 6,
            hidden: false
          },
          {
            label: "Year",
            fill: false,
            backgroundColor: "rgb(62 , 191 , 190, 0.5)",
            borderColor: "rgb(62 , 191 , 190)",
            data: yearToChartData(xValues),
            type: 'line',
            pointStyle: 'rectRot',
            pointRadius: 6,
            hidden: false
          }
        ]
      },
      options: {
        plugins: {
          title: {
            display: false
          },
          tooltip: {
            usePointStyle: true,
            callbacks: {
              label: function(context) {
                let label = context.dataset.label || '';
                if (label) {
                  label += ': ';
                }
                return context.label = 'QAR ' + context.formattedValue;
              }
            }
          },
          legend: {
            onClick: function(e, legendItem) {
              const index = legendItem.datasetIndex;

              if (index == 0 && myChart.data.datasets[0].hidden == false) {
                myChart.data.datasets[0].hidden = true
                myChart.data.datasets[1].hidden = false
                myChart.data.datasets[2].hidden = false
              } else if (index == 0 && myChart.data.datasets[0].hidden == true) {
                myChart.data.datasets[0].hidden = false
                myChart.data.datasets[1].hidden = true
                myChart.data.datasets[2].hidden = true
              }

              myChart.data.datasets.forEach((dataset, i) => {

                if (index > 0) {
                  dataset.hidden = i !== index;
                }

              });

              myChart.update();
            }
          }
        },
        interaction: {
          mode: 'point',
        },
        scales: {
          x: {
            type: 'time',
            title: {
              display: true,
              text: 'Date'
            }
          },
          y: {
            title: {
              display: true,
              text: 'value'
            }
          }
        }
      }
    });

    $('#total_sales').text();

    $('#salesChartContent').remove();
  }


  function getAppoinments(type) {
    $.ajax({
      url: '<?= base_url('index.php/admin/Dashboard/DashboardController/getAppoinments') ?>',
      type: 'POST',
      contentType: 'application/json',
      data: JSON.stringify({
        type: type
      }),
      success: function(response) {
        console.log('Response:', response);
        $('#appoinment_count').text(response.avialable_confirmed_appoinment);
      },
      error: function(error) {
        console.error('Error:', error);
      }
    });
  }

  $(document).ready(function() {
    // Initialize the DataTable
    var dataTable = $('#price_list').DataTable({
      'ajax': {
        'url': '<?= site_url('admin/Dashboard/DashboardController/insurancePriceList'); ?>',
        'type': 'GET',
        'data': function(d) {
          d.insurance = $('#insurance_filter').val();
        }
      },
      'columns': [{
          'data': 'treatment_id',
          'title': 'Treatment ID'
        },
        {
          'data': 'insurance_name',
          'title': 'Insurance'
        },
        {
          'data': 'treatment_name',
          'title': 'Treatment'
        },
        {
          'data': 'lqdc_gross',
          'title': 'Price'
        }
      ],
      'serverSide': true,
      'pageLength': 15,
      'lengthMenu': [15],
      'pagingType': 'full_numbers'
    });

    var priceTable = $('#price_list_company').DataTable({
      'ajax': {
        'url': '<?= site_url('admin/Dashboard/DashboardController/CompanyPriceList'); ?>',
        'type': 'GET',
        'data': function(d) {
          d.company = $('#company_filter').val();
          d.insurance = 1;
        }
      },
      'columns': [{
          'data': 'treatment_id',
          'title': 'Treatment ID'
        },
        {
          'data': 'insurance_name',
          'title': 'Insurance'
        },
        {
          'data': 'treatment_name',
          'title': 'Treatment'
        },
        {
          'data': 'lqdc_gross',
          'title': 'Price'
        }
      ],
      'serverSide': true,
      'pageLength': 15,
      'lengthMenu': [15],
      'pagingType': 'full_numbers',
      // "columnDefs": [
      //   { "width": "10%", "targets": 0 }, // Set width for the first column to 20%
      //   { "width": "10%", "targets": 1 },
      //   { "width": "10%", "targets": 2 },
      //   { "width": "10%", "targets": 3 },
      // ]
      'autoWidth': true
    });

    $('#insurance_filter').on('change', function() {
      dataTable.ajax.reload();
    });

    $('#company_filter').on('change', function() {
      priceTable.ajax.reload();
    });
  });

  var donutChart = '';

  function receptionistReceivedChart(data, param) {
    let donutChartCanvas_ele = $('#donutChart').get(0).getContext('2d');
    let time = $('#timeRangePayments').val()
    let donutChartCanvas = $('#donutChart').get(0).getContext('2d');
    var keysWithoutColour = [];
    var keysWithColour = [];
    var keysWithPayment = [];

    $.each(data[time], function(key, value) {
      if (key.endsWith("_colour")) {
        keysWithColour.push(value);
      } else {
        keysWithoutColour.push(key);
        keysWithPayment.push(value)
      }
    });

    let donutData = {
      labels: keysWithoutColour,
      datasets: [{
        data: keysWithPayment,
        backgroundColor: keysWithColour,
        beginAtZero: true
      }]
    };
    let donutOptions = {
      maintainAspectRatio: false,
      responsive: true,
      plugins: {
        legend: {
          position: 'left'
        }
      }
    };

    if (donutChart != '') {
      donutChart.destroy();
    }
    const sum = keysWithPayment.reduce((accumulator, currentValue) => accumulator + parseFloat(currentValue), 0);

    if (sum > 0) {
      $('#donutChart').parent().find('div').html('');
      donutChart = new Chart(donutChartCanvas, {
        type: 'pie',
        data: donutData,
        options: donutOptions,
      });
    } else {
      $('#donutChart').parent().find('div').html('<p id="tretno" style="text-align: center; color: #888; font-size: 16px;position: absolute;right: 40%;top: 40%;">No data available</p>')
    }

    $('#l_receptionist_received').remove();
  }

  var donutChartTreatment = '';

  function generateTreatments(params) {
    let donutChartCanvas = $('#donutChart_treatment').get(0).getContext('2d');
    var keysWithoutColour = [];
    var keysWithColour = ['#f33e6f', '#3ebfbe', '#9353f9', '#ff9100', '#4d5361'];
    var keysWithPayment = [];

    $.each(params, function(key, value) {
      keysWithoutColour.push(value.treatment_name);
      keysWithPayment.push(value.count)
    });

    if (donutChartTreatment != '') {
      donutChartTreatment.destroy();
    }


    let donutData = {
      labels: keysWithoutColour,
      datasets: [{
        data: keysWithPayment,
        backgroundColor: keysWithColour,
      }]
    };
    let donutOptions = {
      maintainAspectRatio: false,
      responsive: true,
      plugins: {
        legend: {
          position: 'left',
          labels: {
            font: {
              size: 15
            }
          }
        }
      }
    };

    if (params.length > 0) {
      $('#donutChart_treatment').parent().find('div').html('');
      donutChartTreatment = new Chart(donutChartCanvas, {
        type: 'polarArea',
        data: donutData,
        options: donutOptions,

      });
    } else {
      $('#donutChart_treatment').parent().find('div').html('<p id="tretno" style="text-align: center; color: #888; font-size: 16px;position: absolute;right: 40%;top: 40%;">No data available</p>')
    }


    $('#l_receptionist_received_treatment').remove();
  }

  var donutChartPatient = '';

  function generatePatients(params) {
    let donutChartCanvas = $('#donutChart_balances').get(0).getContext('2d');
    var keysWithoutColour = [];
    var keysWithColour = ['#f33e6f', '#3ebfbe', '#9353f9', '#ff9100', '#4d5361'];
    var keysWithPayment = [];


    if (donutChartPatient != '') {
      donutChartPatient.destroy();
    }

    $.each(params, function(key, value) {
      keysWithoutColour.push(value.patient_name);
      keysWithPayment.push(value.count)
    });

    let donutData = {
      labels: keysWithoutColour,
      datasets: [{
        data: keysWithPayment,
        backgroundColor: keysWithColour,
      }]
    };
    let donutOptions = {
      maintainAspectRatio: false,
      responsive: true,
      plugins: {
        legend: {
          position: 'left',
          labels: {
            font: {
              size: 15
            }
          }
        }
      }
    };

    if (params.length > 0) {
      $('#donutChart_balances').parent().find('div').html('');
      donutChartPatient = new Chart(donutChartCanvas, {
        type: 'polarArea',
        data: donutData,
        options: donutOptions,

      });
    } else {
      $('#donutChart_balances').parent().find('div').html('<p id="tretno" style="text-align: center; color: #888; font-size: 16px;position: absolute;right: 40%;top: 40%;">No data available</p>')
    }

    $('#l_receptionist_received_balances').remove();
  }


  $('#timeRangeTop').on('change', function(e) {

    let period = $(this).val();
    $.ajax({
      url: '<?= base_url('index.php/admin/Dashboard/DashboardController/getTreatPatients') ?>',
      type: 'GET',
      contentType: 'application/json',
      data: {
        period: period
      },
      success: function(response) {
        generateTreatments(response.treatment)
        generatePatients(response.patients)
      },
      error: function(error) {}
    });
  })





  function doctorPerformance(data) {
    let table = $('#doctorPerformance');
    let rows = ``;

    Array.from(data).forEach((doctor, index) => {
      console.log(doctor);
      rows += `<tr>
        <td class='text-right'>${index+1}</td>
        <td>${doctor.full_name}</td>
        <td class='text-right'>${Number(doctor.total)-Number(doctor.discount)} QAR</td>
      </tr>`;
    });

    table.append(rows);

  }




  function countSalesBalance(params, balance) {

    let range = $('#timeRange').val()
    let salesData;
    let balanceData;
    switch (range) {
      case '1':
        salesData = params.today == null ? [] : params.today;
        balanceData = balance.today == null ? [] : balance.today;
        break;
      case '2':
        salesData = params.week == null ? [] : params.week;
        balanceData = balance.week == null ? [] : balance.week;
        break;
      case '3':
        salesData = params.month == null ? [] : params.month;
        balanceData = balance.month == null ? [] : balance.month;
        break;
      case '4':
        salesData = params.year == null ? [] : params.year;
        balanceData = balance.year == null ? [] : balance.year;
        break;
      default:
        salesData = [];
        balanceData = [];
    }

    let totalSalesAmount = 0;
    for (let i = 0; i < salesData.length; i++) {
      totalSalesAmount += parseFloat(salesData[i].total);
    }

    let totalBalanceAmount = 0;
    for (let i = 0; i < balanceData.length; i++) {
      totalBalanceAmount += parseFloat(balanceData[i].total);
    };

    let total_sales = new CountUp('total_sales', 0, Number(totalSalesAmount), 2, 1);
    total_sales.start();
    let total_balance = new CountUp('total_balance', 0, Number(totalBalanceAmount), 2, 1);
    total_balance.start();
  }

  $('#timeRange').on('change', function(e) {
    countSalesBalance(fetchData.totalSales, fetchData.totalBalance)
  })

  $('#timeRangePayments').on('change', function(e) {
    receptionistReceivedChart(fetchData.receptionist_received, $(this).val())
  })


  $('.changePriceList').click(function(e) {
    // let enableList =  $(this).attr('data-enable');
    // let disableList =  $(this).attr('data-disable');
    // $('#'+disableList).addClass('hide');
    // $('#'+enableList).removeClass('hide');

    e.preventDefault(); // Prevent default link behavior
    let enableList = $(this).attr('data-enable');
    let disableList = $(this).attr('data-disable');

    // Add flip-out animation to the currently visible list
    $('#' + disableList).addClass('flip-out');

    // After a short delay, toggle classes to show the new list with flip-in animation
    setTimeout(function() {
      $('#' + disableList).addClass('hide').removeClass('flip-out');
      $('#' + enableList).removeClass('hide').addClass('flip-in');
    }, 300); // Adjust the delay time as needed
  })
</script>