<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.13.1/css/all.min.css" integrity="sha256-2XFplPlrFClt0bIdPgpz8H7ojnk10H69xRqd9+uTShA=" crossorigin="anonymous" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" crossorigin="anonymous">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200..1000&family=Noto+Naskh+Arabic:wght@400..700&display=swap" rel="stylesheet">



    <style>
        .spinner {
            font-size: 10px;
            width: 17px;
            height: 17px;
        }

        .custom-card {
            border: 1px solid rgb(0 0 0 / 18%);
            padding: 10px;
            height: auto;
            display: flex;
        }

        .arabic {
            font-family: "Cairo", sans-serif;
            font-weight: 700;
        }

        .btn-light {
            border-color: #c3c3c3 !important;
        }

        @media print {
            .container {
                max-width: 100%;
                width: 100% !important;
            }
        }

        .label-text {
            display: flex;
            justify-content: flex-start;
            margin-bottom: 10px;
            position: relative;
        }

        .label-text h6 {
            margin: 0;
        }

        .label-text span {
            margin-left: 10px;
        }

        #placeHolder {

            right: 0;
        }

        .fa{
            font-size: 13px;
        }

        
    </style>
</head>

<body>
    <?php $invoice = (object)$invoiceData[0];
    $no = $treatment_payment_id;
    if ($view == 'receipt') {
        $no = $patient_payment_id;
    } else if ($view == 'advance') {
        $no = $advance_id;
    }

    ?>
    <div class="container" id="invoice">
        <div class="row">
            <div class="col-lg-12">
                <div class="custom-card">
                    <div class="card-body">
                        <div class="invoice-title">

                            <div class="mb-2">
                                <h2 class="mb-1 text-muted"></h2>
                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="text-muted">
                                        <p class="mb-1 fw-bold"><i class="fa fa-map-marker me-2 "></i><?= $company->address  ?></p>
                                        <p class="mb-1 fw-bold"><i class="fa fa-envelope me-2"></i><?= $company->email  ?></p>
                                        <p class="mb-1 fw-bold"><i class="fa fa-phone me-2 "></i><?= $company->mobile_no  ?></p>
                                    </div>
                                </div>
                                <div class="col-md-4 d-flex justify-content-center">
                                <img style="object-fit:contain" src="<?php echo base_url($company->logo); ?>" class="img-fluid" alt="User Image" />
                                </div>

                                <div class="col-md-4 align-items-right d-flex flex-column"><div>
                                    <h4 class="font-size-15" style="text-transform:uppercase;text-align:right"><?= $view . ' #' . $no ?>
                                        <?php
                                         if($view == 'receipt'){
                                        if ($invoice->due_amount <= 0) { ?>
                                            <span class="badge bg-success font-size-12 ms-2">Paid</span>
                                        <?php  } else { ?>
                                            <span class="badge bg-warning font-size-12 ms-2">Pending</span>
                                        <?php }} ?>
                                    </h4></div>
                                    <?php if ($view != 'advance') { ?><div class="d-flex justify-content-end ">
                                        <img class="" src="<?= base_url('admin/Invoice/InvoiceController/generate_barcode/' . $no) ?>" alt="Barcode for Invoice #">
                                        </div><?php } ?>
                                </div>
                            </div>


                        </div>

                        <hr class="my-2">

                        <div class="row">

                            <!-- end col -->
                            <!-- end row -->
                            <!-- //invoice details -->

                            <?php
                            if ($view == 'invoice') {
                                $this->view('admin/Invoice/Templates/summary.php');
                            } else if ($view == 'lab') {
                                $this->view('admin/Invoice/Templates/summaryLab.php');
                            } else if ($view == 'receipt') {
                                $this->view('admin/Invoice/Templates/summaryReceipt.php');
                            } else if ($view == 'advance') {
                                $this->view('admin/Invoice/Templates/summaryAdvance.php');
                            } else if ($view == 'refund') {
                                $this->view('admin/Invoice/Templates/summaryRefund.php');
                            }


                            ?>

                            <!-- //Invoice detials ends -->


                        </div>
                    </div>
                </div>
            </div><!-- end col -->
        </div>
    </div>
    <div class="container">
        <div class="row">

            <div class="d-print-none mt-4">
                <div class="float-end">
                    <a onclick="window.print()" class="btn btn-light me-1"><i class="fa fa-print me-1"></i>Print</a>
                    <?php if(is_whatsapp($this) == 1) { ?>
                        <a href="#" class="btn btn-light " id="btn-whatsapp"><i class="fab fa-whatsapp me-1"></i> Whatsapp <i class="spinner spinner-border whatsapp-loader" id="whatsapp-loader" style="display:none"></i></a>
                    <?php } ?>
                    <a href="javascript:void(0)" class="btn btn-light btn-download " id="btn-download"><i class="fa fa-download me-1"></i> Download <i class="spinner spinner-border pdf-loader" id="pdf-loader" style="display:none"></i></a>
                </div>
            </div>
        </div>
    </div>

    <script src="<?php echo base_url('js/qrcode.js')  ?>"></script>
    <script src="<?php echo base_url('js/pdf/jspdf.debug.js')  ?> "></script>
    <script src="<?php echo base_url('js/pdf/html2canvas.min.js')  ?>"></script>
    <script src="<?php echo base_url('js/pdf/html2pdf.min.js')  ?> "></script>
    <script>
        var data = "<?php echo $invoice->patient_name  . $invoice->patient_id ?>";

        var typeNumber = 5;
        var errorCorrectionLevel = 'L';
        var qr = qrcode(typeNumber, errorCorrectionLevel);
        qr.addData(data);
        qr.make();
        document.getElementById('placeHolder').innerHTML = qr.createImgTag();
    </script>
    <script>
        const options = {
            margin: 0.5,
            filename: 'invoice.pdf',
            image: {
                type: 'jpeg',
                quality: 500
            },
            html2canvas: {
                scale: 1
            },
            jsPDF: {
                unit: 'in',
                format: 'letter',
                orientation: 'landscape'
            }
        }

        document.getElementById('btn-download').addEventListener('click', function(e) {
            document.getElementById('pdf-loader').style.display = "inline-block";
            e.preventDefault();
            const element = document.getElementById('invoice');
            html2pdf().from(element).set(options).save().then(function() {
                document.getElementById('pdf-loader').style.display = "none";
            });

        });


        function printDiv(divName) {
            var printContents = document.getElementById(divName).innerHTML;
            var originalContents = document.body.innerHTML;

            document.body.innerHTML = printContents;

            window.print();

            document.body.innerHTML = originalContents;
        }
    </script>

    <script>
        var base_url = "<?php echo base_url() ?>";
        const options2 = {
            margin: 0.5,
            filename: 'invoice.pdf',
            image: {
                type: 'jpeg',
                quality: 0.98
            },
            html2canvas: {
                scale: 1
            },
            jsPDF: {
                unit: 'in',
                format: 'letter',
                orientation: 'portrait'
            }
        };

        document.getElementById('btn-whatsapp').addEventListener('click', function(e) {
            e.preventDefault();
            document.getElementById('whatsapp-loader').style.display = "inline-block";
            const element = document.getElementById('invoice');
            html2pdf().from(element).set(options2).outputPdf('blob').then(function(blob) {
                const formData = new FormData();
                formData.append('file', blob, 'invoice.pdf');
                formData.append('id', "<?php echo $no; ?>");
                fetch(base_url + 'admin/Invoice/InvoiceController/send_whatsapp_pdf', {
                    method: 'POST',
                    body: formData
                }).then(response => response.json()).then(data => {
                    alert(data.message);
                    document.getElementById('whatsapp-loader').style.display = "none";
                }).catch(error => {
                    console.error('Error:', error);
                    document.getElementById('whatsapp-loader').style.display = "none";
                });
            });
        });
    </script>
</body>

</html>