<div class="row">
            <div class="col-md-12">
              <div class="panel panel-info">
                <div class="panel-heading">
                  <h4 class="panel-title">All Requests</h4>
                </div>
                <form  method="post" id="allRequest">
                  <div class="panel-body">
                    <div class="row">
                      <div class="col-md-4">
                        <div class="form-group">
                          <label>Enter File No / QID</label>
                            <input type="number" name="file_no" class="form-control" id="file_no">
                        </div>
						</div>
						<div class="col-md-4">
                        <div class="form-group">
                          <label class="from" for="from">From</label>
                          <label class="date" for="date">Date</label>
                          <input type="date" class="form-control" name="from" id="from">
                        </div>
							</div>
						<div class="col-md-4">
                        <div class="form-group">
                          <label for="to">To</label>
                          <input type="date" class="form-control" name="to" id="to">
                        </div>
						</div>
                     
                    </div>
                    <a  class="btn btn-light cursor-pointer text-dark  hidden-print" id="generate_requests">Generate</a>
                    <button type="reset" class="btn btn-light  hidden-print" id="clear">Clear</button>
                  </div>
                </form>
              </div>
            </div>

</div>
<div class="row mt-5" >
    <div class="col-md-12 mx-auto">
        <table id="requests" class="table table-light table-bordered table-striped">
                        
        </table>
        </div>
</div>

<script>

     $(document).ready(function() {
		// Initialize the DataTable
        var base_url ="<?php echo base_url() ?>";
		dataTable = $('#requests').DataTable({
			dom: 'lBfrtip',
			buttons: [{
				extend: 'excel',
				title: `All Requests`
			}, {
				extend: 'print',
				autoPrint: true,
				title: `All Requests`,
				exportOptions: {
					columns: ':not(:last-child)'
				},
				customize: function(win) {
					$(win.document.body).prepend(`<?php print_header($this); ?>`);
				}
			}, ],
			'ajax': {
				'url': '<?= site_url('admin/Lab/LabController/get_all_requests'); ?>',
				'type': 'POST',
				'data': function(d) {
					d.file_no = $('#file_no').val();
					d.from = $('#from').val();
					d.to = $('#to').val();
					d.type = 1;
				}
			},
			'columns': [
				
				{
					'data': 'id',
					'title': 'Case No'
				},
				{
					'data': 'patient_name',
					'title': 'Patient Name.'
				},
				{
					'data': 'patient_id',
					'title': 'File Number.'
				},

				{
					'data': 'qatar_id',
					'title': 'Qatar ID.'
				},
				{
					'data': 'created_at',
					'title': 'Date'
				},
				{
					'data': 'refferedby',
					'title': 'Reffered By'
				},
				{
					'data': 'createdby',
					'title': 'Created By'
				},
                {
            'data': 'status',
            'title': 'Status',
            'render': function(data, type, row, meta) {
                if(row.type==1){
                    return '<span class="badge badge-primary">New Request</span>';
                }else{
                    return '<span class="badge badge-success">Completed</span>';
                }
               
            }
        },
        {
            'data': '',
            'title': 'Action',
            'render': function(data, type, row, meta) {
               
                    return '<a  data-id="'+row.id+'" data-patient="'+row.patient_id+'" class="btn btn-light btn-sm mr-2 make_case"><i class="fa fa-file"> </i> Make Case</a>';
                
               
            }
        },
				
				
			],
			'searching': false,
			'serverSide': true,
			'pageLength': 10,
			aLengthMenu: [
				[25, 50, 100, 200, -1],
				[25, 50, 100, 200, "All"]
			],
			'pagingType': 'full_numbers',
			footer:true,
			autoWidth: false

		});



		$('#generate_requests').on('click', function() {
			dataTable.ajax.reload();
		});
        
        $('#clear').on('click', function() {
            $('#allRequest').trigger("reset");
			dataTable.ajax.reload();
		});
	});


</script>