<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>Patient</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <?php require_once(APPPATH . "views/admin/header.php"); ?>

</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->

    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                &nbsp;Edit Treatment
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>

        <!-- Main content -->
        <section class="content">

            <div class="row mb-2 no-print">
                <div class="col-md-12">
                    <div class="box margin-bottom-5px" style="border: none;">
                        <div class="box-body">
                            <div class="d-flex justify-content-start">
                                <a href="<?php echo base_url('index.php/admin/Patients/PatientsController/medical_book/') . encrypt_and_url_encode(trim($patient_id), $this );?>" class="btn btn-dark btn-sm">
                                    <i class="fa fa-chevron-circle-left" aria-hidden="true"></i> Go Back
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php print_header($this); ?>

            <div class="row">
                <div class="col-md-12">
                    <div class="box margin-bottom-5px" style="border: none;">
                        <div class="box-body">

                            <div class="">
                                <form role="form" action="<?php echo site_url('admin/Modules/GeneralMedicine/GeneralMedicineController/update'); ?>" method="post" enctype="multipart/form-data">
                                    <div class="row no-print">
                                        <div class="col-md-12 col-12">
                                            <input type="hidden" name="attendance" value="1">
                                            

                                            <?php
                                            date_default_timezone_set('Asia/Kuwait');
                                            $date_string = '%Y-%m-%d';
                                            $curr_date = mdate($date_string);
                                            ?>
                                            <input type="hidden" class="form-control" name="treatment_date" id="treatment_date" value=<?php echo $curr_date; ?>>
                                            <input type="hidden" class="form-control" name="patient_id" id="patient_id" value="<?php echo encrypt_and_url_encode(trim($patient_id),$this) ?>">
                                            <input type="hidden" class="form-control" name="treatement_payment_id" id="treatement_payment_id" value="<?php echo $invoice->treatement_payment_id; ?>">
                                            <input type="hidden" class="form-control" style="z-index: 0 !important;" name="treatment_time" id="treatment_time" class="diag-time" value="<?php echo date('H:s'); ?>">
                                            

    <!-- //Other Field -->
    <input type="hidden" class="form-control" name="patient_id" id="patient_id" value="<?php echo  encrypt_and_url_encode( trim($patient_id),$this);?>">
        <div class="row">
        <div class="form-group col-md-6">
            <label>Chief Complaint (in the patient's own words):</label>
            <textarea class="form-control" name="cheif_compalin" rows="2"><?= trim($general->cheif_compalin );?></textarea>
        </div>

        <div class="form-group col-md-6">
                    <label for="clinical_finding">Clinical Examination and finding</label>
                    <textarea class="form-control" name="clinical_finding" id="clinical_finding" rows="3"><?= trim($general->clinical_finding );?></textarea>
                </div>

       
        </div>
        <div class="form-group mt-2">
                    <label for="diagnosis_auto">Enter Diagnosis<span class="text-red" aria-hidden="true">*</span></label>
                    <span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                    <input type="text" class="multi_diagnosis" name="diagnosis_dental"  placeholder="Enter Diagnosis..." id="diagnosis_dental">
                    <!-- <input  class="multi_diagnosis_free form-control" data-department="1" placeholder="Enter Diagnosis" name="multi_diagnosis_free"> -->
                </div>
        <div class="form-group mt-2">
                    <label for="diagnosis_auto">Select Procedure<span class="text-red" aria-hidden="true">*</span></label>
                    <span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                    <select id="procedure" class="procedure" data-department="15" placeholder="Select a procedure..." name="procedure"></select>
                </div>


        <div class="row">
            <div class="col-md-10">
                <button type="button" class="btn btn-sm btn-dark" id="addRow">
                    <i class="fa fa-plus-circle" aria-hidden="true"></i> Add</button>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <hr style="border-top:1px solid #ddd !important">
            </div>
        </div>

        <div class="row">
            <div class="col-md-12 col-12">
                <div class="panel panel-primary">
                    <div class="panel-heading">
                        <h5>Treatment List</h5>
                    </div>
                    <table class="table table-hover display table-striped w-100" id="treatemnts">
                        <thead>
                            <tr>
                                <th>No</th>
                              
                                <th>Treatments</th>
                               
                                <th>Discount(QR)</th>
                                <th>Discount(%)</th>
                                <th>Fees</th>
                                <th class="text-center">Actions</th>
                            </tr>
                        </thead>
                     
                        <tbody>
                                                        <?php $i = 0;
                                                        $arr = [];
                                                        foreach ($episodes as $key => $value) {
                                                            $i++;

                                                            $arr = array_merge($arr, explode(";", $value['full_tooth']));
                                                        ?>
                                                            <tr class="odd">
                                                                <td class="sorting_1"><?= $i ?></td>
                                                          
                                                                <td>
                                                                    <?= $value['treatment_name'] ?>
                                                                    <input type="hidden" name="treat_procedure[]" value="<?= $value['procedure_id'] ?>">
                                                                    <input type="hidden" value="" name="treat_extra[]">
                                                                </td>
                                                               
                                                               
                                                                <td>
                                                                    <input type="hidden" class="orgi" name="orig_price[]" value="<?= $value['orig_price'] ?>">
                                                                    <input type="text" size="7" name="discount[]" value="<?= $value['discount_qr'] ?>" class="discount form-control">
                                                                </td>
                                                                <td>
                                                                    <input type="text" size="7" name="discount_per[]" value="<?= $value['discount_per'] ?>" class="discount_per form-control">
                                                                </td>
                                                                <td>
                                                                    <input type="text" size="7" value="<?= $value['fees'] ?>" name="treat_fees[]" class="teeth_price form-control">
                                                                </td>
                                                                <td class="sorting_1 text-center">
                                                                    <button type="button" class="btn btn-light deleteRow">
                                                                        <i class="fa fa-trash"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                       <?php } ?>
                                                    </tbody>
                        
                    </table>
                </div>
            </div>
        </div>

        <div class="form-group">
                    <label for="condition">Treatment Type</label><br>
                    <div class="followup_div">

                        <label class="radio-inline">
                            <input type="radio" required name="followup" checked id="followup_0" value="0" class="jq_followup"> New Treatment
                        </label>
                        <br>
                        <label class="radio-inline">
                            <input type="radio" required name="followup" id="followup_1" value="1" class="jq_followup"> FOC <small>(Free of Charge)</small>
                        </label>
                        <br>
                        <?php if($is_package==1){
                            $desired_module_id=1;
                            include(APPPATH . "views/admin/Modules/packages.php");
                             
                             } ?>
                                

                            
                    </div>
                </div>

                <button type="submit" class="btn btn-sm btn-light" id="private_submit"><i class="fa fa-check-circle" aria-hidden="true"></i> Update</button>
        </section>
    </div>
    <?php require_once(APPPATH . "views/admin/footer.php"); ?>


</body>


<script>

var multiDiagnosisSelect = undefined
initTomSelectDiagnosis('.multi_diagnosis', '15');
function initTomSelectDiagnosis(selector, departmentId) {
    multiDiagnosisSelect = new TomSelect(selector, {
        valueField: 'id',
        labelField: 'name',
        searchField: 'name',
        persist: false,
        createOnBlur: false,
        create: true,
        // Set the "load" property to define the function to fetch data dynamically
        load: function(query, callback) {
            var apiUrl = "<?php echo site_url('admin/CommenController/get_diagnosis?'); ?>t=" + departmentId + "&q=" + encodeURIComponent(query);

            fetch(apiUrl)
                .then(response => response.json())
                .then(data => {
                    callback(data);
                })
                .catch(() => {
                    callback();
                });
        },
        render: {
            option: function(item, escape) {
                return '<div>' +
                    '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                    '</div>';
            },
            item: function(item, escape) {
                return '<div>' +
                    '<span class="btn  btn-sm">' + escape(item.name) + '</span>' +
                    '</div>';
            }
        },
    });

    // Optional: You can also set a minimum number of characters before triggering the API call
    multiDiagnosisSelect.settings.minLength = 2;
}
    var default_tooth_color = '#ffffffff'
    var selected_tooths = {};
    var counter = <?= count($episodes) + 1; ?>;
    var multiDiagnosisSelect;
    var initTomSelecs;

    // const tooth_sections = ['O', 'B', 'M', 'D', 'L', 'I', 'F', 'P', 'ROOT', 'SURFACE', 'SURFACE2'];
    const tooth_sections = ['O', 'B', 'M', 'D', 'L', 'I', 'F', 'P'];

    function select_tooth(element) {

        let [treatment_color, treatment_name, full_tooth] = Cookies.get('dcolor').split('|');
        let tooth_id = element.id;
        let tooth_num = tooth_id.split('-')[0];
        full_tooth = parseInt(full_tooth);

        if (full_tooth) {
            for (const tooth_section of tooth_sections) {

                const tooth_section_id = `${tooth_num}-${tooth_section}`;
                const tooth_section_element = document.getElementById(tooth_section_id)

                if (!tooth_section_element) continue;

                tooth_section_element.querySelectorAll('path').forEach(path => path.style.fill = treatment_color);
                selected_tooths[tooth_section_id] = tooth_section_id + "|" + treatment_color + "|" + treatment_name;
            }
        } else {
            element.querySelectorAll('path').forEach(path => path.style.fill = treatment_color);
            selected_tooths[tooth_id] = tooth_id + "|" + treatment_color + "|" + treatment_name;
        }

        console.clear();
        console.log(selected_tooths, Object.keys(selected_tooths).length);
        draw_list();
    }

    function unselect_tooth(element) {
        let paths = element.querySelectorAll('path');
        paths.forEach(path => {
            path.style.fill = default_tooth_color;
        });

        delete selected_tooths[element.id];

        console.clear();
        console.log(selected_tooths, Object.keys(selected_tooths).length);
        draw_list();
    }

    function add_treatment() {
        console.log('Function triggered success..')
        let split_procedure = document.querySelector('select[name=procedure]').value.split(' | ');
     

        let fprice = split_procedure[3];

        dataTable.row.add([
            counter,
         
            split_procedure[2] + '<input type="hidden" name="treat_procedure[]" value="' + split_procedure[0] + '"><input type="hidden" value="" name="treat_extra[]">',
         
            // '<input type="checkbox" name="composit[]" value="composit" />',
        
            '<input type="hidden" class="orgi" name="orig_price[]" value="' + fprice + '"><input type="text" size="7" name="discount[]" value="0" class="form-control discount w-50">',
            '<input type="text" size="7" name="discount_per[]" value="0" class="form-control discount_per w-50">',
            '<input type="text" size="7" value="' + fprice + '" name="treat_fees[]"   class="form-control teeth_price ">',
            '<td class="sorting_1"><div class="text-center"><button type="button" class="btn btn-light deleteRow"><i class="fa fa-trash"></i></button></div></td>',
        ]).draw();

        counter++;
      
        initTomSelecs.clear();

        // Clear selected tooth object
      
    }

   
    $(document).on('click','#addRow',function(){
                add_treatment();
            });
    
</script>

<script>
    $(document).ready(function() {
        var procedureElements = document.querySelectorAll('.procedure');

        var procedureCount = procedureElements.length;

        for (var i = 0; i < procedureCount; i++) {
            var currentElement = procedureElements[i];
            var departmentId = currentElement.getAttribute('data-department');
            initTomSelectProcedres(currentElement, departmentId);
        }

       

      

    });

    var dataTable = $('#treatemnts').DataTable({
        "bFilter": false,
        "paging": false,
        "info": false
    });

    function initTomSelectProcedres(selector, departmentId) {
        initTomSelecs = new TomSelect(selector, {
            valueField: 'id',
            labelField: 'name',
            searchField: 'name',
            load: function(query, callback) {
                var apiUrl = "<?php echo site_url('admin/CommenController/get_procedures?p=');
                                echo trim($patient_id . '&' );?>t=" + departmentId + "&q=" + encodeURIComponent(query);

                fetch(apiUrl)
                    .then(response => response.json())
                    .then(data => {
                        callback(data);
                    })
                    .catch(() => {
                        callback();
                    });
            },
            render: {
                option: function(item, escape) {
                    return '<div>' +
                        '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                },
                item: function(item, escape) {
                    return '<div>' +
                        '<span class="btn  btn-sm">' + escape(item.name) + '</span>' +
                        '</div>';
                }
            },
        });

        initTomSelecs.settings.minLength = 2;
    }

  

   


    $('body').on('keyup', '.discount', function() {
        this_td = $(this).closest('td'),
            orig_price = $(this).prev('input').val(),
            dis_per_td = this_td.next('td');
        discount_per = $(dis_per_td).find('input').val(),
            fees_td = dis_per_td.next('td');
        fees = $(fees_td).find('input').val(),
            discount = Number($(this).val()).toFixed(2);

        dis_per_td.find('input').val(Number((discount * 100 / orig_price))); //discount_per
        fees_td.find('input').val(Number(orig_price - discount).toFixed(2)); //fees
    });

    $('body').on('keyup', '.discount_per', function() {
        this_td = $(this).closest('td'),
            dis_td = this_td.prev('td'),
            orig_price = $(dis_td).find('input').val(),
            discount = $(dis_td).find('input').next().val(),
            fees_td = this_td.next('td');
        fees = $(fees_td).find('input').val(),
            discount_per = Number($(this).val()).toFixed(2);

        dis_td.find('input').next().val(Number((discount_per * orig_price) / 100).toFixed(2)); //discount
        fees_td.find('input').val(Number(orig_price - (discount_per * orig_price / 100)).toFixed(2));
    });

    $('body').on('keyup', '.teeth_price', function() {
        this_td = $(this).closest('td'),
            dis_per_td = this_td.prev('td');
        discount_per = $(dis_per_td).find('input').val(),
            dis_td = dis_per_td.prev('td'),
            orig_price = $(dis_td).find('input').val(),
            discount = $(dis_td).find('input').next().val(),
            fees = Number($(this).val()).toFixed(2);

        dis_td.find('input').next().val(Number(orig_price - fees).toFixed(2)); //discount
        dis_per_td.find('input').val(Number((1 - (fees / orig_price)) * 100).toFixed(2)); //discount_per
        // dis_td.find('.orgi').val(fees);
    });

    $('body').on("click", ".deleteRow", function(e) {
        dataTable.row($(this).parents('tr')).remove().draw();
        return false;
    });

   

    
</script>

</html>