<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>Patient</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>

    <?php require_once(APPPATH . "views/admin/header.php"); ?>

</head>

<body class="<?php echo $this->config->item('theme'); ?> fixed">
    <!-- Site wrapper -->

    <!-- Header Navbar: style can be found in header.less -->
    <?php require_once(APPPATH . "views/admin/top_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Left side column. contains the sidebar -->
    <?php require_once(APPPATH . "views/admin/side_bar.php"); ?>

    <!-- =============================================== -->

    <!-- Right side column. Contains the navbar and content of the page -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                &nbsp;Edit Nutrition Treatment
            </h1>
            <?php require_once(APPPATH . "views/admin/breadcrumb.php"); ?>
        </section>


<div id="DentalForm" class="p-3 bg-white">
    <form role="form" action="<?php echo site_url('admin/Modules/Nutrition/NutritionController/save'); ?>" method="post" enctype="multipart/form-data">
        <div class="row">
            <div class="col-12">
                <h4>Edit Treatment</h4><br>
            </div>
        </div>
        <?php
    date_default_timezone_set('Asia/Kuwait');
    $date_string = '%Y-%m-%d';
    $curr_date = mdate($date_string);
    ?>
    <input type="hidden" class="form-control" name="treatment_date" id="treatment_date" value=<?php echo $curr_date; ?>>
    <input type="hidden" class="form-control" name="patient_id" id="patient_id" value="<?php echo encrypt_and_url_encode($patient_id, $this); ?>">
    <input type="hidden" class="form-control" style="z-index: 0 !important;" name="treatment_time" id="treatment_time" class="diag-time" value="<?php echo date('H:s'); ?>">
    <input type="hidden" class="form-control" name="treatment_payment_id" id="treatment_payment_id" class="diag-time" value="<?php echo $treatment_payment_id; ?>">

        <div class="row">
            <div class="col-md-6 col-6">
                <div class="form-group <?php echo (form_error('date') == '') ? '' : ' has-error'; ?>">
                    <label for="app_date">Treatment Date</label>
                    <input type="text" class="form-control select_date" name="treatment_date" id="treatment_date" value="<?php echo $curr_date; ?>">
                    <?php echo form_error('date', '<div style="color:red"><em>* ', '</em></div>'); ?>
                </div>
            </div>
            <div class="col-md-6 col-6">
                <div class="form-group <?php echo (form_error('date') == '') ? '' : ' has-error'; ?>">
                    <label for="app_date">Treatment Time</label>
                    <input type="time" class="form-control" name="treatment_time" id="treatment_time" value="<?php echo date("H:i"); ?>">
                    <?php echo form_error('date', '<div style="color:red"><em>* ', '</em></div>'); ?>
                </div>
            </div>
             <div class="col-md-12">
                <div class="form-group">
                    <label for="">Chief Complaint</label>
                    <textarea name="complain" class="form-control" id="" cols="30" rows="5"><?=$nutree->chief_complaint_general?></textarea>
                </div>
            </div>
             <div class="col-md-12">
                <div class="form-group">
                    <label for="">Subjective</label>
                    <textarea name="subjective" class="form-control" id="" cols="30" rows="5"><?=$nutree->subjective_general?></textarea>
                </div>
            </div>
             <div class="col-md-12">
                <div class="form-group">
                    <label for="">Objective</label>
                    <textarea name="objective" class="form-control" id="" cols="30" rows="5"><?=$nutree->objective_general?></textarea>
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label for="">Assessment & Plans</label>
                    <textarea name="assessment" class="form-control" id="" cols="30" rows="10"><?=$nutree->assessment_general?></textarea>
                </div>
            </div>
            <div class="col-12">
                 <div class="form-group">
                                        <label for="drugs">Select Diagnosis</label>
                                        <input type="text" class="multi_diagnosis" name="diagnosis_physiotherapy" id="diagnosis_physiotherapy">
                 </div>
            </div>
            <div class="col-12">
                <div class="form-group">
                    <label for="procedure">Select Procedure</label>
                    <select class="procedure" data-department="10" name="procedure_physio" id="procedure_physio">
                    </select>
                </div>
            </div>
            
            <div class="col-md-12">
           
            </div>

        </div>
            <div class="row mt-2">
            <div class="col-12">
                <div class="form-group">
                    <button type="button" class="btn btn-sm btn-dark" id="addRow_physio"><i class="fa fa-plus-circle"></i> Add</button>
                </div>
            </div>
        </div>

            <div class="row mt-2">
            <div class="col-12">
                <div class="panel panel-primary">
                    <div class="panel-heading">
                        <h5>
                            Procedure List
                        </h5>
                    </div>
                    <table class="table table-hover display table-striped w-100" id="treatemnts_physio">
                        <thead>
                            <tr>
                                <th>No</th>
                                <th>Diagnosis</th>
                              
                                <th>Procedure</th>
                                <th width="10%">Discount(QR)</th>
                                <th width="10%">Discount(%)</th>
                                <th>Fees</th>
                                <th class="text-center">Actions</th>
                            </tr>
                        </thead>
                        <?php
                                            foreach ($episodes as $index => $value1) {

                                                echo "<tr>
                                        <td>" . (++$index) . "</td>
                                        <td>" . $value1['aditional_diagnostise_name'] . "<input type='hidden' name='general_diagnosis_name[]' value='" . $value1['aditional_diagnostise_name'] . "'><input type='hidden' name='general_diagnosis_id[]' value='" . $value1['diagnostise_id'] . "'></td>

                                      

                                        <td>" . $value1['treatment_name'] . "<input type='hidden' name='general_treatment_name[]' value='" . $value1['treatment_name'] . "'><input type='hidden' name='general_treatment_id[]' value='" . $value1['treatment_id'] . "'></td>

                                        <td class='hidden-print'><span class='hide-input'><input type='hidden' size='7' name='orig_price_general[]' value='" . $value1['fees'] . "'><input type='text' size='7' name='discount_general[]' value='" . $value1['discount_qr'] . "' class='discount_general form-control'></span></td>

                                        <td class='hidden-print'><span class='hide-input'><input type='text' size='7' name='discount_per_general[]' value='" . $value1['discount_per'] . "' class='discount_per_general form-control'></span></td>

                                        <td class='hidden-print text-center'><span class='hide-input'><input type='text' size='7' name='fees_general[]' value='" . ($value1['fees'] - $value1['discount_qr']) . "' class='fees_general form-control'></span></td>
                                        <td class='hidden-print text-center'><button type='button' class='btn btn-light deleteRow_general'><i class='fa fa-trash' aria-hidden='true'></i></button></td>
                                        </tr>";
                                                $ctr++;
                                            }
                                            ?>
                    </table>
                </div>
            </div>
             <div class="col-md-12">
                <div class="form-group">
                    <label for="">Note</label>
                    <textarea name="note" class="form-control" id="" cols="30" rows="5"><?php echo $invoice->notes; ?></textarea>
                </div>
            </div>
        </div>

            <div class="col-md-12">
            <!-- <div class="form-group">
                    <label for="condition">Treatmen Type</label><br>
                    <div class="followup_div">

                        <label class="radio-inline">
                            <input type="radio" required name="followup" id="followup_0" value="0" class="jq_followup"> New Treatment
                        </label>
                        <br>
                        <label class="radio-inline">
                            <input type="radio" required name="followup" id="followup_1" value="1" class="jq_followup"> FOC
                        </label>
                        <br>
                        <?php if($is_package==1){
                            $desired_module_id=11;
                            include(APPPATH . "views/admin/Modules/packages.php");
                             
                             } ?>
                                

                            
                    </div>
                </div> -->


            </div>

            
        <div class="row mt-1">
            <div class="col-12">
                <div class="form-group"> <br> <br>
                    <button type="submit" class="btn btn-light btn-sm"><i class="fa fa-check-circle"></i> Save</button>
                    <button type="reset" class="btn btn-light btn-sm" id="clear"><i class="fa fa-times-circle" aria-hidden="true"></i> Clear</button>
                </div>
            </div>
        </div>
        </div>
    </form>
</div>

<?php require_once(APPPATH . "views/admin/footer.php"); ?>
<script src="<?php echo base_url('js/Modules/nutrition.js') ?>" type="text/javascript"></script>
<script>

var counter = <?= count($episodes) + 1; ?>;

$(document).ready(function() {
    var procedureElements = document.querySelectorAll('.procedure');

    var procedureCount = procedureElements.length;

    for (var i = 0; i < procedureCount; i++) {
        var currentElement = procedureElements[i];
        var departmentId = currentElement.getAttribute('data-department');
        initTomSelectProcedres(currentElement, departmentId);
    }

    var diagnosisElements = document.querySelectorAll('.multi_diagnosis');
    var diagnosisCount = diagnosisElements.length;

    for (var i = 0; i < diagnosisCount; i++) {
        var currentElement = diagnosisElements[i];
        var departmentId = currentElement.getAttribute('data-department');
        initTomSelectDiagnosis(currentElement, departmentId);
    }



    

});


var initTomSelecs = undefined;

function initTomSelectProcedres(selector, departmentId) {
    initTomSelecs = new TomSelect(selector, {
        valueField: 'id',
        labelField: 'name',
        searchField: 'name',
        load: function(query, callback) {
            var apiUrl = "<?php echo site_url('admin/CommenController/get_procedures?p=');
                            echo encrypt_and_url_encode($patient_id, $this) . '&' ?>t=" + departmentId + "&q=" + encodeURIComponent(query);

            fetch(apiUrl)
                .then(response => response.json())
                .then(data => {
                    callback(data);
                })
                .catch(() => {
                    callback();
                });
        },
        render: {
            option: function(item, escape) {
                return '<div>' +
                    '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                    '</div>';
            },
            item: function(item, escape) {
                return '<div>' +
                    '<span class="btn  btn-sm">' + escape(item.name) + '</span>' +
                    '</div>';
            }
        },
    });

    initTomSelecs.settings.minLength = 2;
}
var multiDiagnosisSelect = undefined;

function initTomSelectDiagnosis(selector, departmentId) {
    multiDiagnosisSelect = new TomSelect(selector, {
        valueField: 'id',
        labelField: 'name',
        searchField: 'name',
        load: function(query, callback) {
            var apiUrl = "<?php echo site_url('admin/CommenController/get_diagnosis?'); ?>t=" + departmentId + "&q=" + encodeURIComponent(query);

            fetch(apiUrl)
                .then(response => response.json())
                .then(data => {
                    callback(data);
                })
                .catch(() => {
                    callback();
                });
        },
        render: {
            option: function(item, escape) {
                return '<div>' +
                    '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                    '</div>';
            },
            item: function(item, escape) {
                return '<div>' +
                    '<span class="btn btn-sm">' + escape(item.name) + '</span>' +
                    '</div>';
            }
        },
    });

    multiDiagnosisSelect.settings.minLength = 2;
}
var treatemnts_ent = $("#treatemnts_ent").DataTable({
    bFilter: false,
    paging: false,
    info: false,
});

$("#addRow_general").on("click", function() {
    // if($("#diagnosis_general").val() === "") {
    //      alert('Diagnosis is required.');
    //       return false;

    //   }

    if ($("#procedure_general").val() == "-1") {
        alert("Procedure is required.");
        return false;
    }

    var split_diagnosis = $("input[name=diagnosis_general]").val().split(",");
    var primary_diagnosis = $("input[name=diagnosis_general]").val().split(" - ");
    var split_programs = $("input[name=programs_physiotherapy]").val().split(",");
    var diag_name = "";
    $.each(split_diagnosis, function(index, value) {
        if (value) {
            
            var temp = value.split(" - ");
            diag_name += temp[1] + ",";
        }
    });

    var split_treatment = $("select[name=procedure_general]").val().split(" | ");
    

    if ($("input[name=diagnosis_general]").val().indexOf("-") == -1) {
        var diagnosis =
            $("input[name=diagnosis_general]").val() +
            '<input type="hidden" name="general_diagnosis_name[]" value="' +
            $("input[name=diagnosis_general]").val() +
            '"><input type="hidden" name="general_diagnosis_id[]" value="">';
    } else {
        var diagnosis =
            diag_name +
            '<input type="hidden" name="general_diagnosis_name[]" value="' +
            diag_name +
            '"><input type="hidden" name="general_diagnosis_id[]" value="' +
            primary_diagnosis[0] +
            '">';
    }



    var pro_name = "";
    $.each(split_programs, function(index, value) {
        if (value) {
            
            var temp = value.split(" | ");
            pro_name += temp[1] + ",";
        }
    });

    if ($("input[name=programs_physiotherapy]").val().indexOf("-") == -1) {
        var programs =
            $("input[name=programs_physiotherapy]").val() +
            '<input type="hidden" name="programs_physiotherapy[]" value="' +
            $("input[name=programs_physiotherapy]").val() +
            '">';
    } else {
        var programs =
            pro_name +
            '<input type="hidden" name="programs_physiotherapy[]" value="' +
            pro_name +
            '">';
    }


    var treat_general =
        split_treatment[1] +
        '<input type="hidden" name="general_treatment_name[]" value="' +
        split_treatment[1] +
        '"><input type="hidden" name="general_treatment_id[]" value="' +
        split_treatment[0] +
        '">';

    treatemnts_ent.row
        .add([
            counter,
            diagnosis,
            programs,
            treat_general,
            '<input type="hidden" name="orig_price_general[]" value="' +
            split_treatment[2] +
            '"><input type="text" size="7" name="discount_general[]" value="0" class="discount_general form-control">',
            '<input type="text" size="7" name="discount_per_general[]" value="0" class="discount_per_general form-control">',
            '<input type="text" name="fees_general[]" size="7" value="' +
            split_treatment[2] +
            '" class="fees_general form-control">',
            '<div class="text-center"><button type="button" class="btn btn-light deleteRow_general"><i class="fa fa-trash" aria-hidden="true"></i></button></div>',
        ])
        .draw();

    counter++;
    initTomSelecs.clear();
    multiDiagnosisSelect.clear();
    initTomProgramsSelecs.clear();
});

$("body").on("click", ".deleteRow_general", function(e) {
    treatemnts_ent.row($(this).parents("tr")).remove().draw();
    return false;
});

//ent prescription
var max_fields = 10; //maximum input boxes allowed
var wrapper_ent = $(".input_fields_wrap_ent"); //Fields wrapper
var add_button_ent = $(".add_field_button_ent"); //Add button ID

var x = 1; //initlal text box count
$(add_button_ent).on("click", function(e) {
    //on add input button click
    var drug = $("input[name=drugs_ent]").val().split(" - ");
    var drug_qty = $("input[name=drug_qty_ent]").val();
    var meal = $("input[name=drug_meal_ent]").val();
    var drug_note = $("input[name=drug_note_ent]").val();

    if ($('input[name=drugs_ent]').val().length === 0) {
        alert("Please select drugs");
        return false;
    }

    if ($("input[name=drugs_ent]").val().indexOf("-") == -1) {
        var diagnosis =
            '<input type="text" class="form-control drugs" name="drug[]" value="' +
            drug[0] +
            '" id="drugs" disabled>' +
            '<input type="hidden" class="form-control drugs" name="drug_name_ent[]" value="' +
            drug[0] +
            '"><input type="hidden" class="form-control drugs" name="drug_id_ent[]" value=""><input type="hidden" class="form-control drugs" name="bill_items_id_ent[]" value="" id="drugs">';
    } else {
        var diagnosis =
            '<input type="text" class="form-control drugs" name="drug[]" value="' +
            drug[1] +
            '" id="drugs" disabled>' +
            '<input type="hidden" name="drug_name_ent[]" value="' +
            drug[1] +
            '"><input type="hidden" name="drug_id_ent[]" value="' +
            drug[0] +
            '"><input type="hidden" class="form-control drugs" name="bill_items_id_ent[]" value="' +
            drug[2] +
            '" id="drugs">';
    }

    var treat =
        '<div class="row drug_details">\
      <div class="col-md-3">\
        <div class="form-group">' +
        diagnosis +
        '</div>\
      </div>\
      <div class="col-md-3">\
        <div class="form-group">\
           <input type="text" class="form-control" name="drugs_qty_ent[]" value="' +
        drug_qty +
        '" id="drug_qty_ent" disabled>\
           <input type="hidden" class="form-control" name="drugs_qty_ent[]" value="' +
        drug_qty +
        '" id="drug_qty_ent" >\
        </div>\
      </div>\
      <div class="col-md-3">\
        <div class="form-group">\
          <input type="text" class="form-control" name="meals_ent[]" value="' +
        meal +
        '" id="meal_ent" disabled>\
          <input type="hidden" class="form-control" name="meals_ent[]" value="' +
        meal +
        '" id="meal_ent">\
        </div>\
      </div>\
      <div class="col-md-3">\
        <div class="form-group">\
          <div class="input-group">\
            <input type="text" class="form-control" name="drug_notes_ent[]" value="' +
        drug_note +
        '" id="drug_note_ent" disabled>\
            <input type="hidden" class="form-control" name="drug_notes_ent[]" value="' +
        drug_note +
        '" id="drug_note_ent">\
            <span class="input-group-addon">\
            <button type="button" class="btn btn-danger btn-xs remove_field_ent" id="remove_drug_ent">-</button>\
            </span>\
          </div>\
        </div>\
    </div>\
  </div>';

    $(wrapper_ent).append(treat);

    var drug = $("input[name=drugs_ent]").val("");
    var drug_qty = $("input[name=drug_qty_ent]").val("");
    var drug_note = $("input[name=drug_note_ent]").val("");
    var drug_meal = $("input[name=drug_meal_ent]").val("");
    // var drug_meal = $('input[name=meal_ent]').prop('checked', false);

    return false;
});

$(wrapper_ent).on("click", ".remove_field_ent", function(e) {
    //user click on remove text
    $(this).closest(".drug_details").remove();
    return false;
});

$(".clear_field_ent").on("click", function(e) {
    var drug = $("input[name=drugs_ent]").val("");
    var drug_qty = $("input[name=drug_qty_ent]").val("");
    var drug_note = $("input[name=drug_note_ent]").val("");
    var drug_meal = $("input[name=meal_ent]").prop("checked", false);
    return false;
});
var limit_discount= Number("<?php echo get_discount_limt($this) ?>");


$('body').on('keyup', '.discount_general', function() {
    this_td = $(this).closest('td'),
        orig_price = $(this).prev('input').val(),
        dis_per_td = this_td.next('td');
    discount_per = $(dis_per_td).find('input').val(),
        fees_td = dis_per_td.next('td');
    fees = $(fees_td).find('input').val(),
        discount = Number($(this).val()).toFixed(2);

        var dis_per =Number((discount * 100 / orig_price).toFixed(2));
            if(limit_discount !=''){
            if(dis_per > limit_discount){
                
                showdialog('Authorization Error' ,'Discount percentage exceeds the allowed limit of ' + limit_discount + '%.')
                dis_per = limit_discount
                discount =((dis_per * orig_price) / 100).toFixed(2);

                $(this).val(discount);
            }
        }


dis_per_td.find('input').val(dis_per); //discount_per //discount_per
    fees_td.find('input').val(Number(orig_price - discount).toFixed(2)); //fees
});

$('body').on('keyup', '.discount_per_general', function() {
    this_td = $(this).closest('td'),
        dis_td = this_td.prev('td'),
        orig_price = $(dis_td).find('input').val(),
        discount = $(dis_td).find('input').next().val(),
        fees_td = this_td.next('td');
    fees = $(fees_td).find('input').val(),
        discount_per = Number($(this).val()).toFixed(2);

        if(limit_discount !=''){
            if (discount_per > limit_discount) {
                showdialog('Authorization Error' ,'Discount percentage exceeds the allowed limit of ' + limit_discount + '%.')
        $(this).val(limit_discount); // Optionally, reset the value to the limit
        discount_per = limit_discount; // Update discount_per to the limit value
        }
    }

    dis_td.find('input').next().val(Number((discount_per * orig_price) / 100).toFixed(2)); //discount
    fees_td.find('input').val(Number(orig_price - (discount_per * orig_price / 100)).toFixed(2));
});

$('body').on('keyup', '.fees_general', function() {
    this_td = $(this).closest('td'),
        dis_per_td = this_td.prev('td');
    discount_per = $(dis_per_td).find('input').val(),
        dis_td = dis_per_td.prev('td'),
        orig_price = $(dis_td).find('input').val(),
        discount = $(dis_td).find('input').next().val(),
        fees = Number($(this).val()).toFixed(2);

    dis_td.find('input').next().val(Number(orig_price - fees).toFixed(2)); //discount
    dis_per_td.find('input').val(Number((1 - (fees / orig_price)) * 100).toFixed(2)); //discount_per
});
</script>


