
<div class="col-md-12 col-12">

    <div class="tab-wrapper">

        <ul class="tab-menu">
            <li class="module_tab_qlm">Treatment Done</li>
            <li class="module_tab_qlm">New Treatment</li>
        </ul>

        <div class="tab-content">
            <div>
                <div class="panel ">
                    <div class="box-body">
                        <?php  include('view.php'); ?>
                    </div>
                </div>
            </div>
        
            <div data-tab="tab3">
            <div class="row">
                <div class="col-md-12 ">
                <div class="panel panel-primary">
                    <div class="panel-heading">
                        <h5>PATIENT DETAILS</h5>
                    </div>
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-2">
                                <label for="name">Patient Name</label>
                            </div>
                            <div class="col-md-2">
                                <?= $patient_name; ?>
                            </div>
                            <div class="col-md-2">
                                <label for="name">Date of Birth</label>
                            </div>
                            <div class="col-md-2">
                                <?= $dob; ?>
                            </div>
                            <div class="col-md-2">
                                <label for="name">Qatar ID</label>
                            </div>
                            <div class="col-md-2">
                                <?= $qatar_id; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <hr>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12 ">

                <form id="qlmForm" role="form" action="<?= site_url('admin/Modules/Qlm/QlmController/addPlaneofcare'); ?>" method="post" enctype="multipart/form-data">
                    <input type="hidden" name="patient_id" value="<?= encrypt_and_url_encode($patient_id, $this); ?>">
                    <input type="hidden" name="insurance_id" value="<?= encrypt_and_url_encode($insurance_type, $this); ?>">
                    <input type="hidden" name="patient_qid" value="<?= encrypt_and_url_encode($qatar_id, $this); ?>">
                    <input type="hidden" name="member_id" value="<?= encrypt_and_url_encode($member_id, $this); ?>">

                    <div class="panel panel-primary">
                        <div class="panel-heading">
                            <h5>TREATMENT DETAILS</h5>
                        </div>
                        <div class="panel-body">
                            <div class="row" style="padding:5px;">
                                <div class="col-md-2">
                                    <label for="name">Category</label><span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                </div>
                                <div class="col-md-4">
                                    <select class="form-control" name="p_category" id="p_category" onchange="selectPCategory(this.options[this.selectedIndex].value)">
                                        <option value="-1">Select Category</option>
                                        <?php if ($treatment_categories != FALSE) : ?>
                                            <?php foreach ($treatment_categories as $category) : ?>
                                                <option value="<?= $category->treatment_categorytreatment_category_id ?>" data-value="<?= encrypt_and_url_encode($category->treatment_categorytreatment_category_id, $this); ?>"><?= $category->treatment_categorytreatment_category_name; ?></option>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <label for="name">Treatment Date</label><span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                </div>
                                <div class="col-md-4">
                                    <input type="date" name="enter_date" class="form-control sel_date" value="<?= date('Y-m-d') ?>">
                                </div>
                            </div>
                            <div class="row" style="padding:5px;">
                                <div class="col-md-2">
                                    <label for="name">Illness</label><span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                </div>
                                <div class="col-md-4">
                                    <select class="form-control" name="illness" id="illness">
                                        <option value="001">Acute</option>
                                        <option value="002">Chronic</option>
                                        <option value="003">Accident</option>
                                        <option value="004">Work related</option>
                                        <option value="005">Hereditary/Congenital</option>
                                        <option value="006">Pregnancy</option>
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <label for="name">Priority</label><span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                </div>
                                <div class="col-md-4">
                                    <select class="form-control" name="priority" id="priority">
                                        <option value="4">Urgent</option>
                                        <option value="1">Elective</option>
                                        <option value="2">Normal</option>
                                    </select>
                                </div>
                            </div>
                            <div class="row" style="padding:5px;">
                                <div class="col-md-2">
                                    <label for="name">Illness Details</label><span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                </div>
                                <div class="col-md-10">
                                    <textarea class="form-control" name="illness_details"></textarea>
                                </div>
                            </div>
                            <div class="row" style="padding:5px;">
                                <div class="col-md-2">
                                    <label for="name">Medical history</label><span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                </div>
                                <div class="col-md-10">
                                    <textarea class="form-control" name="medical_history"></textarea>
                                </div>
                            </div>
                            <div class="row" style="padding:5px;">
                                <div class="col-md-2">
                                    <label for="name">Requested Line of Management</label>
                                </div>
                                <div class="col-md-10">
                                    <textarea class="form-control" name="line_of_management"></textarea>
                                </div>
                            </div>
                            <div class="row" style="padding:5px;">
                                <div class="col-md-12">
                                    <hr>
                                </div>
                            </div>
                            <div class="row" style="padding:5px;">
                                <div class="col-md-2">
                                    <label for="drugs">Diagnosis</label><span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                </div>
                                <div class="col-md-10">
                                    <select class="" id="dia_id" name="dia_id[]" multiple="multiple"></select>
                                </div>
                            </div>
                            <div class="row" style="padding:5px;">
                                <div class="col-md-2">
                                    <label for="drugs">Procedure</label><span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                </div>
                                <div class="col-md-10">
                                    <select class="ui-procedure" name="procedures_auto" id="procedures_auto_qlm"></select>
                                </div>
                            </div>
                            <div class="row" style="padding:5px;">
                                <div class="col-md-2">
                                    <label for="drugs">Document</label>
                                </div>
                                <div class="col-md-10">
                                    <input type="file" name="xray" id="xray">
                                </div>
                            </div>
                            <div class="row" style="padding:5px;">
                                <div class="col-md-2">
                                    <label for="name">Justification</label>
                                </div>
                                <div class="col-md-10">
                                    <textarea class="form-control" name="justification_main"></textarea>
                                </div>
                            </div>
                            <div class="row" style="padding:5px;">
                                <div class="col-md-12">
                                    <div class="d-flex justify-content-end">
                                        <button type="button" class="btn btn-sm btn-dark non-ph-panel" id="qlmaddRow"><i class="fa fa-plus-circle" aria-hidden="true"></i> Add Diagnose / Treatment</button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="panel panel-primary other-details">
                        <div class="panel-heading den-panel">
                            <h5>DENTAL INFORMATION</h5>
                        </div>
                        <div class="panel-heading mat-panel">
                            <h5>MATERNITY INFORMATION</h5>
                        </div>
                        <div class="panel-heading ph-panel">
                            <h5>PHARMACY DETAILS</h5>
                        </div>
                        <div class="panel-body">
                            <div class="row mat-panel">
                                <div class="col-md-1">
                                    <div class="form-group">
                                        <label for="name">Pregnant Y/N</label><span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <input type="radio">&nbsp; Yes &nbsp;&nbsp;&nbsp;
                                    <input type="radio">&nbsp; No
                                </div>
                                <div class="col-md-1">
                                    <label for="name">LMP Date</label><span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                </div>
                                <div class="col-md-3">
                                    <input type="date" class="form-control sel_date">
                                </div>
                            </div>

                            <div class="row den-panel">
                                <div class="col-md-12">
                                    <div class="d-flex w-100">
                                        <?php $this->load->view('admin/Chart/tooth_svg') ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row den-panel">
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="name">IOTN Grade</label><span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <select class="form-control" name="iotn" id="iotn">
                                            <option value="">Not Specified</option>
                                            <option value="1">Grade 1</option>
                                            <option value="2">Grade 2</option>
                                            <option value="3">Grade 3</option>
                                            <option value="4">Grade 4</option>
                                            <option value="5">Grade 5</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-2">
                                    <div class="form-group">
                                        <label for="name">Session Count</label><span class="glyphicon glyphicon-asterisk ui-must_remark" aria-hidden="true"></span>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <input type="text" class="form-control" name="sessionCnt">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="panel panel-primary">
                        <div class="panel-heading">
                            <h5>TREATMENT LIST</h5>
                        </div>
                        <div class="panel-body">
                            <table class="table table-hover table-striped non-ph-panel" id="planofcare">
                                <thead>
                                    <tr>
                                        <th>Tooth No</th>
                                        <th>Diagnosis</th>
                                        <th>Procedure</th>
                                        <th>srJustification</th>
                                        <th>Justification</th>
                                        <th width="13%">Discount(QR)</th>
                                        <th width="13%">Discount(%)</th>
                                        <th width="13%">Fees</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                            </table>

                            <div class="panel drug-tbl ph-panel">
                                <div class="input_fields_wrap">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="drugs">Select Drugs</label>
                                                <input type="text" class="form-control drugs" name="drugs" id="drugs">
                                            </div>
                                        </div>
                                        <div class="col-md-1">
                                            <div class="form-group">
                                                <label for="drugs">QTY</label>
                                                <input type="text" class="form-control" name="drug_qty" id="drug_qty">
                                            </div>
                                        </div>
                                        <div class="col-md-2">
                                            <div class="form-group">
                                                <label for="drugs">Dosage</label>
                                                <select class="form-control" name="drug_dosage">
                                                    <?php foreach ($dosage_list as $dosage) : ?>
                                                        <option value="<?= $dosage['dosage_code'] ?>"><?= $dosage['dosage_name'] ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-1">
                                            <div class="form-group">
                                                <label for="drugs">Duration</label>
                                                <input type="text" class="form-control" name="drug_duration" id="drug_duration">
                                            </div>
                                        </div>
                                        <div class="col-md-1">
                                            <div class="form-group">
                                                <label for="drugs">Drug Duration</label>
                                                <select class="form-control" name="drug_d_unit">
                                                    <option value="D">Days</option>
                                                    <option value="W">Weeks</option>
                                                    <option value="M">Months</option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="drugs">Description</label>
                                                <div class="input-group">
                                                    <input type="text" class="form-control" name="drug_note" id="drug_note">
                                                    <span class="input-group-addon ml-1">
                                                        <button type="button" class="btn btn-light add_field_button" id="add_drug"><i class="fa fa-plus-circle" aria-hidden="true"></i></button>
                                                        <button type="button" class="btn btn-light clear_field" id="clear_field"><i class="fa fa-trash" aria-hidden="true"></i></button>
                                                    </span>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row text-center">
                        <div class="col-md-12">
                            <div class="d-flex flex-row justify-content-end">
                                <button type="submit" class="btn btn-sm btn-light mr-1"><i class="fa fa-check-circle" aria-hidden="true"></i> Save Treatment Plan</button>
                                <button type="button" class="btn btn-sm btn-light disabled"><i class="fa fa-check-circle" aria-hidden="true"></i> Update</button>
                            </div>
                        </div>
                    </div>

                </form>
            </div>
        </div>

    </div>
            


</div><!-- //tab-wrapper -->
</div><!-- //tab-wrapper -->


<script type="text/javascript">
    var t = null;
    var procedures_auto_qlm = null;
    var qlm_diagnosis = null;

    $(function() {

        t = $('#planofcare').DataTable({
            "bFilter": false,
            "paging": false,
            "info": false
        });

        qlm_diagnosis = new TomSelect('#dia_id', {
            create: false,
            placeholder: '',
            load: function(query, callback) {
                $.ajax({
                    url: '<?= site_url('admin/Modules/Qlm/QlmController/getDiagnosis'); ?>',
                    type: 'GET',
                    dataType: 'json',
                    data: {
                        term: query
                    },
                    success: function(response) {
                        console.log(response);
                        var options = response.map(function(item) {
                            return {
                                value: item.diagnostise_id,
                                text: item.name
                            };
                        });
                        callback(options);
                    },
                    error: function(xhr, status, error) {
                        console.error('Error fetching data:', error);
                    }
                });
            }
        });

        $('#dia_id').on('select2:select', function(e) {
            var data = e.params.data;
            if (data.id == -1) {
                $(this).select2("val", [-1]);
                v = $('#mySelect2').find(':selected');
            } else {
                vd = $(this).val();
                if (vd.includes("-1")) {
                    alert('You already selected all patient.');
                    $(this).select2("val", [-1]);
                }
            }
        });

        $('.multi_diagnosis').on("focus", function() {
            $(this).autocomplete({
                source: function(request, response) {
                    $.ajax({
                        url: "<?= site_url('doctor_process/get_derma_diagnosis_multi'); ?>",
                        dataType: "json",
                        data: {
                            // name_startsWith: request.term,
                            name_startsWith: request.term,
                            type: 'diagnosis'
                        },
                        success: function(data) {
                            response($.map(data, function(item) {
                                return {
                                    label: item,
                                    value: item
                                }
                            }));
                        }
                    });
                },
                autoFocus: false,
                minLength: 2
            });
        });

        $('.context-menu-one').mouseup(function(e) {
            this.oncontextmenu = function() {
                return false;
            };
            if (e.button == 2) {

                if (e.originalEvent.detail === 2) {

                    var tooth_part = $(this).attr('id');
                    var tooth_num = tooth_part.split('-');

                    var clear = $('#' + tooth_num[0] + '-O').children("linearGradient").attr("id");
                    $('#' + tooth_num[0] + '-O').children('path').attr("fill", "url(#" + clear + ")");
                    $('#' + tooth_num[0] + '-O').children('input').attr("value", "0");

                    var clear = $('#' + tooth_num[0] + '-B').children("linearGradient").attr("id");
                    $('#' + tooth_num[0] + '-B').children('path').attr("fill", "url(#" + clear + ")");
                    $('#' + tooth_num[0] + '-B').children('input').attr("value", "0");

                    var clear = $('#' + tooth_num[0] + '-M').children("linearGradient").attr("id");
                    $('#' + tooth_num[0] + '-M').children('path').attr("fill", "url(#" + clear + ")");
                    $('#' + tooth_num[0] + '-M').children('input').attr("value", "0");

                    var clear = $('#' + tooth_num[0] + '-D').children("linearGradient").attr("id");
                    $('#' + tooth_num[0] + '-D').children('path').attr("fill", "url(#" + clear + ")");
                    $('#' + tooth_num[0] + '-D').children('input').attr("value", "0");

                    var clear = $('#' + tooth_num[0] + '-L').children("linearGradient").attr("id");
                    $('#' + tooth_num[0] + '-L').children('path').attr("fill", "url(#" + clear + ")");
                    $('#' + tooth_num[0] + '-L').children('input').attr("value", "0");

                    var clear = $('#' + tooth_num[0] + '-I').children("linearGradient").attr("id");
                    $('#' + tooth_num[0] + '-I').children('path').attr("fill", "url(#" + clear + ")");
                    $('#' + tooth_num[0] + '-I').children('input').attr("value", "0");

                    var clear = $('#' + tooth_num[0] + '-F').children("linearGradient").attr("id");
                    $('#' + tooth_num[0] + '-F').children('path').attr("fill", "url(#" + clear + ")");
                    $('#' + tooth_num[0] + '-F').children('input').attr("value", "0");

                    var clear = $('#' + tooth_num[0] + '-P').children("linearGradient").attr("id");
                    $('#' + tooth_num[0] + '-P').children('path').attr("fill", "url(#" + clear + ")");
                    $('#' + tooth_num[0] + '-P').children('input').attr("value", "0");

                } else if (e.originalEvent.detail === 1) {
                    var clear = $(this).children("linearGradient").attr("id");

                    var tooth_part = $(this).attr('id');
                    var tooth_num = tooth_part.split('-');

                    var clear = $('#' + tooth_num[0] + '-O').children("linearGradient").attr("id");
                    $('#' + tooth_num[0] + '-O').children('path').attr("fill", "url(#" + clear + ")");
                    $('#' + tooth_num[0] + '-O').children('input').attr("value", "0");

                    var clear = $('#' + tooth_num[0] + '-B').children("linearGradient").attr("id");
                    $('#' + tooth_num[0] + '-B').children('path').attr("fill", "url(#" + clear + ")");
                    $('#' + tooth_num[0] + '-B').children('input').attr("value", "0");

                    var clear = $('#' + tooth_num[0] + '-M').children("linearGradient").attr("id");
                    $('#' + tooth_num[0] + '-M').children('path').attr("fill", "url(#" + clear + ")");
                    $('#' + tooth_num[0] + '-M').children('input').attr("value", "0");

                    var clear = $('#' + tooth_num[0] + '-D').children("linearGradient").attr("id");
                    $('#' + tooth_num[0] + '-D').children('path').attr("fill", "url(#" + clear + ")");
                    $('#' + tooth_num[0] + '-D').children('input').attr("value", "0");

                    var clear = $('#' + tooth_num[0] + '-L').children("linearGradient").attr("id");
                    $('#' + tooth_num[0] + '-L').children('path').attr("fill", "url(#" + clear + ")");
                    $('#' + tooth_num[0] + '-L').children('input').attr("value", "0");

                    var clear = $('#' + tooth_num[0] + '-I').children("linearGradient").attr("id");
                    $('#' + tooth_num[0] + '-I').children('path').attr("fill", "url(#" + clear + ")");
                    $('#' + tooth_num[0] + '-I').children('input').attr("value", "0");

                    var clear = $('#' + tooth_num[0] + '-F').children("linearGradient").attr("id");
                    $('#' + tooth_num[0] + '-F').children('path').attr("fill", "url(#" + clear + ")");
                    $('#' + tooth_num[0] + '-F').children('input').attr("value", "0");

                    var clear = $('#' + tooth_num[0] + '-P').children("linearGradient").attr("id");
                    $('#' + tooth_num[0] + '-P').children('path').attr("fill", "url(#" + clear + ")");
                    $('#' + tooth_num[0] + '-P').children('input').attr("value", "0");
                }
            }
            return true;
        });

        $('.context-menu-one').on('click', function(e) {

            var tooth_part = $(this).attr('id');
            var tooth_num = tooth_part.split('-');

            var clear = $('#' + tooth_num[0] + '-O').children("linearGradient").attr("id");
            $('#' + tooth_num[0] + '-O').children('path').attr("fill", "url(#" + clear + ")");
            $('#' + tooth_num[0] + '-O').children('input').attr("value", "0");

            var clear = $('#' + tooth_num[0] + '-B').children("linearGradient").attr("id");
            $('#' + tooth_num[0] + '-B').children('path').attr("fill", "url(#" + clear + ")");
            $('#' + tooth_num[0] + '-B').children('input').attr("value", "0");

            var clear = $('#' + tooth_num[0] + '-M').children("linearGradient").attr("id");
            $('#' + tooth_num[0] + '-M').children('path').attr("fill", "url(#" + clear + ")");
            $('#' + tooth_num[0] + '-M').children('input').attr("value", "0");

            var clear = $('#' + tooth_num[0] + '-D').children("linearGradient").attr("id");
            $('#' + tooth_num[0] + '-D').children('path').attr("fill", "url(#" + clear + ")");
            $('#' + tooth_num[0] + '-D').children('input').attr("value", "0");

            var clear = $('#' + tooth_num[0] + '-L').children("linearGradient").attr("id");
            $('#' + tooth_num[0] + '-L').children('path').attr("fill", "url(#" + clear + ")");
            $('#' + tooth_num[0] + '-L').children('input').attr("value", "0");

            var clear = $('#' + tooth_num[0] + '-I').children("linearGradient").attr("id");
            $('#' + tooth_num[0] + '-I').children('path').attr("fill", "url(#" + clear + ")");
            $('#' + tooth_num[0] + '-I').children('input').attr("value", "0");

            var clear = $('#' + tooth_num[0] + '-F').children("linearGradient").attr("id");
            $('#' + tooth_num[0] + '-F').children('path').attr("fill", "url(#" + clear + ")");
            $('#' + tooth_num[0] + '-F').children('input').attr("value", "0");

            var clear = $('#' + tooth_num[0] + '-P').children("linearGradient").attr("id");
            $('#' + tooth_num[0] + '-P').children('path').attr("fill", "url(#" + clear + ")");
            $('#' + tooth_num[0] + '-P').children('input').attr("value", "0");

        });

        selectPCategory(null, t);
    });


    $(".context-menu-one").dblclick(function() {
        var tooth_part = $(this).attr('id');
        var tooth_num = tooth_part.split('-');

        $('#' + tooth_num[0] + '-O').find('path').attr("fill", "#000000");
        $('#' + tooth_num[0] + '-O').find('input').attr("value", tooth_num[0] + "-O|" + "#000000");

        $('#' + tooth_num[0] + '-B').find('path').attr("fill", "#000000");
        $('#' + tooth_num[0] + '-B').find('input').attr("value", tooth_num[0] + "-B|" + "#000000");

        $('#' + tooth_num[0] + '-M').find('path').attr("fill", "#000000");
        $('#' + tooth_num[0] + '-M').find('input').attr("value", tooth_num[0] + "-M|" + "#000000");

        $('#' + tooth_num[0] + '-D').find('path').attr("fill", "#000000");
        $('#' + tooth_num[0] + '-D').find('input').attr("value", tooth_num[0] + "-D|" + "#000000");

        $('#' + tooth_num[0] + '-L').find('path').attr("fill", "#000000");
        $('#' + tooth_num[0] + '-L').find('input').attr("value", tooth_num[0] + "-L|" + "#000000");

        $('#' + tooth_num[0] + '-I').find('path').attr("fill", "#000000");
        $('#' + tooth_num[0] + '-I').find('input').attr("value", tooth_num[0] + "-I|" + "#000000");

        $('#' + tooth_num[0] + '-F').find('path').attr("fill", "#000000");
        $('#' + tooth_num[0] + '-F').find('input').attr("value", tooth_num[0] + "-F|" + "#000000");

        $('#' + tooth_num[0] + '-P').find('path').attr("fill", "#000000");
        $('#' + tooth_num[0] + '-P').find('input').attr("value", tooth_num[0] + "-P|" + "#000000");
    });

    var sample = '<?php echo $full_tooth; ?>';
    var arr = sample.split(';');

    $.each(arr, function(index, value) {
        if (value != '0' && value != '') {
            var temp = value.split('|');
            if (temp[0] == 's&p') {
                temp[0] = 's\\&p';
            }
            $('#_' + temp[0]).children("path").attr("fill", temp[1]);
            $('#_' + temp[0]).children("input").attr("value", temp[0] + "|" + temp[1] + "|" + temp[2]);
        }
    });

    $('#qlmaddRow').on('click', function() {
        tooth_desc = $('#tooth_no option:selected').text();

        counter = 1;
        var split_procedure = $('select[name=procedures_auto]').val().split(' | ');
        var finalvalue = '';

        var stooth = '';
        var vstooth = '';
        var fulltooth = '';
        var vtooth = '';
        $('input[name=tpart]').each(function() {
            var vstooth = $(this).attr("value");
            if (vstooth != 0) {
                stooth = vstooth.split('|');
                finalvalue += stooth[0] + ';';
            }

            fulltooth += vstooth + ';';
        });

        var arr = finalvalue.split(';');
        var last_val = "";
        var new_full = [];
        var new_single = [];
        var ctr = 0;
        var tooth_number = "";
        var temp_diag = '';

        for (i = 0; i < arr.length - 1; i++) {
            temp = arr[i].split('-');
            if (last_val == temp[0]) {
                ctr++;
                if (ctr == 4) {
                    new_full.push(temp[0]);
                    ctr = 0;
                }
            } else {
                last_val = temp[0];
            }
        }

        for (i = 0; i < arr.length - 1; i++) {
            temp = arr[i].split('-');
            if (new_full.indexOf(temp[0]) == -1) {
                new_single.push(arr[i]);
            }
        }

        if (new_full != "") {
            if (new_single != "") {
                tooth_number = new_full + "," + new_single;
            } else {
                tooth_number = new_full;
            }
        } else {
            if (new_single != "") {
                tooth_number = new_single;
            }
        }

        var split_diag = $('#dia_id').val();
        var diagn = $('#dia_id').val();

        var selectedOptions = qlm_diagnosis.getValue();
        selectedOptions.forEach(function(value) {
            var option = qlm_diagnosis.options[value];
            if (option) {
                temp_diag += option.text + '<br>';
            }
        });


        t.row.add([
            tooth_number + '<input type="hidden" name="plan_teeth[]" value="' + finalvalue + '"><input type="hidden" name="full_teeth[]" value="' + fulltooth + '">' + tooth_desc,
            temp_diag + '<input type="hidden" name="plan_diag[]" value="' + split_diag[0] + '"><input type="hidden" name="plan_diag_full[]" value="' + diagn + '">',
            split_procedure[1] + '<input type="hidden" name="plan_procedure[]" value="' + split_procedure[0] + '"><input type="hidden" name="plan_procedure_full[]" value="' + $('select[name=procedures_auto]').val() + '">',
            '<textarea type="text" class="form-control" name="srJustification[]"></textarea>',
            '<textarea type="text" class="form-control" name="justification[]"></textarea>',
            '<input type="hidden" class="orgi" name="orig_price[]" value="' + split_procedure[2] + '"><input type="text" size="7" name="discount[]" value="0" class="discount form-control">',
            '<input type="text" class="form-control" size="7" name="discount_per[]" value="0" class="discount_per">',
            '<input type="text" class="form-control" size="7" name="teeth_price[]" value="' + split_procedure[2] + '" class="teeth_price">',
            '<a class="btn btn-light del-treat text-center" id="' + counter + '"><i class="fa fa-trash" aria-hidden="true"></i></a>',
        ]).draw();

        $('.del-treat').on('click', function() {
            t.row($(this).parents('tr')).remove().draw();
        });

        counter++;

        Array.from(document.getElementsByClassName('context-menu-one')).forEach(e => unselect_tooth(e));
        for (let t in selected_tooths) delete selected_tooths[t];

        procedures_auto_qlm.clear();
        qlm_diagnosis.clear();
        
    });


    $('#planofcare tbody').on('click', 'tr', function() {
        if ($(this).hasClass('selected')) {
            $(this).removeClass('selected');
        } else {
            t.$('tr.selected').removeClass('selected');
            $(this).addClass('selected');
        }
    });

    $('#deleteRow').on('click', function() {
        t.row('.selected').remove().draw(false);
    });

    /* OCR Auto fill*/
    $("#auto_fill").change(function() {
        if (this.checked) {
            $('#patient_name').val($("input[name=patient_name_hidden]").val());
            $('#qatar_id').val($("input[name=qatar_id_hidden]").val());
            $('#dob').val($("input[name=dob_hidden]").val());
        }
    });

    $(document).ready(function() {
        var max_fields = 10;
        var x = 1;

        var wrapper = $(".input_fields_wrap");
        var add_button = $(".add_field_button");

        $('.procedures_auto').on("focus", function() {
            $(this).autocomplete({
                source: function(request, response) {
                    $.ajax({
                        url: "<?= site_url('doctor_process/get_planofcare_procedure'); ?>",
                        dataType: "json",
                        data: {
                            name_startsWith: request.term,
                            type: 'diagnosis'
                        },
                        success: function(data) {
                            response($.map(data, function(item) {
                                return {
                                    label: item,
                                    value: item
                                }
                            }));
                        }
                    });
                },
                autoFocus: false,
                minLength: 2
            });
        });

        $('#a_teeth').change(function() {
            if ($(this).is(':checked')) {
                $('.ui-disabled').attr('disabled', true);
                $('#c_teeth').attr('disabled', true);
                $('#aall_tooth').attr('disabled', true);
                $('#call_tooth').attr('disabled', true);
                $('#a_teeth').attr('disabled', false);
                $('.ui-disabled').prop('checked', false);
                $('#aall_tooth').prop('checked', false);
                $('#call_tooth').prop('checked', false);
            } else {
                $('input[type=checkbox]').attr('disabled', false);
            }
        });

        $('#aall_tooth').change(function() {
            if ($(this).is(':checked')) {
                $(".ui-adult").prop('checked', $(this).prop("checked"));
                $('#call_tooth').attr('disabled', true);
                $('#a_teeth').attr('disabled', true);
                $('.ui-child').attr('disabled', true);
            } else {
                $('input[type=checkbox]').attr('disabled', false);
                $('.ui-adult').each(function() { //loop through each checkbox
                    this.checked = false; //deselect all checkboxes with class "checkbox1"                       
                });
            }
        });

        $('#call_tooth').change(function() {
            if ($(this).is(':checked')) {
                $(".ui-child").prop('checked', $(this).prop("checked"));
                $('#aall_tooth').attr('disabled', true);
                $('#a_teeth').attr('disabled', true);
                $('.ui-adult').attr('disabled', true);
            } else {
                $('input[type=checkbox]').attr('disabled', false);
                $('.ui-child').each(function() { //loop through each checkbox
                    this.checked = false; //deselect all checkboxes with class "checkbox1"                       
                });
            }
        });

        $('.drugs').on("focus", function() {
            $(this).autocomplete({
                source: function(request, response) {
                    $.ajax({
                        url: "<?= site_url('doctor_process/get_drugs'); ?>",
                        dataType: "json",
                        data: {
                            name_startsWith: request.term,
                            type: 'drug'
                        },
                        success: function(data) {
                            response($.map(data, function(item) {
                                return {
                                    label: item,
                                    value: item
                                }
                            }));
                        }
                    });
                },
                autoFocus: false,
                minLength: 2
            });
        });

        $(add_button).on('click', function(e) {
            var drug = $('input[name=drugs]').val().split(' - ');
            var drug_qty = $('input[name=drug_qty]').val();
            var drug_dosage = $('select[name=drug_dosage]').find(":selected").text();
            var drug_dosage_id = $('select[name=drug_dosage]').find(":selected").val();
            var drug_duration = $('input[name=drug_duration]').val();
            var drug_d_unit = $('select[name=drug_d_unit]').find(":selected").text();
            var drug_d_unit_id = $('select[name=drug_d_unit]').find(":selected").val();
            var drug_note = $('input[name=drug_note]').val();
            var meal;

            if ($('input[name=drugs]').val().length === 0) {
                alert("Please select drugs");
                return false;
            } else if ($('input[name=drug_qty]').val().length === 0) {
                alert("Please enter drug quantity");
                return false;
            }

            if ($('input:radio[name=meal]:checked').val() == '1') {
                meal = 'After Meal';
            } else if ($('input:radio[name=meal]:checked').val() == '2') {
                meal = 'Before Meal';
            } else {
                meal = '';
            }

            if ($('input[name=drugs]').val().indexOf('-') == -1) {
                var diagnosis = '<input type="text" class="form-control drugs" name="drug[]" value="' + drug[0] + '" id="drugs" disabled>' + '<input type="hidden" class="form-control drugs" name="drug_name[]" value="' + drug[0] + '"><input type="hidden" class="form-control drugs" name="drug_id[]" value=""><input type="hidden" class="form-control drugs" name="bill_items_id[]" value="" id="drugs">';
            } else {
                var diagnosis = '<input type="text" class="form-control drugs" name="drug[]" value="' + drug[1] + '" id="drugs" disabled>' + '<input type="hidden" name="drug_name[]" value="' + drug[1] + '"><input type="hidden" name="drug_id[]" value="' + drug[0] + '"><input type="hidden" class="form-control drugs" name="bill_items_id[]" value="' + drug[2] + '" id="drugs">';
            }

            var treat = '<div class="xys">\
            <div class="col-md-12">\
              <div class="col-md-3">\
                <div class="form-group">' +
                diagnosis +
                '</div>\
              </div>\
              <div class="col-md-1">\
                <div class="form-group">\
                   <input type="text" class="form-control" name="drugs_qty[]" value="' + drug_qty + '" id="drug_qty" disabled>\
                   <input type="hidden" class="form-control" name="drugs_qty[]" value="' + drug_qty + '" id="drug_qty" >\
                </div>\
              </div>\
              <div class="col-md-2">\
                <div class="form-group">\
                   <input type="text" class="form-control" name="drug_dosage[]" value="' + drug_dosage + '" id="drug_dosage" disabled>\
                   <input type="hidden" class="form-control" name="drug_dosage[]" value="' + drug_dosage_id + '" id="drug_dosage" >\
                </div>\
              </div>\
              <div class="col-md-1">\
                <div class="form-group">\
                   <input type="text" class="form-control" name="drug_duration[]" value="' + drug_duration + '" id="drug_duration" disabled>\
                   <input type="hidden" class="form-control" name="drug_duration[]" value="' + drug_duration + '" id="drug_duration" >\
                </div>\
              </div>\
              <div class="col-md-1">\
                <div class="form-group">\
                   <input type="text" class="form-control" name="drug_d_unit[]" value="' + drug_d_unit + '" id="drug_d_unit" disabled>\
                   <input type="hidden" class="form-control" name="drug_d_unit[]" value="' + drug_d_unit_id + '" id="drug_d_unit" >\
                </div>\
              </div>\
              <div class="col-md-4">\
                <div class="form-group">\
                  <div class="input-group">\
                    <input type="text" class="form-control" name="drug_notes[]" value="' + drug_note + '" id="drug_note" disabled>\
                    <input type="hidden" class="form-control" name="drug_notes[]" value="' + drug_note + '" id="drug_note">\
                    <span class="input-group-addon">\
                    <button type="button" class="btn btn-danger btn-xs remove_field" id="remove_drug">-</button>\
                    </span>\
                  </div>\
                </div>\
              </div>\
            </div>\
          </div>';
            // e.preventDefault();
            //if(x < max_fields){ //max input box allowed
            //x++; //text box increment

            //alert(drug_note);
            $(wrapper).append(treat); //add input box

            // }

            //$('.add_drg').html(treat);
            return false;

        });

        $(wrapper).on("click", ".remove_field", function(e) { //user click on remove text
            $(this).parentsUntil('.xys').remove();
            return false;
        })

        $('.clear_field').on('click', function(e) {
            var drug = $('input[name=drugs]').val('');
            var drug_qty = $('input[name=drug_qty]').val('');
            var drug_note = $('input[name=drug_note]').val('');
            return false;
        });

        $('#qlmForm').submit(function() {
            var filename = $("#xray").val();
            var rowCount = $('#planofcare tr').length;
            var category_id = $('#p_category').val();

            if (parseInt(category_id) != 12) {
                if ($('#planofcare tr').parent().siblings(":first").text() == "No data available in table") {
                    alert("Add sufficient treatment plan details");
                    return false;
                } else if (filename === '') {
                    // alert('X-ray field is empty.');
                    //return false;
                }

            }

        });

    });

    $('.treatment-plan-teeth').hide();
    $('.ph-panel').hide();
    $('.non-ph-panel').show();

    $('.treatment-plan-teeth').hide();
    $('.tooth_nu').hide();


    function selectPCategory(category_id, tbl) {

        // tbl.clear().draw();
        // window.location.reload();
        insurance_id = $('input[name="insurance_id"]').val();
        category_id = 1;

        if (category_id == 1) {
            $('.den-panel').show();
            $('.mat-panel').hide();
            $('.ph-panel').hide();
            $('.non-ph-panel').show();
            $('.other-details').show();
        } else if (category_id == 8) {
            $('.den-panel').hide();
            $('.mat-panel').show();
            $('.ph-panel').hide();
            $('.non-ph-panel').show();
            $('.other-details').show();
        } else if (category_id == 12) {
            $('.den-panel').hide();
            $('.mat-panel').hide();
            $('.ph-panel').show();
            $('.non-ph-panel').hide();
            $('.other-details').hide();
        } else {
            $('.den-panel').hide();
            $('.mat-panel').hide();
            $('.ph-panel').hide();
            $('.non-ph-panel').show();
            $('.other-details').hide();
        }

        if (category_id != "-1") {
            loadTreatment(insurance_id, $('#p_category option:selected').attr('data-value'));
        } else {
            $("#procedure").html("<option value='-1'>Select Category</option>");
            $("#procedures_auto_qlm").html("<option value='-1'>Select Category</option>");
        }
    }

    function loadTreatment(insurnaceId, treatmentCategory) {
        $.ajax({
            type: "POST",
            url: "<?= site_url('admin/Modules/Qlm/QlmController/qlmPriceList'); ?>",
            data: {
                insurnaceId: insurnaceId,
                treatmentCategory: treatmentCategory
            },
            success: function(result) {
                console.log(result);
                $("#procedures_auto_qlm").html(result);
                //$("#procedure").html(result);

                if (procedures_auto_qlm) {
                    procedures_auto_qlm.destroy();
                }
                procedures_auto_qlm = new TomSelect('#procedures_auto_qlm', {});
            }
        });
    }

    $('#last_exam').on('click', function(e) {
        $('#app_poppup').modal({
            keyboard: false
        });
    });

    $('body').on('keyup', '.discount', function() {
        this_td = $(this).closest('td'),
            orig_price = $(this).prev('input').val(),
            dis_per_td = this_td.next('td');
        discount_per = $(dis_per_td).find('input').val(),
            fees_td = dis_per_td.next('td');
        fees = $(fees_td).find('input').val(),
            discount = Number($(this).val()).toFixed(2);

        dis_per_td.find('input').val(Number((discount * 100 / orig_price))); //discount_per
        fees_td.find('input').val(Number(orig_price - discount).toFixed(2)); //fees
    });

    $('body').on('keyup', '.discount_per', function() {
        this_td = $(this).closest('td'),
            dis_td = this_td.prev('td'),
            orig_price = $(dis_td).find('input').val(),
            discount = $(dis_td).find('input').next().val(),
            fees_td = this_td.next('td');
        fees = $(fees_td).find('input').val(),
            discount_per = Number($(this).val()).toFixed(2);

        dis_td.find('input').next().val(Number((discount_per * orig_price) / 100).toFixed(2)); //discount
        fees_td.find('input').val(Number(orig_price - (discount_per * orig_price / 100)).toFixed(2));
    });

    $('body').on('keyup', '.teeth_price', function() {
        this_td = $(this).closest('td'),
            dis_per_td = this_td.prev('td');
        discount_per = $(dis_per_td).find('input').val(),
            dis_td = dis_per_td.prev('td'),
            orig_price = $(dis_td).find('input').val(),
            discount = $(dis_td).find('input').next().val(),
            fees = Number($(this).val()).toFixed(2);

        dis_td.find('.orgi').val(fees);
    });
</script>
        </div>